var data = {
    "videos": [
        {
            "filename": "video/tm355_blk3_wifi_access_sec01-600-kbits.mp4",
            "width": "512",
            "height": "300",
            "transcript": "This animation looks at how WiFi allocates the use of the radio channel among its various users.<br/><br/>The way it’s done in WiFi is very different from the way it’s done in cellular mobile communications (such as 3G and 4G).<br/><br/>In cellular mobile communications, the base station controls how the communication resource is shared out among users’ devices. WiFi networks can work in a similar way, with the access point controlling the individual devices, but this type of WiFi network is rare. It’s much more common to use the so-called Distributed Coordination Function, or DCF, where the responsibility for sharing access is distributed among all the devices in the network. If you have WiFi in your house, it almost certainly uses the DCF.<br/><br/>In the DCF, the access point is not privileged – it gets access to the radio channel in the same way that other devices in the network do. I will refer to all devices in the network as nodes. A node can be an access point, a WiFi-enabled computer, a smartphone, a wireless printer, or any other WiFi-enabled device.<br/><br/>The access point <i>does</i> have a special role in allowing other devices onto the network (through the use of passwords and so on), but the way it determines when to transmit is the same as the way other nodes on the network do it.<br/><br/>Before we look at the Distributed Coordination Function, it’s useful to establish some terms.<br/><br/>An access point and the nodes associated with it, under the control of a common coordination function, is called a Basic Service Set (or BSS).<br/><br/>This set of nodes could be a BSS if all the devices were communicating with the access point.<br/><br/>A BSS is identified to WiFi users by a Service Set Identifier (SSID). This in effect is the network name, such as Sarah’s Network. Among other things, the SSID enables the user of a device to see which networks are available, and to choose one to connect to."
        },
        {
            "filename": "video/tm355_blk3_wifi_access_sec02-600-kbits.mp4",
            "width": "512",
            "height": "300",
            "transcript": "Coordination of network nodes is needed to prevent collisions like these.<br/><br/>Collisions cause signal corruption and loss of data.<br/><br/>The Distributed Coordination Function ensures that only one device at a time transmits. It does this through a ‘listen before transmit’ protocol. The official name for this protocol is Carrier Sense Multiple Access with Collision Avoidance, or CSMA CA.<br/><br/>Before transmitting data, all nodes monitor the radio channel that is being used by the SSID that the nodes are intending to connect to.<br/><br/>The same radio channel might also be in use by another nearby SSID. I’ll come back to that point later.<br/><br/>When the channel is clear, nodes with data to transmit wait a fixed length of time. I’ll call this the check period.<br/><br/>At the completion of the check period, provided the channel has remained clear, a period called the ‘contention window’ begins.<br/><br/>At the start of the contention window, each waiting node starts counting down from a random value chosen by itself. This is called ‘backing off’.<br/><br/>It’s extremely unlikely that more than one device will back off from the same number, so whichever node reaches zero first gains control of the channel. Provided the channel has remained clear during the contention window, the successful node starts to transmit all its frames in sequence.<br/><br/>A frame consists of a data payload, with headers indicating the destination MAC address, and other control data. It usually also incorporates error detection or correction data. A typical payload for a frame would be an Internet Protocol packet, which would have the IP address of the destination.<br/><br/>Some of the more recent versions of WiFi enable frames to be merged, which is more efficient because it means that the payload is a bigger proportion of the data transmitted – or, to put it another way, the control data in the headers forms a smaller proportion of the total.<br/><br/>Other nodes with data to transmit that were also backing off must start the whole process again, beginning by monitoring the channel for the check period. But during the next contention period, they count down only the remainder of their back-off period from the previous attempt. This increases their likelihood of success."
        },
        {
            "filename": "video/tm355_blk3_wifi_access_sec03-600-kbits.mp4",
            "width": "512",
            "height": "300",
            "transcript": "You might wonder what the point of the check period is. Why doesn’t the contention period begin immediately the channel is clear?<br/><br/>In fact, the point of the check period is to enable certain types of traffic to be given priority over others. Priority is enabled by specifying a short check period for certain types of traffic.<br/><br/>For example, if a node has just completed a transmission, it will expect to receive an acknowledgement very soon afterwards. Acknowledgements therefore should have priority over new transmissions.<br/><br/>Priority is achieved by allocating a short check period to acknowledgements. This guarantees they will be transmitted before new data, which has a longer check period.<br/><br/>An acknowledgement can be sent immediately after its short check period is over. There is no need for a contention window because there can only be one node needing to transmit an acknowledgement at any moment. <br/><br/>Another example of the use of a short check period to assign priority is when a node has won the race to gain control of the channel. Following the transmission of its first frame, subsequent frames are assigned a short check period. This enables a sequence of frames to be transmitted without interruption."
        },
        {
            "filename": "video/tm355_blk3_wifi_access_sec04-600-kbits.mp4",
            "width": "512",
            "height": "300",
            "transcript": "Now suppose there are two Basic Service Sets using the same channel and within range of each other.<br/><br/>For example, here are two access points and associated nodes, but belonging to separate Basic Service Sets that are within range of each other. They might be in neighbouring houses, for example.<br/><br/>If the Service Sets use the same channel, you might assume they must interfere with each other. But that isn’t what happens.<br/><br/>The nodes in the two sets sense the same channel, and only transmit when the channel is free.<br/><br/>Having more than one Service Set on the same channel, and within range of each other, is likely to slow the throughput, because each node waits longer for the channel to be free – but there isn’t any interference."
        },
        {
            "filename": "video/tm355_blk3_wifi_access_sec05-600-kbits.mp4",
            "width": "512",
            "height": "300",
            "transcript": "The collision avoidance protocol means that WiFi networks behave quite well together, even when there’s a high density of networks, as you often get in urban areas.<br/><br/>These are WiFi signals in the 2.4 GHz band detected in a shopping centre. This density of signals is not unusual for a busy location.<br/><br/>What’s fatal for WiFi is usually not other WiFi networks, but non-WiFi devices on the same channel (or spilling across it). Typical offenders include wireless baby monitors, microwave ovens, security cameras, audio-visual devices and remote controls. These devices do not use the ‘listen before transmit’ protocol that WiFi uses, and so interfere with WiFi transmission.<br/><br/>The relatively weak signal from this remote control unit on channel 3 made WiFi on channel 1 unusable."
        },
        {
            "filename": "video/tm355_blk3_wifi_access_sec06-600-kbits.mp4",
            "width": "512",
            "height": "300",
            "transcript": "The time intervals that must elapse before a node can transmit, such as the check period (which is officially called the interframe space) and the back-off period, are not specified in seconds. They are specified as a number of time slots. So when a node chooses a random back-off time, what it actually chooses is a random number of slots.<br/><br/>The waiting periods involved in CSMA CA mean that the radio channel is not used as efficiently as it could be if there were centralised control. This has led to the use of frame aggregation in WiFi versions 802.11n and 802.11ac. In these WiFi versions, when a node is finally able to transmit, it can send several aggregated frames at once rather than a series of frames.<br/><br/>Nevertheless, delay-sensitive traffic such as voice or video is not well served by the process I have described. Various refinements have been introduced to give this sort of traffic quicker access to the radio channel. These generally go under the name ‘enhanced distributed channel access’.<br/><br/>The configuration of nodes I have described here, where there’s an access point that all traffic passes through, is called ‘infrastructure mode’. The WiFi standards also permit ‘ad hoc mode’, in which nodes communicate directly with each other. This hasn’t been widely adopted."
        }
    ]
}