$(function () {
    // are we running in epub? - crude check
    if ((location.protocol != "http:") && (location.protocol != "https:") && (location.protocol != "file:")) {
        // really want to be able to check if specifically running in iBooks
        $("body").css({"margin-top":"40px"}); //shift activity downwards to escape top black bar in iBooks
    }

    //$("#document").attr("role", "document"); // make JAWS happy and stop it hijacking slider controls
    $("#controls").attr("role", "application"); // make JAWS happy and stop it hijacking slider controls
    //$("#aria").attr("aria-live", "assertive");
    $("#sliderThumb").attr("role", "slider"); // make JAWS happy and stop it hijacking slider controls

    var KEY_LEFT_ARROW = 37;
    var KEY_UP_ARROW = 38;
    var KEY_RIGHT_ARROW = 39;
    var KEY_DOWN_ARROW = 40;
    var KEY_HOME = 36;
    var KEY_END = 35;

    var dragging = false;
    var thumbStep = 5;
    //var thumbMin = 152;
    var thumbMin = 120;
    var thumbMax = 656;
    var thumbX = 120;
    var lastBand = -1;

    var isTouchSupported = 'ontouchstart' in window; //is this a 'touch' device?

    var bands = [
        ["band-VLF",152,214],
        ["band-LF",215,275],
        ["band-MF",276,338],
        ["band-HF",339,400],
        ["band-VHF",401,462],
        ["band-UHF",463,523],
        ["band-SHF",524,589],
        ["band-EHF",590,656]
    ]

    var sliderThumb = document.getElementById("sliderThumb");

    function keyDownHandler(evt) {
        if ((evt.which != KEY_LEFT_ARROW) && (evt.which != KEY_RIGHT_ARROW) &&
            (evt.which != KEY_UP_ARROW) && (evt.which != KEY_DOWN_ARROW) &&
            (evt.which != KEY_HOME) && (evt.which != KEY_END))
            return;

        if (evt.which == KEY_LEFT_ARROW || evt.which == KEY_DOWN_ARROW) {
            thumbX = parseInt($("#sliderThumb").css("left"));
            thumbX = thumbX - thumbStep;
            if (thumbX < thumbMin) thumbX = thumbMin;
            redraw();
        }
        if (evt.which == KEY_RIGHT_ARROW || evt.which == KEY_UP_ARROW) {
            thumbX = parseInt($("#sliderThumb").css("left"));
            thumbX = thumbX + thumbStep;
            if (thumbX > thumbMax) thumbX = thumbMax;
            redraw();
        }
        if (evt.which == KEY_HOME) {
            thumbX = thumbMin;
            redraw();
        }
        if (evt.which == KEY_END) {
            thumbX = thumbMax;
            redraw();
        }
        return consumeKeyEvent(evt);
    }

    //$("#slider").draggable({
    //    start: function (event, ui) {
    //        isDragging = true;
    //    },
    //    stop: function (event, ui) {
    //        isDragging = false;
    //    },
    //    drag: function( event, ui ) {
    //        $("#redline").css("left",ui.position.left+5);
    //    },
    //    containment: [150, 600, 730, 600]
    //});

    $("#sliderThumb").on("touchstart mousedown", function (evt) {
        mouseDownHandler(evt);
    });

    $("#sliderThumb").on("keydown", function (evt) {
        keyDownHandler(evt);
    });

    // show hand pointer when hovering on thumb control
    $("#sliderThumb").hover(
        function () {
            document.body.style.cursor = "pointer";
        },
        function () {
            document.body.style.cursor = "default";
        }
    );

    function consumeKeyEvent(evt) {
        if (evt.preventDefault) {
            evt.preventDefault();
        } //standard
        else if (evt.returnValue) {
            evt.returnValue = false;
        } //older IE
        return false;
    }

    function redraw() {
        sliderPercentage = (thumbX - thumbMin)/(thumbMax - thumbMin);
        $("#sliderThumb").css("left", thumbX);
        $("#redline").css("left", thumbX + 5);
        for (i=0; i<bands.length; i++) {
            if (thumbX >= bands[i][1] && thumbX <= bands[i][2]  ) {
                //check we are in a new band
                if (i != lastBand) {
                    thumbMin = 152; //no going back now we've started!
                    $("#intro").css("display", "none");
                    $("#" + bands[i][0]).css("display", "block");
                    $("#aria").html(bands[i][0]);
                    $("#sliderThumb").attr("aria-valuetext", bands[i][0]);
                    lastBand = i;
                }
            } else
                $("#"+bands[i][0]).css("display","none");
        }
    }

    // mouse/touch DOWN hander
    function mouseDownHandler(evt) {
        document.body.style.cursor = "pointer";
        document.getElementById("sliderThumb").focus();
        var eventObj;
        eventObj = isTouchSupported ? evt.originalEvent.touches[0] : evt;
        mouseX = eventObj.pageX; //(eventObj.pageX - bRect.left)*(uni.canvas.width/bRect.width);
        dragging = true;
        dragHoldX = mouseX - thumbX;
        if (dragging) {
            $("#sliderThumb").on("touchmove mousemove", function (evt) {
                mouseMoveHandler(evt);
            });
            $(document).on("touchmove mousemove", function (evt) {
                mouseMoveHandler(evt);
            });
        }
        $("#sliderThumb").off("touchstart mousedown");
        $("#sliderThumb").on("touchend mouseup", function (evt) {
            mouseUpHandler(evt);
        });
        $(document).on("touchend mouseup", function (evt) {
            mouseUpHandler(evt);
        });
        return consumeKeyEvent(evt);
    }

    // mouse/touch MOVE hander
    function mouseMoveHandler(evt) {
        document.body.style.cursor = "pointer";
        var eventObj;
        var bRect = sliderThumb.getBoundingClientRect();
        eventObj = isTouchSupported ? evt.originalEvent.touches[0] : evt;
        mouseX = eventObj.pageX; //(eventObj.pageX - bRect.left)*(uni.canvas.width/bRect.width);
        if (((mouseX - dragHoldX) >= thumbMin) && ((mouseX - dragHoldX) <= thumbMax))
            thumbX = mouseX - dragHoldX;
        redraw();
        return consumeKeyEvent(evt);
    }

    // mouse/touch UP hander
    function mouseUpHandler(evt) {
        document.body.style.cursor = "default";
        $("#sliderThumb").on("touchstart mousedown", function (evt) {
            mouseDownHandler(evt);
        });
        $("#sliderThumb").off("touchend mouseup");
        $(document).off("touchend mouseup");
        if (dragging) {
            dragging = false;
            $("#sliderThumb").off("touchmove mousemove");
            $(document).off("touchmove mousemove");
        }
        return consumeKeyEvent(evt);
    }
});