//1101010011
$(document).ready(function() {
    var amp = 60;
    var axesH = 80;
    var axesW = 750;
    var marginR = 40;
    var gw = axesW - marginR;
    var ox1 = 38;
    var oy1 = 20 + axesH;
    var ox2 = 38;
    var oy2 = 20 + axesH;
    var ox3 = 38;
    var oy3 = 20 + axesH;
    var isRunning = false;
    var frame = 0;
    var light_val = 50;
    var axes_color = "#000000";
    var verticals_color = "#c0c0c0";

    var square_wave = [];
    var cycles_per_pulse = 2;
    var num_carrier_sines = 30;

    var mode = 1;
    var isInputError = false;
    var pulse_width;
    var isSubmitted = false;

    $('#slider').rangeslider();

    // live entry validation to ensure only 1's & 0's are accepted
    // if value pasted in from clipboard this will strip out invalid chars
    var firstTime = true;
    $("#binary").on("input", function() {
        // IE9 & 10 triggers this event for some reason when the application starts. Also they place the focus
        // in the input box which triggers a bug that causes the placeholder text to disappear :o(
        // For these browsers detect and trap this initial occurrence and move focus onto the submit button instead.
        if ((navigator.userAgent.indexOf("Trident") >= 0) &&   //is an IE browser (pre MS EDGE)
            (navigator.userAgent.indexOf("MSIE 9.0") == -1) && //and not IE9 in standards mode
            (navigator.userAgent.indexOf("MSIE 7.0") == -1) && //and not IE9 in compatibility mode!
            (firstTime)) { // do it only once IMPORTANT!!
            $("#btnSubmit").focus();
            firstTime = false;
        }
        tempBinary = $("#binary").val();
        for (i=0; i<tempBinary.length; i++) {
            if ((tempBinary[i] != '0') && (tempBinary[i] != '1')) {
                tempBinary = tempBinary.slice(0,i) + tempBinary.slice(i+1,tempBinary.length);
                $("#binary").prop("value", tempBinary);
                i = i - 1;
            }
        }
    });

    $("#btnSubmit").on("click", function() {
        isInputError = false;
        square_wave = [];
        var binaryString = $("#binary").val();
        if (binaryString.length == 0) {
            $("#binary").focus();
            return;
        }
        for (i=0; i<binaryString.length; i++) {
            if ((binaryString[i] != '0') && (binaryString[i] != '1'))
                isInputError = true;
            else
                square_wave.push(binaryString[i]);
        }
        if (isInputError) {
            alert("That is not a valid binary string! Only 1's and 0's allowed.");
            $("#binary").focus();
        } else {
            cycles_per_pulse = $("#slider").val();
            num_carrier_sines = cycles_per_pulse * square_wave.length;
            drawMain();
            drawBinaryModulatedWave()
        }
        isSubmitted = true;
    });

    $("#modulation").on("change", function() {
        if (!isSubmitted) return;
        drawMain();
        drawBinaryModulatedWave()
    });

    $("#slider").on("input change", function() {
        if (!isSubmitted) return;
        cycles_per_pulse = $(this).val();
        num_carrier_sines = cycles_per_pulse * square_wave.length;
        drawMain();
        drawBinaryModulatedWave()
    })

    $("#btnDec").on("click", function() {
        if (cycles_per_pulse <= 1) return;
        cycles_per_pulse--;
        num_carrier_sines = cycles_per_pulse * square_wave.length;
        drawMain();
        drawBinaryModulatedWave()
    });
    $("#btnInc").on("click", function() {
        if (cycles_per_pulse >= 10) return;
        cycles_per_pulse++;
        console.log(cycles_per_pulse);
        num_carrier_sines = cycles_per_pulse * square_wave.length;
        drawMain();
        drawBinaryModulatedWave()
    });

    function sign(x){return x>0?1:x<0?-1:x}

    function drawBinaryModulatedWave() {
        switch ($("#modulation").val()) {
            case 'OOK':
                drawOOKModulatedWave();
                break;
            case 'ASK':
                drawASKModulatedWave();
                break;
            case 'BFSK':
                drawFSKModulatedWave();
                break;
            case 'BPSK':
                drawPSKModulatedWave();
                break;
        }
    }

    function drawMain() {
        clearCanvas();
        drawVerticals();
        drawAxes1();
        drawSquareWave();
        drawAxes2();
        drawCarrierWave();
        drawAxes3();
    }

    function drawCarrierWave() {
        var y1;

        var canvas = document.getElementById("carrier_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        scale = 0.1; //(w / 10);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#0000ff";
        ctx.lineWidth = 2;
        step = 1;
        freq = 40;
        ctx.beginPath();

        //cycles_per_pulse = parseInt(40 / square_wave.length);
        //sine_width = parseInt(gw / square_wave.length / cycles_per_pulse);
        console.log("cycles_per_pulse: " + cycles_per_pulse + ", square_wave.length: " + square_wave.length, "sine_width: ", sine_width);
        var lastX = ox2;
        var lastY = oy2;
        for (var i = 0; i < sine_width*square_wave.length*cycles_per_pulse; i++) {
            //calculate sine wave
            y1 = amp * Math.sin(2.0 * Math.PI * i/sine_width);

            ctx.moveTo(ox2 + i, oy2 - y1);
            ctx.lineTo(lastX, lastY);
            lastX = ox2 + i;
            lastY = oy2 - y1;
        }
        ctx.stroke();
        ctx.restore();
    }

    function drawSquareWave(lightness) {
        var y1, y2;
        if (typeof lightness === "undefined")
            lightness = 50;

        var canvas = document.getElementById("pulse_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = 'hsl(0, 100%, ' + lightness + '%)';
        ctx.lineWidth = 2;
        ctx.beginPath();
        //pulse_width = parseInt(gw / square_wave.length);
        for (i=0; i<gw; i++) {
            //calculate sine wave
            pulse_index1 = Math.floor(i / pulse_width);
            pulse_index2 = Math.floor((i+1) / pulse_width);
            if (pulse_index1 > square_wave.length) pulse_index1 = square_wave.length;
            if (pulse_index2 > square_wave.length) pulse_index2 = square_wave.length;
            y1 = amp * square_wave[pulse_index1];
            y2 = amp * square_wave[pulse_index2];
            ctx.moveTo(ox1 + i, oy1 - y1);
            ctx.lineTo(ox1 + (i + 1), oy1 - y2);
        }
        ctx.font = "16pt Arial";
        for (i=0; i<square_wave.length; i++) {
            ctx.fillText(square_wave[i], ox1 + (pulse_width*i) + pulse_width/2 - 8 , oy1 - amp - 10);
        }
        ctx.stroke();
        ctx.restore();
    }

    function drawVerticals() {
        cycles_per_pulse = parseInt(num_carrier_sines / square_wave.length);
        sine_width = parseInt(gw / square_wave.length / cycles_per_pulse);
        pulse_width = sine_width * cycles_per_pulse;

        var ctx = document.getElementById("pulse_graph").getContext("2d");
        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = verticals_color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        for (var i = 0; i <= square_wave.length; i++) {
            ctx.moveTo(ox1 + i * pulse_width, oy1 - axesH);
            ctx.lineTo(ox1 + i * pulse_width, oy1);
        }
        ctx.stroke();
        ctx.restore();

        ctx = document.getElementById("carrier_graph").getContext("2d");
        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = verticals_color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        for (var i = 0; i <= square_wave.length; i++) {
            ctx.moveTo(ox2 + i * pulse_width, oy2 - axesH);
            ctx.lineTo(ox2 + i * pulse_width, oy2 + axesH);
        }
        ctx.stroke();
        ctx.restore();

        ctx = document.getElementById("modulated_graph").getContext("2d");
        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = verticals_color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        for (var i = 0; i <= square_wave.length; i++) {
            ctx.moveTo(ox3 + i * pulse_width, oy3 - axesH);
            ctx.lineTo(ox3 + i * pulse_width, oy3 + axesH);
        }
        ctx.stroke();
        ctx.restore();
    }


    function drawOOKModulatedWave() {
        var y1, y2;

        var canvas = document.getElementById("modulated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        scale = 0.1; //(w / 10);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#0000ff";
        ctx.lineWidth = 2;
        step = 1;
        freq = 40;
        ctx.beginPath();
        //sine_width = parseInt(gw / square_wave.length / cycles_per_pulse);
        console.log(sine_width,gw,square_wave.length,cycles_per_pulse);
        for (var i = 0; i < sine_width*square_wave.length*cycles_per_pulse; i++) {
            //pulse_width = sine_width*cycles_per_pulse;
            pulse_index1 = Math.floor(i/pulse_width);
            pulse_index2 = Math.floor((i+1)/pulse_width);
            if (pulse_index1 > square_wave.length) pulse_index1 = square_wave.length;
            if (pulse_index2 > square_wave.length) pulse_index2 = square_wave.length;

            //calculate sine wave
            y1 = amp * Math.sin(2.0 * Math.PI * i/sine_width);
            y2 = amp * Math.sin(2.0 * Math.PI * (i + 1)/sine_width);

            if (square_wave[pulse_index1] == 0)
                y1 = 0;
            if (square_wave[pulse_index2] == 0)
                y2 = 0;

            ctx.moveTo(ox3+i, oy3 - y1);
            ctx.lineTo(ox3+(i + 1), oy3 - y2);
        }
        ctx.stroke();
        ctx.restore();
    }


    function drawASKModulatedWave() {
        var y1, y2;

        var canvas = document.getElementById("modulated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        scale = 0.1; //(w / 10);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#0000ff";
        ctx.lineWidth = 2;
        step = 1;
        freq = 40;
        ctx.beginPath();
        //sine_width = parseInt(gw / square_wave.length / cycles_per_pulse);
        console.log(sine_width,gw,square_wave.length,cycles_per_pulse);
        for (var i = 0; i < sine_width*square_wave.length*cycles_per_pulse; i++) {
            //pulse_width = sine_width*cycles_per_pulse;
            pulse_index1 = Math.floor(i/pulse_width);
            pulse_index2 = Math.floor((i+1)/pulse_width);
            if (pulse_index1 > square_wave.length) pulse_index1 = square_wave.length;
            if (pulse_index2 > square_wave.length) pulse_index2 = square_wave.length;

            //calculate sine wave
            y1 = amp * Math.sin(2.0 * Math.PI * i/sine_width);
            y2 = amp * Math.sin(2.0 * Math.PI * (i + 1)/sine_width);

            if (square_wave[pulse_index1] == 0)
                y1 = y1/2;
            if (square_wave[pulse_index2] == 0)
                y2 = y2/2;

            ctx.moveTo(ox3+i, oy3 - y1);
            ctx.lineTo(ox3+(i + 1), oy3 - y2);
        }
        ctx.stroke();
        ctx.restore();
    }


    function isEven(num) {
        if (num % 2 == 0) return(true);
        else return(false);
    }

    function drawFSKModulatedWave() { //test with 1010100
        var y1, y2;

        var canvas = document.getElementById("modulated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        scale = 0.1; //(w / 10);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#0000ff";
        ctx.lineWidth = 2;
        step = 1;
        freq = 40;
        ctx.beginPath();
        //sine_width = parseInt(gw / square_wave.length / cycles_per_pulse);
        //pulse_width = parseInt(gw / square_wave.length);
        console.log(sine_width,gw,square_wave.length,cycles_per_pulse);
        var last_bit = square_wave[0];
        var phase = 0;

        lastX = ox3; lastY = oy3;
        for (var j=0; j<square_wave.length; j++) {
            if (!isEven(cycles_per_pulse)) {
                if (square_wave[j] != last_bit) {
                    if (last_bit == 0)
                        if (phase == 0)
                            phase = Math.PI;
                        else
                            phase = 0;
                } else if ((last_bit == 0) && (j != 0))
                    if (phase == 0)
                        phase = Math.PI;
                    else
                        phase = 0;

                last_bit = square_wave[j];
            }
            for (var i=0; i<pulse_width; i++) {
                //calculate sine wave
                if (square_wave[j] == 0)
                    factor = 2;
                else
                    factor = 1;
                y1 = amp * Math.sin(2.0 * Math.PI * i / sine_width /factor + phase);

                ctx.moveTo(ox3 + i + j * pulse_width, oy3 - y1);
                ctx.lineTo(lastX, lastY);
                lastX = ox3 + i + j * pulse_width;
                lastY = oy3 - y1;
            }
        }
        ctx.stroke();
        ctx.restore();
    }


    function drawPSKModulatedWave() {
        var y1, y2;

        var canvas = document.getElementById("modulated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        scale = 0.1; //(w / 10);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#0000ff";
        ctx.lineWidth = 2;
        step = 1;
        freq = 40;
        ctx.beginPath();
        sine_width = parseInt(gw / square_wave.length / cycles_per_pulse);
        console.log(sine_width,gw,square_wave.length,cycles_per_pulse);
        for (var i = 0; i < sine_width*square_wave.length*cycles_per_pulse; i++) {
            pulse_width = sine_width*cycles_per_pulse;
            pulse_index1 = Math.floor(i/pulse_width);
            pulse_index2 = Math.floor((i+1)/pulse_width);
            if (pulse_index1 > square_wave.length) pulse_index1 = square_wave.length;
            if (pulse_index2 > square_wave.length) pulse_index2 = square_wave.length;

            //calculate sine wave
            y1 = amp * Math.sin(2.0 * Math.PI * i/sine_width);
            y2 = amp * Math.sin(2.0 * Math.PI * (i + 1)/sine_width);

            if (square_wave[pulse_index1] == 0) {
                y1 = amp * Math.sin(2.0 * Math.PI * i/sine_width + Math.PI);
            }
            if (square_wave[pulse_index2] == 0) {
                y2 = amp * Math.sin(2.0 * Math.PI * (i + 1)/sine_width + Math.PI);
            }

            ctx.moveTo(ox3+i, oy3 - y1);
            ctx.lineTo(ox3+(i + 1), oy3 - y2);
        }
        ctx.stroke();
        ctx.restore();
    }

    function drawAxes1() {
        var canvas = document.getElementById("pulse_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        //ctx.clearRect(0, 0, canvas.width, canvas.height);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = axes_color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        // y-axis
        ctx.moveTo(ox1, oy1);
        ctx.lineTo(ox1, oy1 - axesH - 8);
        ctx.moveTo(ox1, oy1 - axesH - 8);
        ctx.lineTo(ox1 - 4, oy1 - axesH - 4);
        ctx.moveTo(ox1, oy1 - axesH - 8);
        ctx.lineTo(ox1 + 4, oy1 - axesH - 4);
        // x-axis
        ctx.moveTo(ox1, oy1);
        ctx.lineTo(ox1 + axesW, oy1);
        ctx.moveTo(ox1 + axesW, oy1);
        ctx.lineTo(ox1 + axesW - 4, oy1 - 4);
        ctx.moveTo(ox1 + axesW, oy1);
        ctx.lineTo(ox1 + axesW - 4, oy1 + 4);
        // ticks & labels
        ctx.moveTo(ox1, oy1 - amp);
        ctx.lineTo(ox1 - 6, oy1 - amp);
        ctx.font = "14px Arial";
        ctx.fillText("1", ox1 - 16, oy1 - amp + 4);
        ctx.moveTo(ox1, oy1);
        ctx.lineTo(ox1 - 6, oy1);
        ctx.fillText("0", ox1 - 16, oy1 + 4);
        ctx.fillText("time", ox1 + axesW - 32, oy1 - 8);
        ctx.fillText("0", ox1 - 16, oy1 + 4);
        ctx.fillText("Data", ox1, oy1 + 14);
        ctx.stroke();

        ctx.translate(14, oy1-8);
        ctx.rotate(3*Math.PI/2);
        ctx.font = "14px Arial";
        ctx.fillStyle = "#000000";
        ctx.textAlign = "left";
        ctx.fillText("voltage (V)", 0,0);

        ctx.restore();
    }


    function drawAxes2() {
        var canvas = document.getElementById("carrier_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        //ctx.clearRect(0, 0, canvas.width, canvas.height);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = axes_color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        // y-axis
        ctx.moveTo(ox2, oy2 + axesH);
        ctx.lineTo(ox2, oy2 - axesH - 8);
        ctx.moveTo(ox2, oy2 - axesH - 8);
        ctx.lineTo(ox2 - 4, oy2 - axesH - 4);
        ctx.moveTo(ox2, oy2 - axesH - 8);
        ctx.lineTo(ox2 + 4, oy2 - axesH - 4);
        ctx.moveTo(ox2, oy2);
        ctx.lineTo(ox2, oy2 - axesH - 8);
        ctx.moveTo(ox2, oy2 - axesH - 8);
        ctx.lineTo(ox2 - 4, oy2 - axesH - 4);
        ctx.moveTo(ox2, oy2 - axesH - 8);
        ctx.lineTo(ox2 + 4, oy2 - axesH - 4);
        // x-axis
        ctx.moveTo(ox2, oy2);
        ctx.lineTo(ox2 + axesW, oy2);
        ctx.moveTo(ox2 + axesW, oy2);
        ctx.lineTo(ox2 + axesW - 4, oy2 - 4);
        ctx.moveTo(ox2 + axesW, oy2);
        ctx.lineTo(ox2 + axesW - 4, oy2 + 4);
        // ticks & labels
        ctx.moveTo(ox2, oy2 - amp);
        ctx.lineTo(ox2 - 6, oy2 - amp);
        ctx.font = "14px Arial";
        ctx.fillText("1", ox2 - 16, oy2 - amp + 4);
        ctx.moveTo(ox2, oy2);
        ctx.lineTo(ox2 - 6, oy2);
        ctx.fillText("0", ox2 - 16, oy2 + 4);
        ctx.moveTo(ox2, oy2 + amp);
        ctx.lineTo(ox2 - 6, oy2 + amp);
        ctx.fillText("-1", ox2 - 22, oy2 + amp + 4);
        ctx.fillText("time", ox2 + axesW - 32, oy2 + 14);
        ctx.fillText("Unmodulated carrier", ox2, oy2 + axesH + 14);
        ctx.stroke();

        ctx.translate(14, oy2+32);
        ctx.rotate(3*Math.PI/2);
        ctx.font = "14px Arial";
        ctx.fillStyle = "#000000";
        ctx.textAlign = "left";
        ctx.fillText("voltage (V)", 0,0);

        ctx.restore();
    }


    function drawAxes3() {
        var canvas = document.getElementById("modulated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        //ctx.clearRect(0, 0, canvas.width, canvas.height);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = axes_color;
        ctx.lineWidth = 1;
        ctx.beginPath();
        // y-axis
        ctx.moveTo(ox3, oy3 + axesH);
        ctx.lineTo(ox3, oy3 - axesH - 8);
        ctx.moveTo(ox3, oy3 - axesH - 8);
        ctx.lineTo(ox3 - 4, oy3 - axesH - 4);
        ctx.moveTo(ox3, oy3 - axesH - 8);
        ctx.lineTo(ox3 + 4, oy3 - axesH - 4);
        ctx.moveTo(ox3, oy3);
        ctx.lineTo(ox3, oy3 - axesH - 8);
        ctx.moveTo(ox3, oy3 - axesH - 8);
        ctx.lineTo(ox3 - 4, oy3 - axesH - 4);
        ctx.moveTo(ox3, oy3 - axesH - 8);
        ctx.lineTo(ox3 + 4, oy3 - axesH - 4);
        // x-axis
        ctx.moveTo(ox3, oy3);
        ctx.lineTo(ox3 + axesW, oy3);
        ctx.moveTo(ox3 + axesW, oy3);
        ctx.lineTo(ox3 + axesW - 4, oy3 - 4);
        ctx.moveTo(ox3 + axesW, oy3);
        ctx.lineTo(ox3 + axesW - 4, oy3 + 4);
        // ticks & labels
        ctx.moveTo(ox3, oy3 - amp);
        ctx.lineTo(ox3 - 6, oy3 - amp);
        ctx.font = "14px Arial";
        ctx.fillText("1", ox3 - 16, oy3 - amp + 4);
        ctx.moveTo(ox3, oy3);
        ctx.lineTo(ox3 - 6, oy3);
        ctx.fillText("0", ox3 - 16, oy3 + 4);
        ctx.moveTo(ox3, oy3 + amp);
        ctx.lineTo(ox3 - 6, oy3 + amp);
        ctx.fillText("-1", ox3 - 22, oy3 + amp + 4);
        ctx.fillText("time", ox3 +axesW - 32, oy3 + 14);
        switch ($("#modulation").val()) {
            case 'OOK':
                ctx.fillText("On-off keying (OOK)", ox3, oy3 + axesH + 14);
                break;
            case 'ASK':
                ctx.fillText("Amplitude shift keying (ASK)", ox3, oy3 + axesH + 14);
                break;
            case 'BFSK':
                ctx.fillText("Frequency shift keying (BFSK)", ox3, oy3 + axesH + 14);
                break;
            case 'BPSK':
                ctx.fillText("Phase shift keying (BPSK)", ox3, oy3 + axesH + 14);
                break;
        }
        //ctx.fillText("Modulated signal", ox3, oy3 + axesH + 14);
        ctx.stroke();

        ctx.translate(14, oy3+32);
        ctx.rotate(3*Math.PI/2);
        ctx.font = "14px Arial";
        ctx.fillStyle = "#000000";
        ctx.textAlign = "left";
        ctx.fillText("voltage (V)", 0,0);

        ctx.restore();
    }


    function clearCanvas() {
        var canvas = document.getElementById("pulse_graph");
        var ctx = canvas.getContext("2d");
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        canvas = document.getElementById("carrier_graph");
        ctx = canvas.getContext("2d");
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        canvas = document.getElementById("modulated_graph");
        ctx = canvas.getContext("2d");
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }
});
