/**
 * Created by as3632 on 26/08/2015.
 */
var freq = 200;
var amp = 0.5;
var margin = 8;
var fmargin = 20;
var axes_color = "#000000";

var mamp = 80;
var tmargin = 20;
var cx = 8+mamp, cy=8+mamp+tmargin;
var lx = cx + mamp + 40;
var ly = cy;
var gw = 250;
var angle = 0.5;
var angle_step = 2;
var isRunning = false;
var phase = 0;

var isLineDashSupported = true;

/**
 * requestAnimationFrame polyfill (required for IE9)
 **/
(function() {
    var lastTime = 0;
    var vendors = ['ms', 'moz', 'webkit', 'o'];
    for(var x = 0; x < vendors.length && !window.requestAnimationFrame; ++x) {
        window.requestAnimationFrame = window[vendors[x]+'RequestAnimationFrame'];
        window.cancelAnimationFrame = window[vendors[x]+'CancelAnimationFrame']
            || window[vendors[x]+'CancelRequestAnimationFrame'];
    }

    if (!window.requestAnimationFrame)
        window.requestAnimationFrame = function(callback, element) {
            var currTime = new Date().getTime();
            var timeToCall = Math.max(0, 16 - (currTime - lastTime));
            var id = window.setTimeout(function() { callback(currTime + timeToCall); },
                timeToCall);
            lastTime = currTime + timeToCall;
            return id;
        };

    if (!window.cancelAnimationFrame)
        window.cancelAnimationFrame = function(id) {
            clearTimeout(id);
        };
}());

$(document).ready(function() {
    // check if canvas line dash functionality is available
    var _canvas = document.createElement("canvas");
    _ctx = _canvas.getContext("2d");
    if (typeof _ctx.setLineDash === "undefined") isLineDashSupported = false;

    // line dash function for browsers without it, e.g. IE9 & 10
    var CP = window.CanvasRenderingContext2D && CanvasRenderingContext2D.prototype;
    if (CP.lineTo) {
        CP.dashedLine = function(x, y, x2, y2, da) {
            if (!da) da = [10,5];
            this.save();
            var dx = (x2-x), dy = (y2-y);
            var len = Math.sqrt(dx*dx + dy*dy);
            var rot = Math.atan2(dy, dx);
            this.translate(x, y);
            this.moveTo(0, 0);
            this.rotate(rot);
            var dc = da.length;
            var di = 0, draw = true;
            x = 0;
            while (len > x) {
                x += da[di++ % dc];
                if (x > len) x = len;
                draw ? this.lineTo(x, 0): this.moveTo(x, 0);
                draw = !draw;
            }
            this.restore();
        }
    }

    $('#freq_slider').rangeslider();
    $('#amp_slider').rangeslider();
    $('#phase_slider').rangeslider();

    drawTimeGraphAxes();
    drawWave();

    drawAnimatorAxes();
    drawAnimatorCircle();

    $("#freq_slider").on("input change", function(ev) {
        freq = parseFloat(this.value);
        updateFreqText();
        angle_step = freq/50;
        drawWave();
    });
    $("#amp_slider").on("input change", function(ev) {
        amp = parseFloat(this.value);
        updateAmpText();
        drawWave();
        redrawAnimator();
    });
    $("#phase_slider").on("input change", function(ev) {
        phase = parseFloat(this.value);
        updatePhaseText();
        drawWave();
    });

    function updateFreqText() {
        $("#freq_text").html("Frequency<br/>" + parseInt(freq) + " Hz");
    }
    function updateAmpText() {
        $("#amp_text").html("Amplitude<br/>" + amp.toFixed(2));
    }
    function updatePhaseText() {
        var ptext = "";
        if (phase == 0) ptext = "0"
        else if (Math.abs(phase) == 1) {
            if (phase < 0) ptext += "-";
            ptext += "&#x3c0;/8";
        }
        else {
            if (phase < 0) ptext += "-";
            var reduced = reduce(phase, 8);
            if (Math.abs(reduced[0]) != 1) ptext += Math.abs(reduced[0]);
            ptext += "&#x3c0;";
            if (Math.abs(reduced[1]) != 1) ptext += "/" + Math.abs(reduced[1]);
        }
        $("#phase_text").html("Phase<br/>" + ptext +"<br/>("+(phase*360.0/16.0).toFixed(1)+"&#xb0;)");
    }

    function reduce(numerator,denominator){
        var gcd = function gcd(a,b){
            return b ? gcd(b, a%b) : a;
        };
        gcd = gcd(numerator,denominator);
        return [numerator/gcd, denominator/gcd];
    }

    function drawWave() {
        var w, h, ox, oy, y1, y2, scale, step, wh;

        var canvas = document.getElementById("time_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
        drawTimeGraphAxes();

        ox = parseInt(w / 2);
        oy = parseInt(h / 2);
        scale = (w - (margin * 2)) / 20;

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#804080";
        ctx.lineWidth = 1;
        step = 0.01;
        wh = (amp * h - margin * 2) / 2;
        ctx.beginPath();
        for (var i = -10; i < 10; i = i + step) {
            //calculate sine wave
            y1 = wh * Math.sin(2.0 * Math.PI * freq * i / 1000 + phase * Math.PI / 8);
            y2 = wh * Math.sin(2.0 * Math.PI * freq * (i + step) / 1000 + phase * Math.PI / 8);
            ctx.moveTo(ox+i*scale, oy-y1);
            ctx.lineTo(ox+(i + step)*scale, oy-y2);
        }
        ctx.stroke();
        ctx.restore();
    }

    function drawTimeGraphAxes() {
        var canvas = document.getElementById("time_graph");
        var ctx = canvas.getContext("2d");
        ctx.save();
        ctx.translate(0.5,0.5);
        w = canvas.width;
        h = canvas.height;
        ox = parseInt(w / 2);
        oy = parseInt(h / 2);
        ctx.lineWidth = 1;
        ctx.strokeStyle = axes_color;
        ctx.beginPath();
        ctx.moveTo(ox, margin);
        ctx.lineTo(ox, h - margin);
        ctx.moveTo(margin, oy);
        ctx.lineTo(w - margin, oy);
        // draw ticks - horizontal axis
        ctx.moveTo(w - margin, oy);
        ctx.lineTo(w - margin, oy + 6);
        ctx.moveTo(margin, oy);
        ctx.lineTo(margin, oy + 6);
        // draw ticks - vertical axis
        ctx.moveTo(ox, margin);
        ctx.lineTo(ox - 6, margin);
        ctx.moveTo(ox, h - margin);
        ctx.lineTo(ox - 6, h - margin);
        ctx.stroke();
        // draw labels
        ctx.font = '10pt Arial';
        ctx.fillText('(ms)', w - margin - 24, oy - 6);
        ctx.fillText('-10', margin - 6, oy + 20);
        ctx.fillText('10', w - margin - 10, oy + 20);
        ctx.fillText('1', ox - 16, margin + 4);
        ctx.fillText('-1', ox - 20, h - margin + 4);
        ctx.font = 'italic 10pt Arial';
        ctx.fillText('t', w - margin - 34, oy - 6);
        ctx.fillText('V', ox + 5, margin + 4);
        ctx.restore();
    }

    $("#btnRun").on("click", function() {
        if (!isRunning) {
            $("#btnRun").html("Stop");
            $("#btnReset").prop("disabled", true);
            doAnimate();
        } else {
            isRunning = false;
            $("#btnRun").html("Generate");
            $("#btnReset").prop("disabled", false);
        }

    });
    $("#btnReset").on("click", function() {
        angle = 0.5;
        freq = 200.0;
        amp = 0.5;
        phase = 0;
        angle_step = freq/50;
        $("#freq_slider").val(freq);
        $("#amp_slider").val(amp);
        $("#phase_slider").val(phase);
        updateFreqText();
        updateAmpText();
        updatePhaseText();
        clearCanvas();
        drawTimeGraphAxes();
        drawWave();
        drawAnimatorCircle();
        drawAnimatorAxes();
    });

    function doAnimate() {
        isRunning = true;
        window.requestAnimationFrame(animLoop);
    }

    function animLoop() {
        if (((angle*50/freq) < gw) && (isRunning)) {
            redrawAnimator();
            drawAnimatorClockFace();
            drawAnimatorWave();
            angle += angle_step;
            window.requestAnimationFrame(animLoop);
        } else {
            isRunning = false;
            $("#btnRun").html("Generate");
            $("#btnReset").prop("disabled", false);
            angle = 0.5;
        }
    }

    function drawAnimatorClockFace() {
        var lineX1 = amp * mamp * Math.cos(2*Math.PI*angle/360 + phase * Math.PI / 8);
        var lineY1 = amp * mamp * Math.sin(2*Math.PI*angle/360 + phase * Math.PI / 8);
        var coordX1 = cx + lineX1;
        var coordY1 = cy - lineY1;

        var canvas = document.getElementById("animated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#000000";
        ctx.lineWidth = 1;
        ctx.font = 'italic 10pt Arial';

        //draw a radius out from circle centre
        ctx.beginPath();
        ctx.moveTo(cx, cy);
        ctx.lineTo(coordX1, coordY1);
        ctx.stroke();
        ctx.fillText('a', cx + lineX1/2 + (lineX1<0 ? 5 : -5), cy - lineY1/2 - (lineY1<0 ? -5 : 8));

        //draw perpendiular down to centre line
        ctx.beginPath();
        if (isLineDashSupported) {
            ctx.setLineDash([2.5, 2.5]);
            ctx.moveTo(coordX1, coordY1);
            ctx.lineTo(coordX1, cy);
        } else {
            ctx.dashedLine(coordX1, coordY1, coordX1, cy, [2.5, 2.5]);
        }
        ctx.stroke();
        ctx.fillText('y', coordX1 + (lineX1>=0 ? 4 : -10), (coordY1 + cy)/2);

        //draw dot following the circumference
        ctx.beginPath();
        if (isLineDashSupported) ctx.setLineDash([]);
        ctx.fillStyle="#000000";
        ctx.arc(coordX1, coordY1, 3, 0, 2*Math.PI);
        ctx.fill();

        ctx.restore();
    }

    function drawAnimatorWave() {
        var y1, y2;

        var canvas = document.getElementById("animated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        scale = 50/freq; //(w / 10);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#000000";
        ctx.lineWidth = 1;
        step = 1;
        //freq = 100;
        ctx.beginPath();
        //console.log(angle);
        for (var i = 0; i < angle; i++) {
            //calculate sine wave
            y1 = amp*mamp * Math.sin(2.0 * Math.PI * i/360 + phase * Math.PI / 8);
            y2 = amp*mamp * Math.sin(2.0 * Math.PI * (i + 1)/360 + phase * Math.PI / 8);
            ctx.moveTo(lx+i*scale, ly - y1);
            ctx.lineTo(lx+(i + 1)*scale, ly - y2);
        }
        ctx.stroke();

        var lineX1 = amp*mamp * Math.cos(2*Math.PI*angle/360 + phase*Math.PI/8);
        var lineY1 = amp*mamp * Math.sin(2*Math.PI*angle/360 + phase*Math.PI/8);
        var coordX1 = cx + lineX1;
        var coordY1 = cy - lineY1;
        ctx.beginPath();
        if (isLineDashSupported) {
            ctx.setLineDash([2.5, 2.5]);
            ctx.moveTo(coordX1, coordY1);
            ctx.lineTo(lx + (i + 1) * scale, ly - y2);
        } else {
            ctx.dashedLine(coordX1, coordY1, lx + (i + 1) * scale, ly - y2, [2.5, 2.5]);
        }
        ctx.stroke();
        ctx.restore();
    }

    function drawAnimatorAxes() {
        var canvas = document.getElementById("animated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        //ctx.clearRect(0, 0, canvas.width, canvas.height);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#000000";
        ctx.lineWidth = 1;
        ctx.beginPath();
        ctx.moveTo(lx, ly + mamp + tmargin);
        ctx.lineTo(lx, ly - mamp - tmargin);
        ctx.moveTo(lx, ly - mamp - tmargin);
        ctx.lineTo(lx - 4, ly - mamp - tmargin + 4);
        ctx.moveTo(lx, ly - mamp - tmargin);
        ctx.lineTo(lx + 4, ly - mamp - tmargin + 4);
        ctx.moveTo(lx-6, ly);
        ctx.lineTo(lx+gw, ly);
        ctx.moveTo(lx+gw, ly);
        ctx.lineTo(lx+gw-4, ly+4);
        ctx.moveTo(lx+gw, ly);
        ctx.lineTo(lx+gw-4, ly-4);
        // vertical ticks
        ctx.moveTo(lx, ly + mamp);
        ctx.lineTo(lx-6, ly + mamp);
        ctx.moveTo(lx, ly - mamp);
        ctx.lineTo(lx-6, ly - mamp);
        // horizontal ticks
        ctx.moveTo(lx+180, ly);
        ctx.lineTo(lx+180, ly + 6);
        ctx.stroke();
        ctx.font = 'normal 10pt Arial';
        ctx.fillText('-1', lx - 20, ly + mamp + 4);
        ctx.fillText('0', lx - 16, ly + 4);
        ctx.fillText('1', lx - 16, ly - mamp + 4);
        ctx.fillText('10', lx+180-8, ly+20);
        ctx.fillText('(ms)', lx+gw-8+6, ly+16);
        ctx.font = 'italic 10pt Arial';
        ctx.fillText('t', lx+gw-12, ly+16);
        ctx.fillText('V', lx-20, ly-mamp-12);
        ctx.restore();
    }

    function drawAnimatorCircle() {
        var canvas = document.getElementById("animated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        //ctx.clearRect(0, 0, canvas.width, canvas.height);

        ctx.save();
        ctx.translate(0.5, 0.5);
        ctx.strokeStyle = "#000000";
        ctx.lineWidth = 1;
        ctx.beginPath();
        if (isLineDashSupported) {
            ctx.setLineDash([5, 2.5]);
            ctx.arc(cx, cy, amp * mamp, 0, 2 * Math.PI);
            ctx.moveTo(cx - amp * mamp, cy);
            ctx.lineTo(cx + amp * mamp, cy);
        } else {
            ctx.arc(cx, cy, amp * mamp, 0, 2 * Math.PI);
            ctx.dashedLine(cx - amp * mamp, cy, cx + amp * mamp, cy, [5, 2.5]);
        }
        ctx.stroke();

        ctx.beginPath();
        if (isLineDashSupported) ctx.setLineDash([0, 0]);
        ctx.fillStyle="#000000";
        ctx.arc(cx, cy, 3, 0, 2*Math.PI);
        ctx.fill();
        ctx.restore();

        ctx.font = 'italic 10pt Arial';
        ctx.fillText('O', cx - 8, cy + 16);
    }

    function redrawAnimator() {
        clearCanvas();
        drawAnimatorCircle();
        drawAnimatorAxes();
    }

    function clearCanvas() {
        var canvas = document.getElementById("animated_graph");
        var ctx = canvas.getContext("2d");
        w = canvas.width;
        h = canvas.height;
        ctx.clearRect(0, 0, canvas.width, canvas.height);
    }

});