var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:0,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<div class=\"list-view\">Your tutor</div><div class=\"diagram-view\"><div class=\"ttl\">Your tutor</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Your tutor is an invaluable resource.  They are not just there to mark your assignments; they should be the first person to approach if you have questions about study issues.  They will be able to advise not only on the specialist content of your module or course, but also help with concerns about other study issues, such as academic writing.  They are likely to be able to provide advice tailored to your concerns and situation.</p></div>"
        },
        {
            label:"<div class=\"list-view\">Student support teams</div><div class=\"diagram-view\"><div class=\"ttl\">Student support teams</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Student Support Teams (SST) exist in all universities.  At The Open University, the team comprises experienced academics, educational advisors and other staff with subject-specific expertise.  The SST can point you towards appropriate support mechanisms and resources, for example, if you’d like extra help with writing skills.</p></div>"
        },
        {
            label:"<div class=\"list-view\">Tutorials</div><div class=\"diagram-view\"><div class=\"ttl\">Tutorials</div>",
            content:"<div class=\"box\"><p class=\"n-m-t\">The module or course you are studying may offer telephone, online or face-to-face tutorials.  These sessions may be run by your tutor or other subject specialists and are likely to develop your understanding of subject specific content, academic practices and also help you to practice communication skills. There may also be sessions specialising in academic writing and referencing help.</p></div>"
        },
        {
            label:"<div class=\"list-view\">Library</div><div class=\"diagram-view\"><div class=\"ttl\">Library</div>",
            content:"<div class=\"box\"><p class=\"n-m-t\">University libraries are about so much more than ‘borrowing books’.  Many will provide training (from live online events, recordings or face-to-face) along with interactive guides on ‘how to reference’ and ‘referencing styles’. Although it may sound strange, reading a range of academic literature – getting used to the style of writing and specialist terminology used in your discipline – will also help you to develop your voice.</p></div>"
        },
        {
            label:"<div class=\"list-view\">Other students</div><div class=\"diagram-view\"><div class=\"ttl\">Other students</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Other students can be very supportive as you progress through your studies. If your module or course uses online forums these can be a useful place to ask for help – you can share problems and ideas at any time.   However, keep in mind appropriate boundaries – when you followed Grace on her study journey, you should have identified potential areas of concern.</p></div>"
        },
        {
            label:"<div class=\"list-view\">You</div><div class=\"diagram-view\"><div class=\"ttl\">You</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Be honest with yourself.  Sometimes it is hard to acknowledge that you need help.  Be proactive. Make sure you engage with your module or course materials, read and interact with activities, and don’t be afraid to ask for help from appropriate sources.  Write all your study notes in your own words – that way, when you come to answer an assignment question, you will be less likely to accidentally use someone else’s words. Also – and this is the hard one – practice, practice, practice.  Learning to write in your own words and developing your academic voice takes time.  Everyone was a beginner once!</p></div>"
        }
    ]
};

var labels, reveals, resize;
var prevHeight;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
    prevHeight=document.getElementById("container").offsetHeight;
})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(function(){
            if(prevHeight!==document.getElementById("container").offsetHeight) {
                prevHeight=document.getElementById("container").offsetHeight;
                VLE.resize_iframe();
            } else {
                clearTimeout(resize);
            }
        }, 250);
    };
}
function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    resizeScreen();
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe()}, 250);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
}
function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        resizeScreen();
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
};