var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:false,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<div class=\"shadow-r\"></div><div class=\"title\">Specific</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">This is about being clear what you are trying to achieve: make your goal simple and specific.  For example, planning to spend an hour ‘studying’ is a little vague.  Instead, planning to ‘read and take notes from Section 3.2 of Topic 1’, or ‘complete Activity 1.1 in Topic 2’ are much more specific.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Measurable</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">How will you track your progress and know whether you’ve completed your goal? For example, ‘being able to correctly use and apply the equation to calculate density’ is better than ‘be better at maths’.   If you’ve been specific in planning what you will do, you will more easily be able to see if you’ve achieved your goal.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Achievable</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Your goal needs to be realistic.  It is likely to be something that will stretch or challenge you – to get to grips with a new concept, to learn a new skill – but it should still be possible.  For example, with the best will in the world, my goal of reading all the Sherlock Holmes stories in a week is unlikely to be achievable.  Unrealistic goals will demotivate you. Instead, you might consider goals such as ‘Complete chapter 3, in three, 2 hr sessions).</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Relevant</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">You need to consider how your specific goal fits in with other aspects of your life.  Is this goal important at the moment?  Is it necessary for your needs?  You might want to learn to sky-dive – but is this relevant to your other commitments at the moment (e.g. time available, places to learn, financial considerations).</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"title\">Timebound</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Linking back to ensuring your goal is measurable, you need to have a completion date.  This will help you to fit this specific goal into other aspects of your life but also stop you becoming too distracted.  Give yourself a sensible date when it needs to be finished.  For example, ‘I plan to complete Activity 1.1 in Topic 2 by the end of the week dated 15 September 2021’.  Setting yourself sensible deadlines can keep you focused but your completion dates need to be realistic or you’ll demotivate yourself.</p></div>"
        }
    ]
};

var labels, reveals, resize;
var prevHeight;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
    addClickToContainer();
    hasMediaLoaded();
    prevHeight=document.getElementById("container").offsetHeight;
    resizeScreen();
})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(function(){
            if(prevHeight!==document.getElementById("container").offsetHeight) {
                prevHeight=document.getElementById("container").offsetHeight;
                VLE.resize_iframe();
                scrollTop()

            } else {
                clearTimeout(resize);
            }
        }, 250);
    };
}

function addClickToContainer(){
    var containers = document.querySelectorAll(".seperate-container");
    for(var i=0; i< containers.length;i++){
        containers[i].onclick=function(){
            this.querySelector(".label-container .label").click();
        }
    }
}

function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    stopMedia();
    resizeScreen();
}
function stopMedia(){
    /* pauses vids */
    var medias = document.querySelectorAll("video,audio");
    for(var j=0; j<medias.length; j++){
        if(medias[j]) {
            if (medias[j].parentNode) {
                if (medias[j].parentNode.nextElementSibling) {
                    if (medias[j].parentNode.nextElementSibling.querySelector(".omp-stop")) {
                        medias[j].parentNode.nextElementSibling.querySelector(".omp-stop").click();
                    }
                }
            }
        }
    }
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe();scrollTop()}, 1000);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
                scrollTop()
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
    if(data.backgroundimage) {
        createEl(content,"div", null, null, {"class":"bkg-img"});
    }
    createEl(document.getElementById("container"), "script", null, null, {
        "data-main": "./oump/js/oump",
        "src": "./oump/js/loader.js"
    });
    var mediaContainer = document.querySelectorAll(".media-holder");
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        mediaContainer[mc].addEventListener("click", showHideTranscripts);
    }

    updateClass("add", document.querySelector("#container"), "loaded")
}

function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        stopMedia();
        VLE.resize_iframe();
        scrollTop()
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
}
function hasMediaLoaded() {
    var mediaContainer = document.querySelectorAll(".media-holder");
    var loaded = true;
    if(!hasClass(document.querySelector("#container"),"loaded")){
        loaded = false;
    }
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        if (!mediaContainer[mc].querySelector(".omp-placeholder-image")) {
            loaded = false;
        }
    }
    if (loaded) {
        setTimeout(function(){VLE.resize_iframe();scrollTop()}, 500);
        document.addEventListener('fullscreenchange', exitHandler);
        document.addEventListener('webkitfullscreenchange', exitHandler);
        document.addEventListener('mozfullscreenchange', exitHandler);
        document.addEventListener('MSFullscreenChange', exitHandler);
    } else {
        setTimeout(function () {
            hasMediaLoaded();
        }, 500);
    }

}
function exitHandler() {
    if (!document.fullscreenElement && !document.webkitIsFullScreen && !document.mozFullScreen && !document.msFullscreenElement) {
        setTimeout(function () {
            VLE.resize_iframe();
            scrollTop()
        }, 500);
    }
}
function showHideTranscripts(e) {
    var el = e.target;
    if (hasClass(el.parentNode, "omp-transcript-toggle-checkbox")) {
        setTimeout(function () {
            VLE.resize_iframe();
            scrollTop()
        }, 500);
    }
};
function scrollTop(){
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
}