var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:0,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<div class=\"list-view\">Description</div><div class=\"diagram-view\"><div class=\"ttl\">Description</div><div class=\"lbl-txt\"> What happened?</div></div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Remind yourself what you were intending to do in a study session – what were you hoping to achieve? What did you do / not do?  Where did it take place?  When did it take place?  Was anyone else there?</p></div>"
        },
        {
            label:"<div class=\"list-view\">Feelings</div><div class=\"diagram-view\"><div class=\"ttl\">Feelings</div><div class=\"lbl-txt\"> What were you thinking and feeling?</div></div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Your emotions and feelings can affect your actions.  How did you feel about your goal?  For example, were you looking forward to this topic? Had you any preconceived ideas about the topic? What sort of day outside of study had you had (e.g. productive day at work, difficult day juggling external demands?)</p></div>"
        },
        {
            label:"<div class=\"list-view\">Evaluation</div><div class=\"diagram-view\"><div class=\"ttl\">Evaluation</div><div class=\"lbl-txt\"> What was good and bad about the situation?</div></div>",
            content:"<div class=\"box\"><p class=\"n-m-t\">You need to be honest with yourself.  What worked well?  Why was this? What didn’t work so well? Why was this?</p></div>"
        },
        {
            label:"<div class=\"list-view\">Analysis</div><div class=\"diagram-view\"><div class=\"ttl\">Analysis</div><div class=\"lbl-txt\"> What sense can you make of the situation?</div></div>",
            content:"<div class=\"box\"><p class=\"n-m-t\">What do you think contributed to your feelings and overall evaluation?  Did you bring any assumptions into the task?  Do you have any new insights now you’ve attempted the task?</p></div>"
        },
        {
            label:"<div class=\"list-view\">Conclusion</div><div class=\"diagram-view\"><div class=\"ttl\">Conclusion</div><div class=\"lbl-txt\"> What else could you have done?</div></div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">What sense can you make of the session?  Could you have done anything differently?  What have you learnt about how you study?</p></div>"
        },
        {
            label:"<div class=\"list-view\">Action plan</div><div class=\"diagram-view\"><div class=\"ttl\">Action plan</div><div class=\"lbl-txt\"> If the situation arose again, what would you do?</div></div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">A take home point summing up what you will do differently next time.  It might be that everything went well – and you don’t need to change anything – that’s fabulous!</p></div>"
        }
    ]
};

var labels, reveals, resize;
var prevHeight;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
    prevHeight=document.getElementById("container").offsetHeight;
})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(function(){
            if(prevHeight!==document.getElementById("container").offsetHeight) {
                prevHeight=document.getElementById("container").offsetHeight;
                VLE.resize_iframe();
            } else {
                clearTimeout(resize);
            }
        }, 250);
    };
}
function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    resizeScreen();
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe()}, 250);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
}
function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        resizeScreen();
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
};