$(document).ready(function (){
	
	var page = 0;
 	var result =0;
	var resulttext ="";
	var tryagain=false;
	
	/* HIDE PAGES */ 
	
	$("#intro").hide();
	$("#intro").fadeIn(1000);	
	$("#mainpage").hide();

	/* INTRO CONTINUE BUTTON HOVER */

	$( "#introcontinue" ).hover(
	  function() {
		$( this ).css("background-image", "url(images/arrowhover.jpg)");
		$( this ).css("color", "#fcc92a");
		
	  }, function() {
		$( this ).css("background-image", "url(images/arrow.jpg)");
		$( this ).css("color", "#e6e7e9");
	  }
	);	
	
	function hovercontinue(){

		$(".continue").mouseenter(function(){
			$( this ).css("color", "#fcc92a");
		});
	   $(".continue").mouseleave(function(){
			$( this ).css("color", "#e6e7e9");
		});
	}	
	
	/* TRUE/FALSE HOVER */
	
	function hoverbuttons(){

		$("#truebutton,#falsebutton").mouseenter(function(){
			$( this ).css("color", "#fcc92a");
		});
	   $("#truebutton,#falsebutton").mouseleave(function(){
			$( this ).css("color", "#e6e7e9");
		});
	}

	/* QUESTIONS/ANSWERS */

	var questions = [
		{ question: "All students in Key Stages 3 and 4 must have careers education.", 
			answer:"The 1997 Education Act required schools to provide careers education in years 9-11 and this was extended to include year 7 and 8 from September 2004.", 
			boolean: "true" },
		{ question: "Schools must provide up-to-date information about careers and opportunities in learning for their students.", 
			answer:"The 1997 Act also required schools to provide up-to-date information about opportunities in education, training and employment. Schools provide this in a careers or Connexions resource centre or library. Much of this information is now ICT-based and help is available from the local Connexions service for providing it.", 
			boolean: "true" },
		{ question: "All students aged 13-19 must have a careers interview with a Connexions personal adviser.", 
			answer:"The Connexions service does not have the resources to provide this. Its prime purpose is to reduce the number of 13-19 year olds not in education, employment or training (NEETs) and its priority is those students with barriers to learning or at risk of dropping out. However most Connexions PAs run drop-in sessions in schools to answer students’ queries. Students can request an interview either at school or at the local Connexions centre with a personal adviser to discuss career options. ", 
			boolean: "false" },
		{ question: "There is a programme of study for careers education in the national curriculum for Key Stage 4.", 
			answer:"Although CEG is statutory for 11-16 year olds there has never been any statutory guidance that schools must follow. However, the programme of study for PSHE at Key Stages 3 and 4 does cover some aspects of CEG.", 
			boolean: "false" },
		{ question: "The national framework for CEG in England covers careers education for post-16 students.", 
			answer:"The framework includes learning outcomes for 16-19 year olds, which can be used to plan CEG programmes for young people in both full-time education and in work-based training. However schools, colleges and work-based training providers have no statutory duty to provide these programmes.", 
			boolean: "true" },
		{ question: "All students must do work-related learning during Key Stage 4.", 
			answer:"Since September 2004 schools have had a statutory duty to provide work-related learning for all KS4 students as part of the changes to the KS4 curriculum. There is a non-statutory framework for what should be provided (QCA/03/1168) which schools must ‘have regard for’.", 
			boolean: "true" },
		{ question: "All students must do work experience during Key Stage 4.", 
			answer:"Although currently about 94% of school students have a work experience placement of at least one week during Key Stage 4, there is no law requiring either schools or employers to provide placements or organise work experience programmes.", 
			boolean: "false" },
		{ question: "All trainee secondary teachers must know about the progression routes for their subject after Key Stage 4.", 
			answer:"From 2003, \"<span style=\"font-style:italic\">those awarded Qualified Teacher Status must demonstrate that for KS4 and post-16, they are aware of the pathways for progression through the 14-19 phase in school, college and work-based settings. They are familiar with the Key Skills as specified by QCA and the National Qualifications Framework, and they know the progression within and from their own subject and the range of qualifications to which their subject contributes. They understand how courses are combined in students’ curricula.</span>\" (TTA handbook:<span style=\"font-style:italic\">Qualifying to Teach 2003: S2.1d KS4 and post-16</span>)", 
			boolean: "true" }
	];
	
	/* INTRO CONTINUE BUTTON - EVENT HANDLER */
	
	$("#introcontinue").click(function(){
		$("#intro").hide();
		$("#mainpage").show();	
		loadcontent(page);
	});	
	
	/* RESET */
	
	function resetquest(){
		
		page = 0;
		result =0;
		resulttext ="";
		tryagain=false;	
		$("#truebutton").show();
		$("#falsebutton").show();
		$("#truebutton,#falsebutton").bind("click",aClick);		
		$("#truebutton,#falsebutton").removeClass("buttondisabled");
		$("#truebutton,#falsebutton").addClass("button");
		$(".continue").html("Continue");
		$(".continue").removeClass("button");
		$(".continue").addClass("buttondisabled");  
		$(".continue").unbind("click",nextpage);
		$(".continue").unbind('mouseenter mouseleave');	
		$(".continue").css("color", "#e6e7e9");
		hoverbuttons();		
	}
	
	/* CONTINUE BUTTON - EVENT HANDLER*/
	
	function nextpage(){
	
		page +=1;	
		
		if(page<8){
			loadcontent(page); 
			$(".answer").html("");
			$("#truebutton,#falsebutton").bind("click",aClick);		
			$("#truebutton,#falsebutton").removeClass("buttondisabled");
			$("#truebutton,#falsebutton").addClass("button");
			hoverbuttons();
			$(".continue").removeClass("button");
			$(".continue").addClass("buttondisabled");	
			$(".continue").unbind("click",nextpage);
			$(".continue").unbind('mouseenter mouseleave');	
			$(".continue").css("color", "#e6e7e9");
		}else{
			
			if(!tryagain){
				$(".continue").html("Try again");
				tryagain=true;
							
				$("#truebutton").hide();
				$("#falsebutton").hide();
				$(".pager").html("Result");
								
				var resulttext = "<span style=\"font-size:20px;\">You got "+result+" out of 8 of the answers correct.</span>";
				
				$(".text").html(resulttext);
				$(".answer").html("");
				
			}else{
				resetquest();
				loadcontent(page); 
			}
					
		}		
	}
	
	function loadcontent(content){		 
		$(".pager").html((content+1)+" of 8");
		$(".text").html(questions[content]["question"]);		
	}	
	
	/* TRUE/FALSE BUTTONS - EVENT HANDLER */
		
	function aClick() {
		$("#truebutton,#falsebutton").unbind("click");
		$("#truebutton,#falsebutton").removeClass("button");
		$("#truebutton,#falsebutton").addClass("buttondisabled");
		$("#truebutton,#falsebutton").unbind('mouseenter mouseleave');
		$("#truebutton,#falsebutton").css("color", "#e6e7e9");
		$(".continue").removeClass("buttondisabled");
		$(".continue").addClass("button");
		checkanswer(this.id);
		hovercontinue();
	} 
	
	$("#truebutton").bind("click",aClick);
	$("#falsebutton").bind("click",aClick);
	$(".continue").removeClass("button");
	$(".continue").addClass("buttondisabled");  	
	
	/* CHECK THE RIGHT ANSWER */
	
	function checkanswer(trigger){
			
		var rightanswer="";
		
		if(trigger=="truebutton"){
			if(questions[page]["boolean"]=="true"){
				rightanswer="<span class=\"bold\">True is the right answer.</span> "; result++;
			}else{
				rightanswer="<span class=\"bold\">True is not the right answer.</span> ";
			}
		}else{
			if(questions[page]["boolean"]=="false"){
				rightanswer="<span class=\"bold\">False is the right answer.</span> "; result++;
			}else{
				rightanswer="<span class=\"bold\">False is not the right answer.</span> ";
			}
		}	
				
		$(".answer").html(rightanswer+questions[page]["answer"]);
		
		$(".continue").bind("click",nextpage);
	}	
	
	hoverbuttons();
})	
	
	
	
	
	
	
	
	
	
	
	
	
	
	