var saveData = {};
var slides = [];
var slideContainer;
var currSlide = 0;
var init = true;
var resize;
var prevHeight = 0;
var maxHeight = 0;
var maxWidth = 0;
var imgs = [];
var initSlideCount = 0;
var imgLoadCount = 0;

(function () {
    document.querySelector("#styles").onload = function () {
        resizeContainer();
    }
    slideContainer = document.querySelector("#slides");
    setupSlides();
    addNavBtns();
    cloneMenus();
    selectPage(0);
    window.onresize = function () {
        resizeContainer();
    };
    resizeContainer();
}());

function makeCloneMenu(navMenuClone, menu) {
    navMenuClone.classList.remove("nav-menu");
    navMenuClone.classList.add("nav-menu-clone");
    menu.parentNode.replaceChild(navMenuClone, menu)
    var navMarkers = navMenuClone.querySelectorAll(".nav-marker")
    for (var p = 0; p < navMarkers.length; p++) {
        navMarkers[p].onclick = function () {
            selectPage(this.getAttribute("data-marker"))
            document.getElementById("slide-" + currSlide).querySelector(".nav-marker[data-marker=\"" + this.getAttribute("data-marker") + "\"]").focus();
        }
    }
    navMenuClone.querySelector(".nav-next-btn").onclick = function () {
        var n = Number(currSlide) + 1;
        if (n < 0) {
            n = slides.length - 1;
        } else if (n === slides.length) {
            n = 0;
        }
        selectPage(Number(currSlide) + 1)
        if (this.parentNode.getAttribute("data-location") === "mid") {
            document.getElementById("slide-" + currSlide).querySelector(".nav-next-btn").focus();
        }
    }
    navMenuClone.querySelector(".nav-prev-btn").onclick = function () {
        var n = Number(currSlide) - 1;
        if (n < 0) {
            n = slides.length - 1;
        } else if (n === slides.length) {
            n = 0;
        }
        selectPage(Number(currSlide) - 1)
        if (this.parentNode.getAttribute("data-location") === "mid") {
            document.getElementById("slide-" + currSlide).querySelector(".nav-prev-btn").focus();
        }
    }
}
function resizeContainer(imgResize) {
    if (imgResize) {
        VLE.resize_iframe();
        setSlideSize();
    } else {
        clearTimeout(resize);
        resize = setTimeout(function () {
            if (prevHeight !== document.getElementById("slides").offsetHeight) {
                prevHeight = document.getElementById("slides").offsetHeight;
                VLE.resize_iframe();
            } else {
                clearTimeout(resize);
            }
            setSlideSize();
        }, 250);
    }
}

function setSlideSize() {
    //ensures all slide sizes are the same so that menu doesn't jump around.
    prevMaxHeight = maxHeight;
    maxHeight = 0;
    prevMaxWidth = maxWidth;
    maxWidth = 0;
    document.querySelector("#slides").style.height = "";
    document.querySelector("#slides").style.width = "";
    for (var i = 0; slides.length > i; i++) {
        if (slides[i].offsetHeight > maxHeight) {
            maxHeight = slides[i].offsetHeight
        }
        if (slides[i].offsetWidth > maxWidth) {
            maxWidth = slides[i].offsetWidth
        }
    }
    if (maxHeight !== prevMaxHeight) {
        document.querySelector("#slides").style.height = maxHeight + "px";
    } else {
        document.querySelector("#slides").style.height = prevMaxHeight + "px";
    }
    if (maxWidth !== prevMaxWidth) {
        document.querySelector("#slides").style.width = maxWidth + "px";
    } else {
        document.querySelector("#slides").style.width = prevMaxWidth + "px";
    }
}
function setupSlides() {
    var slidenum = 0;
    var cloneMenuTop = slideContainer.parentNode.insertBefore(document.createElement("div"), slideContainer);
    cloneMenuTop.classList.add("add-menu");
    cloneMenuTop.setAttribute("data-location", "top")
    for (var i = 0; i < data.length; i++) {
        var slide = document.createElement("div");
        slide.classList.add("slide");
        slide.id = "slide-" + slidenum;
        slideContainer.appendChild(createSlide(slide, data[i]));
        if (typeof data[i].content !== "undefined") {
            var content = slide.appendChild(document.createElement("div"))
            content.classList.add("slide-content")
            content.innerHTML = data[i].content
        }
        if (typeof data[i].questions !== "undefined") {
            setupupQuestions(slide, data[i].questions, i)
        }
        slides.push(slide)
        slidenum++;
    }

}
function setupupQuestions(slide, questions, sNum) {
    var qNum = 0;
    var slideQsDiv = slide.appendChild(document.createElement("div"))
    slideQsDiv.classList.add("slide-qs-div")
    for (var q in questions) {
        var qDiv = slideQsDiv.appendChild(document.createElement("div"))
        qDiv.classList.add("q-div")
        var question = qDiv.appendChild(document.createElement("div"))
        question.classList.add("q")
        question.innerHTML = questions[q].question;
        var aNum = 0;
        for (var a in questions[q].answers) {
            var aDiv = qDiv.appendChild(document.createElement("div"))
            aDiv.classList.add("a-div")
            var inp = aDiv.appendChild(document.createElement("input"))
            inp.type = questions[q].type
            inp.name = "s-" + sNum + "-q-" + qNum
            inp.id = inp.name + "-a-" + aNum
            var lbl = aDiv.appendChild(document.createElement("label"))
            lbl.setAttribute("for", inp.id)
            lbl.innerHTML = questions[q].answers[a].answer
            aNum++;
            inp.onchange = function () {
                var inps = this.parentNode.parentNode.querySelectorAll("input")
                for (var i = 0; i < inps.length; i++) {
                    dataSlct(inps[i])
                }
            }
        }
        var qBtns = qDiv.appendChild(document.createElement("div"));
        qBtns.classList.add("q-btns")
        var checkBtn = qBtns.appendChild(document.createElement("button"));
        checkBtn.setAttribute("data-slide", sNum)
        checkBtn.setAttribute("data-q", qNum)
        checkBtn.innerHTML = "Check answer"
        checkBtn.classList.add("checkBtn")
        checkBtn.onclick = function () {
            checkAnswer(this, false)
        }
        var revealBtn = qBtns.appendChild(document.createElement("button"));
        revealBtn.setAttribute("data-slide", sNum)
        revealBtn.setAttribute("data-q", qNum)
        revealBtn.innerHTML = "Reveal answer"
        revealBtn.classList.add("revealBtn")
        revealBtn.onclick = function () {
            checkAnswer(this, true)
        }
        var resetBtn = qBtns.appendChild(document.createElement("button"));
        resetBtn.setAttribute("data-slide", sNum)
        resetBtn.setAttribute("data-q", qNum)
        resetBtn.innerHTML = "Reset"
        resetBtn.classList.add("resetBtn")
        resetBtn.setAttribute("disabled", true)
        resetBtn.onclick = function () {
            resetAnswers(this)
        }
        var qFeedback = qDiv.appendChild(document.createElement("div"));
        qFeedback.classList.add("q-feedback")
        qFeedback.setAttribute("data-slide", sNum)
        qFeedback.setAttribute("aria-live", "polite")
        qFeedback.setAttribute("data-q", qNum)
        qNum++;
    }
}
function resetAnswers(obj) {
    var s = obj.getAttribute("data-slide")
    var q = obj.getAttribute("data-q")
    var fbk = document.querySelector(".q-feedback[data-slide=\"" + s + "\"][data-q=\"" + q + "\"]")
    fbk.innerHTML = ""
    var inps = fbk.parentNode.querySelectorAll("input");
    for (var i = 0; i < inps.length; i++) {
        inps[i].removeAttribute("disabled")
        inps[i].checked = false
        dataSlct(inps[i])
    }

    fbk.parentNode.querySelector(".resetBtn").setAttribute("disabled", true)
    fbk.parentNode.querySelector(".revealBtn").removeAttribute("disabled")
    fbk.parentNode.querySelector(".checkBtn").removeAttribute("disabled")
    resizeContainer(true)
}

function checkAnswer(obj, reveal) {
    var defaultAnswers = {
        "correct": "<p>Your answer is correct.</p>",
        "incorrect": "<p>Your answer is incorrect.</p>",
        "partial": "<p>Your answer is partially correct.</p>",
        "reveal": ""
    }
    var s = obj.getAttribute("data-slide")
    var q = obj.getAttribute("data-q")
    var fbk = document.querySelector(".q-feedback[data-slide=\"" + s + "\"][data-q=\"" + q + "\"]")
    var qContain = fbk.parentNode
    var inps = qContain.querySelectorAll("input");
    if (reveal) {
        for (var i = 0; i < inps.length; i++) {
            inps[i].checked = false
            if (data[s].questions[q].answers[i].correct) {
                inps[i].checked = "true"
            }
            dataSlct(inps[i])
            inps[i].setAttribute("disabled", true)
        }
        fbk.parentNode.classList.add("revealed")
        qContain.parentNode.querySelector(".resetBtn").removeAttribute("disabled")
        qContain.parentNode.querySelector(".revealBtn").setAttribute("disabled", true)
        qContain.parentNode.querySelector(".checkBtn").setAttribute("disabled", true)
        if (data[s].questions[q].feedback) {
            if (data[s].questions[q].feedback.reveal) {
                fbk.innerHTML = data[s].questions[q].feedback.reveal
            } else {
                fbk.innerHTML = defaultAnswers.reveal
            }
        } else {
            fbk.innerHTML = defaultAnswers.reveal
        }
        resizeContainer(true)
    } else {
        var correct = true;
        var partial = false;
        for (var i = 0; i < inps.length; i++) {
            if (data[s].questions[q].answers[i].correct === inps[i].checked) {
                if (inps[i].checked) {
                    partial = true
                }
            } else {
                correct = false
            }
        }
        if (correct) {
            if (data[s].questions[q].feedback) {
                if (data[s].questions[q].feedback.correct) {
                    fbk.innerHTML = data[s].questions[q].feedback.correct
                } else {
                    fbk.innerHTML = defaultAnswers.correct
                }
            } else {
                fbk.innerHTML = defaultAnswers.correct
            }
            for (var i = 0; i < inps.length; i++) {
                inps[i].setAttribute("disabled", true)
            }

            fbk.parentNode.classList.add("revealed")
            fbk.parentNode.querySelector(".revealBtn").setAttribute("disabled", true)
            obj.setAttribute("disabled", true);
        } else {
            if (partial) {
                if (data[s].questions[q].feedback) {
                    if (data[s].questions[q].feedback.partial) {
                        fbk.innerHTML = data[s].questions[q].feedback.partial
                    } else {
                        fbk.innerHTML = defaultAnswers.partial
                    }
                } else {
                    fbk.innerHTML = defaultAnswers.partial
                }
            } else {
                if (data[s].questions[q].feedback) {
                    if (data[s].questions[q].feedback.incorrect) {
                        fbk.innerHTML = data[s].questions[q].feedback.incorrect
                    } else {
                        fbk.innerHTML = defaultAnswers.incorrect
                    }
                } else {
                    fbk.innerHTML = defaultAnswers.incorrect
                }
            }
            fbk.parentNode.classList.remove("revealed")
        }
        fbk.parentNode.querySelector(".resetBtn").removeAttribute("disabled")
        obj.setAttribute("disabled", true);
    }
    resizeContainer(true)
}
function dataSlct(obj) {
    var s = obj.parentNode.parentNode.querySelector(".checkBtn").getAttribute("data-slide")
    var q = obj.parentNode.parentNode.querySelector(".checkBtn").getAttribute("data-q")
    var fbk = document.querySelector(".q-feedback[data-slide=\"" + s + "\"][data-q=\"" + q + "\"]")

    obj.parentNode.parentNode.querySelector(".checkBtn").removeAttribute("disabled");
    fbk.innerHTML = ""
    obj.parentNode.setAttribute("data-slct", obj.checked)

    fbk.parentNode.classList.remove("revealed")
}
function cloneMenus() {

    document.querySelector(".nav-menu").setAttribute("data-location", "bottom")
    var addmenus = document.querySelectorAll(".add-menu")
    for (var o = 0; o < addmenus.length; o++) {
        if (typeof settings.navMenu !== "undefined") {
            if (settings.navMenu.mid !== false && addmenus[o].getAttribute("data-location") === "mid") {
                var navMenuClone = document.querySelector(".nav-menu").cloneNode(true)
                navMenuClone.setAttribute("data-location", "mid")
                makeCloneMenu(navMenuClone, addmenus[o])
            }
        }
    }

    if (typeof settings.navMenu !== "undefined") {
        if (settings.navMenu.top !== false) {
            var navMenuClone = document.querySelector(".nav-menu").cloneNode(true)
            navMenuClone.setAttribute("data-location", "top")
            makeCloneMenu(navMenuClone, slideContainer.parentNode.querySelector(".add-menu"))

        }
        if (settings.navMenu.bottom === false) {
            document.querySelector(".nav-menu").classList.add("hidden")
        }
    }

}
function createSlide(slide, data) {
    if (data.img !== undefined) {
        var imgContainer = slide.appendChild(document.createElement("div"));
        imgContainer.classList.add("img-container");
        var imgPlace = imgContainer.appendChild(document.createElement("div"));
        imgPlace.classList.add("img-place");
        var img = imgPlace.appendChild(document.createElement("img"));
        img.src = data.img;
        img.setAttribute("alt",data.imgalt);
        var imgAlt = imgContainer.appendChild(document.createElement("div"));
        imgAlt.classList.add("img-alt");
        imgAlt.setAttribute("tabindex", "0");
        imgAlt.innerHTML = data.imgdesc;
        var imgDescBtnContain = imgPlace.appendChild(document.createElement("div"));
        imgDescBtnContain.classList.add("img-desc");
        var imgDescBtn = imgDescBtnContain.appendChild(document.createElement("button"));
        imgDescBtn.innerText = "View image description"

        imgDescBtn.onclick = function () {
            //this.parentNode.parentNode.querySelector(".img-alt")
            var imgAlt = this.parentNode.parentNode.parentNode.querySelector(".img-alt")
            if (this.innerText === "View image description") {
                this.innerText = "Hide image description";
                imgAlt.classList.add("showing");
            } else {
                this.innerText = "View image description";
                imgAlt.classList.remove("showing");
            }
            resizeContainer(true);
        }
    }

    var cloneMenuMid = slide.appendChild(document.createElement("div"));
    cloneMenuMid.classList.add("add-menu");
    cloneMenuMid.setAttribute("data-location", "mid")
    return slide;
}


function addNavBtns() {
    var menu = slideContainer.parentNode.appendChild(document.createElement("div"));
    menu.classList.add("nav-menu");
    var prevBtn = document.createElement("button");
    prevBtn.classList.add("nav-btn");
    prevBtn.classList.add("nav-prev-btn");
    prevBtn.innerText = "previous";
    prevBtn.setAttribute("aria-label", "previous");
    prevBtn.onclick = function () {
        selectPage(Number(currSlide) - 1)
    };
    menu.appendChild(prevBtn);
    for (var i = 0; i < slides.length; i++) {
        var marker = document.createElement("button");
        marker.classList.add("nav-marker");
        marker.setAttribute("data-marker", i);
        marker.setAttribute("aria-label", "page " + (i + 1));
        marker.onclick = function () {
            selectPage(Number(this.getAttribute("data-marker")))
        }
        menu.appendChild(marker);
    }
    var nextBtn = document.createElement("button");
    nextBtn.classList.add("nav-btn");
    nextBtn.classList.add("nav-next-btn");
    nextBtn.innerText = "next";
    nextBtn.setAttribute("aria-label", "next");
    nextBtn.onclick = function () {
        selectPage(Number(currSlide) + 1);
    };
    menu.appendChild(nextBtn);
}
function selectPage(n) {
    if (n < 0) {
        n = slides.length - 1
    } else if (n === slides.length) {
        n = 0;
    }
    var menus = document.querySelectorAll(".nav-menu, .nav-menu-clone")
    for (var j = 0; j < menus.length; j++) {
        for (var i = 0; i < slides.length; i++) {
            if (slides[i].classList.contains("hidden")) {
                slides[i].classList.remove("hidden");
            }
            slides[i].classList.add("hidden");
            if (menus[j].querySelectorAll(".nav-menu .nav-marker, .nav-menu-clone .nav-marker")[i].classList.contains("active")) {
                menus[j].querySelectorAll(".nav-menu .nav-marker, .nav-menu-clone .nav-marker")[i].classList.remove("active");
            }
            slides[n].classList.remove("hidden");
            menus[j].querySelectorAll(".nav-menu .nav-marker, .nav-menu-clone .nav-marker")[n].classList.add("active");
            currSlide = n;
        }
    }
    if (!init) {
        VLE.resize_iframe();
    } else {
        init = false;
    }
}