var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:false,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<div class=\"shadow-r\"></div><div class=\"title\">Picture fiction/picture books</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\"><b>Possible benefits</b></p><p class=\"n-m-t n-m-b\">1. Seems manageable to a less confident reader.</p><p class=\"n-m-t n-m-b\">2. Opportunities to discuss the illustrations in relation to the text.</p><p class=\"n-m-t n-m-b\">3. Can offer a comprehension challenge to interpret a story without words or meaning ‘hidden’ in the illustrations.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Possible features and forms</b></p><p class=\"n-m-t n-m-b\">Less dense text; interplay between the writing and the pictures; wordless picture fiction; hybrid picture fiction based on non-fiction themes.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Examples</b></p><p class=\"n-m-t n-m-b\"><i>The Hat Trilogy</i> by Jon Klassen; <i>Lost</i> by Nicola Davies; <i>Counting on Katherine</i> by Helaine Becker; <i>The Arrival</i> by Shaun Tan; <i>Tuesday</i> by David Wiesner.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Narrative fiction</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\"><b>Possible benefits</b></p><p class=\"n-m-t n-m-b\">1. Opportunities to invest in characters and storyline.</p><p class=\"n-m-t n-m-b\">2. Sustained reading challenge through longer plot-line.</p><p class=\"n-m-t n-m-b\">3. Likely to prompt discussion of characters, setting and actions with the potential to relate to the readers' own experiences.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\">4. Opportunities to predict and discuss events.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Possible features and forms</b></p><p class=\"n-m-t n-m-b\">Chapters or short stories can sustain interest for reading aloud; wide range of contexts and genres within narrative, such as fantasy, histoical, and contemporary realism.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Examples</b></p><p class=\"n-m-t n-m-b\"><i>Legend of Eerie on Sea</i>, <i>Malamander</i> and <i>Gargantis</i> by Thomas Taylor; <i>Armistice Runner</i> and <i>After the War</i> by Tom Palmer; <i>High Rise Mystery</i> by Sharna Jackson.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Comics and graphic novels</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\"><b>Possible benefits</b></p><p class=\"n-m-t n-m-b\">1. Illustrations and more minimal text with a storyboard format can support shorter attention spans.</p><p class=\"n-m-t n-m-b\">2. Readers can become interested in familiar comic characters and enjoy the swift paced action.</p><p class=\"n-m-t n-m-b\">3. Format can 'chime' with those who enjoy computer games.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Possible features and forms</b></p><p class=\"n-m-t n-m-b\">Familiar children's comics; new contemporary comics; graphic novels developing comic characters, graphic novels tackling serious themes.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Examples</b></p><p class=\"n-m-t n-m-b\"><i>The Beano</i>; <i>Minecraft World</i>; <i>The Stonekeeper</i> by Kazu Kibuishi; <i>El Deafo</i> by Cicely Bell.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Poetry</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\"><b>Possible benefits</b></p><p class=\"n-m-t n-m-b\">1. Short bursts of reading and fewer words can entice a nervous reader.</p><p class=\"n-m-t n-m-b\">2. Reading aloud, listening to recordings or performing with friends can stimulate the social element of reading.</p><p class=\"n-m-t n-m-b\">3. Funny poems can be popular as can themed anthologies with colourful illustrations.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Possible features and forms</b></p><p class=\"n-m-t n-m-b\">Single author volumes or anthologies or multiple authors; poetic non-fiction crosses over with picture books.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Examples</b></p><p class=\"n-m-t n-m-b\"><i>Poems Aloud</i> by Joseph Coehlo; <i>Poems from a green and blue planet</i> by Sabrina Mahfouz; <i>The story of a Raindrop</i> by James Carter.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"title\">Non-fiction</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\"><b>Possible benefits</b></p><p class=\"n-m-t n-m-b\">1. Covers subjects that may picque the interest of individuals from maps to fashion design.</p><p class=\"n-m-t n-m-b\">2. Readers can 'dip into' the text and also enjoy the illustrations.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Possible features and forms</b></p><p class=\"n-m-t n-m-b\">Enticing photographs or illustrations with text; wide topic range, including biography, history, etc.</p><p class=\"n-m-t n-m-b\"></p><p class=\"n-m-t n-m-b\"><b>Examples</b></p><p class=\"n-m-t n-m-b\"><i>A Book of Bears: At home with bears around the world</i> by Katie Viggers; <i>The Undefeated</i> by Kwame Alexander.</p></div>"
        }
    ]
};

var labels, reveals, resize;
var prevHeight;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
    addClickToContainer();
    hasMediaLoaded();
    prevHeight=document.getElementById("container").offsetHeight;
    resizeScreen();
})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(function(){
            if(prevHeight!==document.getElementById("container").offsetHeight) {
                prevHeight=document.getElementById("container").offsetHeight;
                VLE.resize_iframe();
                scrollTop()

            } else {
                clearTimeout(resize);
            }
        }, 250);
    };
}

function addClickToContainer(){
    var containers = document.querySelectorAll(".seperate-container");
    for(var i=0; i< containers.length;i++){
        containers[i].onclick=function(){
            this.querySelector(".label-container .label").click();
        }
    }
}

function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    stopMedia();
    resizeScreen();
}
function stopMedia(){
    /* pauses vids */
    var medias = document.querySelectorAll("video,audio");
    for(var j=0; j<medias.length; j++){
        if(medias[j]) {
            if (medias[j].parentNode) {
                if (medias[j].parentNode.nextElementSibling) {
                    if (medias[j].parentNode.nextElementSibling.querySelector(".omp-stop")) {
                        medias[j].parentNode.nextElementSibling.querySelector(".omp-stop").click();
                    }
                }
            }
        }
    }
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe();scrollTop()}, 1000);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
                scrollTop()
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
    if(data.backgroundimage) {
        createEl(content,"div", null, null, {"class":"bkg-img"});
    }
    createEl(document.getElementById("container"), "script", null, null, {
        "data-main": "./oump/js/oump",
        "src": "./oump/js/loader.js"
    });
    var mediaContainer = document.querySelectorAll(".media-holder");
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        mediaContainer[mc].addEventListener("click", showHideTranscripts);
    }

    updateClass("add", document.querySelector("#container"), "loaded")
}

function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        stopMedia();
        VLE.resize_iframe();
        scrollTop()
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
}
function hasMediaLoaded() {
    var mediaContainer = document.querySelectorAll(".media-holder");
    var loaded = true;
    if(!hasClass(document.querySelector("#container"),"loaded")){
        loaded = false;
    }
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        if (!mediaContainer[mc].querySelector(".omp-placeholder-image")) {
            loaded = false;
        }
    }
    if (loaded) {
        setTimeout(function(){VLE.resize_iframe();scrollTop()}, 500);
        document.addEventListener('fullscreenchange', exitHandler);
        document.addEventListener('webkitfullscreenchange', exitHandler);
        document.addEventListener('mozfullscreenchange', exitHandler);
        document.addEventListener('MSFullscreenChange', exitHandler);
    } else {
        setTimeout(function () {
            hasMediaLoaded();
        }, 500);
    }

}
function exitHandler() {
    if (!document.fullscreenElement && !document.webkitIsFullScreen && !document.mozFullScreen && !document.msFullscreenElement) {
        setTimeout(function () {
            VLE.resize_iframe();
            scrollTop()
        }, 500);
    }
}
function showHideTranscripts(e) {
    var el = e.target;
    if (hasClass(el.parentNode, "omp-transcript-toggle-checkbox")) {
        setTimeout(function () {
            VLE.resize_iframe();
            scrollTop()
        }, 500);
    }
};
function scrollTop(){
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
}