/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 316);
/******/ })
/************************************************************************/
/******/ ({

/***/ 116:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

var emitter = __webpack_require__(127);
var crossvent = __webpack_require__(307);
var classes = __webpack_require__(310);
var doc = document;
var documentElement = doc.documentElement;

function dragula(initialContainers, options) {
  var len = arguments.length;
  if (len === 1 && Array.isArray(initialContainers) === false) {
    options = initialContainers;
    initialContainers = [];
  }
  var _mirror; // mirror image
  var _source; // source container
  var _item; // item being dragged
  var _offsetX; // reference x
  var _offsetY; // reference y
  var _moveX; // reference move x
  var _moveY; // reference move y
  var _initialSibling; // reference sibling when grabbed
  var _currentSibling; // reference sibling now
  var _copy; // item used for copying
  var _renderTimer; // timer for setTimeout renderMirrorImage
  var _lastDropTarget = null; // last container item was over
  var _grabbed; // holds mousedown context until first mousemove

  var o = options || {};
  if (o.moves === void 0) {
    o.moves = always;
  }
  if (o.accepts === void 0) {
    o.accepts = always;
  }
  if (o.invalid === void 0) {
    o.invalid = invalidTarget;
  }
  if (o.containers === void 0) {
    o.containers = initialContainers || [];
  }
  if (o.isContainer === void 0) {
    o.isContainer = never;
  }
  if (o.copy === void 0) {
    o.copy = false;
  }
  if (o.copySortSource === void 0) {
    o.copySortSource = false;
  }
  if (o.revertOnSpill === void 0) {
    o.revertOnSpill = false;
  }
  if (o.removeOnSpill === void 0) {
    o.removeOnSpill = false;
  }
  if (o.direction === void 0) {
    o.direction = 'vertical';
  }
  if (o.ignoreInputTextSelection === void 0) {
    o.ignoreInputTextSelection = true;
  }
  if (o.mirrorContainer === void 0) {
    o.mirrorContainer = doc.body;
  }

  var drake = emitter({
    containers: o.containers,
    start: manualStart,
    end: end,
    cancel: cancel,
    remove: remove,
    destroy: destroy,
    canMove: canMove,
    dragging: false
  });

  if (o.removeOnSpill === true) {
    drake.on('over', spillOver).on('out', spillOut);
  }

  events();

  return drake;

  function isContainer(el) {
    return drake.containers.indexOf(el) !== -1 || o.isContainer(el);
  }

  function events(remove) {
    var op = remove ? 'remove' : 'add';
    touchy(documentElement, op, 'mousedown', grab);
    touchy(documentElement, op, 'mouseup', release);
  }

  function eventualMovements(remove) {
    var op = remove ? 'remove' : 'add';
    touchy(documentElement, op, 'mousemove', startBecauseMouseMoved);
  }

  function movements(remove) {
    var op = remove ? 'remove' : 'add';
    crossvent[op](documentElement, 'selectstart', preventGrabbed); // IE8
    crossvent[op](documentElement, 'click', preventGrabbed);
  }

  function destroy() {
    events(true);
    release({});
  }

  function preventGrabbed(e) {
    if (_grabbed) {
      e.preventDefault();
    }
  }

  function grab(e) {
    _moveX = e.clientX;
    _moveY = e.clientY;

    var ignore = whichMouseButton(e) !== 1 || e.metaKey || e.ctrlKey;
    if (ignore) {
      return; // we only care about honest-to-god left clicks and touch events
    }
    var item = e.target;
    var context = canStart(item);
    if (!context) {
      return;
    }
    _grabbed = context;
    eventualMovements();
    if (e.type === 'mousedown') {
      if (isInput(item)) {
        // see also: https://github.com/bevacqua/dragula/issues/208
        item.focus(); // fixes https://github.com/bevacqua/dragula/issues/176
      } else {
        e.preventDefault(); // fixes https://github.com/bevacqua/dragula/issues/155
      }
    }
  }

  function startBecauseMouseMoved(e) {
    if (!_grabbed) {
      return;
    }
    if (whichMouseButton(e) === 0) {
      release({});
      return; // when text is selected on an input and then dragged, mouseup doesn't fire. this is our only hope
    }
    // truthy check fixes #239, equality fixes #207
    if (e.clientX !== void 0 && e.clientX === _moveX && e.clientY !== void 0 && e.clientY === _moveY) {
      return;
    }
    if (o.ignoreInputTextSelection) {
      var clientX = getCoord('clientX', e);
      var clientY = getCoord('clientY', e);
      var elementBehindCursor = doc.elementFromPoint(clientX, clientY);
      if (isInput(elementBehindCursor)) {
        return;
      }
    }

    var grabbed = _grabbed; // call to end() unsets _grabbed
    eventualMovements(true);
    movements();
    end();
    start(grabbed);

    var offset = getOffset(_item);
    _offsetX = getCoord('pageX', e) - offset.left;
    _offsetY = getCoord('pageY', e) - offset.top;

    classes.add(_copy || _item, 'gu-transit');
    renderMirrorImage();
    drag(e);
  }

  function canStart(item) {
    if (drake.dragging && _mirror) {
      return;
    }
    if (isContainer(item)) {
      return; // don't drag container itself
    }
    var handle = item;
    while (getParent(item) && isContainer(getParent(item)) === false) {
      if (o.invalid(item, handle)) {
        return;
      }
      item = getParent(item); // drag target should be a top element
      if (!item) {
        return;
      }
    }
    var source = getParent(item);
    if (!source) {
      return;
    }
    if (o.invalid(item, handle)) {
      return;
    }

    var movable = o.moves(item, source, handle, nextEl(item));
    if (!movable) {
      return;
    }

    return {
      item: item,
      source: source
    };
  }

  function canMove(item) {
    return !!canStart(item);
  }

  function manualStart(item) {
    var context = canStart(item);
    if (context) {
      start(context);
    }
  }

  function start(context) {
    if (isCopy(context.item, context.source)) {
      _copy = context.item.cloneNode(true);
      drake.emit('cloned', _copy, context.item, 'copy');
    }

    _source = context.source;
    _item = context.item;
    _initialSibling = _currentSibling = nextEl(context.item);

    drake.dragging = true;
    drake.emit('drag', _item, _source);
  }

  function invalidTarget() {
    return false;
  }

  function end() {
    if (!drake.dragging) {
      return;
    }
    var item = _copy || _item;
    drop(item, getParent(item));
  }

  function ungrab() {
    _grabbed = false;
    eventualMovements(true);
    movements(true);
  }

  function release(e) {
    ungrab();

    if (!drake.dragging) {
      return;
    }
    var item = _copy || _item;
    var clientX = getCoord('clientX', e);
    var clientY = getCoord('clientY', e);
    var elementBehindCursor = getElementBehindPoint(_mirror, clientX, clientY);
    var dropTarget = findDropTarget(elementBehindCursor, clientX, clientY);
    if (dropTarget && (_copy && o.copySortSource || !_copy || dropTarget !== _source)) {
      drop(item, dropTarget);
    } else if (o.removeOnSpill) {
      remove();
    } else {
      cancel();
    }
  }

  function drop(item, target) {
    var parent = getParent(item);
    if (_copy && o.copySortSource && target === _source) {
      parent.removeChild(_item);
    }
    if (isInitialPlacement(target)) {
      drake.emit('cancel', item, _source, _source);
    } else {
      drake.emit('drop', item, target, _source, _currentSibling);
    }
    cleanup();
  }

  function remove() {
    if (!drake.dragging) {
      return;
    }
    var item = _copy || _item;
    var parent = getParent(item);
    if (parent) {
      parent.removeChild(item);
    }
    drake.emit(_copy ? 'cancel' : 'remove', item, parent, _source);
    cleanup();
  }

  function cancel(revert) {
    if (!drake.dragging) {
      return;
    }
    var reverts = arguments.length > 0 ? revert : o.revertOnSpill;
    var item = _copy || _item;
    var parent = getParent(item);
    var initial = isInitialPlacement(parent);
    if (initial === false && reverts) {
      if (_copy) {
        if (parent) {
          parent.removeChild(_copy);
        }
      } else {
        _source.insertBefore(item, _initialSibling);
      }
    }
    if (initial || reverts) {
      drake.emit('cancel', item, _source, _source);
    } else {
      drake.emit('drop', item, parent, _source, _currentSibling);
    }
    cleanup();
  }

  function cleanup() {
    var item = _copy || _item;
    ungrab();
    removeMirrorImage();
    if (item) {
      classes.rm(item, 'gu-transit');
    }
    if (_renderTimer) {
      clearTimeout(_renderTimer);
    }
    drake.dragging = false;
    if (_lastDropTarget) {
      drake.emit('out', item, _lastDropTarget, _source);
    }
    drake.emit('dragend', item);
    _source = _item = _copy = _initialSibling = _currentSibling = _renderTimer = _lastDropTarget = null;
  }

  function isInitialPlacement(target, s) {
    var sibling;
    if (s !== void 0) {
      sibling = s;
    } else if (_mirror) {
      sibling = _currentSibling;
    } else {
      sibling = nextEl(_copy || _item);
    }
    return target === _source && sibling === _initialSibling;
  }

  function findDropTarget(elementBehindCursor, clientX, clientY) {
    var target = elementBehindCursor;
    while (target && !accepted()) {
      target = getParent(target);
    }
    return target;

    function accepted() {
      var droppable = isContainer(target);
      if (droppable === false) {
        return false;
      }

      var immediate = getImmediateChild(target, elementBehindCursor);
      var reference = getReference(target, immediate, clientX, clientY);
      var initial = isInitialPlacement(target, reference);
      if (initial) {
        return true; // should always be able to drop it right back where it was
      }
      return o.accepts(_item, target, _source, reference);
    }
  }

  function drag(e) {
    if (!_mirror) {
      return;
    }
    e.preventDefault();

    var clientX = getCoord('clientX', e);
    var clientY = getCoord('clientY', e);
    var x = clientX - _offsetX;
    var y = clientY - _offsetY;

    _mirror.style.left = x + 'px';
    _mirror.style.top = y + 'px';

    var item = _copy || _item;
    var elementBehindCursor = getElementBehindPoint(_mirror, clientX, clientY);
    var dropTarget = findDropTarget(elementBehindCursor, clientX, clientY);
    var changed = dropTarget !== null && dropTarget !== _lastDropTarget;
    if (changed || dropTarget === null) {
      out();
      _lastDropTarget = dropTarget;
      over();
    }
    var parent = getParent(item);
    if (dropTarget === _source && _copy && !o.copySortSource) {
      if (parent) {
        parent.removeChild(item);
      }
      return;
    }
    var reference;
    var immediate = getImmediateChild(dropTarget, elementBehindCursor);
    if (immediate !== null) {
      reference = getReference(dropTarget, immediate, clientX, clientY);
    } else if (o.revertOnSpill === true && !_copy) {
      reference = _initialSibling;
      dropTarget = _source;
    } else {
      if (_copy && parent) {
        parent.removeChild(item);
      }
      return;
    }
    if (reference === null && changed || reference !== item && reference !== nextEl(item)) {
      _currentSibling = reference;
      dropTarget.insertBefore(item, reference);
      drake.emit('shadow', item, dropTarget, _source);
    }
    function moved(type) {
      drake.emit(type, item, _lastDropTarget, _source);
    }
    function over() {
      if (changed) {
        moved('over');
      }
    }
    function out() {
      if (_lastDropTarget) {
        moved('out');
      }
    }
  }

  function spillOver(el) {
    classes.rm(el, 'gu-hide');
  }

  function spillOut(el) {
    if (drake.dragging) {
      classes.add(el, 'gu-hide');
    }
  }

  function renderMirrorImage() {
    if (_mirror) {
      return;
    }
    var rect = _item.getBoundingClientRect();
    _mirror = _item.cloneNode(true);
    _mirror.style.width = getRectWidth(rect) + 'px';
    _mirror.style.height = getRectHeight(rect) + 'px';
    classes.rm(_mirror, 'gu-transit');
    classes.add(_mirror, 'gu-mirror');
    o.mirrorContainer.appendChild(_mirror);
    touchy(documentElement, 'add', 'mousemove', drag);
    classes.add(o.mirrorContainer, 'gu-unselectable');
    drake.emit('cloned', _mirror, _item, 'mirror');
  }

  function removeMirrorImage() {
    if (_mirror) {
      classes.rm(o.mirrorContainer, 'gu-unselectable');
      touchy(documentElement, 'remove', 'mousemove', drag);
      getParent(_mirror).removeChild(_mirror);
      _mirror = null;
    }
  }

  function getImmediateChild(dropTarget, target) {
    var immediate = target;
    while (immediate !== dropTarget && getParent(immediate) !== dropTarget) {
      immediate = getParent(immediate);
    }
    if (immediate === documentElement) {
      return null;
    }
    return immediate;
  }

  function getReference(dropTarget, target, x, y) {
    var horizontal = o.direction === 'horizontal';
    var reference = target !== dropTarget ? inside() : outside();
    return reference;

    function outside() {
      // slower, but able to figure out any position
      var len = dropTarget.children.length;
      var i;
      var el;
      var rect;
      for (i = 0; i < len; i++) {
        el = dropTarget.children[i];
        rect = el.getBoundingClientRect();
        if (horizontal && rect.left + rect.width / 2 > x) {
          return el;
        }
        if (!horizontal && rect.top + rect.height / 2 > y) {
          return el;
        }
      }
      return null;
    }

    function inside() {
      // faster, but only available if dropped inside a child element
      var rect = target.getBoundingClientRect();
      if (horizontal) {
        return resolve(x > rect.left + getRectWidth(rect) / 2);
      }
      return resolve(y > rect.top + getRectHeight(rect) / 2);
    }

    function resolve(after) {
      return after ? nextEl(target) : target;
    }
  }

  function isCopy(item, container) {
    return typeof o.copy === 'boolean' ? o.copy : o.copy(item, container);
  }
}

function touchy(el, op, type, fn) {
  var touch = {
    mouseup: 'touchend',
    mousedown: 'touchstart',
    mousemove: 'touchmove'
  };
  var pointers = {
    mouseup: 'pointerup',
    mousedown: 'pointerdown',
    mousemove: 'pointermove'
  };
  var microsoft = {
    mouseup: 'MSPointerUp',
    mousedown: 'MSPointerDown',
    mousemove: 'MSPointerMove'
  };
  if (global.navigator.pointerEnabled) {
    crossvent[op](el, pointers[type], fn);
  } else if (global.navigator.msPointerEnabled) {
    crossvent[op](el, microsoft[type], fn);
  } else {
    crossvent[op](el, touch[type], fn);
    crossvent[op](el, type, fn);
  }
}

function whichMouseButton(e) {
  if (e.touches !== void 0) {
    return e.touches.length;
  }
  if (e.which !== void 0 && e.which !== 0) {
    return e.which;
  } // see https://github.com/bevacqua/dragula/issues/261
  if (e.buttons !== void 0) {
    return e.buttons;
  }
  var button = e.button;
  if (button !== void 0) {
    // see https://github.com/jquery/jquery/blob/99e8ff1baa7ae341e94bb89c3e84570c7c3ad9ea/src/event.js#L573-L575
    return button & 1 ? 1 : button & 2 ? 3 : button & 4 ? 2 : 0;
  }
}

function getOffset(el) {
  var rect = el.getBoundingClientRect();
  return {
    left: rect.left + getScroll('scrollLeft', 'pageXOffset'),
    top: rect.top + getScroll('scrollTop', 'pageYOffset')
  };
}

function getScroll(scrollProp, offsetProp) {
  if (typeof global[offsetProp] !== 'undefined') {
    return global[offsetProp];
  }
  if (documentElement.clientHeight) {
    return documentElement[scrollProp];
  }
  return doc.body[scrollProp];
}

function getElementBehindPoint(point, x, y) {
  var p = point || {};
  var state = p.className;
  var el;
  p.className += ' gu-hide';
  el = doc.elementFromPoint(x, y);
  p.className = state;
  return el;
}

function never() {
  return false;
}
function always() {
  return true;
}
function getRectWidth(rect) {
  return rect.width || rect.right - rect.left;
}
function getRectHeight(rect) {
  return rect.height || rect.bottom - rect.top;
}
function getParent(el) {
  return el.parentNode === doc ? null : el.parentNode;
}
function isInput(el) {
  return el.tagName === 'INPUT' || el.tagName === 'TEXTAREA' || el.tagName === 'SELECT' || isEditable(el);
}
function isEditable(el) {
  if (!el) {
    return false;
  } // no parents were editable
  if (el.contentEditable === 'false') {
    return false;
  } // stop the lookup
  if (el.contentEditable === 'true') {
    return true;
  } // found a contentEditable element in the chain
  return isEditable(getParent(el)); // contentEditable is set to 'inherit'
}

function nextEl(el) {
  return el.nextElementSibling || manually();
  function manually() {
    var sibling = el;
    do {
      sibling = sibling.nextSibling;
    } while (sibling && sibling.nodeType !== 1);
    return sibling;
  }
}

function getEventHost(e) {
  // on touchend event, we have to use `e.changedTouches`
  // see http://stackoverflow.com/questions/7192563/touchend-event-properties
  // see https://github.com/bevacqua/dragula/issues/34
  if (e.targetTouches && e.targetTouches.length) {
    return e.targetTouches[0];
  }
  if (e.changedTouches && e.changedTouches.length) {
    return e.changedTouches[0];
  }
  return e;
}

function getCoord(coord, e) {
  var host = getEventHost(e);
  var missMap = {
    pageX: 'clientX', // IE8
    pageY: 'clientY' // IE8
  };
  if (coord in missMap && !(coord in host) && missMap[coord] in host) {
    coord = missMap[coord];
  }
  return host[coord];
}

module.exports = dragula;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(28)))

/***/ }),

/***/ 118:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Grouper = function () {
	function Grouper() {
		var selector = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

		_classCallCheck(this, Grouper);

		this.mainContainer = selector ? document.querySelector(selector) : document.createElement("div");
		this.groups = document.createElement("div");
		this.classes = {
			group: 'group',
			item: 'item',
			label: 'label'
		};
		this.onMoveUpHook = function (item, container) {
			console.log("Moves item up inside group labelled " + container.getAttribute("aria-label"));
		};
		this.onMoveDownHook = function (item, container) {
			console.log("Moves item down inside group labelled " + container.getAttribute("aria-label"));
		};
		this.current = false;
		return this;
	}

	_createClass(Grouper, [{
		key: "init",
		value: function init() {
			this.mainContainer.appendChild(this.groups);
			this._applyEvents();
			return this.mainContainer;
		}
	}, {
		key: "addGroup",
		value: function addGroup(id, labelTxt) {
			var dataAttributes = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

			var group = document.createElement("div");
			var label = document.createElement("div");
			label.innerHTML = labelTxt;
			label.className = this.classes.label;
			group.setAttribute('aria-label', labelTxt);
			//group.setAttribute('tabindex', 0);
			group.className = this.classes.group;
			group.id = id;

			if (dataAttributes && (typeof dataAttributes === "undefined" ? "undefined" : _typeof(dataAttributes)) === 'object') {
				for (var _iterator = Object.entries(dataAttributes), _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
					var _ref;

					if (_isArray) {
						if (_i >= _iterator.length) break;
						_ref = _iterator[_i++];
					} else {
						_i = _iterator.next();
						if (_i.done) break;
						_ref = _i.value;
					}

					var _ref2 = _ref,
					    _ref3 = _slicedToArray(_ref2, 2),
					    key = _ref3[0],
					    val = _ref3[1];

					group.setAttribute("data-" + key, val);
				}
			}

			this.groups.appendChild(label);
			this.groups.appendChild(group);
			this.current = group;
			return this;
		}
	}, {
		key: "addItem",
		value: function addItem(content) {
			if (!this.current) return;
			this.current.appendChild(this._makeItem(content));
		}
	}, {
		key: "_makeItem",
		value: function _makeItem(content) {
			var item = document.createElement("div");
			item.setAttribute('tabindex', 0);
			item.className = this.classes.item;
			item.innerHTML = content;
			return item;
		}
	}, {
		key: "_applyEvents",
		value: function _applyEvents() {
			var _this = this;

			// get all containers
			var groups = [].slice.call(document.querySelectorAll("." + this.classes.group));

			// accessible controls
			// add event listener to all groups for up and down arrow

			var _loop = function _loop() {
				if (_isArray2) {
					if (_i2 >= _iterator2.length) return "break";
					_ref4 = _iterator2[_i2++];
				} else {
					_i2 = _iterator2.next();
					if (_i2.done) return "break";
					_ref4 = _i2.value;
				}

				var _ref5 = _ref4,
				    _ref6 = _slicedToArray(_ref5, 2),
				    i = _ref6[0],
				    container = _ref6[1];

				container.addEventListener("keydown", function (e) {
					if (e.target.className.split(" ").indexOf(_this.classes.item) === -1) return;
					if (e.keyCode !== 38 && e.keyCode !== 40) return; // only handle up and down arrows

					e.preventDefault(); // kill off annoying scroll on arrow press

					var item = e.target;
					var prev = item.previousElementSibling;
					var next = item.nextElementSibling;

					// going up
					if (e.keyCode === 38 && prev !== null) {
						// up - move item inside container
						item.parentNode.insertBefore(item, prev);
						item.focus();
						_this.onMoveUpHook(item, container);
					} else if (e.keyCode === 38 && prev === null) {
						// up - if first in container move up a container
						if (!groups[i - 1]) return;
						groups[i - 1].appendChild(item);
						item.focus();
						_this.onMoveUpHook(item, groups[i - 1]);
					}

					// going down
					if (e.keyCode === 40 && next !== null) {
						// up - move item inside container
						item.parentNode.insertBefore(next, item);
						item.focus();
						_this.onMoveDownHook(item, container);
					} else if (e.keyCode === 40 && next === null) {
						// up - if first in container move up a container
						if (!groups[i + 1]) return;
						groups[i + 1].insertBefore(item, groups[i + 1].firstElementChild);
						item.focus();
						_this.onMoveDownHook(item, groups[i + 1]);
					}
				});
			};

			for (var _iterator2 = groups.entries(), _isArray2 = Array.isArray(_iterator2), _i2 = 0, _iterator2 = _isArray2 ? _iterator2 : _iterator2[Symbol.iterator]();;) {
				var _ref4;

				var _ret = _loop();

				if (_ret === "break") break;
			}
		}
	}, {
		key: "clean",
		value: function clean() {
			var groups = [].slice.call(this.mainContainer.children);
			this.groups = document.createElement("div"); // prevents duplication
			for (var _iterator3 = groups.entries(), _isArray3 = Array.isArray(_iterator3), _i3 = 0, _iterator3 = _isArray3 ? _iterator3 : _iterator3[Symbol.iterator]();;) {
				var _ref7;

				if (_isArray3) {
					if (_i3 >= _iterator3.length) break;
					_ref7 = _iterator3[_i3++];
				} else {
					_i3 = _iterator3.next();
					if (_i3.done) break;
					_ref7 = _i3.value;
				}

				var _ref8 = _ref7,
				    _ref9 = _slicedToArray(_ref8, 2),
				    _i4 = _ref9[0],
				    _container = _ref9[1];

				_container.parentNode.removeChild(_container);
			}
		}
	}, {
		key: "data",
		value: function data() {
			var data = [];
			var groups = [].slice.call(document.querySelectorAll("." + this.classes.group));

			var _loop2 = function _loop2() {
				if (_isArray4) {
					if (_i5 >= _iterator4.length) return "break";
					_ref10 = _iterator4[_i5++];
				} else {
					_i5 = _iterator4.next();
					if (_i5.done) return "break";
					_ref10 = _i5.value;
				}

				var group = _ref10;


				var groupData = {
					id: group.id,
					label: group.getAttribute('aria-label'),
					items: []
				};

				[].slice.call(group.children).forEach(function (item) {
					groupData.items.push({ content: item.innerHTML });
				});

				data.push(groupData);
			};

			for (var _iterator4 = groups, _isArray4 = Array.isArray(_iterator4), _i5 = 0, _iterator4 = _isArray4 ? _iterator4 : _iterator4[Symbol.iterator]();;) {
				var _ref10;

				var _ret2 = _loop2();

				if (_ret2 === "break") break;
			}

			return data;
		}
	}]);

	return Grouper;
}();

exports.Grouper = Grouper;

/***/ }),

/***/ 119:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
    value: true
});

var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Notifier = function () {
    function Notifier() {
        var selector = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;

        _classCallCheck(this, Notifier);

        this.container = document.querySelector(selector) || document.createElement("div");
        this.classes = {
            notifier: 'notifier'
        };
        this.attributes = {
            "aria-live": "assertive",
            //"role": "alert",
            "aria-atomic": "true",
            "tabindex": 0
        };
        return this;
    }

    _createClass(Notifier, [{
        key: "init",
        value: function init() {
            this._setAttribs(this.container, this.attributes);
            this.container.className = this.classes.notifier;
            return this;
        }
    }, {
        key: "say",
        value: function say(content) {
            var stateClass = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

            this.container.innerHTML = content;
            if (stateClass) this.state(stateClass);
        }
    }, {
        key: "state",
        value: function state(stateClasses) {
            this.container.className = this.classes.notifier + " " + stateClasses;
        }
    }, {
        key: "_setAttribs",
        value: function _setAttribs(element, attributes) {
            if ((typeof attributes === "undefined" ? "undefined" : _typeof(attributes)) !== 'object') return false;
            for (var _iterator = Object.entries(attributes), _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
                var _ref;

                if (_isArray) {
                    if (_i >= _iterator.length) break;
                    _ref = _iterator[_i++];
                } else {
                    _i = _iterator.next();
                    if (_i.done) break;
                    _ref = _i.value;
                }

                var _ref2 = _ref,
                    _ref3 = _slicedToArray(_ref2, 2),
                    key = _ref3[0],
                    val = _ref3[1];

                element.setAttribute(key, val);
            }
            return element;
        }
    }]);

    return Notifier;
}();

exports.Notifier = Notifier;

/***/ }),

/***/ 120:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Resizer = function () {
	function Resizer(selector) {
		_classCallCheck(this, Resizer);

		this.container = document.querySelector(selector);
		this.height = parseFloat(getComputedStyle(this.container).height);
		this.transitions = true;
		this.trigger = "resize";
		this.anonFunc;
		this.tolerance = 30;
		this.timeoutDuration = 100;
	}

	_createClass(Resizer, [{
		key: "do",
		value: function _do(anonFunc) {
			this.anonFunc = anonFunc;
			var transitionEventName = this._whichTransitionEvent();

			if (this.transitions && transitionEventName) this._transitionEvent(transitionEventName);

			this._events();
			return;
		}
	}, {
		key: "_events",
		value: function _events() {
			var _this = this;

			if (this.transitions) return this._transitionEvent();

			var triggers = this.trigger.split(" ");

			//console.log(triggers);

			for (var _iterator = triggers, _isArray = Array.isArray(_iterator), _i = 0, _iterator = _isArray ? _iterator : _iterator[Symbol.iterator]();;) {
				var _ref;

				if (_isArray) {
					if (_i >= _iterator.length) break;
					_ref = _iterator[_i++];
				} else {
					_i = _iterator.next();
					if (_i.done) break;
					_ref = _i.value;
				}

				var t = _ref;

				if (t === "resize") {
					window.addEventListener("resize", function (event) {
						return _this._heightCheck(event);
					});
					continue;
				}

				this.container.addEventListener(t, function (event) {
					return _this._heightCheck(event);
				});
			}
		}
	}, {
		key: "_transitionEvent",
		value: function _transitionEvent(transitionEventName) {
			var _this2 = this;

			/* Listen for a transition! */
			this.container.addEventListener(transitionEventName, function (event) {
				var heightAfterTransition = parseFloat(getComputedStyle(_this2.container).height);
				var minTolerance = _this2.height - _this2.tolerance;
				var maxTolerance = _this2.height + _this2.tolerance;

				if (heightAfterTransition > maxTolerance || heightAfterTransition < minTolerance) {
					_this2.height = heightAfterTransition;
					_this2.anonFunction(event);
				}
			});

			return true;
		}
	}, {
		key: "_heightCheck",
		value: function _heightCheck(event) {
			var _this3 = this;

			var heightAfterChange = parseFloat(getComputedStyle(this.container).height);
			var minTolerance = this.height - this.tolerance;
			var maxTolerance = this.height + this.tolerance;

			if (heightAfterChange > maxTolerance || heightAfterChange < minTolerance) {
				this.height = heightAfterChange;
				var timeout = setTimeout(function (event) {
					_this3.anonFunc(event);
					clearTimeout(timeout);
				}, this.timeoutDuration);
			}
		}
		/**
      * Below code implements vle resize script taking css transitions into account
      */
		/* From Modernizr */

	}, {
		key: "_whichTransitionEvent",
		value: function _whichTransitionEvent() {
			var el = document.createElement("fakeelement"),
			    transitions = {
				"transition": "transitionend",
				"OTransition": "oTransitionEnd",
				"MozTransition": "transitionend",
				"WebkitTransition": "webkitTransitionEnd"
			};

			for (var t in transitions) {
				if (el.style[t] !== undefined) return transitions[t];
			}

			return false;
		}
	}]);

	return Resizer;
}();

exports.Resizer = Resizer;

/***/ }),

/***/ 121:
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ 122:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "data.js";

/***/ }),

/***/ 123:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "vleapi.1.js";

/***/ }),

/***/ 124:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


module.exports = function atoa(a, n) {
  return Array.prototype.slice.call(a, n);
};

/***/ }),

/***/ 126:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var ticky = __webpack_require__(313);

module.exports = function debounce(fn, args, ctx) {
  if (!fn) {
    return;
  }
  ticky(function run() {
    fn.apply(ctx || null, args || []);
  });
};

/***/ }),

/***/ 127:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var atoa = __webpack_require__(124);
var debounce = __webpack_require__(126);

module.exports = function emitter(thing, options) {
  var opts = options || {};
  var evt = {};
  if (thing === undefined) {
    thing = {};
  }
  thing.on = function (type, fn) {
    if (!evt[type]) {
      evt[type] = [fn];
    } else {
      evt[type].push(fn);
    }
    return thing;
  };
  thing.once = function (type, fn) {
    fn._once = true; // thing.off(fn) still works!
    thing.on(type, fn);
    return thing;
  };
  thing.off = function (type, fn) {
    var c = arguments.length;
    if (c === 1) {
      delete evt[type];
    } else if (c === 0) {
      evt = {};
    } else {
      var et = evt[type];
      if (!et) {
        return thing;
      }
      et.splice(et.indexOf(fn), 1);
    }
    return thing;
  };
  thing.emit = function () {
    var args = atoa(arguments);
    return thing.emitterSnapshot(args.shift()).apply(this, args);
  };
  thing.emitterSnapshot = function (type) {
    var et = (evt[type] || []).slice(0);
    return function () {
      var args = atoa(arguments);
      var ctx = this || thing;
      if (type === 'error' && opts.throws !== false && !et.length) {
        throw args.length === 1 ? args[0] : args;
      }
      et.forEach(function emitter(listen) {
        if (opts.async) {
          debounce(listen, args, ctx);
        } else {
          listen.apply(ctx, args);
        }
        if (listen._once) {
          thing.off(type, listen);
        }
      });
      return thing;
    };
  };
  return thing;
};

/***/ }),

/***/ 28:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _typeof = typeof Symbol === "function" && typeof Symbol.iterator === "symbol" ? function (obj) { return typeof obj; } : function (obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; };

var g;

// This works in non-strict mode
g = function () {
	return this;
}();

try {
	// This works if eval is allowed (see CSP)
	g = g || Function("return this")() || (1, eval)("this");
} catch (e) {
	// This works if the window reference is available
	if ((typeof window === "undefined" ? "undefined" : _typeof(window)) === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;

/***/ }),

/***/ 307:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

var customEvent = __webpack_require__(309);
var eventmap = __webpack_require__(308);
var doc = global.document;
var addEvent = addEventEasy;
var removeEvent = removeEventEasy;
var hardCache = [];

if (!global.addEventListener) {
  addEvent = addEventHard;
  removeEvent = removeEventHard;
}

module.exports = {
  add: addEvent,
  remove: removeEvent,
  fabricate: fabricateEvent
};

function addEventEasy(el, type, fn, capturing) {
  return el.addEventListener(type, fn, capturing);
}

function addEventHard(el, type, fn) {
  return el.attachEvent('on' + type, wrap(el, type, fn));
}

function removeEventEasy(el, type, fn, capturing) {
  return el.removeEventListener(type, fn, capturing);
}

function removeEventHard(el, type, fn) {
  var listener = unwrap(el, type, fn);
  if (listener) {
    return el.detachEvent('on' + type, listener);
  }
}

function fabricateEvent(el, type, model) {
  var e = eventmap.indexOf(type) === -1 ? makeCustomEvent() : makeClassicEvent();
  if (el.dispatchEvent) {
    el.dispatchEvent(e);
  } else {
    el.fireEvent('on' + type, e);
  }
  function makeClassicEvent() {
    var e;
    if (doc.createEvent) {
      e = doc.createEvent('Event');
      e.initEvent(type, true, true);
    } else if (doc.createEventObject) {
      e = doc.createEventObject();
    }
    return e;
  }
  function makeCustomEvent() {
    return new customEvent(type, { detail: model });
  }
}

function wrapperFactory(el, type, fn) {
  return function wrapper(originalEvent) {
    var e = originalEvent || global.event;
    e.target = e.target || e.srcElement;
    e.preventDefault = e.preventDefault || function preventDefault() {
      e.returnValue = false;
    };
    e.stopPropagation = e.stopPropagation || function stopPropagation() {
      e.cancelBubble = true;
    };
    e.which = e.which || e.keyCode;
    fn.call(el, e);
  };
}

function wrap(el, type, fn) {
  var wrapper = unwrap(el, type, fn) || wrapperFactory(el, type, fn);
  hardCache.push({
    wrapper: wrapper,
    element: el,
    type: type,
    fn: fn
  });
  return wrapper;
}

function unwrap(el, type, fn) {
  var i = find(el, type, fn);
  if (i) {
    var wrapper = hardCache[i].wrapper;
    hardCache.splice(i, 1); // free up a tad of memory
    return wrapper;
  }
}

function find(el, type, fn) {
  var i, item;
  for (i = 0; i < hardCache.length; i++) {
    item = hardCache[i];
    if (item.element === el && item.type === type && item.fn === fn) {
      return i;
    }
  }
}
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(28)))

/***/ }),

/***/ 308:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

var eventmap = [];
var eventname = '';
var ron = /^on/;

for (eventname in global) {
  if (ron.test(eventname)) {
    eventmap.push(eventname.slice(2));
  }
}

module.exports = eventmap;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(28)))

/***/ }),

/***/ 309:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global) {

var NativeCustomEvent = global.CustomEvent;

function useNative() {
  try {
    var p = new NativeCustomEvent('cat', { detail: { foo: 'bar' } });
    return 'cat' === p.type && 'bar' === p.detail.foo;
  } catch (e) {}
  return false;
}

/**
 * Cross-browser `CustomEvent` constructor.
 *
 * https://developer.mozilla.org/en-US/docs/Web/API/CustomEvent.CustomEvent
 *
 * @public
 */

module.exports = useNative() ? NativeCustomEvent :

// IE >= 9
'function' === typeof document.createEvent ? function CustomEvent(type, params) {
  var e = document.createEvent('CustomEvent');
  if (params) {
    e.initCustomEvent(type, params.bubbles, params.cancelable, params.detail);
  } else {
    e.initCustomEvent(type, false, false, void 0);
  }
  return e;
} :

// IE <= 8
function CustomEvent(type, params) {
  var e = document.createEventObject();
  e.type = type;
  if (params) {
    e.bubbles = Boolean(params.bubbles);
    e.cancelable = Boolean(params.cancelable);
    e.detail = params.detail;
  } else {
    e.bubbles = false;
    e.cancelable = false;
    e.detail = void 0;
  }
  return e;
};
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(28)))

/***/ }),

/***/ 310:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var cache = {};
var start = '(?:^|\\s)';
var end = '(?:\\s|$)';

function lookupClass(className) {
  var cached = cache[className];
  if (cached) {
    cached.lastIndex = 0;
  } else {
    cache[className] = cached = new RegExp(start + className + end, 'g');
  }
  return cached;
}

function addClass(el, className) {
  var current = el.className;
  if (!current.length) {
    el.className = className;
  } else if (!lookupClass(className).test(current)) {
    el.className += ' ' + className;
  }
}

function rmClass(el, className) {
  el.className = el.className.replace(lookupClass(className), ' ').trim();
}

module.exports = {
  add: addClass,
  rm: rmClass
};

/***/ }),

/***/ 311:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


// shim for using process in browser
var process = module.exports = {};

// cached from whatever global is present so that test runners that stub it
// don't break things.  But we need to wrap it in a try catch in case it is
// wrapped in strict mode code which doesn't define any globals.  It's inside a
// function because try/catches deoptimize in certain engines.

var cachedSetTimeout;
var cachedClearTimeout;

function defaultSetTimout() {
    throw new Error('setTimeout has not been defined');
}
function defaultClearTimeout() {
    throw new Error('clearTimeout has not been defined');
}
(function () {
    try {
        if (typeof setTimeout === 'function') {
            cachedSetTimeout = setTimeout;
        } else {
            cachedSetTimeout = defaultSetTimout;
        }
    } catch (e) {
        cachedSetTimeout = defaultSetTimout;
    }
    try {
        if (typeof clearTimeout === 'function') {
            cachedClearTimeout = clearTimeout;
        } else {
            cachedClearTimeout = defaultClearTimeout;
        }
    } catch (e) {
        cachedClearTimeout = defaultClearTimeout;
    }
})();
function runTimeout(fun) {
    if (cachedSetTimeout === setTimeout) {
        //normal enviroments in sane situations
        return setTimeout(fun, 0);
    }
    // if setTimeout wasn't available but was latter defined
    if ((cachedSetTimeout === defaultSetTimout || !cachedSetTimeout) && setTimeout) {
        cachedSetTimeout = setTimeout;
        return setTimeout(fun, 0);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedSetTimeout(fun, 0);
    } catch (e) {
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't trust the global object when called normally
            return cachedSetTimeout.call(null, fun, 0);
        } catch (e) {
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error
            return cachedSetTimeout.call(this, fun, 0);
        }
    }
}
function runClearTimeout(marker) {
    if (cachedClearTimeout === clearTimeout) {
        //normal enviroments in sane situations
        return clearTimeout(marker);
    }
    // if clearTimeout wasn't available but was latter defined
    if ((cachedClearTimeout === defaultClearTimeout || !cachedClearTimeout) && clearTimeout) {
        cachedClearTimeout = clearTimeout;
        return clearTimeout(marker);
    }
    try {
        // when when somebody has screwed with setTimeout but no I.E. maddness
        return cachedClearTimeout(marker);
    } catch (e) {
        try {
            // When we are in I.E. but the script has been evaled so I.E. doesn't  trust the global object when called normally
            return cachedClearTimeout.call(null, marker);
        } catch (e) {
            // same as above but when it's a version of I.E. that must have the global object for 'this', hopfully our context correct otherwise it will throw a global error.
            // Some versions of I.E. have different rules for clearTimeout vs setTimeout
            return cachedClearTimeout.call(this, marker);
        }
    }
}
var queue = [];
var draining = false;
var currentQueue;
var queueIndex = -1;

function cleanUpNextTick() {
    if (!draining || !currentQueue) {
        return;
    }
    draining = false;
    if (currentQueue.length) {
        queue = currentQueue.concat(queue);
    } else {
        queueIndex = -1;
    }
    if (queue.length) {
        drainQueue();
    }
}

function drainQueue() {
    if (draining) {
        return;
    }
    var timeout = runTimeout(cleanUpNextTick);
    draining = true;

    var len = queue.length;
    while (len) {
        currentQueue = queue;
        queue = [];
        while (++queueIndex < len) {
            if (currentQueue) {
                currentQueue[queueIndex].run();
            }
        }
        queueIndex = -1;
        len = queue.length;
    }
    currentQueue = null;
    draining = false;
    runClearTimeout(timeout);
}

process.nextTick = function (fun) {
    var args = new Array(arguments.length - 1);
    if (arguments.length > 1) {
        for (var i = 1; i < arguments.length; i++) {
            args[i - 1] = arguments[i];
        }
    }
    queue.push(new Item(fun, args));
    if (queue.length === 1 && !draining) {
        runTimeout(drainQueue);
    }
};

// v8 likes predictible objects
function Item(fun, array) {
    this.fun = fun;
    this.array = array;
}
Item.prototype.run = function () {
    this.fun.apply(null, this.array);
};
process.title = 'browser';
process.browser = true;
process.env = {};
process.argv = [];
process.version = ''; // empty string to avoid regexp issues
process.versions = {};

function noop() {}

process.on = noop;
process.addListener = noop;
process.once = noop;
process.off = noop;
process.removeListener = noop;
process.removeAllListeners = noop;
process.emit = noop;
process.prependListener = noop;
process.prependOnceListener = noop;

process.listeners = function (name) {
    return [];
};

process.binding = function (name) {
    throw new Error('process.binding is not supported');
};

process.cwd = function () {
    return '/';
};
process.chdir = function (dir) {
    throw new Error('process.chdir is not supported');
};
process.umask = function () {
    return 0;
};

/***/ }),

/***/ 312:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(global, process) {

(function (global, undefined) {
    "use strict";

    if (global.setImmediate) {
        return;
    }

    var nextHandle = 1; // Spec says greater than zero
    var tasksByHandle = {};
    var currentlyRunningATask = false;
    var doc = global.document;
    var registerImmediate;

    function setImmediate(callback) {
        // Callback can either be a function or a string
        if (typeof callback !== "function") {
            callback = new Function("" + callback);
        }
        // Copy function arguments
        var args = new Array(arguments.length - 1);
        for (var i = 0; i < args.length; i++) {
            args[i] = arguments[i + 1];
        }
        // Store and register the task
        var task = { callback: callback, args: args };
        tasksByHandle[nextHandle] = task;
        registerImmediate(nextHandle);
        return nextHandle++;
    }

    function clearImmediate(handle) {
        delete tasksByHandle[handle];
    }

    function run(task) {
        var callback = task.callback;
        var args = task.args;
        switch (args.length) {
            case 0:
                callback();
                break;
            case 1:
                callback(args[0]);
                break;
            case 2:
                callback(args[0], args[1]);
                break;
            case 3:
                callback(args[0], args[1], args[2]);
                break;
            default:
                callback.apply(undefined, args);
                break;
        }
    }

    function runIfPresent(handle) {
        // From the spec: "Wait until any invocations of this algorithm started before this one have completed."
        // So if we're currently running a task, we'll need to delay this invocation.
        if (currentlyRunningATask) {
            // Delay by doing a setTimeout. setImmediate was tried instead, but in Firefox 7 it generated a
            // "too much recursion" error.
            setTimeout(runIfPresent, 0, handle);
        } else {
            var task = tasksByHandle[handle];
            if (task) {
                currentlyRunningATask = true;
                try {
                    run(task);
                } finally {
                    clearImmediate(handle);
                    currentlyRunningATask = false;
                }
            }
        }
    }

    function installNextTickImplementation() {
        registerImmediate = function registerImmediate(handle) {
            process.nextTick(function () {
                runIfPresent(handle);
            });
        };
    }

    function canUsePostMessage() {
        // The test against `importScripts` prevents this implementation from being installed inside a web worker,
        // where `global.postMessage` means something completely different and can't be used for this purpose.
        if (global.postMessage && !global.importScripts) {
            var postMessageIsAsynchronous = true;
            var oldOnMessage = global.onmessage;
            global.onmessage = function () {
                postMessageIsAsynchronous = false;
            };
            global.postMessage("", "*");
            global.onmessage = oldOnMessage;
            return postMessageIsAsynchronous;
        }
    }

    function installPostMessageImplementation() {
        // Installs an event handler on `global` for the `message` event: see
        // * https://developer.mozilla.org/en/DOM/window.postMessage
        // * http://www.whatwg.org/specs/web-apps/current-work/multipage/comms.html#crossDocumentMessages

        var messagePrefix = "setImmediate$" + Math.random() + "$";
        var onGlobalMessage = function onGlobalMessage(event) {
            if (event.source === global && typeof event.data === "string" && event.data.indexOf(messagePrefix) === 0) {
                runIfPresent(+event.data.slice(messagePrefix.length));
            }
        };

        if (global.addEventListener) {
            global.addEventListener("message", onGlobalMessage, false);
        } else {
            global.attachEvent("onmessage", onGlobalMessage);
        }

        registerImmediate = function registerImmediate(handle) {
            global.postMessage(messagePrefix + handle, "*");
        };
    }

    function installMessageChannelImplementation() {
        var channel = new MessageChannel();
        channel.port1.onmessage = function (event) {
            var handle = event.data;
            runIfPresent(handle);
        };

        registerImmediate = function registerImmediate(handle) {
            channel.port2.postMessage(handle);
        };
    }

    function installReadyStateChangeImplementation() {
        var html = doc.documentElement;
        registerImmediate = function registerImmediate(handle) {
            // Create a <script> element; its readystatechange event will be fired asynchronously once it is inserted
            // into the document. Do so, thus queuing up the task. Remember to clean up once it's been called.
            var script = doc.createElement("script");
            script.onreadystatechange = function () {
                runIfPresent(handle);
                script.onreadystatechange = null;
                html.removeChild(script);
                script = null;
            };
            html.appendChild(script);
        };
    }

    function installSetTimeoutImplementation() {
        registerImmediate = function registerImmediate(handle) {
            setTimeout(runIfPresent, 0, handle);
        };
    }

    // If supported, we should attach to the prototype of global, since that is where setTimeout et al. live.
    var attachTo = Object.getPrototypeOf && Object.getPrototypeOf(global);
    attachTo = attachTo && attachTo.setTimeout ? attachTo : global;

    // Don't get fooled by e.g. browserify environments.
    if ({}.toString.call(global.process) === "[object process]") {
        // For Node.js before 0.9
        installNextTickImplementation();
    } else if (canUsePostMessage()) {
        // For non-IE10 modern browsers
        installPostMessageImplementation();
    } else if (global.MessageChannel) {
        // For web workers, where supported
        installMessageChannelImplementation();
    } else if (doc && "onreadystatechange" in doc.createElement("script")) {
        // For IE 6–8
        installReadyStateChangeImplementation();
    } else {
        // For older browsers
        installSetTimeoutImplementation();
    }

    attachTo.setImmediate = setImmediate;
    attachTo.clearImmediate = clearImmediate;
})(typeof self === "undefined" ? typeof global === "undefined" ? undefined : global : self);
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(28), __webpack_require__(311)))

/***/ }),

/***/ 313:
/***/ (function(module, exports, __webpack_require__) {

"use strict";
/* WEBPACK VAR INJECTION */(function(setImmediate) {

var si = typeof setImmediate === 'function',
    tick;
if (si) {
  tick = function tick(fn) {
    setImmediate(fn);
  };
} else {
  tick = function tick(fn) {
    setTimeout(fn, 0);
  };
}

module.exports = tick;
/* WEBPACK VAR INJECTION */}.call(exports, __webpack_require__(314).setImmediate))

/***/ }),

/***/ 314:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var apply = Function.prototype.apply;

// DOM APIs, for completeness

exports.setTimeout = function () {
  return new Timeout(apply.call(setTimeout, window, arguments), clearTimeout);
};
exports.setInterval = function () {
  return new Timeout(apply.call(setInterval, window, arguments), clearInterval);
};
exports.clearTimeout = exports.clearInterval = function (timeout) {
  if (timeout) {
    timeout.close();
  }
};

function Timeout(id, clearFn) {
  this._id = id;
  this._clearFn = clearFn;
}
Timeout.prototype.unref = Timeout.prototype.ref = function () {};
Timeout.prototype.close = function () {
  this._clearFn.call(window, this._id);
};

// Does not start the time, just sets up the members needed.
exports.enroll = function (item, msecs) {
  clearTimeout(item._idleTimeoutId);
  item._idleTimeout = msecs;
};

exports.unenroll = function (item) {
  clearTimeout(item._idleTimeoutId);
  item._idleTimeout = -1;
};

exports._unrefActive = exports.active = function (item) {
  clearTimeout(item._idleTimeoutId);

  var msecs = item._idleTimeout;
  if (msecs >= 0) {
    item._idleTimeoutId = setTimeout(function onTimeout() {
      if (item._onTimeout) item._onTimeout();
    }, msecs);
  }
};

// setimmediate attaches itself to the global object
__webpack_require__(312);
exports.setImmediate = setImmediate;
exports.clearImmediate = clearImmediate;

/***/ }),

/***/ 316:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


__webpack_require__(121);

__webpack_require__(122);

__webpack_require__(123);

var _Grouper = __webpack_require__(118);

var _Notifier = __webpack_require__(119);

var _Resizer = __webpack_require__(120);

var dragula = __webpack_require__(116);

var activityId = VLE.get_param('activity_id') || VLE.get_param('_a') || false;
var storeId = activityId ? activityId + "_17j" : 'activity';

// builds group list with keyboard controls
// used by initGroups function
function buildGroupsFromData(grouper, groups) {
	var notifier = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : false;

	for (var gIndex = 0, gLength = groups.length; gIndex < gLength; gIndex++) {
		var group = groups[gIndex];

		grouper.addGroup(group.id, group.label, group.attributes);
		for (var iIndex = 0, iLength = group.items.length; iIndex < iLength; iIndex++) {
			grouper.addItem(group.items[iIndex].content);
		}
	}
	grouper.init();

	var dragulaItems = dragula([].slice.call(document.querySelectorAll(".group"))); // add drag and drop
	dragulaItems.on('drop', function (el, target, source, sibling) {
		if (notifier) {
			var fromGroup = source.getAttribute("aria-label");
			var toGroup = target.getAttribute("aria-label");
			notifier.say("Dragged item from group labelled " + fromGroup + " into group labelled " + toGroup);
		}
	});

	VLE.resize_iframe();
}

// gets data in this priority vle > local > data file
function initGroups(storeId, grouper, fallbackData) {
	var notifier = arguments.length > 3 && arguments[3] !== undefined ? arguments[3] : false;

	var store = false;

	VLE.get_server_data(true, [storeId], function (values) {
		// vle data
		if (!values[storeId]) {
			// no data found - useing data file
			return buildGroupsFromData(grouper, fallbackData, notifier);
		}

		store = JSON.parse(values[storeId]);
		return buildGroupsFromData(grouper, store, notifier);
	}, function (msg) {
		if (msg === null && window.localStorage) {
			// local data
			store = JSON.parse(localStorage.getItem(storeId)) || fallbackData;
		} else {
			return buildGroupsFromData(grouper, fallbackData, notifier); // falling back to data file
		}

		buildGroupsFromData(grouper, store, notifier);
	});
}

function save(storeId, data) {
	var dataToStore = {};
	dataToStore[storeId] = JSON.stringify(data);

	VLE.set_server_data(true, dataToStore, function () {
		return true;
	}, function (msg) {
		if (msg === null && window.localStorage) {
			localStorage.setItem(storeId, dataToStore[storeId]);
			console.warn("saved to local store against store is " + storeId);
			return true;
		}
		return false;
	});
}

var notifier = new _Notifier.Notifier('#notifier').init();
var notifierDefault = notifier.container.innerHTML;

// build groups
var grouper = new _Grouper.Grouper("#container");
grouper.onMoveDownHook = function (item, container) {
	notifier.say("Moved item down inside group labelled " + container.getAttribute("aria-label"));
};
grouper.onMoveUpHook = function (item, container) {
	notifier.say("Moved item up inside group labelled " + container.getAttribute("aria-label"));
};
initGroups(storeId, grouper, Data.groups, notifier);

// button events
document.getElementById('save').addEventListener("click", function () {
	save(storeId, grouper.data());
	notifier.say("Saved");
});

document.getElementById('reset').addEventListener("click", function () {
	grouper.clean();
	localStorage.removeItem(storeId);
	buildGroupsFromData(grouper, Data.groups);
	save(storeId, grouper.data());
	notifier.say(notifierDefault);
});

/* Resize */
//VLE.resize_iframe();

var resizer = new _Resizer.Resizer("#main");
resizer.trigger = "resize click mouseup";
resizer.transitions = false;

resizer.do(function () {
	//console.log("attempting resize");
	VLE.resize_iframe();
});

/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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