/******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// identity function for calling harmony imports with the correct context
/******/ 	__webpack_require__.i = function(value) { return value; };
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, {
/******/ 				configurable: false,
/******/ 				enumerable: true,
/******/ 				get: getter
/******/ 			});
/******/ 		}
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = 302);
/******/ })
/************************************************************************/
/******/ ({

/***/ 117:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


Object.defineProperty(exports, "__esModule", {
	value: true
});

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

var Resizer = function () {
	function Resizer(selector) {
		_classCallCheck(this, Resizer);

		this.container = document.querySelector(selector);
		this.height = parseFloat(getComputedStyle(this.container).height);
		this.transitions = true;
		this.trigger = "resize";
		this.anonFunc;
		this.tolerance = 30;
		this.timeoutDuration = 100;
	}

	Resizer.prototype.do = function _do(anonFunc) {
		this.anonFunc = anonFunc;
		var transitionEventName = this._whichTransitionEvent();

		if (this.transitions && transitionEventName) this._transitionEvent(transitionEventName);

		this._events();
		return;
	};

	Resizer.prototype._events = function _events() {
		var _this = this;

		if (this.transitions) return this._transitionEvent();

		var triggers = this.trigger.split(" ");

		console.log(triggers);

		var _iteratorNormalCompletion = true;
		var _didIteratorError = false;
		var _iteratorError = undefined;

		try {
			for (var _iterator = triggers[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
				var t = _step.value;

				if (t === "resize") {
					window.addEventListener("resize", function (event) {
						return _this._heightCheck(event);
					});
					continue;
				}

				this.container.addEventListener(t, function (event) {
					return _this._heightCheck(event);
				});
			}
		} catch (err) {
			_didIteratorError = true;
			_iteratorError = err;
		} finally {
			try {
				if (!_iteratorNormalCompletion && _iterator.return) {
					_iterator.return();
				}
			} finally {
				if (_didIteratorError) {
					throw _iteratorError;
				}
			}
		}
	};

	Resizer.prototype._transitionEvent = function _transitionEvent(transitionEventName) {
		var _this2 = this;

		/* Listen for a transition! */
		this.container.addEventListener(transitionEventName, function (event) {
			var heightAfterTransition = parseFloat(getComputedStyle(_this2.container).height);
			var minTolerance = _this2.height - _this2.tolerance;
			var maxTolerance = _this2.height + _this2.tolerance;

			if (heightAfterTransition > maxTolerance || heightAfterTransition < minTolerance) {
				_this2.height = heightAfterTransition;
				_this2.anonFunction(event);
			}
		});

		return true;
	};

	Resizer.prototype._heightCheck = function _heightCheck(event) {
		var _this3 = this;

		var heightAfterChange = parseFloat(getComputedStyle(this.container).height);
		var minTolerance = this.height - this.tolerance;
		var maxTolerance = this.height + this.tolerance;

		if (heightAfterChange > maxTolerance || heightAfterChange < minTolerance) {
			this.height = heightAfterChange;
			var timeout = setTimeout(function (event) {
				_this3.anonFunc(event);
				clearTimeout(timeout);
			}, this.timeoutDuration);
		}
	};
	/**
     * Below code implements vle resize script taking css transitions into account
     */
	/* From Modernizr */


	Resizer.prototype._whichTransitionEvent = function _whichTransitionEvent() {
		var el = document.createElement("fakeelement"),
		    transitions = {
			"transition": "transitionend",
			"OTransition": "oTransitionEnd",
			"MozTransition": "transitionend",
			"WebkitTransition": "webkitTransitionEnd"
		};

		for (var t in transitions) {
			if (el.style[t] !== undefined) return transitions[t];
		}

		return false;
	};

	return Resizer;
}();

exports.Resizer = Resizer;

/***/ }),

/***/ 118:
/***/ (function(module, exports) {

// removed by extract-text-webpack-plugin

/***/ }),

/***/ 119:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "data.js";

/***/ }),

/***/ 120:
/***/ (function(module, exports, __webpack_require__) {

module.exports = __webpack_require__.p + "vleapi.1.js";

/***/ }),

/***/ 302:
/***/ (function(module, exports, __webpack_require__) {

"use strict";


var _slicedToArray = function () { function sliceIterator(arr, i) { var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"]) _i["return"](); } finally { if (_d) throw _e; } } return _arr; } return function (arr, i) { if (Array.isArray(arr)) { return arr; } else if (Symbol.iterator in Object(arr)) { return sliceIterator(arr, i); } else { throw new TypeError("Invalid attempt to destructure non-iterable instance"); } }; }();

__webpack_require__(118);

__webpack_require__(119);

__webpack_require__(120);

var _Resizer = __webpack_require__(117);

// Quick dirty activity due to time constraints

/* function definitions */
var check = function check(possibleValues, correctAnswer) {
	var answers = Array.from(document.querySelectorAll(".answer"));
	var wrong = [];
	var right = [];

	var _iteratorNormalCompletion = true;
	var _didIteratorError = false;
	var _iteratorError = undefined;

	try {
		for (var _iterator = answers[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
			var answer = _step.value;

			if (answer.value === correctAnswer[answer.id]) {
				right.push(answer);
				continue;
			}
			wrong.push(answer);
		}
	} catch (err) {
		_didIteratorError = true;
		_iteratorError = err;
	} finally {
		try {
			if (!_iteratorNormalCompletion && _iterator.return) {
				_iterator.return();
			}
		} finally {
			if (_didIteratorError) {
				throw _iteratorError;
			}
		}
	}

	return { wrong: wrong, right: right };
};

var reveal = function reveal(correctAnswers) {
	reset();
	var answers = Array.from(document.querySelectorAll(".answer"));
	var _iteratorNormalCompletion2 = true;
	var _didIteratorError2 = false;
	var _iteratorError2 = undefined;

	try {
		for (var _iterator2 = answers[Symbol.iterator](), _step2; !(_iteratorNormalCompletion2 = (_step2 = _iterator2.next()).done); _iteratorNormalCompletion2 = true) {
			var answer = _step2.value;

			answer.value = correctAnswer[answer.id];
			answer.parentNode.className = "question correct";
		}
	} catch (err) {
		_didIteratorError2 = true;
		_iteratorError2 = err;
	} finally {
		try {
			if (!_iteratorNormalCompletion2 && _iterator2.return) {
				_iterator2.return();
			}
		} finally {
			if (_didIteratorError2) {
				throw _iteratorError2;
			}
		}
	}
};

var reset = function reset(correctAnswers) {
	var answers = Array.from(document.querySelectorAll(".answer"));
	var _iteratorNormalCompletion3 = true;
	var _didIteratorError3 = false;
	var _iteratorError3 = undefined;

	try {
		for (var _iterator3 = answers[Symbol.iterator](), _step3; !(_iteratorNormalCompletion3 = (_step3 = _iterator3.next()).done); _iteratorNormalCompletion3 = true) {
			var answer = _step3.value;

			answer.value = answer.firstChild.value || "";
			answer.parentNode.className = "question";
		}
	} catch (err) {
		_didIteratorError3 = true;
		_iteratorError3 = err;
	} finally {
		try {
			if (!_iteratorNormalCompletion3 && _iterator3.return) {
				_iterator3.return();
			}
		} finally {
			if (_didIteratorError3) {
				throw _iteratorError3;
			}
		}
	}
};
/* end function definitions */

var checkBtn = document.getElementById("check");
var revealBtn = document.getElementById("reveal");
var resetBtn = document.getElementById("reset");
var resultDiv = document.getElementById("result");

var possibleValues = ["human_capital", "rights_based", "capabilities"];
var correctAnswer = {
	question5: "human_capital",
	question9: "human_capital",
	question3: "human_capital",
	question1: "rights_based",
	question8: "rights_based",
	question7: "rights_based",
	question2: "capabilities",
	question4: "capabilities",
	question6: "capabilities"
};
var incorrectFeedback = "<br>Some of your answers are incorrect";
var correctFeedback = "Correct, you have correctly identified the classifications for each quote";

var maxAttempts = 3;
var attempts = 0;

/* Events */
resetBtn.addEventListener("click", function () {
	reset();
	resultDiv.innerHTML = "";
	attempts = 0;
});

revealBtn.addEventListener("click", function () {
	reveal(correctAnswer);
	resultDiv.innerHTML = "The correct values are now displayed";
});

checkBtn.addEventListener("click", function () {
	var results = check(possibleValues, correctAnswer, incorrectFeedback);
	var resultString = "";

	// handle attempts
	if (attempts >= maxAttempts) {
		reveal(correctAnswer);
		resultDiv.innerHTML = "You have exceeded " + maxAttempts + " attempts. The correct answers are now shown.";
		return;
	}

	// handle incorrect answers
	if (results.wrong.length) {
		var _iteratorNormalCompletion4 = true;
		var _didIteratorError4 = false;
		var _iteratorError4 = undefined;

		try {
			for (var _iterator4 = results.wrong.entries()[Symbol.iterator](), _step4; !(_iteratorNormalCompletion4 = (_step4 = _iterator4.next()).done); _iteratorNormalCompletion4 = true) {
				var _step4$value = _slicedToArray(_step4.value, 2),
				    k = _step4$value[0],
				    i = _step4$value[1];

				resultString += "Answer " + i.id.match(/\d/g) + " incorrect. ";
				i.parentNode.className = "question incorrect";
			}
		} catch (err) {
			_didIteratorError4 = true;
			_iteratorError4 = err;
		} finally {
			try {
				if (!_iteratorNormalCompletion4 && _iterator4.return) {
					_iterator4.return();
				}
			} finally {
				if (_didIteratorError4) {
					throw _iteratorError4;
				}
			}
		}

		resultString += incorrectFeedback;
	}

	// handle correct answers
	if (results.right.length) {
		var _iteratorNormalCompletion5 = true;
		var _didIteratorError5 = false;
		var _iteratorError5 = undefined;

		try {
			for (var _iterator5 = results.right.entries()[Symbol.iterator](), _step5; !(_iteratorNormalCompletion5 = (_step5 = _iterator5.next()).done); _iteratorNormalCompletion5 = true) {
				var _step5$value = _slicedToArray(_step5.value, 2),
				    k = _step5$value[0],
				    i = _step5$value[1];

				i.parentNode.className = "question correct";
			}
		} catch (err) {
			_didIteratorError5 = true;
			_iteratorError5 = err;
		} finally {
			try {
				if (!_iteratorNormalCompletion5 && _iterator5.return) {
					_iterator5.return();
				}
			} finally {
				if (_didIteratorError5) {
					throw _iteratorError5;
				}
			}
		}

		if (!results.wrong.length) resultString = correctFeedback;
	}

	resultDiv.innerHTML = resultString;
	attempts++;
});

/* events */
VLE.resize_iframe();

var resizer = new _Resizer.Resizer("#select_answers");
resizer.trigger = "resize click";
resizer.transitions = false;

resizer.do(function () {
	console.log("attempting resize");
	VLE.resize_iframe();
});

/***/ })

/******/ });
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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