var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:false,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<div class=\"shadow-r\"></div><div class=\"title\">Role and role model:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">the participants recognised that they had an important role to play in promoting children’s health. They also recognised that they needed to be positive role models for the children. They modelled positive behaviour by changing their own habits, for example substituting their usual drinks for water. As mentioned already, the adults in children’s lives are the people who are going to teach them about health habits, either consciously or unconsciously. Children will copy adults, and you may not be aware of the powerful influence that you have on them; as professionals with responsibility for their education and care, you may need to consider how you can model positive health behaviours for children when in your care.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Responsibility:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">as well as a moral responsibility for the children, the participants were aware that they had a legal responsibility to implement high quality care and education as a requirement of the Early Years Foundation Stage (Department for Education, 2024). And as there are over 30 aims and principles that relate to promoting and supporting children’s health, delivering high quality ECEC can make a useful contribution to children’s health.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Relevant and realistic:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Relevant and realistic: to ensure that the health promotion intervention was relevant to the children and families, the participants carried out Step 1 of the 5 Step Approach, this was an audit of the health needs and details of the families’ circumstances. This step helped them to gain a greater understanding of the children and the context of their lives and the factors that may influence their health. The information gathered about the families helped the participants to learn more about the families and helped to decide what sorts of intervention would be realistic.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Built on relationships:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">at the heart of the success of the healthy eating and drinking campaign, was the relationship with the families. The participants were mindful of the World Health Organisation’s warning that health promotion should not be done to, but should be done with people, therefore, they worked with the parents as partners. The positive relationships that they had developed with their parents meant that they were able to have sensitive and helpful conversations with parents.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"title\">Routines:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">the participants realised that many health promoting activities can and already are embedded in everyday routines. For example, routines that include adequate time for mealtimes that offer healthy food, drink and sleep and rest times are examples of some of the foundations that children need for good health. Supporting children to develop self-care with good hygiene practices are also part of toileting and handwashing routines. Improving awareness of the importance of handwashing is a global aim, as discussed in Session 5. The participants sought playful approaches to building in the handwashing routines by singing ‘the handwashing song’.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"title\">Resources:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">the research highlighted the need to ensure that resources are available to that support health promotion activities. Examples of resources include time needed to invest in carrying out the activities. Other resources include paper and printing.</p></div>"
        }
    ]
};

var labels, reveals, resize;
var prevHeight;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
    addClickToContainer();
    hasMediaLoaded();
    prevHeight=document.getElementById("container").offsetHeight;
    resizeScreen();
})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(function(){
            if(prevHeight!==document.getElementById("container").offsetHeight) {
                prevHeight=document.getElementById("container").offsetHeight;
                VLE.resize_iframe();
                scrollTop()

            } else {
                clearTimeout(resize);
            }
        }, 250);
    };
}

function addClickToContainer(){
    var containers = document.querySelectorAll(".seperate-container");
    for(var i=0; i< containers.length;i++){
        containers[i].onclick=function(){
            this.querySelector(".label-container .label").click();
        }
    }
}

function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    stopMedia();
    resizeScreen();
}
function stopMedia(){
    /* pauses vids */
    var medias = document.querySelectorAll("video,audio");
    for(var j=0; j<medias.length; j++){
        if(medias[j]) {
            if (medias[j].parentNode) {
                if (medias[j].parentNode.nextElementSibling) {
                    if (medias[j].parentNode.nextElementSibling.querySelector(".omp-stop")) {
                        medias[j].parentNode.nextElementSibling.querySelector(".omp-stop").click();
                    }
                }
            }
        }
    }
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe();scrollTop()}, 1000);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
                scrollTop()
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
    if(data.backgroundimage) {
        createEl(content,"div", null, null, {"class":"bkg-img"});
    }
    createEl(document.getElementById("container"), "script", null, null, {
        "data-main": "./oump/js/oump",
        "src": "./oump/js/loader.js"
    });
    var mediaContainer = document.querySelectorAll(".media-holder");
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        mediaContainer[mc].addEventListener("click", showHideTranscripts);
    }

    updateClass("add", document.querySelector("#container"), "loaded")
}

function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        stopMedia();
        VLE.resize_iframe();
        scrollTop()
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
}
function hasMediaLoaded() {
    var mediaContainer = document.querySelectorAll(".media-holder");
    var loaded = true;
    if(!hasClass(document.querySelector("#container"),"loaded")){
        loaded = false;
    }
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        if (!mediaContainer[mc].querySelector(".omp-placeholder-image")) {
            loaded = false;
        }
    }
    if (loaded) {
        setTimeout(function(){VLE.resize_iframe();scrollTop()}, 500);
        document.addEventListener('fullscreenchange', exitHandler);
        document.addEventListener('webkitfullscreenchange', exitHandler);
        document.addEventListener('mozfullscreenchange', exitHandler);
        document.addEventListener('MSFullscreenChange', exitHandler);
    } else {
        setTimeout(function () {
            hasMediaLoaded();
        }, 500);
    }

}
function exitHandler() {
    if (!document.fullscreenElement && !document.webkitIsFullScreen && !document.mozFullScreen && !document.msFullscreenElement) {
        setTimeout(function () {
            VLE.resize_iframe();
            scrollTop()
        }, 500);
    }
}
function showHideTranscripts(e) {
    var el = e.target;
    if (hasClass(el.parentNode, "omp-transcript-toggle-checkbox")) {
        setTimeout(function () {
            VLE.resize_iframe();
            scrollTop()
        }, 500);
    }
};
function scrollTop(){
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
}