var VLE = {
    apiversion: 1,
    pointversion: 25,
    serverversion: false,
    strings : {
        label_group: 'Group',
        option_choose: 'Choose...'
    },
    get_param : function(name) {
        // Check valid param name
        this.check_key(name, 'Invalid param name: ' + name);

        // Find in query
        var search = String(location.search);
        var matches = new RegExp('[?&]' + name + '=([^&]+)').exec(search);
        if (matches && matches[1]) {
            return decodeURIComponent(matches[1].replace(/\+/g, ' '));
        } else {
            return null;
        }
    },
    get_attachment : function(name, ok, error) {
        var url = this.get_param(name);
        if (!url) {
            error('Attachment not found: ' + name);
            return;
        }
        var xml = url.match(/\.xml$/);
        this.ajax_get(url, function(req) {
            ok(req.responseText, xml ? req.responseXML : null);
        }, error);
    },
    get_folder : function(name, ok, error, t) {
        // Specify this for callbacks.
        if (t === undefined) {
            t = this;
        }
        VLE.get_folder_callback = function(data) {
            ok.call(t, data);
        };
        var script = document.createElement('script');
        script.async = true;
        script .src = name + '/' + name + '.folder.js';
        document.getElementsByTagName('head')[0].appendChild(script);
    },
    get_server_data : function(userorgroup, names, ok, error, activityid, itemid, courseid, modname) {
        window.setTimeout(function() { error(null); }, 0);
    },
    set_server_data : function(userorgroup, values, ok, error, previousvalues, retry,
            activityid, itemid, courseid) {
        window.setTimeout(function() { error(null); }, 0);
    },
    set_exported_response : function(html, ok, error, activityid, itemid, courseid) {
        window.setTimeout(function() { error(null); }, 0);
    },
    get_all_groups : function(ok, error, t) {
        if (t === undefined) {
            t = this;
        }
        window.setTimeout(function() { error.call(t, null); }, 0);
    },
    get_tutor_groups : function(ok, error, t) {
        if (t === undefined) {
            t = this;
        }
        window.setTimeout(function() { error.call(t, null); }, 0);
    },
    get_regional_groups : function(ok, error, t) {
        if (t === undefined) {
            t = this;
        }
        window.setTimeout(function() { error.call(t, null); }, 0);
    },
    make_group_chooser : function(groups, onchange, autoselect, error, t) {
        var div = document.createElement('div');
        div.style.display = 'none';
        if (t === undefined) {
            t = this;
        }
        window.setTimeout(function() { onchange.call(t, null, false); }, 0);
        return div;
    },
    ajax_get : function(url, ok, error) {
        // Get the XMLHttpRequest object. On IE we prefer the ActiveX version
        // even though it now supports the standard way too, because the ActiveX
        // one can access files if run locally.
        var req;
        if (window.ActiveXObject) {
            req = new ActiveXObject("Microsoft.XMLHTTP");
        } else {
            req = new XMLHttpRequest();
        }
        req.open('GET', url, true);
        req.onreadystatechange = function(e) {
            if (req.readyState == 4) {
                // Status 0 is for local files (testing use only).
                if (req.status == 200 || req.status == 0) {
                    ok(req);
                } else {
                    error('Error ' + req.status + ' loading ' + url);
                }
            }
        };
        req.send(null);
    },
    check_key : function(key, message) {
        if (key === null || !key.match(/^[A-Za-z0-9._-]{1,20}$/)) {
            throw message;
        }
    },
    get_embed_context : function() {
        return {
            backgroundColor: '#ffffff',
            fontSize: '0.875em',
            color: '#1a1a1a',
            fontFamily: 'Arial, sans-serif',
            lineHeight: '1.4',
            marginBottom: '0.5em',
            variant: '#e80074'
        };
    },
    report_visit : function(error, activityid, itemid, courseid) {
        if (typeof error !== undefined) {
            error(null);
        }
    },
    report_count : function(shortname, displayname, error, activityid, itemid, courseid) {
        if (typeof error !== undefined) {
            error(null);
        }
    },
    report_start_timer : function(shortname, displayname, error, activityid, itemid, courseid) {
        if (typeof error !== undefined) {
            error(null);
        }
        return function() {};
    },
    reset_caches : function() {
    },
    send_service_request : function(service, input, ok, error, t) {
        if (typeof(error) !== undefined) {
            window.setTimeout(function() { error.call(t, null); }, 0);
        }
    },
    get_olink_url : function(targetdoc, targetptr, ok, error, courseid, t) {
        if (t === undefined) {
            t = this;
        }
        if (typeof(errror) !== undefined) {
            window.setTimeout(function() { error.call(t, null); }, 0);
        }
    },
    get_multiple_olink_url : function(targetdocs, targetptrs, ok, error, courseid, t) {
        if (t === undefined) {
            t = this;
        }
        if (typeof(errror) !== undefined) {
            window.setTimeout(function() { error.call(t, null); }, 0);
        }
    },
    resize_iframe : function() {
        // Find iframe in parent window.
        var iframe = window.frameElement;
        // If we can't find it, put a message in the console and abort.
        if (!iframe) {
            if (window.console) {
                console.log('VLE.resize_iframe: Unable to find parent iframe');
            }
            return;
        }
        // Calculate body height including margins.
        var html = document.getElementsByTagName('html')[0];
        var styles = getComputedStyle(html);
        var totalHeight = parseFloat(styles['marginTop']) +
               parseFloat(styles['marginBottom']) + html.offsetHeight;
        // Set the height.
        iframe.height = totalHeight;
    },
    can_save: function() {
        return this.get_param('_nosave') !== 'y';
    },
    get_fullscreen_link : function() {
        return document.location.href;
    },
    get_server_time : function(ok, error, t) {
        if (t === undefined) {
            t = this;
        }
        ok.call(t, Date.now());
    },
    is_offline: function () {
        return false;
    },
    get_week : function(ok, error, activityid, itemid, courseid, t) {
        if (t === undefined) {
            t = this;
        }
        if (typeof (errror) !== undefined) {
            window.setTimeout(function () {
                error.call(t, null);
            }, 0);
        }
    },
    get_all_weeks: function(ok, error, activityid, itemid, courseid, t) {
        if (t === undefined) {
            t = this;
        }
        if (typeof (errror) !== undefined) {
            window.setTimeout(function () {
                error.call(t, null);
            }, 0);
        }
    },
    get_completion : function(ok, error, activityid, itemid, courseid, t) {
        if (t === undefined) {
            t = this;
        }
        if (typeof (errror) !== undefined) {
            window.setTimeout(function () {
                error.call(t, null);
            }, 0);
        }
    }
};
