var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:0,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<span>Unconditional positive regard <br/>(non-judgemental)</span>",
            content:"<img class=\"imgPerson\" src=\"imgs/bkgimg1.png\" width=\"216\" height=\"523\" /><div class=\"box\"><p>Unconditional positive regard means being non-judgemental. An individual will not feel comfortable revealing information about themselves to you if they feel that you will judge them. It is particularly important to remember this if you wish to obtain accurate and honest information.</p></div>"
        },
        {
            label:"<span>Congruence (genuine)</span>",
            content:"<img class=\"imgPerson\" src=\"imgs/bkgimg2.png\" width=\"216\" height=\"523\" /><div class=\"box\"><p>Congruence in this context refers to being authentic, genuine and honest. This suggests that in sport a practitioner can be enthusiastic, bored, angry, sensitive and sympathetic (Rogers, 1969). Those facilitating others’ development can use the full range of emotions that inevitably accompany practice. This is not to suggest that coaches should take this literally and act upon every emotion. Instead, they can live their feelings and, where appropriate, choose to share those feelings if they believe they might benefit learning (Nelson et. al., 2014).</p></div>"
        },
        {
            label:"<span>Empathy</span>",
            content:"<img class=\"imgPerson\" src=\"imgs/bkgimg3.png\" width=\"216\" height=\"523\" /><div class=\"box\"><p>Empathy can be defined as putting yourself in the other person’s shoes and an ability to show this understanding to the other person.  Empathy helps to make the other person feel listened to and helps to begin establishing a trusting connection.</p></div>"
        }
    ],
    backgroundimage:true
};



var labels, reveals, resize;
var prevHeight;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
    addClickToContainer();


    var mediaContainer = document.querySelectorAll(".vid-holder");
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        mediaContainer[mc].addEventListener("click", showHideTranscripts);
    }
    hasMediaLoaded();
    prevHeight=document.getElementById("container").offsetHeight;


})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(function(){
            if(prevHeight!==document.getElementById("container").offsetHeight) {
                prevHeight=document.getElementById("container").offsetHeight;
                VLE.resize_iframe();
            } else {
                clearTimeout(resize);
            }
        }, 250);
    };
}

function addClickToContainer(){
    var containers = document.querySelectorAll(".seperate-container");
    for(var i=0; i< containers.length;i++){
        containers[i].onclick=function(){
            this.querySelector(".label-container .label").click();
        }
    }
}

function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    /* pauses vids */
    var vids = document.querySelectorAll("video");
    for(var j=0; j<vids.length; j++){
        if(vids[j]) {
            if (vids[j].parentNode) {
                if (vids[j].parentNode.nextElementSibling) {
                    if (vids[j].parentNode.nextElementSibling.querySelector(".pause")) {
                        vids[j].parentNode.nextElementSibling.querySelector(".pause").click();
                    }
                }
            }
        }
    }
    var currentVideo =
    /* END pauses vids */
    resizeScreen();
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe()}, 250);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
    if(data.backgroundimage) {
        createEl(content,"div", null, null, {"class":"bkg-img"});
    }
}

function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        resizeScreen();
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
}
function hasMediaLoaded() {
    var mediaContainer = document.querySelectorAll(".vid-holder");
    var loaded = true;
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        if (!mediaContainer[mc].querySelector(".omp-placeholder")) {
            loaded = false;
        }
    }
    if (loaded) {
        VLE.resize_iframe();
    } else {
        setTimeout(function () {
            hasMediaLoaded();
        }, 500);
    }
    document.addEventListener('fullscreenchange', exitHandler);
    document.addEventListener('webkitfullscreenchange', exitHandler);
    document.addEventListener('mozfullscreenchange', exitHandler);
    document.addEventListener('MSFullscreenChange', exitHandler);
}
function exitHandler() {
    if (!document.fullscreenElement && !document.webkitIsFullScreen && !document.mozFullScreen && !document.msFullscreenElement) {
        setTimeout(function () {
            VLE.resize_iframe();
        }, 500);
    }
}
function showHideTranscripts(e) {
    var el = e.target;
    if (hasClass(el.parentNode, "omp-transcript-toggle-checkbox")) {
        setTimeout(function () {
            VLE.resize_iframe();
        }, 500);
    }
};