/*
 * Function to create a tab navigation system for OSL.
 * Data is loaded from tabManagerData.json, this stores details of the tabs as an array of objects.
 *
 * */

var tabNav = (function(){
  var tabData = {
    "tabs":[
      {"name": "Emotional", "type": "content text-only"},
      {"name": "Technical", "type": "content text-only"},
      {"name": "Informational", "type": "content text-only"},
      {"name": "Tangible", "type": "content text-only"},
	  {"name": "Motivational", "type": "content text-only"}
    ]
  };
  /*
   * createTabs
   * uses data Object loaded in createTabContent.
   * Creates #tabs div and adds tabs to it from the data file.
   * Binds click and keydown behaviour
   * The first tab is set to active.
   */
  var createTabs = function(){
    var protocol = location.protocol;
    if (protocol !== "http:" && protocol !== "https:") {
      $("body").addClass("offline");
    }
    $("#tabs").append("<ul id='tabList'></ul>");
    $.each(tabData.tabs, function(i, v){
      var j = i+1;
      $("#tabList").append("<li id='tab"+i+"' tabindex='"+ j +"' class='tab'><a>"+v.name+"</a></li>");
      $("#tab"+i).bind("keydown", function(event){keyDownTab(event, "#tab"+i)}).bind("click", function(event){clickTab(event, "#tab"+i)});
    });
    $("#tab0").addClass("selected");
    $("#tab0_content").show();
  };

  var keyDownTab = function(event, id){
    if(event.which == 13){
      $(".selected").removeClass("selected");
      $(id).addClass("selected");
      $(".content").hide();
      $(id + "_content").show();
    }
  };

  var clickTab = function(event, id){
    $(".selected").removeClass("selected");
    $(id).addClass("selected");
    $(".content").hide();
    $(id + "_content").show();
  };

  var revealAnswerBtn = function(event, id){
    $("#"+id + "_answer").removeClass("notvisible");
    $('#'+id).attr("disabled", "disabled");
  };

  return{
    createTabs: createTabs,
    revealAnswerBtn: revealAnswerBtn
  }
})();

$( document ).ready(function(){
  tabNav.createTabs();
  $(".answerBtn").on('click', function(evt){tabNav.revealAnswerBtn(evt, this.id)});
});

