/**
 * @fileOverview SaveHtml - Works just like an HTML div object, but also allows you to save element values
 *     (eg, from a table/form, where the user has entered data)
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Div');
OU.require('OU.util.Keyboard');
OU.require('OU.util.PopUpInfo');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.SaveHtml = function(data, instance, controller) {
    /**
     *
     */
    OU.activity.SaveHtml.prototype.canvasView = function() {
        var self=this;
        this.begoneWrong = false;
        this.bgLayer = new OU.util.Layer({
            container: this
        });
        this.bgLayer.context.gradRect(); // draw background on backdrop layer
        this.margin = this.data.margin || 40;
        this.htmlDiv = new OU.util.Div({
            x: this.x + this.margin,
            y: this.y + this.margin,
            w: this.w - this.margin * 2,
            h: this.h - this.margin * 2,
            container: this,
            style: 'overflow: auto'
        });
        if (this.data.keypad) {
            this.keypad = new OU.util.Keyboard({
                x: (this.data.keypad.x || 0.01),
                y: (this.data.keypad.y || 0.01),
                h: (this.data.keypad.h || 0.7),
                calculate: this.data.keypad.calculate,
                scientific: this.data.keypad.scientific,
                numbers: this.data.keypad.numbers,
                ok: true,
                okFn: function() {
                    OU.thsKP.dispDiv.innerHTML = OU.thsKP.div.div.innerHTML;
                    OU.thsKP.dispDiv.style.border = 'solid 1px';
                    OU.thsKP.setVisible(false);
                    OU.thsKP.container.saveVars();
                },
                background: '#fcfcfc',
                formatting: false,
                unicode: this.data.keypad.unicode || false,
                space: false,
                specials: this.data.textPad || false,
                container: this,
                zIndex: OU.OVERLAY_CONTROLLER_LEVEL
            });
            OU.thsKP = this.keypad;
            this.keypad.resize();
        }
                   this.insertHtml();

        if (this.data.javascript) {
            var inc = document.createElement('script');
            inc.src = this.data.javascript;
            inc.type = 'text/javascript';
/*
            if (document.all) { // Fix for IE's lack of 'onload' support
                inc.onreadystatechange = function() {
                    if (inc.readyState === 'complete' || inc.readyState === 'loaded') {
                        self.insertHtml();
                    }
                };
            }
            else {
                inc.onload = function() {
                    self.insertHtml();
                };
            }
//*/
            OU.head.appendChild(inc);
        }
        else {
//            this.insertHtml();
        }

    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.insertHtml = function() {
        var i, id, e, self = this, html = this.data.html;
        if (OU.thsKP && html) {
            html = html.replace(/<input/g, "<div class='saveHtmlDiv' style='border:solid 1px;border-radius:3px;min-height:" + ((window.innerHeight / 40) | 0) + "px;height:100%;border:solid 1px;width:90%;position:relative;' onclick='this.style.border=\"solid 3px\";OU.thsKP.dispDiv=this;OU.thsKP.setVisible(true,\" \"+this.innerHTML);' ");
        }
        this.htmlDiv.div.innerHTML = html;
        this.findValidateButton();
        this.findClearButton();
        if (this.data.saveIDs) {
            for (i = this.data.saveIDs.length; i--; ) { //add listeners to the elements we need to save
                id = this.data.saveIDs[i];
                e = document.getElementById(id);
                e.onchange = function() {
                    self.saveVars();
                };
            }
            this.loadVars();
        }
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.saveVars = function() {
        var i, id, e, val;
        if (this.data.saveIDs) {
            for (i = this.data.saveIDs.length; i--; ) {
                id = this.data.saveIDs[i];
                e = document.getElementById(id);
                if (this.keypad)
                    val = e.innerHTML;
                else
                    val = e.value;
                OU.LocalStorage.save('ou.savehtml.' + this.data.saveTitle + '.' + id, val);
            }
        }
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.loadVars = function() {
        var i, id, e, val;
        if (this.data.saveIDs) {
            for (i = this.data.saveIDs.length; i--; ) {
                id = this.data.saveIDs[i];
                e = document.getElementById(id);
                val = OU.LocalStorage.load('ou.savehtml.' + this.data.saveTitle + '.' + id) || '';
                if (this.keypad)
                    e.innerHTML = val;
                else
                    e.value = val;
            }
        }
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.resize = function() {
        OU.activity.SaveHtml.superClass_.resize.call(this); // call the parent class resize
        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        this.htmlDiv.resize({
            x: this.x + this.margin,
            y: this.y + this.margin,
            w: this.w - this.margin * 2,
            h: this.h - this.margin * 2,
            container: this
        });
        if (this.keypad)
            this.keypad.resize();
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.findValidateButton = function() {
        var self = this, e = document.getElementById('htmlSaveValidateButton');
        if (e != undefined) {
            e.setAttribute('class', '_abuttonNOFLOAT');
            e.onclick = function() {
                self.preValidate();
                return false;
            };
        }
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.findClearButton = function() {
        var self = this, e = document.getElementById('htmlSaveClearButton');
        if (e != undefined) {
            e.setAttribute('class', '_abuttonNOFLOAT');
            e.onclick = function() {
                self.clearAnswers();
                return false;
            };
        }
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.clearAnswers = function() {
        if (confirm("Are you sure you wish to clear out all the answers in this table?")) {
            this.doClearAnswers();
            this.saveVars();
        }
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.doClearAnswers = function() {
        var i, inputs = (this.keypad ? document.getElementsByClassName('saveHtmlDiv') : document.getElementsByTagName('input')), itemid, s;
        for (i = inputs.length; i--; ) {
            itemid = inputs[i].id;
            if (itemid) {
                s = itemid.split("_");
                if (s[0] == data.solution.fields) {
                    if (this.keypad)
                        inputs[i].innerHTML = '';
                    else
                        inputs[i].value = '';
                    inputs[i].style.border = "";
                }
            }
        }
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.preValidate = function() {
        if (this.checkCount == null)
            this.checkCount = 0;
        if (this.checkCount > 2) {
            // give them the answers
            this.populateAnswers();
            this.validate();
            this.checkCount = 10;
        }
        else {
            //validate
            this.validate();
            this.checkCount += 1;
            if (this.checkCount > 2) {
                // change the button text
                var e = document.getElementById('htmlSaveValidateButton');
                e.innerHTML = 'View Solution';
            }
        }
        this.saveVars();
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.populateAnswers = function() {
        var i, inputs = (this.keypad ? document.getElementsByClassName('saveHtmlDiv') : document.getElementsByTagName('input')), itemid, s, v, f, score = 0, self = this;
        for (i = inputs.length; i--; ) {
            itemid = inputs[i].id;
            if (itemid) {
                s = itemid.split("_");
                if (s[0] == data.solution.fields) {
                    if (this.keypad)
                        inputs[i].innerHTML = data.solution.answers[s[1]];
                    else
                        inputs[i].value = data.solution.answers[s[1]];
                }
            }
        }
    };
    /**
     *
     */
    OU.activity.SaveHtml.prototype.validate = function() {
        var i, inputs = (this.keypad ? document.getElementsByClassName('saveHtmlDiv') : document.getElementsByTagName('input')), itemid, s, v, f, score = 0, self = this;
        for (i = inputs.length; i--; ) {
            itemid = inputs[i].id;
            if (itemid != undefined) {
                s = itemid.split("_");
                if (s[0] == data.solution.fields) {
                    if (this.keypad)
                        v = inputs[i].innerHTML;
                    else
                        v = inputs[i].value ? inputs[i].value : "";
                    if (v.toLowerCase() == data.solution.answers[s[1]]) {
                        score++;
                        inputs[i].style.border = "1px solid #00ff80";
                        inputs[i].style.background = "#00ff00";
                        if (v.length == 2)
                            f = v[0].toUpperCase() + v[1].toLowerCase();
                        else
                            f = v.toUpperCase();
                        if (this.keypad)
                            inputs[i].innerHTML = f;
                        else
                            inputs[i].value = f;
                    }
                    else {
                        inputs[i].style.border = "1px solid #c0c0c0";
                        inputs[i].style.background = "transparent";
                    }
                }
            }
        }
        if (score == data.solution.answers.length) {
            new OU.util.PopUpInfo({
                container: this,
                txt: data.solution.correctText,
                x: this.w * .20,
                y: this.h * .15,
                w: this.w * .6,
                h: this.h * .7,
                onClose: function() {
                }
            });
        }
        else {
            if (!this.begoneWrong) {
                new OU.util.PopUpInfo({
                    container: this,
                    txt: data.solution.incorrectText,
                    x: this.w * .20,
                    y: this.h * .15,
                    w: this.w * .5,
                    h: this.h * .4,
                    onClose: function() {
                        self.begoneWrong = true;
                    }
                });
            }
        }
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.SaveHtml, OU.util.Activity);
