/**
 * @fileOverview QuizForm - simple HTML form quiz - allows typed input
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Div');
OU.require('OU.util.Keyboard');

/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.QuizForm = function(data,instance,controller) {

    OU.activity.QuizForm.prototype.canvasView = function() {

        OU.obj[instance] = this;
        this.keypads=[];
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.bgLayer.context.gradRect(); // draw background on backdrop layer

        if(this.failedAttempts===undefined) {
            this.failedAttempts={};
        }
        this.hintAfter = this.data.hintAfter || 0;
        this.hint = this.data.hint || null;
        this.revealAfter = this.data.revealAfter || 3;

        this.margin=this.data.margin || 40;
        this.htmlDiv = new OU.util.Div({
            x:this.x+this.margin,
            y:this.y+this.margin,
            w:this.w-this.margin*2,
            h:this.h-this.margin*2,
            container: this
        });

        if(! this.data.waitForCue)
            this.load();
    };
    OU.activity.QuizForm.prototype.step = function(n) {
        if(n==this.stepN)
            return;
        this.stepN=n;
        if(n==0)
            this.htmlDiv.div.innerHTML="";
        else
            this.load();
    };
    OU.activity.QuizForm.prototype.load = function() {
        var i,h,qs=this.data.qs,iF;

        this.htmlDiv.div.innerHTML=this.makeForm();

        for(i=0; i<qs.length; i++) {
            if(qs[i].keypad) {
                iF = document.getElementById(this.instance+"_qf_"+i);
                this.keypads.push(new OU.util.Keypad({
                    type: qs[i].keypad,
                    container: this,
                    inputField: iF
                }));
            }
        }
    };
    OU.activity.QuizForm.prototype.remove = function() {
        OU.activity.QuizForm.superClass_.remove.call(this); // call the superclass method
        for(var i=this.keypads.length;i--;)
            this.keypads[i].remove();
    };
    OU.activity.QuizForm.prototype.resize = function() {
        OU.activity.QuizForm.superClass_.resize.call(this); // call the parent class resize
        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        this.htmlDiv.resize({
            x:this.x+this.margin,
            y:this.y+this.margin,
            w:this.w-this.margin*2,
            h:this.h-this.margin*2,
            container: this
        });
        for(var i=this.keypads.length;i--;)
            this.keypads[i].resize();
    };
    OU.activity.QuizForm.prototype.makeForm = function() {
        var i,h,qs=this.data.qs,
        bT=this.data.buttonText || 'Submit';

        h = "<h1>"+this.data.title+"</h1>";

        for(i=0; i<qs.length; i++) {
            h = h + ""+qs[i].q+"<br/><br/><input type='text' id='"+this.instance+"_qf_"+i+"'/><br/><br/>";
        }

        h = h + "<p><input type='button' value='"+bT+"' onclick=\"javascript:OU.obj['"+this.instance+"'].answerForm();\"/></p>";
        return h;
    };
    OU.activity.QuizForm.prototype.answerForm = function() {
        var i,e,qs=this.data.qs,failed=false,reg,v,m="",m2="",oid;

        for(i=0; i<qs.length; i++) {
            failed=false;
            e = document.getElementById(this.instance+"_qf_"+i);
            v = e.value.trim();
            if(qs[i].type=='string') {
                reg=new RegExp(qs[i].a,'i');
                if(v.match(reg)==null) {
                    failed=true;
                    m = m + "<p>"+qs[i].incorrectFeedback+"</p>";
                }
                else if(qs[i].caseSensitive) {
                    reg=new RegExp(qs[i].a,'');
                    if(v.match(reg)==null) {
                        failed=true;
                        m = m + "<p>"+qs[i].incorrectCaseFeedback+"</p>";
                    }
                }
            }
            else if(qs[i].type=='numeric') {
                if(parseFloat(e.value)!=parseFloat(qs[i].a)) {
                    failed=true;
                    m = m + "<p>"+qs[i].incorrectFeedback+"</p>";
                }
            }
            if(!failed) {
                m = m + "<p>"+qs[i].correctFeedback+"</p>";
            }
            else {
                m2="<input type='button' value='Retry' onclick=\"OU.obj['"+this.instance+"'].init();return false;\"/>";
                if(this.failedAttempts[i]===undefined)
                    this.failedAttempts[i]=1;
                else
                    this.failedAttempts[i]++;
                if(this.failedAttempts[i]>this.hintAfter && this.hint) {
                    m += '<p>'+this.hint+'</p>';
                }
                if(this.failedAttempts[i]>this.revealAfter) {
                    m += '<p>The correct answer is: <strong>'+qs[i].a+'</strong></p>';
                }

            }
        }
        if(this.data.nextActivity!==undefined) {
            oid = OU.storeOverride(this.data.nextActivity);
            m = m + "<p><input type='button' value='Continue' onclick='return OU.replaceActivity("+oid+","+this._zOffset+","+this.controller.controllerId+")' /></p>";
        }
        this.htmlDiv.div.innerHTML=m+"<p>"+m2+"</p>";
        return false;
    };

    OU.activity.QuizForm.prototype.accessibleView = function() {
        var h = '<div id="accessibleView">';
        h += this.data.html;
        h += '</div>';
        document.body.innerHTML='';
        var accessible = document.createElement('div');
        accessible.innerHTML = h;
        document.body.appendChild(accessible);
    };
    OU.base(this,data,instance,controller);
};
OU.inherits(OU.activity.QuizForm,OU.util.Activity);
