/**
 * @fileOverview ButtonTest - A test activity for buttons
 *
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

// Load in any util elements that are required
OU.require('OU.util.Layer');
OU.require('OU.util.Button');

BUTTON_GAP=1.5; // Constant to define button spacing

/**
 * @class ButtonTest - A template for activities that extend the OU.util.Activity class
 * @extends OU.util.Activity
 * @param {Object} data - Holds the data content for a specific instance of the activity
 * @param {String} instance - (Optional) A unique identifier name for this instance, defaults to 'a1'
 * @param {OU.util.Controller} controller - (Optional) A reference to the controller that initialised this instance, if undefined, the superclass will generate a new controller and create the reference to it as 'this.controller'
 */
OU.activity.ButtonTest = function(data, instance, controller) {

    /**
     * canvasView - this is the function that is first called when the activity is launched,
     *              assuming you are in a browser that supports canvas.
     *
     * Typical tasks for this function are:
     * <ul>
     * <li> Define and initialise and activity wide variables</li>
     * <li> Initialise Layers & Divs</li>
     * <li> Call a loading function</li>
     * <li> Initiating the activity by calling any methods that</li>
     * </ul>
     */
    OU.activity.ButtonTest.prototype.canvasView = function() {

        // Most activities should have a background layer
        this.bgLayer = new OU.util.Layer({
            container: this,
            hasEvents:true
        });
        this.bgLayer.context.gradRect(); // draw default background
        var bH = OU.controlHeight, buttonY = bH,self=this;

        // standard button
        this.standardButton = new OU.util.Button({
            txt:"Standard",
            layer: this.bgLayer,
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH,
            group:'topGroup',
            onClick: function() {
                console.log("Standard Button HIT");
            }
        });
        buttonY += bH * BUTTON_GAP;

        // Control button
        this.controlButton = new OU.util.ControlButton({
            txt:"Control",
            layer: this.bgLayer,
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH,
            group:'topGroup',
            onClick: function() {
                console.log("Control Button HIT");
            }
        });
        buttonY += bH * BUTTON_GAP;

        // Checkbox button
        this.checkboxButton = new OU.util.CheckBoxButton({
            txt:"CheckBox",
            layer: this.bgLayer,
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH,
            onClick: function() {
                console.log("CheckBox Button HIT");
                self.render();
            }
        });
        buttonY += bH * BUTTON_GAP;

        // Radio buttons
        this.radioButton1 = new OU.util.RadioButton({
            txt:"Radio1",
            layer: this.bgLayer,
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH,
            onClick: function() {
                console.log("Radio 1 Button HIT");
                self.render();
            }
        });
        this.radioButton1.state(true); // Switch on first button
        this.radioButton2 = new OU.util.RadioButton({
            txt:"Radio2",
            layer: this.bgLayer,
            x: bH*5.5,
            y: buttonY,
            w: bH * 3,
            h: bH,
            onClick: function() {
                console.log("Radio 2 Button HIT");
                self.render();
            }
        });
        this.radioButton3 = new OU.util.RadioButton({
            txt:"Radio3",
            layer: this.bgLayer,
            x: bH*9,
            y: buttonY,
            w: bH * 3,
            h: bH,
            onClick: function() {
                console.log("Radio 3 Button HIT");
                self.render();
            }
        });
        buttonY += bH * BUTTON_GAP;

        // Info button
        this.infoButton = new OU.util.InfoButton({
            txt:"Info",
            layer: this.bgLayer,
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH,
            onClick: function() {
                console.log("Info Button HIT");
                self.render();
            }
        });
        buttonY += bH * BUTTON_GAP;

        // Next button
        this.nextButton = new OU.util.NextButton({
            txt:"Next",
            layer: this.bgLayer,
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH,
            onClick: function() {
                console.log("Next Button HIT");
                self.render();
            }
        });
        buttonY += bH * BUTTON_GAP;

        // Previous button
        this.prevButton = new OU.util.PrevButton({
            txt:"Prev",
            layer: this.bgLayer,
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH,
            onClick: function() {
                console.log("Previous Button HIT");
                self.render();
            }
        });
        buttonY += bH * BUTTON_GAP;


    };

    /**
     * resize - called whenever the outer bounds of the activity change, ie when the browser window is resized, or a mobile device is rotated.
     *
     * This function should do the following:
     * <ul>
     * <li>Resize all visible elements</li>
     * <li>Re-layout all visible elements</li>
     * <li>Actually re-render the current view of the activity</li>
     * </ul>
     */
    OU.activity.ButtonTest.prototype.resize = function() {
        OU.activity.ButtonTest.superClass_.resize.call(this); // call the superclass resize

        this.bgLayer.resize();
        this.bgLayer.context.gradRect();
        var bH=OU.controlHeight,buttonY = bH;

        this.standardButton.resize({
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        buttonY += bH * BUTTON_GAP;

        this.controlButton.resize({
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        buttonY += bH * BUTTON_GAP;

        this.checkboxButton.resize({
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        buttonY += bH * BUTTON_GAP;

        this.radioButton1.resize({
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        this.radioButton2.resize({
            x: bH*5.5,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        this.radioButton3.resize({
            x: bH*9,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        buttonY += bH * BUTTON_GAP;

        this.infoButton.resize({
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        buttonY += bH * BUTTON_GAP;
        this.nextButton.resize({
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        buttonY += bH * BUTTON_GAP;
        this.prevButton.resize({
            x: bH*2,
            y: buttonY,
            w: bH * 3,
            h: bH
        });
        buttonY += bH * BUTTON_GAP;

        this.render();
    };
    OU.activity.ButtonTest.prototype.render = function() {
        this.standardButton.render();
        this.controlButton.render();
        this.checkboxButton.render();
        this.radioButton1.render();
        this.radioButton2.render();
        this.radioButton3.render();
        this.infoButton.render();
        this.nextButton.render();
        this.prevButton.render();
    };

    // call the superclass's constructor
    OU.base(this, data, instance, controller);
};
// Call our inherits function to implement the class inheritance
OU.inherits(OU.activity.ButtonTest, OU.util.Activity);
