/**
 * @fileOverview Static Timeline
 *
 * @author Martin Donnelly
 */
OU.require('OU.util.Button');
OU.require('OU.util.DynText');
OU.require('OU.util.Layer');
OU.require('OU.util.ImageLoader');
/**
 * @class
 * @extends OU.util.Activity
 */
OU.activity.StaticTimeline = function ( data, instance, controller ) {
    OU.activity.StaticTimeline.prototype.canvasView = function () {
        this.cb = 0;
        this.cbThickness = 0;
        this.c = 0;
        this.validWidth = 0;
        this.config = {
            imageLoadTimeout:60000, // 60 seconds
            fps:40
        };
        this.bgLayer = new OU.util.Layer({
            container:this
        });
        this.graphLayer = new OU.util.Layer({
            container:this
        });
        this.controlLayer = new OU.util.Layer({
            container:this,
            hasEvents:true
        });
        this.controlLayer.events.clickable.length = 0;
        this.initData();
    };
    //
    OU.activity.StaticTimeline.prototype.initData = function () {
        this.data.barH = this.h * .04;
        this.start();
    };
    //
    OU.activity.StaticTimeline.prototype.start = function () {
        var i;
        // designed to be broken in to 21 even vertical slots for laying out.
        this.c = this.h / 21;
        this.cb = this.c * 11;
        this.cbThickness = this.c;
        this.validWidth = this.w - (5 * this.c);
        this.renderBackdrop();
        for (i = 0; i < this.data.events.length; i++) {
            this.pinTime(this.data.events[i]);
        }
        // as a heads up the data should be in the following format:
        /*
         {
         pos:0,
         valign:true,
         text:'1.5 million years before present',
         align:false,
         btntext:'Islands formed',
         action:function (){
         alert('The islands were formed 1.5 million years before the present day');
         }
         }

         ------------

         pos: this is a percentage value 0..100 that determines how far along the timeline the event is displayed
         valign: true = above the bar, false = below the bar
         text: this is the text that will be displayed beside the time mark
         align:  true = the text appears to the left of the time mark, fale = the text appears to the right of the time mark
         btntxt: this is the text that will appear in the accomponing button
         action: this is the function that gets called when the button is clicked

         */
    };
    //
    OU.activity.StaticTimeline.prototype.resize = function () {
        OU.activity.StaticTimeline.superClass_.resize.call(this); // call the parent class resize 
        this.bgLayer.resize();
        this.graphLayer.resize();
        this.controlLayer.resize();
        this.start();
    };
    //
    OU.activity.StaticTimeline.prototype.pinTime = function ( settings ) {
        this.drawTriangle(settings.pos, settings.valign);
        this.drawText(settings);
        this.drawButton(settings);
    };
    //
    OU.activity.StaticTimeline.prototype.drawButton = function ( settings ) {
        var ctx = this.controlLayer.context,
            align = "left",
            ypos, xpos, clickAction = settings.action || function () {
            };
        ctx.save();
        if (settings.valign) {
            ypos = this.cb - (this.c * 8.5);
        }
        else {
            ypos = this.cb + (this.c * 3.5);
        }
        if (settings.align) {
            xpos = this.c + ((this.validWidth / 100) * settings.pos) - (200 - (this.c * 5));
            align = "right";
        }
        else {
            xpos = ((this.validWidth / 100) * settings.pos) - this.c;
        }
        new OU.util.ControlButton({
            "txt":settings.btntext ? settings.btntext : "",
            "x":xpos,
            "y":ypos,
            "w":200,
            "h":this.c * 4,
            layer:this.controlLayer,
            "align":align,
            onClick:clickAction
        });
    };
    //
    OU.activity.StaticTimeline.prototype.drawText = function ( settings ) {
        var ctx = this.graphLayer.context,
            align = "left", ypos, xpos;
        ctx.save();
        if (settings.valign) {
            ypos = this.cb - (this.c * 4);
        }
        else {
            ypos = this.cb + (this.c * 0.5);
        }
        if (settings.align) {
            xpos = this.c + ((this.validWidth / 100) * settings.pos) - (200 - (this.c * 2));
            align = "right";
        }
        else {
            xpos = this.c + ((this.validWidth / 100) * settings.pos) + this.c;
        }
        new OU.util.DynText({
            "txt":settings.text ? settings.text : "",
            "x":xpos,
            "y":ypos,
            "w":200,
            "h":this.c * 3,
            "context":ctx,
            "propTextHeight":0.6,
            "align":align
        });
    };
    //
    OU.activity.StaticTimeline.prototype.drawTriangle = function ( xPC, above ) {
        var ctx = this.graphLayer.context,
            xpos = this.c + ((this.validWidth / 100) * xPC),
            ypos = this.cb - (this.c * 4);
        ctx.save();
        ctx.fillStyle = '#101010';
        ctx.strokeStyle = '#101010';
        ctx.beginPath();
        if (above) {
            xpos = this.c + ((this.validWidth / 100) * xPC);
            ypos = this.cb - (this.c * 4);
            ctx.moveTo(xpos, ypos);
            ctx.lineTo(xpos + (this.c * 3), ypos);
            ctx.lineTo(xpos + (this.c * 1.5), ypos + (this.c * 3));
        }
        else {
            xpos = this.c + ((this.validWidth / 100) * xPC);
            ypos = this.cb + (this.c * 3);
            ctx.moveTo(xpos, ypos);
            ctx.lineTo(xpos + (this.c * 3), ypos);
            ctx.lineTo(xpos + (this.c * 1.5), ypos - (this.c * 3));
        }
        ctx.closePath();
        ctx.stroke();
        ctx.fill();
        ctx.restore();
    };
    //
    OU.activity.StaticTimeline.prototype.renderBackdrop = function () {
        var ctx = this.bgLayer.context;
        ctx.save();
        ctx.gradRect();
        ctx.fillStyle = '#101010';
        ctx.fillRect(0, this.cb - this.cbThickness, this.w, this.c);
        ctx.restore();
    };
    OU.activity.StaticTimeline.prototype.accessibleView = function () {
        var h = "<div id='timelineAccessible'>";
        if (this.data.title && this.data.title.length > 0) {
            h += "<h1>" + this.data.title + "</h1>";
            h += "<p>This is a timeline marking important dates relating to " + this.data.title + "</p>";
        }
        h += "<h2>Static Time Line:</h2>";
        h += this.accessibleEvents(this.data.events);
        h += "</div>";
        document.body.innerHTML = '';
        var accessible = document.createElement('div');
        accessible.innerHTML = h;
        document.body.appendChild(accessible);
    };
    OU.base(this, data, instance, controller);
};
OU.inherits(OU.activity.StaticTimeline, OU.util.Activity);
