/**
 * @fileoverview Ajax handler
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

/**
 * Ajax - Ajax handler class
 * 
 * Usage:
 *      a = new OU.util.Ajax({ server: "some.domain/", onSuccess: someFunction()});
 *      a.postRequest("UriPath",someJsonObject);
 * 
 * @class
 */
OU.util.Ajax = function ( params ) {
    
    this.server = params.server;
    this.onSuccess = params.onSuccess;
    
    OU.util.Ajax.prototype.postRequest = function(uri,json) {
        this._SendRequest('POST',this.server+uri,json);
    };
    OU.util.Ajax.prototype.getRequest = function(uri,json) {
        this._SendRequest('GET',this.server+uri,json);
    };
    
    /** @private */
    OU.util.Ajax.prototype._OnUninitialize = function() { };
    /** @private */
    OU.util.Ajax.prototype._OnLoading = function() { };
    /** @private */
    OU.util.Ajax.prototype._OnLoaded = function() { };
    /** @private */
    OU.util.Ajax.prototype._OnInteractive = function() { };
    /** @private */
    OU.util.Ajax.prototype._OnSuccess = function() {
        var jsonObj =  JSON.parse(this.http.responseText);
        if(this.onSuccess)
            this.onSuccess(jsonObj);
    };
    /** @private */
    OU.util.Ajax.prototype._OnFailure = function() {
    };
   
    /** @private */
    OU.util.Ajax.prototype._stateHandler = function() {
        console.log(this.http.readyState + " : "+ this.http.status);
        console.log("responseText:" + this.http.responseText);
        switch (this.http.readyState)
        {
            case 0:
                setTimeout("void(0)", 100);
                this._OnUninitialize();
                break;
                               
            case 1:
                setTimeout("void(0)", 100);
                this._OnLoading();
                break;
                               
            case 2:
                setTimeout("void(0)", 100);
                this._OnLoaded();
                break;
                       
            case 3:
                setTimeout("void(0)", 100);
                this._OnInteractive();
                break;
                               
            case 4:
                if (this.http.status === 200)
                    this._OnSuccess();
                else
                    this._OnFailure();
                                       
                return;
                break;
        }
    };
    /** @private */
    OU.util.Ajax.prototype._SendRequest = function(Method, Uri) {
        var self=this;
        this.http = this._InitRequest();
        if(this.http) {
            this.http.onreadystatechange = function() { 
                self._stateHandler();
            };
      
            switch (2)
            {
                case 2:
                    this.http.open(Method, Uri);
                    break;
                case 3:
                    this.http.open(Method, Uri, arguments[2]);
                    break;
                case 4:
                    this.http.open(Method, Uri, arguments[2], arguments[3]);
                    break;
            }
               
//            this.http.setRequestHeader("If-Modified-Since", "Sat, 1 Jan 2000 00:00:00 GMT");
            this.http.setRequestHeader("Content-Type", "application/x-www-form-urlencoded; charset=UTF-8");
            this.http.send(null);  
        }
    };
    /** @private */
    OU.util.Ajax.prototype._InitRequest = function() {
        var r;
        try {
            r = new XMLHttpRequest();
        }
        catch (error) {
            try {
                r = new ActiveXObject("Microsoft.XMLHTTP");
            }
            catch (error) {
                return false;
            }
        }
        return r;
    };
    
};