/**
 * @fileOverview Transitions - canvas transitions to provide
 *
 * @deprecated This is a clunky solution - Activities should implement their own transitions.
 *
 * Transition methods: slideLeft, slideRight, circles, fade
 *
 * each transistion receives a function as a parameter, which should render the new view
 *
 * @param {canvas} canvas to render to
 * @param {canvas.context} context Context to render to
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */
/**
 * @deprecated This is a clunky solution - Activities should implement their own transitions.
 * @class Transitions - A test case class that shouldn't really be used.
 */
OU.util.Transitions = function ( canvas, context ) {
    this.config = {
        fps:20 // 40ms = 25 fps
    };
    this.xOffset = 0;
    this.yOffset = 0;
    this.slideSpeed = 2;
    this.fadeSpeed = 3;
    this.display = null; // {function} to call to render the display
    this.canvas = canvas;
    this.context = context;
    // Slide Left - from off right of canvas
    OU.util.Transitions.prototype.slideLeft = function ( display ) {
        this.xOffset = this.canvas.width;
        this.yOffset = 0;
        this.display = display;
        this._slideToTarget();
    };
    //Slide Right - from off left of canvas
    OU.util.Transitions.prototype.slideRight = function ( display ) {
        this.xOffset = 0 - this.canvas.width;
        this.yOffset = 0;
        this.display = display;
        this._slideToTarget();
    };
    // Circles - grow circles to solid colour and then reduce circles to new display
    OU.util.Transitions.prototype.circles = function ( display, colour ) {
        this.display = display;
        if (colour===undefined) {
            var r = Math.floor(Math.random() * 256);
            var g = Math.floor(Math.random() * 256);
            var b = Math.floor(Math.random() * 256);
            this.colour = 'rgba(' + r + ',' + g + ',' + b + ',1)';
        }
        else
            this.colour = colour;
        this.xOffset = 100;
        this.yOffset = 75;
        this.radius = 0;
        this.fadeBack = this._reducingCircles;
        this._growingCircles();
    };
    // Fade - fade to solid colour and then back to new display
    OU.util.Transitions.prototype.fade = function ( display, rgb ) {
        if (rgb===undefined)
            rgb = '255,255,255';
        if (this.yOffset!=0)
            return;
        this.display = display;
        this.rgb = rgb;
        this.xOffset = 5; // number of frames per fade
        this.yOffset = 0; // current fade value
        this.fadeBack = this._fadeIn;
        this.transLayer = new OU.util.Layer();
        this._fadeOut();
    };
    OU.util.Transitions.prototype._slideToTarget = function ( display, canvas ) {
        var self = this;
        if (Math.abs(this.xOffset) < 1 && Math.abs(this.yOffset) < 1) { // we've reached target, so finish animation
            this.xOffset = 0;
            this.yOffset = 0;
            this.display(this.xOffset, this.yOffset);
            return;
        }
        this.display(this.xOffset, this.yOffset);
        this.xOffset -= (this.xOffset) / this.slideSpeed;
        this.yOffset -= (this.yOffset) / this.slideSpeed;
        setTimeout(function () {
            self.slideToTarget()
        }, this.config.fps);
    };
    OU.util.Transitions.prototype._reducingCircles = function () {
        var self = this, i, j;
        this.display(0, 0);
        if (this.yOffset < 1) {
            this.yOffset = 0;
            return;
        }
        this.context.fillStyle = this.colour;
        for (i = 0; i < this.canvas.width + this.xOffset; i += this.xOffset) {
            for (j = 0; j < this.canvas.height + this.xOffset; j += this.xOffset) {
                this.context.beginPath();
                this.context.arc(i, j, this.yOffset, 0, Math.PI * 2, false);
                this.context.closePath();
                this.context.fill();
            }
        }
        this.yOffset -= this.yOffset / this.fadeSpeed;
        setTimeout(function () {
            self._reducingCircles()
        }, this.config.fps);
    };
    OU.util.Transitions.prototype._growingCircles = function () {
        var self = this, i, j;
        if (this.radius > this.yOffset - 1) {
            this.fadeBack();
            return;
        }
        this.context.fillStyle = this.colour;
        for (i = 0; i < this.canvas.width + this.xOffset; i += this.xOffset) {
            for (j = 0; j < this.canvas.height + this.xOffset; j += this.xOffset) {
                this.context.beginPath();
                this.context.arc(i, j, this.radius, 0, Math.PI * 2, false);
                this.context.closePath();
                this.context.fill();
            }
        }
        this.radius += (this.yOffset - this.radius) / this.fadeSpeed;
        setTimeout(function () {
            self._growingCircles()
        }, this.config.fps);
    };
    OU.util.Transitions.prototype._fadeIn = function () {
        var self = this, alpha, ctx = this.transLayer.context;
        if (this.yOffset < 1) {
            this.yOffset = 0;
            if (this.transLayer)
                this.transLayer.remove();
            return;
        }
        alpha = this.yOffset / this.xOffset;
        ctx.fillStyle = 'rgba(' + this.rgb + ',' + alpha + ')';
        ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.yOffset--;
        setTimeout(function () {
            self._fadeIn()
        }, this.config.fps);
    };
    OU.util.Transitions.prototype._fadeOut = function () {
        var self = this, alpha, ctx = this.transLayer.context;
        if (this.yOffset > this.xOffset - 1) {
            this.display();
            this.fadeBack();
            return;
        }
        alpha = this.yOffset / this.xOffset;
        ctx.fillStyle = 'rgba(' + this.rgb + ',' + alpha + ')';
        ctx.fillRect(0, 0, this.canvas.width, this.canvas.height);
        this.yOffset++;
        setTimeout(function () {
            self._fadeOut()
        }, this.config.fps);
    };
};