/**
 * @fileOverview ThumbControls - gamepad stylie controls
 *
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */
OU.require('OU.util.Button');
OU.require('OU.util.Layer');
/**
 * @class Gamepad style controls - never used (so far!).
 * Not completed yet
 * //TODO handle left button events, etc.
 * 
 * @param {object} params - options:
 * <ul>
 * <li><strong>{object} container:</strong> (required) The calling object, typically an OU.util.Acitivity </li>
 * <li><strong>{canvas.context} context:</strong> (required) Context of the canvas/layer to render to</li>
 * <li><strong>{boolean} leftOn:</strong> Display the left controls, (default: true)</li>
 * <li><strong>{boolean} rightOn:</strong> Display the right controls (default: true)</li>
 * <li><strong>{function} stickCallback:</strong> Function to call when stick moves position</li>
 * <li><strong>{string} stickLabel:</strong> Label to display next to the joystick</li>
 * </ul>
 */
OU.util.ThumbControls = function( params ) {
    this.container = params.container;
    this.context = params.context;
    this.leftOn=params.leftOn===undefined?true:params.leftOn;
    this.rightOn=params.rightOn===undefined?true:params.rightOn;
    this.stickCallback = params.stickCallback || function() {};
    this.stickLabel=params.stickLabel;
    OU.addRemovable(this,this.container.zOffset);

    /**
     * @private
     */
    OU.util.ThumbControls.prototype.init = function() {
        var c=this.container;
        if(this.leftOn) {
            this.leftLayer = new OU.util.Layer({
                container: c,
                y: c.h-120,
                w: 120,
                h: 120,
                hasEvents: true
            });
            this.stick=new this.stick({
                controller: this,
                context: this.leftLayer.context
            });
            this.leftLayer.events.clickable.push(this.stick);
        }
        if(this.rightOn) {
            this.rightLayer = new OU.util.Layer({
                container: c,
                x: c.w-120,
                y: c.h-120,
                w: 120,
                h: 120,
                hasEvents: true
            });
        }
        this.render();
    };
    /**
     * Render the controls
     * @private
     */
    OU.util.ThumbControls.prototype.render = function() {
        var ctx,circ=Math.PI*2,self=this;
        if(this.leftOn) {
            ctx = this.leftLayer.context;
            ctx.save();
            ctx.beginPath();
            ctx.lineWidth=2;
            ctx.arc(40,82,80,0,circ,false);
            ctx.strokeStyle='#777';
            ctx.fillStyle='#fff';
            ctx.fill();
            ctx.stroke();
            ctx.restore();
            ctx.fillStyle='#fff';
            ctx.fillRect(0,80,120,40);
            this.stick.render();
            if(this.stickLabel!==undefined) {
                ctx.textAlign="center";
                ctx.fillText(this.stickLabel,50,110);
            }
        }
        if(this.rightOn) {
            ctx = this.rightLayer.context;
            ctx.save();
            ctx.beginPath();
            ctx.lineWidth=2;
            ctx.arc(80,82,80,0,circ,false);
            ctx.strokeStyle='#777';
            ctx.fillStyle='#fff';
            ctx.fill();
            ctx.stroke();
            ctx.restore();
            ctx.fillStyle='#fff';
            ctx.fillRect(0,80,120,40);

            this.dPadU =  new OU.util.ControlButton({
                txt:'Select',
                x:30,
                y:15,
                w:90,
                h:30,
                layer:this.rightLayer,
                onClick: function() {
                    self.dPadActionU();
                }
            });

            this.dPadL =  new OU.util.ControlButton({
                txt:'Select',
                x:5,
                y:49,
                w:60,
                h:30,
                layer:this.rightLayer,
                onClick: function() {
                    self.dPadActionL();
                }
            });
            this.dPadR =  new OU.util.ControlButton({
                txt:'Select',
                x:60,
                y:49,
                w:60,
                h:30,
                layer:this.rightLayer,
                onClick: function() {
                    self.dPadActionL();
                }
            });
            this.dPadD =  new OU.util.ControlButton({
                txt:'Select',
                x:20,
                y:84,
                w:90,
                h:30,
                layer:this.rightLayer,
                onClick: function() {
                    self.dPadActionL();
                }
            });
        }
    };

    /**
     * @class Stick - Joystick control
     * @private
     */
    OU.util.ThumbControls.prototype.stick = function(p) {
        var circ=Math.PI*2,g;
        this.params=p;
        this.controller = p.controller;
        this.position = {
            x:0,
            y:0
        };
        OU.util.ThumbControls.prototype.stick.prototype.render = function() {
            var ctx=this.params.context,
            x=this.position.x,y=this.position.y;
            ctx.beginPath();
            ctx.arc(50,60,40,0,circ,false);
            g = ctx.createRadialGradient(50+x/2,60+y/2,0,50,60,40);
            g.addColorStop(0,'#000');
            g.addColorStop(0.5,'#999');
            g.addColorStop(0.85,'#444');
            g.addColorStop(1,'#fff');
            ctx.fillStyle=g;
            ctx.fill();
            ctx.beginPath();
            ctx.arc(51+x,61+y,30,0,circ,false);
            g = ctx.createRadialGradient(36+x,46+y,0,51+x,61+y,30);
            g.addColorStop(0,'#444');
            g.addColorStop(0.4,'#666');
            g.addColorStop(0.85,'#ccc');
            g.addColorStop(1,'#000');
            ctx.fillStyle=g;
            ctx.fill();
            ctx.gripPattern({
                col:'#ccc',
                x: 40+x,
                y:50+y,
                w:20,
                h:20
            });
        };
        OU.util.ThumbControls.prototype.stick.prototype.isHit = function(x,y,pressed) {
            var newX = x-51,newY=y-61;
            newX=newX<-15?-15:(newX>15?15:newX);
            newY=newY<-15?-15:(newY>15?15:newY);

            if(pressed) {
                this.position = {
                    x: newX,
                    y: newY
                }
            }
            else {
                this.position ={
                    x:0,
                    y:0
                };
            }
            this.controller.render();
        };
        OU.util.ThumbControls.prototype.stick.prototype.cycle = function() {
            var self=this;
            if(this.position.x!=0 || this.position.y!=0) {
                this.controller.stickCallback({
                    x: this.position.x/15,
                    y: this.position.y/15
                });
            }
            setTimeout(function() {
                self.cycle();
            },40);
        };
        this.cycle();
    };
    /**
     * Resizes the controls
     */
    OU.util.ThumbControls.prototype.resize = function() {
        var c=this.container;
        if(this.leftOn) {
            this.leftLayer.resize({
                x:0,
                y: c.h-120,
                w: 120,
                h: 120
            });
        }
        if(this.rightOn) {
            this.rightLayer.resize({
                x: c.w-120,
                y: c.h-120,
                w: 120,
                h: 120
            });
        }
        this.render();
    };
    this.init();
};
