/**
 * @fileoverview JsonP (JSON with padding) handler - used for cross domain server calls or calls to server from remote apps
 * @author Nigel Clarke <nigel.clarke@pentahedra.com>
 */

/**
 * @class JsonP - JsonP (JSON with padding) handler class.
 *
 * Requires a corresponding Web Service that supports JsonP and is also set up to call OU.jsonpCallback.
 * Google JsonP for further information about this model architecture.
 *
 * WARNING!!
 * Be careful how you use this, as it allows the responding server to insert javascript into the page/DOM.
 * So only use it to call servers that you control.
 *
 * @usage:
 *      OU.util.JsonP({
 *          data: "someGETFormattedData",
 *          uri: "some.domain/somepath.php",
 *          onSuccess: someCallbackFunction
 *      });
 *
 * @param {object} params - options:
 * <ul>
 * <li><strong>{string} uri:</strong> (required) URI of the web service to call</li>
 * <li><strong>{function} onSuccess :</strong> (required) function to call when data is returned</li>
 * <li><strong>{URL encoded parameter string} data:</strong> data to pass in the web service call</li>
 * <li><strong>{} :</strong> </li>
 * </ul>
 *
 * @returns a JsonObject to the callback function from the web service
 *
 * Expects the server to return a JS function call of the type:
 *
 *      OU.jsonpCallback(<id>,<json object>);
 *
 */
OU.util.JsonP = function ( params ) {
    var inc,newId,data = params.data || '';
    if(!OU._JsonPCallbackArray)
        OU._JsonPCallbackArray=[];
    newId=OU._JsonPCallbackArray.length;
    OU._JsonPCallbackArray[newId] = params.onSuccess;

    data = encodeURI(data);
    inc = document.createElement('script');
    inc.src = params.uri+"?callbackId="+newId+"&"+data;
    inc.id = "jsonp"+newId
    inc.type = 'text/javascript';
    OU.head.appendChild(inc);
    setTimeout(function() { // if not already complete then remove after 5 seconds
        OU._cleanupJsonP(newId);
    },5000);
};
/**
 * Function called by the returning script from the web service.
 * Passes the returning data object to the corresponding function
 * @private - you do not call this directly
 */
OU.jsonpCallback = function(id,obj) {
    if(OU._JsonPCallbackArray[id]) // else already been cleaned - response too slow
        OU._JsonPCallbackArray[id](obj);
    OU._cleanupJsonP(id);
};
/** @private */
OU._cleanupJsonP = function(id) {
    var n = document.getElementById("jsonp"+id);
    if(n) {
        setTimeout(function() {
            try {
                OU.head.removeChild(n); // remove the script from the head, use delay as removing a script that is still running may fail
            } catch(err) {
            }
        },1);
    }
    OU._JsonPCallbackArray[id]=undefined; // clear the array entry to purge memory
};
