/**
 * Messagebox - Messagebox with ok/cancel functions
 *
 * this.confirm("Question html?",function(){yesFunction();});
 *
 * @author Will Rawes
 */

OU.require('OU.util.Layer');
OU.require('OU.util.Div');
/**
 * @class
 */
OU.util.Messagebox = function ( params ) {
    var self = this;
    if (params===undefined)params = {};
    this.container = params.container || {};
    this.zIndexStart = params.zIndex || OU.POP_UP_LEVEL;
    this.zOffset = this.container.zOffset || 0;
    this.zIndexStart = this.zIndexStart + this.zOffset + 10;
    if (this.container.controller!==undefined && this.container.controller.activities!==undefined && this.container.controller.activities[this.container.instance]!==undefined && this.container.controller.activities[this.container.instance]._zOffset!==undefined) {
        this.zOffset = this.container.controller.activities[this.container.instance]._zOffset;
        this.zIndexStart = this.zIndexStart + this.zOffset;
    }
    else {
        this.zOffset = this.zIndexStart;
    }
    this.params = params;
    this.dims = params.dims ||
    {x:0.1, y:0.1, w:.4, h:.4};
    this.style = params.style || '';
    this.addStyle = '';
    if (params.overflow!==undefined)
        this.addStyle = 'overflow:' + params.overflow + '; ';
    OU.util.Messagebox.prototype.init = function ( params ) {
        this.isWeb = 0;
        if (params===undefined)params = {dims:{}};
        var x = params.dims.x || 0,
            y = params.dims.y || 0,
            w = params.dims.w * 1. || 480,
            h = params.dims.h || 360;
        this._x = x;
        this._y = y;
        this._w = w;
        this._h = h;
        if (params.dontRegister===undefined || params.dontRegister===false) {
                OU.addRemovable(this, this.zOffset);
        }
        this.layer = new OU.util.Layer({
            container:this.container,
            hasEvents:true,
            zIndex:this.zIndexStart
        });
        this.div = new OU.util.Div({
            container:this.container,
            zIndex:this.zIndexStart,
            style:'padding:12px;overflow:visible;'
        });
        this.div.div.innerHTML = (params.html || "");
        //this.div.div.tabIndex=1;
        this.yes = this.newButton("Yes", null, function () {
            self.fn();
            self.setVisible(false);
        });
        this.no = this.newButton("No", null, function () {
            self.setVisible(false);
        });
        this.setVisible(false);
    };
    OU.util.Messagebox.prototype.confirm = function ( html, fn ) {
        this.div.div.innerHTML = html;
        this.setVisible(true);
        this.fn = fn;
    };
    OU.util.Messagebox.prototype.render = function () {
    };
    OU.util.Messagebox.prototype.newButton = function ( txt, i, fn ) {
        var btn;
        if (txt.indexOf('_ <sup>_') > 0) {
            btn = {
                render:function () {
                },
                resize:function () {
                },
                setTxt:function () {
                }
            };
        }
        else {
            var ctx, tfn = fn || function () {
            };
            if (this.isWeb) {
                ctx = this.div.div;
                btn = document.createElement("a");
                btn.th = [this, i];
                btn.onclick = function () {
                    tfn(this.th);
                };
                btn.href = "javascript:;";
                btn.setAttribute("style", "position:absolute;top:10px;left:20px; font-size:90%;text-align:center;background:#efefef;border:solid 1px;border-radius:3px;text-decoration:none;");
                btn.style.zIndex = this.zIndexStart + 10;
                btn.render = function () {
                };
                btn.resize = function ( dims ) {
                    this.style.left = "" + ((parseInt(self.layer.canvas.style.left) + dims.x) | 0) + "px";
                    this.style.top = "" + ((parseInt(self.layer.canvas.style.top) + dims.y) | 0) + "px";
                    this.style.height = "" + ((dims.h * 0.7) | 0) + "px";
                    this.style.width = "" + ((dims.w * 0.7) | 0) + "px";
                    this.style.fontSize = "" + ((dims.h / 2.3) | 0) + "px";
                };
                ctx.appendChild(btn);
                btn.style.padding = "0px";
                btn.style.paddingTop = "0.5%";
            }
            else {
                btn = new OU.util.Button({
                    txt:txt,
                    layer:this.layer,
                    background:{
                        col:'#dddddd',
                        radius:2,
                        borderCol:'#999999'
                    },
                    onClick:fn,
                    onClickParam:[this, i]
                });
                btn.th = [this, i];
                btn.params.onClick = function () {
                    fn(this.th);
                };
            }
            btn.setTxt = function ( t ) {
                if (this.params) {
                    this.params.txt = t;
                    this.render();
                } else if (this.th)this.innerHTML = t;
            };
            btn.setTxt(txt);
        }
        return btn;
    };
    OU.util.Messagebox.prototype.setVisible = function ( v, html ) {
        this.visible = v;
        var disp = (v ? "block" : "none");
        if (v) {
            if (html!==undefined) {
                this.html = html;
                this.div.div.innerHTML = html;
            }
        }
        this.layer.canvas.style.display = disp;
        this.div.div.style.display = disp;
        this.resize();
    };
    OU.util.Messagebox.prototype.resize = function ( p ) {
        if (!this.visible)return;
        var w = window.innerWidth,
            h = window.innerHeight,
            x = w * this._x,
            y = h * this._y
            ;
        w *= this._w;
        h *= this._h;
        this.div.resize({x:x, y:y, w:w, h:0.01});
        this.layer.resize({x:x, y:y, w:w, h:h});
        this.yes.resize({
            x:w * 0.1,
            y:h - 50,
            w:w * 0.35
        });
        this.yes.render();
        this.no.resize({
            x:w * 0.6,
            y:h - 50,
            w:w * 0.35
        });
        this.no.render();
        this.layer.canvas.style.background = '#fcfcfc';
        this.layer.canvas.style.border = 'solid 1px #999';
        this.layer.canvas.style.borderRadius = '8px';
    };
    OU.util.Messagebox.prototype.remove = function () {
        if (this.div.parentNode)
            this.div.parentNode.removeChild(this.div);
    };
    this.init(params);
};
