if (typeof window.console == 'undefined') {
    window.console = {
        log: function() {}
    };
}

if (!Array.prototype.indexOf) {
    Array.prototype.indexOf = function(obj, start) {
        for (var i = (start || 0), j = this.length; i < j; i++) {
            if (this[i] === obj) { return i; }
        }
        return -1;
    };
}

if (!Array.prototype.compact) {
    Array.prototype.compact = function() {
        return this.filter(function(x) {
            return x !== null && x !== undefined;
        });
    };
}

var utils = {
    colours: [
        ['#9ecfe9', '#d1e7f4'],
        ['#c2ce8d', '#d1e2cf'],
        ['#d49fb8', '#e9cfdc'],
        ['#bfc0de', '#d9d9eb'],
        ['#f5cd9f', '#fbe6cf'],
        ['#b3dddc', '#dceeee'],
        ['#f7cadd', '#fadde9'],
        ['#f2af9e', '#f9d8ce']
    ],

    saveDataToVLE: function(params) {
        var userorgroup = params.user || true;
        var ok = params.success || function() {
                console.log('set_server_data was successful');
            };
        var error = params.fail || function(msg) {
                console.log('set_server_data has failed');
                if (msg !== null) {
                    console.log(msg);
                }
            };
        var previousValues = params.previous;
        var retry = params.retry || null;
        var activityId = VLE.get_param('activityId') || VLE.get_param('_a');
        var itemId = VLE.get_param('documentId') || VLE.get_param('_i');
        var courseId = VLE.get_param('courseId') || VLE.get_param('_c');

        console.log(params.values);

        VLE.set_server_data(userorgroup, params.values, ok, error, previousValues, retry, activityId, itemId, courseId);

    },

    retrieveDataFromVLE: function(params) {
        var userorgroup = params.user || true;
        var ok = params.success || function() {
                console.log('set_server_data was successful');
            };
        var error = params.fail || function(msg) {
                console.log('Failed to get server data.');

                if (msg !== null) {
                    console.log(msg);
                }
            };
        var activityId = VLE.get_param('activityId') || VLE.get_param('_a');
        var itemId = VLE.get_param('documentId') || VLE.get_param('_i');
        var courseId = VLE.get_param('courseId') || VLE.get_param('_c');

        console.log(params.names);

        VLE.get_server_data(userorgroup, params.names, ok, error, activityId, itemId, courseId);

    },

    getObjKeys: function(obj) {
        var names = [];

        for (var k in obj) {
            if (obj.hasOwnProperty(k)) {
                names.push(k);
            }
        }

        return names;
    },

    getResetObj: function(obj) {
        var values = {};

        for (var k in obj) {
            if (obj.hasOwnProperty(k)) {
                values[k] = '';
            }
        }

        return values;
    },

    detectProtocol: (function() {
        var protocol = location.protocol;
        var el = document.getElementById('container');
        if (protocol !== "http:" && protocol !== "https:") {
            if (el) {
                el.className = 'not-http';
            }
        }
    })(),

    getOffsetSum: function(elem) {
        var top = 0, left = 0;

        while(elem) {
            top = top + parseInt(elem.offsetTop);
            left = left + parseInt(elem.offsetLeft);
            elem = elem.offsetParent;
        }

        return {top: top, left: left};
    },

    getOffset: function(e) {
        var target = e.target || e.srcElement,
            style = target.currentStyle || window.getComputedStyle(target, null),
            borderLeftWidth = parseInt(style.borderLeftWidth, 10),
            borderTopWidth = parseInt(style.borderTopWidth, 10),
            rect = target.getBoundingClientRect(),
            offsetX = e.clientX - borderLeftWidth - rect.left,
            offsetY = e.clientY - borderTopWidth - rect.top;

        return {
            x: offsetX,
            y: offsetY
        };
    },

    preloadImages: function(imageSrcArray, firstLoaded, lastLoaded) {
        data.images = [];
        for (var i = 0; i < imageSrcArray.length; i++) {
            data.images[i] = new Image();
            data.images[i].src = imageSrcArray[i];

            if (i === 0) {
                data.images[i].onload = function () {
                    console.log('first image loaded!');
                    if (firstLoaded) {
                        firstLoaded();
                    }
                };
            }
            else if (i === imageSrcArray.length - 1) {
                data.images[i].onload = function () {
                    console.log('last image loaded!');
                    if (lastLoaded) {
                        lastLoaded();
                    }
                };

            }
        }
    },

    /**
     * @param selector {(string|object)} CSS selector, DOM element or jQuery object
     * @param degree {(number|string)} degrees to rotate element
     */
    rotate: function(selector, degree) {
        $(selector).css({
            '-ms-transform': 'rotate(' + degree + 'deg)',
            //'-ms-transform-origin': '50% 50%',
            '-webkit-transform': 'rotate(' + degree + 'deg)',
            //'-webkit-transform-origin': '50% 50%',
            'transform': 'rotate(' + degree + 'deg)'
            //'transform-origin': '50% 50%'
        });
    },

    /**
     * @param selector {(string|object)} CSS selector, DOM element or jQuery object
     * @param moveId {boolean} if true moves id to a then removes original element
     */
    makeSVGelementTabbable: function(selector, moveId) {
        var a = document.createElementNS('http://www.w3.org/2000/svg', 'a');
        var $el = $(selector);

        a.setAttributeNS('http://www.w3.org/1999/xlink', 'xlink:href', 'javascript:void(0);');

        if (moveId) {
            var id = $el.attr('id');

            a.setAttribute('id', id);
            $el.removeAttr('id').wrapInner(a);

            return $('#' + id).unwrap();
        }
        else {
            return $el.wrap(a);
        }
    },

    isCanvasSupported: function(){
        var elem = document.createElement('canvas');
        return !!(elem.getContext && elem.getContext('2d'));
    },

    isSVGsupported: function() {
        return document.implementation.hasFeature("http://www.w3.org/TR/SVG11/feature#BasicStructure", "1.1");
    },

    showUnsupportedMsg: function(msg) {
        msg = msg || 'Your browser does not support certain technologies used in this activity. To view the activity, please reopen it in a modern browser (e.g. IE9+, Chrome or Firefox).';

        document.getElementsByTagName('body')[0].innerHTML = msg;
    },

    capFirstLetter: function(string) {
        return string.charAt(0).toUpperCase() + string.slice(1);
    },

    inWords: function(num) {
        var a = ['','one ','two ','three ','four ', 'five ','six ','seven ','eight ','nine ','ten ','eleven ','twelve ','thirteen ','fourteen ','fifteen ','sixteen ','seventeen ','eighteen ','nineteen '];
        var b = ['', '', 'twenty','thirty','forty','fifty', 'sixty','seventy','eighty','ninety'];
        var c = ['thousand', 'million', ''];
        var words = '';

        num = num.toString();

        if (num.length > 9) {
            return ''; // Number is larger than what function can deal with
        }

        //num = ('000000000' + num).substr(-9); // Make number into a predictable nine character string
        num = ('000000000' + num).slice(-9); // Make number into a predictable nine character string
        num = num.match(/.{3}/g); // Split string into chunks of three numbers then reverse order of returned array

        for(var i = 0; i < c.length; i++) {
            var n = num[i];
            var str = '';

            str += (words !== '') ? ' ' + c[i] + ' ' : '';
            str += (parseInt(n[0]) !== 0) ? (a[Number(n[0])] + 'hundred ') : '';
            n = n.substr(1);
            str += (parseInt(n) !== 0) ? (( str !== '' ) ? 'and ' : '') + (a[Number( n )] || b[n[0]] + ' ' + a[n[1]]) : '';
            words += str;
        }

        return words;
    }
};


//jQuery plugins
if (typeof(jQuery) != 'undefined') {
    $.fn.preloadImages = function() {
        for (var i = 0; i < arguments.length; i++) {
            $("<img />").attr("src", arguments[i]);
        }
    };

    $.fn.shuffle = function(childElem) {
        return this.each(function() {
            var $this = $(this);
            var elems = $this.children(childElem);

            elems.sort(function() {
                return (Math.round(Math.random()) - 0.5);
            });

            $this.remove(childElem);

            for (var i = 0; i < elems.length; i++) {
                $this.append(elems[i]);
            }
        });
    };

    $.fn.reverse = [].reverse;

}