var mindMap = function(id, data) {
    var container = document.getElementById(id) || document.getElementsByTagName('body')[0];
    var mindMap;
    var menu;
    var buttons = {
        create: {
            el: null,
            show: true,
            disable: false,
            value: 'Create'
        },
        update: {
            el: null,
            show: true,
            disable: false,
            value: 'Update'
        },
        delete: {
            el: null,
            show: true,
            disable: false,
            value: 'Delete'
        },
        deleteAll: {
            el: null,
            show: true,
            disable: false,
            value: 'Delete All'
        },
        save: {
            el: null,
            show: true,
            disable: false,
            value: 'Save'
        }
    };
    var input;
    var mapArea;
    var nodeArea;
    var lineArea;
    var nodes = [];
    var userData;
    var saver = new Saver();
    var cfg = {
        width: 720,
        height: 660,
        menuWidth: 150,
        nodeWidth: 100,
        nodeHeight: 100,
        backgroundImage: false,
        lines: false,
        resizable: false,
        keyboardMsg: false,
        centre: {
            text: 'Placeholder text',
            width: 200,
            height: 100,
            color: 'inherit',
            backgroundColor: '#d1e7f4',
            borderColor: '#9ecfe9'
        }
    };
    var selected = null;
    var debug = false;
    var keys = {};

    var load = function() {
        saver.retrieve({
            names: utils.getObjKeys(getUserSaveObj()),
            callback: function(data) {
                if (data.nodes !== '') {
                    userData = JSON.parse(data.nodes);
                }

                init();
            }
        });
    };

    var init = function() {
        mindMap = document.createElement('div');
        mindMap.className = 'mind-map';
        container.appendChild(mindMap);
        mindMap.appendChild(createInstructionsMsg());

        setCfg();
        initMenu();
        initMapArea();
        setEventHandlers();

        if (debug === true) {
            initDebugging();
        }

        if (typeof userData != 'undefined') {
            loadData();
        }

        container.style.visibility = 'visible';
        document.getElementById('loading-msg').style.display = 'none';

        input.focus();
    };

    var initDebugging = function() {
        input.value = 'Debug';
        createNode();
    };

    var setCfg = function() {
        for (var p in data) {
            if (data.hasOwnProperty(p)) {
                if (Object.prototype.toString.call(data[p]) === Object.prototype.toString.call({})) {
                    for (var prop in data[p]) {
                        if (data[p].hasOwnProperty(prop)) {
                            cfg[p][prop] = data[p][prop];
                        }
                    }
                }
                else {
                    cfg[p] = data[p];
                }
            }
        }
    };

    var initMenu = function() {
        menu = document.createElement('div');
        menu.className = 'mind-map-menu';
        menu.style.width = cfg.menuWidth + 'px';

        input = document.createElement('textarea');
        input.style.minHeight = cfg.menuWidth + 'px';
        menu.appendChild(input);
        menu.appendChild(createButtons(buttons));
        menu.appendChild(createKeyboardMsg());
        menu.appendChild(createKeyboardTip());
        mindMap.appendChild(menu);

    };

    var createKeyboardMsg = function() {
        var div = document.createElement('div');

        div.className = 'notice';
        div.innerHTML = cfg.keyboardMsg || '<b>Keyboard access</b>:<br/> Use <b>Tab</b> key to select node; WASD keys to move [<b>WASD</b> keys = W = up, A = left, S = down, D = right]; <b>Shift+WASD</b> to resize; <br/><b>E</b> key to edit.';

        return div;
    };
    var createKeyboardTip = function() {
        var div = document.createElement('div');

        div.className = 'tip';
        div.innerHTML = cfg.keyboardMsg || '<b>Tip</b>: holding down keys while moving/resizing will speed up the action.';

        return div;
    };

    var createInstructionsMsg = function() {
        var div = document.createElement('div');

        div.className = 'instructions';
        div.innerHTML = cfg.keyboardMsg || 'You will now create your own personal support-network diagram. Click into the box on the left and type your note, then use the buttons to create/modify your note. Either drag the note into position on the diagram, or use the keyboard instructions at bottom left to use the keyboard. <br/>Remember to click the ‘<b>Save</b>’ button before leaving the page to save your added notes.';

        return div;
    };

    var initMapArea = function() {
        var centre, centreText, borderRadius;

        mapArea = document.createElement('div');
        mapArea.className = 'mind-map-area';
        mapArea.style.width = cfg.width + 'px';
        mapArea.style.height = cfg.height + 'px';
        mapArea.style.marginLeft = cfg.menuWidth + 10 + 'px';

        nodeArea = document.createElement('div');
        nodeArea.className = 'node-area';
        nodeArea.tabIndex = 0;
        mapArea.appendChild(nodeArea);

        if (cfg.centre) {
            centre = document.createElement('div');
            centreText = document.createElement('div');
            borderRadius = cfg.centre.width + 'px / ' + cfg.centre.width / 2 + 'px';

            centre.className = 'mind-map-centre';
            centre.style.position = 'absolute';
            centre.style.width = cfg.centre.width + 'px';
            centre.style.height = cfg.centre.height + 'px';
            centre.style.left = cfg.width / 2 - cfg.centre.width / 2 + 'px';
            centre.style.top = cfg.height / 2 - cfg.centre.height / 2 + 'px';
            centre.style.webkitBorderRadius = borderRadius;
            centre.style.mozBorderRadius = borderRadius;
            centre.style.borderRadius = borderRadius;
            centre.style.color = cfg.centre.color;
            centre.style.borderColor = cfg.centre.borderColor;
            centre.style.backgroundColor = cfg.centre.backgroundColor;
            centreText.innerHTML = cfg.centre.text;
            centre.appendChild(centreText);
            nodeArea.appendChild(centre);
        }

        if (cfg.backgroundImage) {
            nodeArea.style.background = 'url("' + cfg.backgroundImage + '") no-repeat center center';
        }

        if (cfg.lines) {
            lineArea = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
            lineArea.className = 'line-area';
            mapArea.appendChild(lineArea);
        }

        mindMap.appendChild(mapArea);
    };

    var createButtons = function(obj) {
        var btnGroup = document.createElement('div');
        var btn, p, c, i;

        btnGroup.className = 'btn-group';

        for (p in obj) {
            if (obj.hasOwnProperty(p)) {
                btn = document.createElement('button');
                c = p;

                for (i = 0; i < p.length; i++) {
                    if (/[A-Z]/.test(p.charAt(i))) {
                        c = p.replace(p.charAt(i), '-' + p.charAt(i).toLowerCase());
                    }
                }

                btn.setAttribute('type', 'button');
                btn.className = 'btn-' + c;
                btn.innerHTML = obj[p].value;

                if (!obj[p].show) {
                    btn.style.display = 'none';
                }

                if (obj[p].disable) {
                    btn.disabled = true;
                }

                obj[p].el = btn;
                btnGroup.appendChild(btn);
            }
        }

        return btnGroup;
    };

    var setEventHandlers = function() {
        $(window).on('keyup', function(e) {
            if ([87, 65, 83, 68].indexOf(e.which) > -1) {
                keys[e.which] = 0;
            }
        });

        $(nodeArea)
            .on('mousedown', unSelectNode)
            .on('mousedown keyup', '.mind-map-node', selectNode)
            .on('keydown', '.mind-map-node', handleKeyEvents);

        $(menu)
            .on('click', '.btn-create', createNode)
            .on('click', '.btn-update', updateNode)
            .on('click', '.btn-delete', deleteNode)
            .on('click', '.btn-delete-all', deleteAllNodes)
            .on('click', '.btn-save', saveUserData);
    };

    var loadData = function() {
        for (var i = 0; i < userData.length; i++) {
            createNode(null, userData[i]);
        }
    };

    var createNode = function(e, data) {
        var node = document.createElement('div');
        var nodeText = document.createElement('div');
        var line;

        if (!data && input.value === '') {
            return;
        }

        node.className = 'mind-map-node';
        node.tabIndex = 0;

        nodeText.className = 'mind-map-node-text';

        if (data) {
            node.style.top = data.top;
            node.style.left = data.left;
            node.style.width = data.width;
            //node.style.height = data.height;
            nodeText.innerHTML = data.text;
        }
        else {
            node.style.top = '0';
            node.style.left = '0';
            node.style.width = cfg.nodeWidth + (typeof cfg.nodeWidth == 'number' ? 'px' : '');
            node.style.height = cfg.nodeHeight + (typeof cfg.nodeHeight == 'number' ? 'px' : '');
            nodeText.innerHTML = input.value;
        }

        node.appendChild(nodeText);
        nodeArea.appendChild(node);

        if (cfg.lines) {
            line = document.createElementNS('http://www.w3.org/2000/svg', 'line');

            $(node).data({line: line});

            console.log($(node).data());

            positionLine(node);

            line.setAttribute('x2', cfg.width / 2);
            line.setAttribute('y2', cfg.height / 2);

            lineArea.appendChild(line);
        }

        $(node)
            .draggable({
                containment: nodeArea,
                delay: 100,
                drag: function() {
                    if (cfg.lines) {
                        positionLine();
                    }
                }
            });

        if (cfg.resizable) {
            $(node)
                .resizable({
                    containment: nodeArea,
                    autoHide: true,
                    handles: 'se',
                    minWidth: 50,
                    minHeight: 30,
                    maxWidth: 300,
                    maxHeight: 300,
                    resize: function() {
                        if (cfg.lines) {
                            positionLine();
                        }
                    }
                });
        }

        nodes.push(node);
        input.value = '';

        unSelectNode();

        if (!data) {
            selectNode(jQuery.Event('mousedown', {currentTarget: node, which: 1}));
            node.focus();
        }
    };

    var handleKeyEvents = function(e) {
        if ([69].indexOf(e.which) > -1) {
            input.focus();
        }

        if ([8, 46].indexOf(e.which) > -1) {
            deleteNode();
        }

        if ([87, 65, 83, 68].indexOf(e.which) > -1) {
            keys[e.which] = (typeof keys[e.which] == 'undefined' ? 0 : ++keys[e.which]);

            if (e.shiftKey) {
                keyResize(e);
            }
            else {
                keyMove(e);
            }
        }
    };

    var keyResize = function(e)  {
        var unit = (keys[e.which] < 2) ? 1 : 10;
        var styles = window.getComputedStyle(e.target);
        var w = parseInt(styles.width);
        var h = parseInt(styles.height);

        switch (e.which) {
            case 65: //left (a)
                w -= unit;
                break;
            case 87: //up (w)
                h -= unit;
                break;
            case 68: //right (d)
                w += unit;
                break;
            case 83: //down (s)
                h += unit;
        }

        e.target.style.width = w + 'px';
        e.target.style.height = h + 'px';

        if (cfg.lines) {
            positionLine();
        }
    };

    var keyMove = function(e) {
        var unit = (keys[e.which] < 2) ? 1 : 10;
        var left = parseInt(e.target.style.left);
        var top = parseInt(e.target.style.top);

        switch (e.which) {
            case 65: //left (a)
                left -= unit;
                break;
            case 87: //up (w)
                top -= unit;
                break;
            case 68: //right (d)
                left += unit;
                break;
            case 83: //down (s)
                top += unit;
        }

        e.target.style.left = left + 'px';
        e.target.style.top = top + 'px';

        if (cfg.lines) {
            positionLine();
        }
    };

    var positionLine = function(el) {
        var node = el || selected;
        var styles = window.getComputedStyle(node);
        var left = parseInt(node.style.left);
        var top = parseInt(node.style.top);
        var w = parseInt(styles.width);
        var h = parseInt(styles.height);

        $(node).data('line').setAttribute('x1', (left + w / 2).toString());
        $(node).data('line').setAttribute('y1', (top + h / 2).toString());
    };

    var selectNode = function(e) {
        if ([1, 9].indexOf(e.which) < 0) {
            return;
        }

        e.stopPropagation();

        if (selected != e.currentTarget) {
            unSelectNode();

            $(e.currentTarget).addClass('mind-map-node-selected');
            input.value = $('.mind-map-node-text', e.currentTarget).text();

            selected = e.currentTarget;
        }

        selected.focus();
    };

    var unSelectNode = function() {
        if (selected !== null) {
            $(selected).removeClass('mind-map-node-selected');
            input.value = '';
            selected.blur();
            selected = null;
        }
    };

    var updateNode = function() {
        if (selected !== null) {
            $('.mind-map-node-text', selected).html(input.value);

            selected.style.height = 'auto';

            if (cfg.lines) {
                positionLine();
            }

            selected.focus();
        }
    };

    var deleteNode = function() {
        var index;

        if (selected !== null) {
            index = nodes.indexOf(selected);

            if (cfg.lines) {
                $(selected).data('line').remove();
            }

            $(selected).remove();

            if (index > -1) {
                nodes.splice(index, 1);
            }

            unSelectNode();
        }
    };

    var deleteAllNodes = function() {
        $('.mind-map-node').remove();

        if (cfg.lines) {
            $('line', 'svg').remove();
        }

        nodes = [];
        unSelectNode();
    };

    var getUserSaveObj = function() {
        var saveObj = {};
        var i, array = [];

        for (i = 0; i < nodes.length; i++) {
            array.push({
                text: $(nodes[i]).text(),
                top: nodes[i].style.top,
                left: nodes[i].style.left,
                width: (cfg.resizable) ? nodes[i].style.width : cfg.nodeWidth,
                height: (cfg.resizable) ? nodes[i].style.height : cfg.nodeHeight
            });
        }

        saveObj.nodes = JSON.stringify(array);

        return saveObj;
    };

    var saveUserData = function() {
        saver.save({
            values: getUserSaveObj()
        });
    };

    load();
};

mindMap('container', {
    width: 720,
    height: 720,
    nodeWidth: 100,
    nodeHeight: 'auto',
    backgroundImage: 'img/diagram_arrows.png',
    centre: false,
    resizable: true
});