
"use strict";

var ouSpiderChart = (function(){

 "use strict";

 var spider = function(args){
     var self = this;
     
     this.id = args.id || "genSp01";
     this.deg=0;
     this.doMove=false;
     this.version = "v2.1.6";
     this.domChartId = "";
     this.currentHandle = "-1";
     this.currentHandleIdx = -1;
     this.storedX      = 0;
     this.storedY      = 0;
     
     this.points       = args.axis.length || 5;
     this.chartWidth   = args.chartWidth  || 200;
     this.chartHeight  = args.chartHeight || 200;
     this.chartCenterX = args.chartCenterX || 250;
     this.chartCenterY = args.chartCenterY || 250;
     this.currentPoly  = 0;
     this.pointsArray  = [[]];
     this.numberOfPolys = args.polys.length;
     this.optionsTitleHeight = 124;
     this.optionsItemHeight = 40;
     this.optionsHeight=0;
     this.handleRadius=(OULib.isMobileDevice)?25:10;
     
     this.data = args;

     
     this.scaleDefs={"containerDiv":"mainDiv","originalWidth":this.width,"originalHeight":this.height};
   
     document.getElementById("mainDiv").style.width = this.data.width+"px";
     document.getElementById("mainDiv").style.height = this.data.height+"px";
     
     document.getElementById("versionId").style.top = (this.data.height-12)+"px";
   
     OULib.utils.addEvent(document.getElementById("mainDiv"),"selectstart",function(e){if(OULib.isIE8 === false){e.preventDefault();}return false;});
    
     OULib.utils.addEvent(document,"keyup",function(event){self.keyHandler(event);});
     OULib.utils.addEvent(document,"keydown",function(event){return OULib.disableWindowScrolling(event);});
    
    OULib.trace("Get Data");
     
    OULib.loadData(this.id,true,function(data){self.initActivity(data);});
     

 };

 
 
 spider.prototype.initActivity= function(data){
     
     OULib.trace("Data is ");
     if (data!==null){
         
         OULib.trace(data);
     }else{
         OULib.trace("No data loaded");
     }
     
     this.renderChart(data);
     if (this.data.polys.length>1){ this.createOptions(); }
     this.startApp();
 };

 /**
  * 
  * @memberof ouSpiderChart#
  */
 spider.prototype.createOptions = function(){

     var dom,divElm, domString = '', self = this, count;


	dom = document.getElementById('polyCheckBox0');
	OULib.utils.addEvent(dom,"click",function(event){self.polyShowHide(event);});

	dom = document.getElementById('polyCheckBox1');
	OULib.utils.addEvent(dom,"click",function(event){self.polyShowHide(event);});

    
    dom = document.getElementById("showAllId");
    OULib.utils.addEvent(dom,"click",function(event){self.polyShowHide(event);});
     
    dom = document.getElementById("optionsId");

    dom.style.height=this.optionsTitleHeight+"px";

    this.optionsHeight = (this.optionsItemHeight*(this.data.polys.length+2));

     OULib.utils.addEvent(dom,"touchstart",function(){this.style.height=self.optionsHeight+"px";});
 };


 spider.prototype.polyShowHide = function (e){
   var id;
   this.highlightHandle();
   e = e || window.event;
   id=OULib.getTargetId(e).toString();
   this.doPolyShowHide(id);
   
 };

 
 spider.prototype.keyPolyShowHide = function(id){
    
    for (var count=0;count<this.data.polys.length;count++){
                
        
        if (id === count){
             document.getElementById("polyCheckBox"+count).checked = true;
        }else{
            document.getElementById("polyCheckBox"+count).checked = false;
        }
    }
    
    this.doPolyShowHide("polyCheckBox"+id);
    
    
 };
 
 spider.prototype.doPolyShowHide = function (id){

   var dom,index,count,allChecked=false, currentRadioButton;
  
   if (id==="showAllId")
    {
        var domAll = document.getElementById(id);
        
        if (domAll.checked===true){
            allChecked=true;
        }else{
            for (count=0;count<this.data.polys.length;count++){
                
                var domCheck = document.getElementById("polyCheckBox"+count);
                if (domCheck.checked){
                     index= domCheck.value;
                     currentRadioButton= document.getElementById("polyCheckBox"+count);
                }
            }
            
        }
    }else{
        
        document.getElementById("showAllId").checked = false;
        
        currentRadioButton= document.getElementById(id);
        index= currentRadioButton.value;
    }
   
   
   if (allChecked===true){
       
       for (count=0;count<this.data.polys.length;count++){
            dom = document.getElementById("poly"+count);
            dom.style.visibility="visible";
            
            
       } 
       for (count=0;count<this.data.axis.length;count++){
           document.getElementById('handle'+count).style.visibility = "hidden";
       }
   }
   else{
     
        for (count=0;count<this.data.polys.length;count++){
            dom = document.getElementById("poly"+count);
            dom.style.visibility="hidden";

            //make sure the handles are visible
          
        } 
        for (count=0;count<this.data.axis.length;count++){
           document.getElementById('handle'+count).style.visibility = "visible";
        }

     

        if (currentRadioButton.checked){
            document.getElementById("poly"+index).style.visibility="visible";

             this.currentPoly=index;
             if (this.currentPoly>=this.numberOfPolys){this.currentPoly=0;}
             this.resetHandles(this.pointsArray[this.currentPoly]);

        }
    
   }
   document.getElementById("optionsId").style.height=this.optionsTitleHeight+"px";
   this.currentHandleIdx = -1;
   
 };
 
 /**
  * 
  * @param data data from the data file js
  * @memberof ouSpiderChart#
  */
spider.prototype.renderChart = function(data){
 /*First decide wether we are using VML or SVG*/
    var dom,domString, self = this;
 
    dom = document.getElementById("mainDiv");
    if (OULib.isIE8===true)
    {
        domString = '<div id="chartId" class="chartContainer"></div>';
        
        document.namespaces.add('v',"urn:schemas-microsoft-com:vml", "#default#VML");
   
        if(!document.documentMode || document.documentMode < 8)
        {
          var styles = document.createElement('style');
          styles.type = "text/css";
          styles.styleSheet.cssText ='v\\:*{behavior: url(#default#VML);}'; 
          document.getElementsByTagName('head')[0].appendChild(styles);
        }
    
    }else{
        domString ='<svg id="chartId" class="chartContainer" version="1.1" xmlns="http://www.w3.org/2000/svg"></svg>';
    }
    
  
    
    dom.innerHTML+=domString;
    
    this.domChartId = document.getElementById("chartId");
   
     var sectionWidth = this.chartWidth/this.data.chartSegments;
    
     for (var j=this.data.chartSegments; j>0;j--){
        var circle = {"id":"bgcircle"+j,"cx":this.chartCenterX,"cy":this.chartCenterY,"radius":sectionWidth,"strokeColour":"#000000","fill":"white","opacity":1,"strokeWidth":2};
        circle.radius = (j*sectionWidth);
        this.drawCircle(circle);

        /* hgd4 writing values 1 to 10 on one axis */

	   var point_x = this.chartCenterX + (circle.radius - 30),
		   point_y = this.chartCenterY;

	   if(j === 1) {
		 point_x += 4;
	   }

        var value_label = {
		  	"id":"value_label"+j,
	   		"points": {
				"x":point_x,
			  	"y": point_y
			},
		  	"text": (j)
		};

	    this.drawAxisLabel(value_label);

       /* hgd4 end writing values */

     }
    
    /* Now draw the lines*/

    var slice = 2 * Math.PI / this.points;
    var radiusWidth = this.chartWidth;
    var radiusHeight = this.chartHeight;            
                            
    for (var i = 0; i < this.points; i++)
    {
        var angle = (slice * i);
        
        /*  centerPos + radius * angle              */
        var newX = parseInt(this.chartCenterX  +  radiusWidth  * Math.cos(angle));
        var newY = parseInt(this.chartCenterY  +  radiusHeight * Math.sin(angle));

        var line = {"id":"line"+i,"x1":this.chartCenterX,"y1":this.chartCenterY,"x2":newX,"y2":newY,"strokeColour":"#000000","strokeWidth":2};
       
        this.drawLine(line);
    }
    
    /*now draw the handles*/
    
    //init poitns array
    
    for (var count=0;count<this.numberOfPolys;count++){
        this.pointsArray[count] = [];
    }
    
    for (var i = 0; i < this.points; i++)
    {
        var angle = (slice * i);

        var x,y;
        
        x = parseInt(this.chartCenterX  + (this.chartWidth) * Math.cos(angle));
        y = parseInt(this.chartCenterY  + (this.chartHeight) * Math.sin(angle));
        
        
        for (var count=0;count<this.numberOfPolys;count++){
            if (data === null){
                this.pointsArray[count][i] = {"x":x,"y":y};
            }else{
                this.pointsArray[count][i] = {"x":data[count][i].x,"y":data[count][i].y};
            }
        }
       
        var label = {"id":"label"+i,"points":{"x":x,"y":y},"text":this.data.axis[i].label};
        this.drawAxisLabel(label);
    }
   
      
    //Draw Polys
    for (var count=0;count<this.numberOfPolys;count++){
        var isPolyVisible = (count===0)?"visible":"hidden";
        this.drawPoly({"id":"poly"+count,"points":this.pointsArray[count],"fill":this.data.polys[count].bgColour,"opacity":this.data.polys[count].opacity,"visible":isPolyVisible});
    }
   
    
    //Draw Handles
    for (var i = 0; i < this.points; i++)
    {   
        var circle = {"id":"handle"+i,"cx":this.pointsArray[this.currentPoly][i].x,"cy":this.pointsArray[this.currentPoly][i].y,"radius":this.handleRadius,"stroke":"#000000","fill":"#c0c0c0","opacity":100,"strokeWidth":2};
        this.drawCircle(circle);
          var domH = document.getElementById('handle'+i);
              OULib.utils.addEvent(domH,"mousedown",function(event){self.handleSelect(event);});
              OULib.utils.addEvent(domH,"touchstart",function(event){event.preventDefault(); self.handleSelect(event);});
        
    }
    
    
    
    OULib.utils.addEvent(this.domChartId,"mousemove",function(event){self.handleMove(event);});
    OULib.utils.addEvent(this.domChartId,"touchmove",function(event){self.handleTouchMove(event);});
    
    OULib.utils.addEvent(this.domChartId,"mouseup",function(event){self.handleRelease(event);});
    OULib.utils.addEvent(this.domChartId,"touchend",function(event){self.handleRelease(event);});
    
    
};
 
 
 

 

 
 
 
 
 spider.prototype.highlightHandle = function(){
   
   for (var i = 0; i < this.points; i++)
   {
     document.getElementById('handle'+i).style.stroke = "black";  
   }
    
   if (this.currentHandleIdx!==-1){
   
      document.getElementById(this.currentHandle).style.stroke = "red";
   
   }
 };
 
 
 spider.prototype.handleSelect = function(e){
     e = e || window.event;
     OULib.setPageXY(e);
  
     this.currentHandle = OULib.getTargetId(e).toString();
     this.currentHandleIdx = parseInt(this.currentHandle.substring(6)); 
     this.highlightHandle(); 
                 
     this.storedX = e.pageX;     
     this.storedY = e.pageY;
     
     this.doMove=true;
                
      
 };
 
 
 spider.prototype.doHandleMove = function(xx,yy,direction){
     var slice = 2 * Math.PI / this.points;
     var angle = (slice * this.currentHandleIdx);
     var r=0;
     
     if (this.currentHandleIdx!==-1 && this.doMove){
                 
       
            
        if(Math.sin(angle)!==0){
         
           r = parseInt(((yy - this.chartCenterY)/Math.sin(angle)));
       
        }else{
            
           r = parseInt(((xx - this.chartCenterX)/Math.cos(angle)));
        }
       
        


        r-=direction;

        if (r<0)r=0;
        if (r>this.chartWidth)r=this.chartWidth;

        

         var x,y;
         x = parseInt(this.chartCenterX + ((1)*r) * Math.cos(angle));
         y = parseInt(this.chartCenterY + ((1)*r) * Math.sin(angle));

         if (OULib.isIE8===true){
            document.getElementById(this.currentHandle).style.left=(x-10)+"px";
            document.getElementById(this.currentHandle).style.top=(y-10)+"px";
         }else{
            document.getElementById(this.currentHandle).setAttribute("cx",x);
            document.getElementById(this.currentHandle).setAttribute("cy",y);
         }

      this.storedX = xx;
      this.storedY = yy;
      
      this.pointsArray[this.currentPoly][this.currentHandleIdx].x = x;
      this.pointsArray[this.currentPoly][this.currentHandleIdx].y = y;
      this.updatePolyPoints(this.currentPoly,this.pointsArray[this.currentPoly]);
    }
     
     
 };
 
 
 spider.prototype.handleTouchMove = function(e){

    e.preventDefault();
    
    var xx = e.targetTouches[0].pageX;
    var yy = e.targetTouches[0].pageY;
    
    this.doHandleMove(xx,yy,0);
    
};
 
 spider.prototype.handleMove = function(e){
     e = e || window.event;
     OULib.setPageXY(e);
     
     
     var xx = e.pageX;
     var yy = e.pageY;
    
     this.doHandleMove(xx,yy,0);
     
     
 };
 
 
 
  spider.prototype.handleKeyMove = function(direction){
    
     var xx = this.pointsArray[this.currentPoly][this.currentHandleIdx].x;
     var yy = this.pointsArray[this.currentPoly][this.currentHandleIdx].y;
     
     this.doHandleMove(xx,yy,direction);
     this.doMove=false; 
     
     OULib.saveData(this.id,true,this.pointsArray);
     
 };
 
 spider.prototype.handleRelease = function(e){
     
     this.currentHandleIdx = -1;
     this.highlightHandle();
     this.doMove=false;
     
     OULib.saveData(this.id,true,this.pointsArray);
 };
 
 
 spider.prototype.resetHandles = function(thePoint){
    var handle;
    for (var i = 0; i < this.points; i++)
    {     
        
        
         if (OULib.isIE8===true){
            handle = document.getElementById('handle'+i);
            handle.style.left=(thePoint[i].x-10)+"px";
            handle.style.top=(thePoint[i].y-10)+"px";
         }else{
            handle = document.getElementById('handle'+i);
            handle.setAttributeNS(null,'cx',thePoint[i].x);
            handle.setAttributeNS(null,'cy',thePoint[i].y);
         }
    }
 };
 
 
 spider.prototype.updatePolyPoints = function(id,points){
    
     var poly = document.getElementById("poly"+id);
     var pointsString="";
     
     
     
     if (OULib.isIE8===true){

         pointsString = "M " + points[0].x+","+points[0].y+" L";
         for (var count=1;count<points.length;count++){
            pointsString +=" "+points[count].x+","+points[count].y;
         }
        pointsString += " X E";
        poly.path = pointsString;
     
        
     }else{
        for (var count=0;count<points.length;count++){
               pointsString +=points[count].x+","+points[count].y+" ";
           }

        poly.setAttribute('points',pointsString);
     }
 };
 
 spider.prototype.drawAxisLabel = function(args){
     var id     = args.id || "label";
     var left   = args.points.x+"px" || "0px";
     var top    = args.points.y+"px" || "0px";
     var text   = args.text || "label";
     var dom    = document.getElementById("mainDiv");
     var label,
         label_width = 120,
         possible_space_to_use_for_left_label = 0,
         possible_nice_left_label_offset = 60,
         set_width = false;
     
     // Need to position and wrap labels close to drags circles but off the diagram
     // Labels above and below the Y center line
     if (args.points.y>this.chartCenterY){top = (args.points.y + 15)+"px";}
     if (args.points.y<this.chartCenterY){top = (args.points.y - 30)+"px";}
     // Deals with odd case of an axis that's right on the Y center line and is
     // to the right of the X center line
     if (args.points.y===this.chartCenterY){
    	 top = (args.points.y - 20)+"px";
         if (args.points.x>this.chartCenterX){
        	 left = (args.points.x + 10)+"px";
         } 
     }
     // Find out if there's a viable nice offset to use to position labels on the
     // left side of the X center line
     if (args.points.x<this.chartCenterX){
         possible_space_to_use_for_left_label = this.chartCenterX - this.chartWidth;
         if (args.points.x < (this.chartCenterX * 0.8)) {
             if (possible_space_to_use_for_left_label > possible_nice_left_label_offset) {
            	 possible_nice_left_label_offset = possible_space_to_use_for_left_label;
             }
             set_width = true; 
         }
     } 

     if (possible_nice_left_label_offset < label_width) {
    	 label_width = possible_nice_left_label_offset;
     }  
     
     if (args.points.x<this.chartCenterX){left = (args.points.x - possible_nice_left_label_offset)+"px";}
         
     label = document.createElement('div');
     label.setAttribute('id',id);

     /* hgd4 adding code for setting valuelabel classes */
     if(id.indexOf("value_label") !== -1) {
        label.className = "valueLabel";
     } else {
        label.className = "axisLabel";
     }

     label.style.left=left;
     label.style.top=top;
     if (set_width) {
         label.style.width=label_width + 'px';    	 
     }
     label.innerHTML = text;
     dom.appendChild(label);    
 };
 
 spider.prototype.drawPoly = function(args){
    
    var id              = args.id || "poly";
    var points          = args.points;
    var strokeColour    = args.strokeColour || "#000";
    var strokeWidth     = args.strokeWidth  || 1;
    var fill            = args.fill || "grey";
    var opacity         = args.opacity || 50;
    var visible         = args.visible || "visible";
    var poly;
    var pointsString    = "";
    
    if (points.length<=0){
        OULib.trace("ERR points not defined");
        return;
    }
    
    
    
    
     if (OULib.isIE8===true){

        pointsString = points[0].x+","+points[0].y+" L";
        
         for (var count=1;count<points.length;count++){
            pointsString +=" "+points[count].x+","+points[count].y;
        }

         poly  = '<v:shape id="'+id+'" style="position:absolute;width:'+
                                       this.data.width+'px;height:'+
                                       this.data.height+'px;left:'+0+'px;top:'+
                                       0+'px;visibility:'+visible+';" strokecolor="'+strokeColour+
                                       '" strokeweight="'+strokeWidth+
                                       'pt" coordsize="'+this.data.width+' '+
                                       this.data.height+'">';

        poly += '<v:path v="M '+ pointsString+' X E "/>';
        poly += '<v:fill opacity="50%" color="'+fill+'" />';
        poly += '</v:shape>';


/*
       poly = '<v:shape id="'+id+'" '+
               'style="width:'+this.data.width+';height:'+this.data.height+';position:absolute;visibility:'+visible+'" '+
               'coordorigin="0 0" coordsize="'+this.data.width+' '+this.data.height+'" >'+
               '<v:fill opacity="50%" color="'+fill+'" />'+
               '<v:path v="M '+pointsString+' X E"/>'+
               '<v:stroke color="'+strokeColour+'" weight="'+strokeWidth+'pt" />' +
               '</v:shape>';
  */
 
 
       this.domChartId.insertAdjacentHTML('beforeEnd', poly);

    }else{
        
        for (var count=0;count<points.length;count++){
            pointsString +=points[count].x+","+points[count].y+" ";
        }
        
        poly = document.createElementNS('http://www.w3.org/2000/svg','polygon');
        poly.setAttributeNS(null,'id',id);
        poly.setAttributeNS(null,'points',pointsString);
        poly.setAttribute('stroke', strokeColour);
        poly.setAttribute('stroke-width', strokeWidth);
        poly.setAttribute('fill', fill);
        poly.setAttribute('fill-opacity', (opacity/100));
        poly.style.visibility = visible;
        this.domChartId.appendChild(poly);
    }
    
    
 };
 
  /**
  * 
  * @param {type} args
  * @returns {unresolved}
  */
 spider.prototype.drawLine = function(args){
    
    var id              = args.id || "line";
    var x1              = args.x1 || 0;
    var y1              = args.y1 || 0;
    var x2              = args.x2 || 0;
    var y2              = args.y2 || 0;
    var strokeColour    = args.strokeColour || "#000";
    var strokeWidth     = args.strokeWidth  || 1;
    var line;
    
     
    if (OULib.isIE8===true){

        line  = '<v:shape id="'+id+'" style="position:absolute;width:'+
                                       this.data.width+'px;height:'+
                                       this.data.height+'px;left:'+0+'px;top:'+
                                       0+'px" strokecolor="'+strokeColour+
                                       '" strokeweight="'+strokeWidth+
                                       'pt" coordsize="'+this.data.width+' '+
                                       this.data.height+'">';

        line += '<v:path v="M '+x1+','+y1+' L';
        line += ' '+x2+','+y2 ;
        line += ' E "/></v:shape>';
       
        this.domChartId.insertAdjacentHTML('beforeEnd', line);

    }else{
        line = document.createElementNS('http://www.w3.org/2000/svg','line');
        line.setAttributeNS(null,'id',id);
        line.setAttributeNS(null,'x1',x1);
        line.setAttributeNS(null,'y1',y1);
        line.setAttributeNS(null,'x2',x2);
        line.setAttributeNS(null,'y2',y2);
        line.setAttribute('stroke', strokeColour);
        line.setAttribute('stroke-width', strokeWidth);
        this.domChartId.appendChild(line);
    }
 };
 
 /**
  * 
  * @param {type} args
  * @returns {unresolved}
  */
 spider.prototype.drawCircle = function(args){
    
    var id              = args.id || "circle";
    var cx              = args.cx || 0;
    var cy              = args.cy || 0;
    var radius          = args.radius || 0;
    var strokeColour    = args.strokeColour || "#000000";
    var strokeWidth     = args.strokeWidth  || 1;
    var fill            = args.fill         || "#c0c0c0";
    var opacity         = args.opacity      || 50;
    var circle          = "";
    
    if (OULib.isIE8===true){
       
        var r = radius;
        var diameter = (2*r);
/*
         circle = '<v:group id="g'+id+'" ';
      
         circle += ' style="width:'+(radius*2)+'px;height:'+ 
                            (radius*2)+'px;position:absolute;left:'+(cx-radius)+'px;top:'+
                            (cy-radius)+ 'px; overflow:hidden;" coordorigin="'+(cx-radius)+','+
                            (cy-radius)+'" coordsize="'+(radius*2)+','+(radius*2)+'" >';    

         circle += '<v:oval id="'+id+'" style="width:'+
                            (radius*2)+'px;height:'+ (radius*2)+'px;left:'+
                            (cx-r)+'px;top:'+(cy-r)+ 'px;"';
      
      
         
       circle += ' strokecolor="'+strokeColour+'" strokeweight="'+strokeWidth+'pt" >'+
                 '<v:fill opacity="'+opacity+'%" color="'+fill+'" />'+
                 '</v:oval></v:group>';  
  */     
    
        
/*
         circle =  '<v:oval id="'+id+'" style="position:absolute;width:'+diameter+
                   'px;height:'+diameter+'px;'+ 
                   'left:'+(cx-r)+'px;top:'+(cy-r)+ 'px;" fillopacity="'+
                   opacity+'%" fillcolor="'+fill+
                   '" strokecolor="'+strokeColour+'" strokeweight="'+strokeWidth+'pt">';
           
         circle +='</v:oval>';
*/

       
           circle  = '<v:shape id="'+id+'" style="position:absolute;width:'+
                                       diameter+'px;height:'+
                                       diameter+'px;left:'+(cx-r)+'px;top:'+
                                       (cy-r)+'px" strokecolor="'+strokeColour+
                                       '" strokeweight="'+strokeWidth+
                                       'pt" coordsize="'+diameter+' '+
                                       diameter+'" fillcolor="'+fill+'" fillopacity="'+
                                        opacity+'%">';

        circle += '<v:path v="M '+0+','+0+' ';
        circle += 'm '+0+','+r+' ';
        circle += 'wa  0,0,'+diameter+','+diameter+', 0,'+r+' '+diameter+','+r;
        circle += 'wa  0,0,'+diameter+','+diameter+', '+diameter+','+r+' '+0+','+r;
        
        circle += ' X E "/></v:shape>';
  /*
   * wa
   * 
   * left, top, right, bottom, start(x,y) end(x,y) 
   * 
   *
   */
         
         this.domChartId.insertAdjacentHTML('beforeEnd', circle);        
        
      
    
    }else{
        circle = document.createElementNS('http://www.w3.org/2000/svg','circle');
        circle.setAttributeNS(null,'id',id);
        circle.setAttributeNS(null,'cx',cx);
        circle.setAttributeNS(null,'cy',cy);
        circle.setAttributeNS(null,'r',radius);
        circle.setAttribute('stroke', strokeColour);
        circle.setAttribute('stroke-width', strokeWidth);
        circle.setAttribute('fill', fill);
        circle.setAttribute('fill-opacity',(opacity/100));
        
        this.domChartId.appendChild(circle);
    }

 };
 
 /**
  * start the application
  * 
  * @memberof ouSpiderChart#
  */
spider.prototype.startApp = function(){
 
   document.getElementById("mainDiv").style.visibility="visible";
    
};



 /**
  * function to prevent the default browser event happening. Incluides code to detect browsers <= IE8 
  * 
  * @param {type} e
  * @returns {Boolean}
  * @memberof ouSpiderChart#
  */
 spider.prototype.preventDef = function (e){
     e = e || window.event;
     if (OULib.isIE8 === false){
        e.preventDefault();
    }
    return false;
 };

 spider.prototype.keyHandler  = function(evt){
          
    var keyCode=OULib.getKeyCode(evt);
     
   if (keyCode===48 || keyCode===96){
        document.getElementById("showAllId").checked=!document.getElementById("showAllId").checked;
        this.doPolyShowHide("showAllId");
   }
  
    switch (keyCode)
    {
       
       case OULib.KEY_PLUS:
       case OULib.KEY_EQUALS:
           this.currentPoly++;
           if (this.currentPoly>=this.numberOfPolys){this.currentPoly=0;}
            this.keyPolyShowHide(this.currentPoly);
         
           break;
       case OULib.KEY_MINUS:
       case OULib.KEY_DASH:
           this.currentPoly--;
           if (this.currentPoly<0){this.currentPoly=this.numberOfPolys-1;}
            this.keyPolyShowHide(this.currentPoly);
         
           break;
       break;

        case OULib.KEY_UP_ARROW:
           this.currentHandleIdx++;
           if (this.currentHandleIdx>this.data.axis.length-1){this.currentHandleIdx=0;}
           this.currentHandle = "handle"+this.currentHandleIdx;
           this.highlightHandle();
           break;

       case OULib.KEY_DOWN_ARROW:
           this.currentHandleIdx--;
           if (this.currentHandleIdx<0){this.currentHandleIdx=this.data.axis.length-1;}
           this.currentHandle = "handle"+this.currentHandleIdx;
           this.highlightHandle();
           break;

       case OULib.KEY_LEFT_ARROW:
           if (this.currentHandleIdx!==-1){
               this.doMove=true;
                this.handleKeyMove(6);
            }
           break;
       case OULib.KEY_RIGHT_ARROW:
           if (this.currentHandleIdx!==-1){
               this.doMove=true;
                this.handleKeyMove(-6);
            }
           break;
           
      
        
    }
    
    
   
  };
 

 return spider;
}());  

/**
 * @var {ou_spiderChart} ouSpiderChart
 */
var ou_spiderchart = new ouSpiderChart(spider_data); 





