var Checkboxes = {
		// Some params to use with VLE calls
	    course_id: VLE.get_param('course_id') || VLE.get_param('_c'),
	    document_id: VLE.get_param('document_id') || VLE.get_param('_i'),
	    activity_id: VLE.get_param('activity_id') || VLE.get_param('_a'),
	    previous_values: undefined, // Leave undefined to pass as a default param to the VLE functions
		
	    /**
	     * Part one of set up: adds listener(s) and loads stuff etc. Second phase of
	     * initialisation is done once storage values are ready for use i.e. VLE
	     * object calls this object's methods as callbacks.
	     */
		init: function() {		
			var submit_button = document.getElementById("sb_t0-t-ts-k313"),
			    clear_button = document.getElementById("cb_t0-t-ts-k313"),
	    	    checkboxes_container = document.getElementById("t-ts-k313"),
			    that = this;		
			
			if (submit_button !== null) {
				if (typeof window.addEventListener === 'function') {			
	                submit_button.addEventListener('click', function(evt) {
	                    return that.collectAndPassDataToStorage(evt);
	                }, false);
				} else {				
					submit_button.attachEvent("onclick", function(evt) {
					    return that.collectAndPassDataToStorage(evt);
					});
				}
			}
			
			if (clear_button !== null) {
				if (typeof window.addEventListener === 'function') {			
	                clear_button.addEventListener('click', function(evt) {
	                    return that.clearAllCheckboxes(evt);
	                }, false);
				} else {				
					clear_button.attachEvent("onclick", function(evt) {
					    return that.clearAllCheckboxes(evt);
					});
				}
			}
			
			if (checkboxes_container !== null) {
				if (typeof window.addEventListener === 'function') {			
	                checkboxes_container.addEventListener('click', function(evt) {
	                    return that.handleCheckboxChange(evt);
	                }, false);
				} else {				
					checkboxes_container.attachEvent("onclick", function(evt) {
					    return that.handleCheckboxChange(evt);
					});
				}
			}			
			
		},
		
		/**
		 * Get server value, if set, of the same name as document.body.id and passes this value
		 * on to another method that sets up the state of the app, mirror's below for local storage
		 * @return {Function}
		 */
	    getVleData: function() {
	    	var that = this;
	    	
	    	return function (values) {  		
	            if (values !== null && values[document.body.id] !== "") {  // Second condition handles VLE bug
	            	that.setUpCheckboxes(values[document.body.id]);	
	            }
	    	};
	     },
	    
	    /**
	     * Gets a local storage value, if set, of the same name as document.body.id and passes this
	     * value on to another method that sets up the state of the app
	     * @return {Function}
	     */
	    getLocalData: function() {
	        var that = this;
	    
	        return function(message) {
	        	var local_storage_value = null;
	            if (message === null) {
	            	if (window.localStorage) {
	            		local_storage_value = window.localStorage.getItem(document.body.id);          		
	            		if (local_storage_value !== null) {
	                    	that.setUpCheckboxes(local_storage_value);           			
	            		}
	            	}           	
	            } else {
	            	alert("Error saving data. Check connection's OK.");
	            }
	        };
	    },
	    
	    /** Checks previously checked checkboxes.
	     * @param String checked_checkboxes Comma separated list of the checked checkboxes
	     */
	    setUpCheckboxes: function(checked_checkboxes) { 	
	    	var checkbox_array = checked_checkboxes.split(","),
	    	    clear_button = document.getElementById("cb_t0-t-ts-k313"),
		    	i = 0,
		    	max = checkbox_array.length,
		    	checkbox = {},
		    	feedback_counter = 0;
	 	
	    	for (; i < max; i += 1) {
	    	    checkbox = document.getElementById("a" + checkbox_array[i]);
	    	    if (checkbox !== null) {
	        	    checkbox.checked = true;
	        	    feedback_counter += 1;
	    	    }		
	    	}
	    	
	    	if (feedback_counter > 0 ) {
	    	    clear_button.disabled = false;	
	    	}
	    },
	    
	    /**
	     * Collects the data to save and passes it to various storage places
	     * @param Object evt
	     */
	    collectAndPassDataToStorage: function(evt) {
	    	var server_data = {},
	    	    submit_button = document.getElementById("sb_t0-t-ts-k313"),
	    	    checkboxes_container = document.getElementById("t-ts-k313"),
	    	    checkboxes = checkboxes_container.getElementsByTagName("input"), // Contains checkboxes
	    	    i = 0,
	    	    max = checkboxes.length,
	    	    checkbox_values = [];
	    	 	    
		    // Loop through all the checkboxes and add the position of the checked ones to an array
	        for (; i < max; i += 1) {
	        	if (checkboxes.item(i).type === 'checkbox') {
	        	    if (checkboxes.item(i).checked === true) {
	        	        checkbox_values.push(i);	
	        	    }	
	        	}
	        }
	        
	        submit_button.disabled = true;
       
	        // Pass values as string for storing
	    	server_data[document.body.id] = checkbox_values.join(",");   	
	        VLE.set_server_data(true, server_data, function() {
	        	// Success, don't need to do anything
	        }, this.saveLocalData(server_data), this.previous_values, null, this.activity_id,
	        this.document_id, this.course_id);
	    },
	    
	    /**
	     * Saves the checkboxes' state locally if VLE storage isn't present and VLE object's message is null
	     * @param Object server_data The name/value pairs to save to local storage
	     */
	    saveLocalData: function(server_data) {
	        var i = "";
	        return function(message) {
	        	if (message === null) {
	                if (window.localStorage) {
	            		for (i in server_data) {
	            		    if (server_data.hasOwnProperty(i)) {
	            		    	if (server_data[i] === "") {
	            		    		window.localStorage.removeItem(i);
	            		    	} else {
	                		    	window.localStorage.setItem(i, server_data[i]);            		    		
	            		    	}
	            		    }
	            		}
	            	}        		
	        	}      	
	        };
	    },
	    
	    /**
	     * Clears all the checkboxes and enables the save all button
	     * @param {Object} e The event object
	     * @param {String} table_id The ID of the table to reset
	     */
	    clearAllCheckboxes: function(evt) {
			var submit_button = document.getElementById("sb_t0-t-ts-k313"),
		        clear_button = document.getElementById("cb_t0-t-ts-k313"),
	    	    checkboxes_container = document.getElementById("t-ts-k313"),
	    	    checkboxes = checkboxes_container.getElementsByTagName("input"), // Contains checkboxes
	    	    i = 0,
	    	    max = checkboxes.length,
	    	    changed_counter = 0;
	    	 	    
		    // Loop through all the checkboxes and add the position of the checked ones to an array
	        for (; i < max; i += 1) {
	        	if (checkboxes.item(i).type === 'checkbox') {
	        	    if (checkboxes.item(i).checked === true) {
	        	    	checkboxes.item(i).checked = false;
	        	    	changed_counter += 1;
	        	    }	
	        	}
	        }
	        
	        // Set the save/clear all buttons to reflect what's happened
	        clear_button.disabled = true;
	        if (changed_counter > 0) {
	            submit_button.disabled = false;   	
	        }	        
	    },
	    
	    /**
	     * Save state of checkboxes if one is changed dependent on whether or not
	     * this is part of a text in tables activity
	     * @param {Object} evt The event object
	     */
	    handleCheckboxChange: function (evt) {
	    	var evt = evt || window.event,
	    	    target = evt.target || evt.srcElement,
				submit_button = document.getElementById("sb_t0-t-ts-k313"),
		        clear_button = document.getElementById("cb_t0-t-ts-k313");
            
	    	// delegated event so needs filtering for just checkboxes
	    	if (target.type !== null && target.type === 'checkbox') {
		    	// Turn on the clear all button if one's just been checked
	    		if (target.checked === true) {
	    			clear_button.disabled = false;
	    		}
	    		// Handle submit button if working as part of a bigger activity
		    	if (submit_button === null) {
		    		// Save without waiting for a submit button to be hit
		            this.collectAndPassDataToStorage();	    		
		    	} else {
		    		submit_button.disabled = false;
		    	}	    		
	    	}
	    }
	};

	Checkboxes.init();

	// App saves state so makes sense for the call to VLE object start the action...
	VLE.get_server_data(true, [document.body.id], (Checkboxes.getVleData()),
			(Checkboxes.getLocalData()), Checkboxes.activity_id, Checkboxes.document_id,
			Checkboxes.course_id);