if (!String.prototype.trim) {
  String.prototype.trim = function () {
    return this.replace(/^\s+|\s+$/g,'');
  };
}

// Immediate function used to start the action and create scope
(function(){
  // All the variables used in this scope
  var name_of_parent_div = "contentLayer", // The container for the node net
      number_of_rows = 5, // Node net's rows
      number_of_columns = 6, // Node net's columns
      utils = { // Methods and variables that are conditional on platform
        addEvent: null,
        removeEvent: null
      },
      /** ONLY EVER add new item to the end of this array, the order is important once
      * data has been saved as the zero indexed position in this array is the ID used to
      * save favourite data about the tool AND pass this index position to the tool's Tool constructor
      */
      drags = [
        {src: "./goal_setting/k313_tool_goal_setting-1.0.png", href: "./goal_setting/goal_setting.html"},
        {src: "./personal_awareness/k313_tool_personal_awareness-1.0.png", href: "./personal_awareness/personal_awareness.html"},
        {src: "./time_management/k313_tool_time_management-1.0.png", href: "./time_management/time_management.html"},
        {src: "./forcefield/k313_tool_forcefield-1.0.png", href: "./forcefield/forcefield.html"},
        {src: "./swot/k313_tool_swot_analysis-1.0.png", href: "./swot/swot.html"},
        {src: "./stakeholder/k313_tool_stakeholder-1.0.png", href: "./stakeholder/stakeholder.html"},
        {src: "./critical_appraisal/k313_tool_critical_appraisal-1.0.png", href: "./critical_appraisal/critical_appraisal.html"},
        {src: "./perform/k313_tool_perform-1.0.png", href: "./perform/perform.html"},
        {src: "./grow/k313_tool_grow-1.0.png", href: "./grow/grow.html"},
        {src: "./conflict_management/k313_tool_conflict_management-1.0.png", href: "./conflict_management/conflict_management.html"},
        {src: "./pdsa/k313_tool_pdsa-1.0.png", href: "./pdsa/pdsa.html"},
        {src: "./ten_step/k313_tool_ten_step-1.0.png", href: "./ten_step/ten_step.html"},
        {src: "./managing_manager/k313_tool_managing_manager-1.0.png", href: "./managing_manager/managing_manager.html"},
        {src: "./spider/k313_tool_spider-1.0.png", href: "./spider/spider.html"}
      ],
      app_id = document.body.id,
      course_id = VLE.get_param('course_id') || VLE.get_param('_c'),
      document_id = VLE.get_param('document_id') || VLE.get_param('_i'),
      activity_id = VLE.get_param('activity_id') || VLE.get_param('_a');

  // Start of 'init time branching' where we 'feature sniff' just the once, setting members of
  // the utils object to whatever value's right for that platform and just use util.member thereafter
  if (typeof window.addEventListener === 'function') {
    utils.addEvent = function (elem, type, func) {
      elem.addEventListener(type, func, false);
    };
    utils.removeEvent = function (elem, type, func) {
      elem.removeEventListener(type, func, false);
    };
  } else if (typeof document.attachEvent === 'function') {
    utils.addEvent = function (elem, type, func) {
      elem.attachEvent('on' + type, func);
    };
    utils.removeEvent = function (elem, type, func) {
      elem.detachEvent('on' + type, func);
    };
  } else {
    utils.addEvent = function (elem, type, func) {
      elem['on' + type] = func;
    };
  }

  // See if the drags already have a positional state
  VLE.get_server_data(true, [app_id], function (values) {
      new NodeNet(name_of_parent_div, number_of_rows, number_of_columns,
      values[app_id]);
    }, function (message) {
      if (message === null) {
        if (window.localStorage) {
          // Create the Node Net with its configuration and state info
          new NodeNet(name_of_parent_div, number_of_rows, number_of_columns,
          localStorage.getItem(app_id));
        }
      }
    }, activity_id, document_id, course_id);

  /** Constructor for a NodeNet. Lays out a 'net' of nodes in a parent container element
  * such as a div.
  * @param {String} parent_div The div to make the node net in
  * @param {Number} rows Rows in the node net
  * @param {Number} cols Columns in the node net
  * @param {String} positions A comma delimited string of integers that signify which
  *         drops the drags belong to and which tiles are favourites (starred)
  */
  NodeNet = function(parent_div, rows, cols, positions_and_favs) {
    var positions_and_favs = positions_and_favs || '',
        parent_container = document.getElementById(parent_div),
        i,
        max = rows * cols,
        new_drop_div,
        node_size = Math.floor((parent_container.offsetWidth / cols)),
        border_size = Math.floor(node_size / 20),
        starting_width = parent_container.offsetWidth,
        bg_image,
        saved_state = [],
        iframe = window.frameElement,
        iframe_height = document.body.getAttribute("height"),
        tile_path = '',
        that = this;

    // Privileged members
    this.zIndex_top = 0; // Gets incremented each time a tile's dragged
    this.nodes = [];
    // JSON that will record where drags have been last dropped and if they are a
    // favourite or not
    this.dnd_state = {
      "drags": [29,28,27,0,2,1,26,25,24,23,22,21,20,19], // jaj248 - pre-populate to set different start positions
      "favourites": []};

    // Add any saved positions if provided in correct format
    if (typeof positions_and_favs === 'string' && positions_and_favs !== '') {
      saved_state = positions_and_favs.split(';');
      if (saved_state.constructor === Array && saved_state.length === 2) {
        if (typeof saved_state[0] === 'string') {
          if (saved_state[0].trim() !== "") {
            this.dnd_state.drags = saved_state[0].split(",");
          }
        }
        if (typeof saved_state[1] === 'string') {
          if (saved_state[1].trim() !== "") {
            this.dnd_state.favourites = saved_state[1].split(",");
          }
        }
      }
    }
    // Set up the nodes i.e. the drop zones
    for (i=0; i < max; i += 1) {
      new_drop_div = document.createElement("div");
      new_drop_div.setAttribute("id", "drop-" + i);
      new_drop_div.style.borderStyle = "solid";
      new_drop_div.style.borderWidth = border_size + "px";
      new_drop_div.style.width =  (node_size - (border_size * 2)) + "px";
      new_drop_div.style.height = new_drop_div.style.width;
      new_drop_div.style.cssFloat = "left";
      new_drop_div.style.styleFloat = "left";  // IE 8 and under
      new_drop_div.style.backgroundColor = "#000000";
      new_drop_div.style.position = "relative";
      new_drop_div.draggable = false;
      bg_image = document.createElement("img");
      bg_image.draggable = false;
      bg_image.src = "./base_black_square.png";
      bg_image.width = node_size - (border_size * 2);
      bg_image.height = bg_image.width;
      utils.addEvent(bg_image, "dragover", this.onDragOver);
      utils.addEvent(bg_image, "drop", function (evt) {
          return that.onDrop(evt);
        });
      new_drop_div.appendChild(bg_image);
      this.nodes.push(new_drop_div);
      parent_container.appendChild(new_drop_div);
    }

    // Set up the tiles, i.e. the drag items
    for (i=0; i < drags.length; i += 1) {
      bg_image = document.createElement("img");
      (function (i, bg_image) {
        bg_image.onload = function () {
          var drop_index = i;
          bg_image.setAttribute("id", "drag-" + i);
          bg_image.width = node_size - (border_size * 2);
          bg_image.height = bg_image.width;
          bg_image.style.position = "absolute";
          bg_image.style.top = "0px";
          bg_image.style.left = "0px";
          bg_image.tabIndex = (i + 1).toString();
          utils.addEvent(bg_image, "dragstart", that.onDragStart);
          utils.addEvent(bg_image, "touchstart", function (evt) {
            return that.onTouchStart(evt);
          });
          utils.addEvent(bg_image, "touchmove", that.onTouchMove);
          utils.addEvent(bg_image, "dragend", that.onDragEnd);
          utils.addEvent(bg_image, "touchend", function (evt) {
            return that.onTouchEnd(evt);
          });
          if (window.navigator.msMaxTouchPoints > 1) {
            // MS surface
            utils.addEvent(bg_image, "pointerdown", function (evt) {
              return that.onPointerDown(evt);
            });
            utils.addEvent(bg_image, "pointermove", that.onPointerMove);
            utils.addEvent(bg_image, "pointerup", function (evt) {
              return that.onPointerUp(evt);
            });
            utils.addEvent(bg_image, "pointerout", function (evt) {
              return that.onPointerOut(evt);
            });
          }
          utils.addEvent(bg_image, "focus", function (evt) {
            return that.onFocus(evt);
          });
          utils.addEvent(bg_image, "keydown", function (evt) {
            return that.onKeyDown(evt);
          });
          (function (click_target) {
            utils.addEvent(bg_image, "click", function (evt) {
              return that.onClick(evt, click_target);
            });
          }(drags[i].href));
          bg_image.touchCounter = 0; // Used to distinguish a touch from a drag
          if (that.dnd_state.drags[i] !== undefined) {
            // Use saved position (won't ever conflict as can't drop on an occupied drop zone)
            that.nodes[that.dnd_state.drags[i]].appendChild(bg_image);
          } else {
            // First time set up (may conflict if added after other tools have been positioned)
            if (that.nodes[i].children.length > 1) {
              // Need to find an unoccupied spot
              drop_index = that.getNearestUnoccupiedDropZone(i);
            }
            that.nodes[drop_index].appendChild(bg_image);
            that.dnd_state.drags[i] = drop_index; // Add default positions before any dragging
          }
        };
      }(i, bg_image));

      // Decide whether to use a 'starred' favourited tile or not
      if (parseInt(that.dnd_state.favourites[i], 10) === 1) {
        tile_path = this.getFavouriteImageName(drags[i].src);
      } else {
        tile_path = drags[i].src;
      }
      bg_image.src = tile_path;
    }

    // If in an iframe set a proper height
    if (iframe !== null && iframe_height !== null) {
      iframe.height = iframe_height;
    }
    parent_container.style.width = starting_width + "px";  // Bring it back to its original size
  };

  /**
  * Element clicked
  */
  NodeNet.prototype.onClick = function (evt, local_click_target) {
    var search_string = window.location.search;
    window.location.href = "./" + local_click_target + search_string;
  };

  /**
  * Element gets focus
  */
  NodeNet.prototype.onFocus = function (evt) {
    var evt = evt || window.event,
        src = evt.target || evt.srcElement;
    this.zIndex_top += 1;
    src.style.zIndex = this.zIndex_top;
  };

  /**
  * Keyboard moving of tiles and linking
  */
  NodeNet.prototype.onKeyDown = function (evt) {
    var evt = evt || window.event,
        src = evt.target || evt.srcElement,
        parent_node_number = parseInt(src.parentNode.getAttribute("id").split("-")[1], 10),
        new_parent_number = parent_node_number,
        src_id = parseInt(src.id.split("-")[1], 10);

    if (evt.shiftKey === true && (evt.keyCode > 36 && evt.keyCode < 41)) {
      switch (evt.keyCode) {
        case 37:
          new_parent_number -= 1;
          break;
        case 38:
          new_parent_number -= number_of_columns;
          break;
        case 39:
          new_parent_number += 1;
          break;
        case 40:
          new_parent_number += number_of_columns;
          break;
        default:
          alert('Error condition: wrong keycode.');
      }

      if (new_parent_number >= 0 && new_parent_number < (number_of_columns * number_of_rows)) {
        // Reset in case just previously just landed on a occupied drag
        src.style.top = "0px";
        src.style.left = "0px";
        src.style.opacity = 1;
        src.style.filter = "alpha(opacity:100)";
        this.nodes[new_parent_number].appendChild(src);
        if (this.nodes[new_parent_number].childNodes.length > 2) {
          // Already taken drop spot so don't save it, mark it for clearance and offset it
          src.style.top = parseInt(src.style.top.split("px")[0], 10) + 5 + "px";
          src.style.left = parseInt(src.style.left.split("px")[0], 10) + 5 + "px";
          src.style.opacity = 0.8;
          src.style.filter = "alpha(opacity:80)";
        } else {
          // Save its new position
          this.dnd_state.drags[src_id] = new_parent_number;
          this.saveStateToServer();
        }
      }
      src.focus();

      if (evt.preventDefault) {
        evt.preventDefault();
      } else {
        evt.returnValue = false;
      }
    } else if (evt.keyCode === 13) {
      // Send to the new page
      if (evt.target.onclick) {
        evt.target.onclick();
      } else {
        evt.target.click();
      }
    }
  };

  /** Tile element touched
  */
  NodeNet.prototype.onTouchStart = function (evt) {
    evt.preventDefault();
    this.zIndex_top += 1;
    evt.target.focus();
    evt.target.style.zIndex = this.zIndex_top;
    evt.target.touchCounter = 0;
    evt.target.startPosY = evt.targetTouches.item(0).clientY;
    evt.target.startPosX = evt.targetTouches.item(0).clientX;
    evt.target.timeoutId = setTimeout(function() {
        evt.target.touchCounter += 1;
      }, 200);
  };

  /** Tile element touch ended
  */
  NodeNet.prototype.onTouchEnd = function (evt) {
    var dropzone = {},
        drop_id = [],
        drag_id_pos = 0;
    window.clearTimeout(evt.target.timeoutID);
    if (evt.target.touchCounter === 0) {
      evt.target.style.top = "0px";
      evt.target.style.left = "0px";
      if (evt.target.click) {
        evt.target.click();
      } else {
        evt.target.onclick();
      }
    } else {
      evt.target.style.top = "0px";
      evt.target.style.left = "0px";
      try {
        dropzone = document.elementFromPoint(evt.target.startPosX, evt.target.startPosY).parentNode;
        drop_id = dropzone.getAttribute("id").split("-");
        if (drop_id[0] === "drop") {
          if (dropzone.childNodes.length <= 1) { // Indicates a unoccupied drop
            dropzone.appendChild(evt.target);
            drag_id_pos = parseInt(evt.target.id.split("-")[1], 10);
            this.dnd_state.drags[drag_id_pos] = parseInt(drop_id[1], 10); // Save new position
            this.saveStateToServer();
            evt.target.addEventListener("touchstart", function () {
                return this.onTouchStart;
              }, false);
          }
        }
      }
      catch (e) {
        // Just fail silently...
      }
      evt.target.focus();
    }
  };

  /** Tile element being touch dragged
  */
  NodeNet.prototype.onTouchMove = function (evt) {
    var y_moved = evt.target.startPosY - evt.targetTouches.item(0).clientY,
        x_moved = evt.target.startPosX - evt.targetTouches.item(0).clientX,
        split_top = evt.target.style.top.split('px'),
        split_left = evt.target.style.left.split('px');
    evt.target.style.top = (parseInt(split_top[0], 10) - y_moved) + "px";
    evt.target.style.left = (parseInt(split_left[0], 10) - x_moved) + "px";
    evt.target.startPosY = evt.targetTouches.item(0).clientY;
    evt.target.startPosX = evt.targetTouches.item(0).clientX;
  };

  /** Tile element touched on MS pointer device
  */
  NodeNet.prototype.onPointerDown = function (evt) {
    var e = evt || window.event,
        target = e.target || e.srcElement;
    target.setPointerCapture(e.pointerId);
    e.cancelBubble = true;
    e.preventDefault();
    this.zIndex_top += 1;
    target.focus();
    target.style.zIndex = this.zIndex_top;
    target.touchCounter = 0;
    target.startPosY = Math.round(e.clientY);
    target.startPosX = Math.round(e.clientX);
    target.timeoutId = setTimeout(function() {
        target.touchCounter += 1;
      }, 200);
  };

  /** Tile element touch ended on MS surface device
  */
  NodeNet.prototype.onPointerUp = function (evt) {
    var dropzone = {},
        drop_id = [],
        drag_id_pos = 0,
        e = evt || window.event,
        target = e.target || e.srcElement,
        temp_reference_node = {};
    e.cancelBubble = true;
    e.returnValue = false;
    target.releasePointerCapture(e.pointerId);
    window.clearTimeout(target.timeoutID);
    if (target.touchCounter === 0) {
      target.style.top = "0px";
      target.style.left = "0px";
      if (target.click) {
        target.click();
      } else {
        target.onclick();
      }
    } else {
      target.style.top = "0px";
      target.style.left = "0px";
      try {
        dropzone = document.elementFromPoint(target.startPosX, target.startPosY).parentNode;
        drop_id = dropzone.getAttribute("id").split("-");
        if (drop_id[0] === "drop") {
          if (dropzone.childNodes.length <= 1) { // Indicates a unoccupied drop
            dropzone.appendChild(target);
            drag_id_pos = parseInt(target.id.split("-")[1], 10);
            this.dnd_state.drags[drag_id_pos] = parseInt(drop_id[1], 10); // Save new position
            this.saveStateToServer();
          } else {
            // Hack to stop click firing on ms surfaces
            temp_reference = target.parentNode;
            temp_reference.removeChild(target);
            temp_reference.appendChild(target);
          }
        } else {
          temp_reference = target.parentNode;
          temp_reference.removeChild(target);
          temp_reference.appendChild(target);
        }
      }
      catch (e) {
        // Just fail silently...
        temp_reference = target.parentNode;
        temp_reference.removeChild(target);
        temp_reference.appendChild(target);
      }
      target.focus();
    }
    target.startPosX = null;
    target.startPosY = null;
  };

  /** Tile element being touch dragged on MS surface device
  */
  NodeNet.prototype.onPointerMove = function (evt) {
    var e = evt || window.event,
        target = e.target || e.srcElement
        y_moved = Math.round(target.startPosY - e.clientY),
        x_moved = Math.round(target.startPosX - e.clientX),
        split_top = target.style.top.split('px'),
        split_left = target.style.left.split('px');
    e.preventDefault();
    e.cancelBubble = true;
    e.stopPropagation();
    e.stopImmediatePropagation();
    if(e.buttons === 1) { // Disables dragging on pen hover
      e.srcElement.setPointerCapture(e.pointerId);
      target.style.top = (parseInt(split_top[0], 10) - y_moved) + "px";
      target.style.left = (parseInt(split_left[0], 10) - x_moved) + "px";
      target.startPosY = Math.round(e.clientY);
      target.startPosX = Math.round(e.clientX);
    }
  };

  /**
  * Tile element is starting to be dragged
  */
  NodeNet.prototype.onDragStart = function (evt) {
    var localevt = typeof evt === 'undefined' ? event : evt,
        localelm = typeof localevt.srcElement === 'undefined' ? localevt.currentTarget : localevt.srcElement,
        localdatatransfer = localevt.dataTransfer;
    localdatatransfer.setData("Text", localelm.getAttribute("id"));
  };

  /**
  * Tile element has finished being dragged
  */
  NodeNet.prototype.onDragEnd = function (evt) {
    var evt = evt || window.event,
        src = evt.target || evt.srcElement;
    src.focus();
  };

  /**
  * Node element has an dragged tile over it
  */
  NodeNet.prototype.onDragOver = function (evt) {
    if (window.event) { // IE and Chrome
      window.event.preventDefault ? evt.preventDefault() : window.event.returnValue = false;
    } else {
      evt.preventDefault(); // FF
    }
  };

  /**
  * Node element has an dragged tile dropped on it
  */
  NodeNet.prototype.onDrop = function (evt) {
    var localevt = typeof evt === 'undefined' ? event : evt,
        localelm = typeof localevt.srcElement === 'undefined' ? localevt.currentTarget : localevt.srcElement,
        dragid = localevt.dataTransfer.getData("Text"),
        dragelm = document.getElementById(dragid),
        drag_id_pos = 0,
        drop_id_pos = 0;
    if (window.event) { // IE and Chrome
      window.event.preventDefault ? evt.preventDefault() : window.event.returnValue = false;
    } else {
      evt.preventDefault(); // FF
    }
    if (dragelm !== null) {
      localelm.parentNode.appendChild(dragelm);
      drag_id_pos = parseInt(dragid.split("-")[1], 10);
      drop_id_pos = parseInt(dragelm.parentNode.id.split("-")[1], 10);
      this.dnd_state.drags[drag_id_pos] = drop_id_pos;
      this.saveStateToServer();
    }
  };

  /**
  * Transforms the state saving object into a string for saving.  Didn't use JSON as the data is
  * so simple it can be made to work in IE 7 as a normal string with some comma delimiting etc.
  * @param Array drags The list of drags and their positions
  * @return String Delimited string that represents the position of the drags
  */
  NodeNet.prototype.getStateAsString = function (drags) {
    var i = 0,
        max = drags.length,
        state_as_string = "";
    for (i = 0; i < max; i += 1) {
      state_as_string += drags[i];
      if (i < max - 1) {
        state_as_string += ",";
      }
    }
    return state_as_string;
  };

  /** 
  * Encapsulates the VLE objects save data function.  Just sends what's in this.dnd_state to
  * the server or localstorage
  */
  NodeNet.prototype.saveStateToServer = function () {
    var state_as_string = "",
        server_data = {},
        app_id = document.body.id,
        that = this,
        previous_values;
    state_as_string = this.getStateAsString(this.dnd_state.drags);
    state_as_string += ';' + this.getStateAsString(this.dnd_state.favourites);
    server_data[app_id] = state_as_string;
    if (state_as_string.trim() !== "") {
      VLE.set_server_data(true, server_data, function () {
        // Nothing to do just carry on...
      }, function (message) {
        if (message === null) {
          if (window.localStorage) {
            localStorage.setItem(app_id, state_as_string);
          }
        } else {
          alert(message); // This is stuff like lost connection etc.
        }
      }, previous_values, null, activity_id, document_id, course_id);
    }
  };

  /**
  * Given the name of a tile image it returns the name of the companion 'favourited'
  * tile image i.e. it just adds a '_star' to the passed in string in the correct place
  * which is before the last '-' which denotes the start of the version and extension
  * @param {String} src_tile_name The name of the standard tile image
  * @return {String} The name of the favourited tile image if found or just return the
  *         normal one, if poss
  */
  NodeNet.prototype.getFavouriteImageName = function (src_tile_name) {
    var favourite_name = src_tile_name,
        src_tile_parts = favourite_name.split('-');
    if (src_tile_parts.constructor === Array) {
      if (src_tile_parts.length > 1) {
        src_tile_parts[src_tile_parts.length - 2] += '_star';
        favourite_name = src_tile_parts.join('-');
      }
    }
    return favourite_name;
  };

  /**
  * Finds the nearest unoccupied drop zone. Finds the nearest to the right, left to
  * the right, nearest down, nearest up and returns the best one.
  * @param {Number} taken_spot The position of the original drop used
  * @return {Number} The positon of the best unoccupied drop zone
  */
  NodeNet.prototype.getNearestUnoccupiedDropZone = function (taken_spot) {
    var empty_nodes = [],
        i = 0,
        max = this.nodes.length,
        best_found_spot = 0;
    // Try and improve this strategy at some point to get one spatially nearer
    for (; i < max; i += 1) {
      if (this.nodes[i].children.length === 1) {
        best_found_spot = i;
        break;
      }
    }
    return best_found_spot;
  };

  // Make the CSS transition do its stuff
  document.body.className = "faded";
}());