/**
 * @fileOverview OULib file
 * <br/> <br/>
 * <b>History</b><br/> <br/>
 * <br/>
 * 1.0.0 - initial version
 *    
 * <b>Usage</b><br/>
 * Include the script file into your main HTML file, then access any of the
 * public vars or methods useing OULib.
 * 
 * @file libs.js
 * @author <a href="mailto:tegai.lansdell@open.ac.uk">Tegai Lansdell</a>
 * @version 1.0.0 
 * 
 *
 */

/**
     * OULibs
     * 
     * @class Represents  OULibs
     * @name OULibs
     * 
     */
var OULibs = (function (){

/**
 * Defines the event listener functionaly, some key defines and other
 *  checks like browser verisons
 * 
 * @constructor 
 * @param args set up any defualts
 * @returns {libs}
 * @memberof OULibs#
 */
 var libs = function (args){
    
       this.KEY_ENTER       = 13;
       this.KEY_SPACE       = 32;
       this.KEY_UP_ARROW    = 38;
       this.KEY_DOWN_ARROW  = 40;
       this.KEY_LEFT_ARROW  = 37;
       this.KEY_RIGHT_ARROW = 39;
       this.KEY_CTRL        = 64;
       this.KEY_PLUS        = 107;
       this.KEY_MINUS       = 109;
       this.KEY_EQUALS      = 187;
       this.KEY_DASH        = 189;
               
       this.debugOn = args.debugOn; 
       this.isMobileDevice = false;
       this.html5Video = false;
          
       this.isChrome    = navigator.userAgent.indexOf('Chrome')  > -1;
       this.isExplorer  = navigator.userAgent.indexOf('MSIE')    > -1;
       this.isIE8       = navigator.userAgent.indexOf('MSIE 8')  > -1 || navigator.userAgent.indexOf('MSIE 7')  > -1;
       this.isFirefox   = navigator.userAgent.indexOf('Firefox') > -1;
       this.isSafari    = navigator.userAgent.indexOf("Safari")  > -1;
       this.isOpera     = navigator.userAgent.indexOf("Presto")  > -1;
       
             
       if ( ! window.console ) console = { log: function(){} };
      
       if (typeof args.debugOn !== "undefined"){ this.debugOn = args.debugOn;}
       if ((this.isChrome)&&(this.isSafari)) {this.isSafari=false;}
      
      
       if ((/iphone|ipod|ipad|android|iemobile|blackberry|fennec|opera mini/i).test
              (navigator.userAgent.toLowerCase())){this.isMobileDevice=true;}
       
       if (!!document.createElement('video').play){
           if (!!document.createElement('video').canPlayType( 'video/mp4' )){
                this.html5Video = true;}
       }
       
       
       
              
       this.utils = { // Methods and variables that are conditional on platform
          addEvent: null,
          removeEvent: null
       };
       
       if ( ! window.console ){ console = { log: function(){} };}
    
        if (typeof window.addEventListener === 'function') {
           this.utils.addEvent = function (elem, type, func) {
                elem.addEventListener(type, func, false);
       };
           this.utils.removeEvent = function (elem, type, func) {
            elem.removeEventListener(type, func, false);
       };
      } else if (typeof document.attachEvent === 'function') {
           this.utils.addEvent = function (elem, type, func) {
            elem.attachEvent('on' + type, func);
       };
           this.utils.removeEvent = function (elem, type, func) {
            elem.detachEvent('on' + type, func);
       };   
      } else {
            this.utils.addEvent = function (elem, type, func) {
                elem['on' + type] = func;                  
            };
      }
      
      
 };

/**
 * Check to see if the current key press match the supplied ascii character
 * @param {string} chr
 * @param {integer} keyCode
 * @returns {Boolean}
 * @memberof OULibs#
 */
 libs.prototype.isKeyCode = function(chr, keyCode){
     
     var asciiCode = chr.charCodeAt(0),
         bResult = false;

     this.trace("asciiCode:"+asciiCode+" keyCode:"+keyCode);
     if (keyCode>=48 && keyCode<=57){
        if (asciiCode === keyCode)
         {bResult = true;}
     }else if (keyCode>=65 && keyCode<=90){
        if (asciiCode === (keyCode+32))
         {bResult = true;}
     }
     
     
     return bResult;
 };

/**
 * Debug function to the console if turned on. Debug is off by defualt but can 
 * be manually turned on by setting OULib.debugOn = true
 * @param {string} str
 * @memberof OULibs#
 */
 libs.prototype.trace = function(str){
    if (this.debugOn===true){
        try{
            console.log("OUlib trace: "+str);
        }catch(e){
            console.log("OUlib trace: Error in expression: " + e);
        }
    }
 };
 
 /**
  * method which creates a way of loading and displaying an MPEG 4 video. If the browser
  * implements the HTML5 video tag then this will be used. Otherwise a flash
  * swf player will need to be specified in the parameters.<br/>
  * List of values within the args object
  * <ul>
  * <li> <b>videoId</b> - id of the video that will be created</li>
  * <li> <b>divId</b> - the id of the div where the video will be placed</li>
  * <li> <b>videoSrc</b> - path to the mp4 file</li>
  * <li> <b>posterSrc</b> - image to be displayed before playing commences</li>
  * <li> <b>width</b> - video width</li>
  * <li> <b>height</b> - video height</li>
  * <li> <b>controls</b> - set to true to display controls</li>
  * <li> <b>swfPlayer</b> - path to the swf player if needed to support non HTML5 browsers</li>
  * <li> <b>loadCbf</b> - callback that is called when the video has loaded</li>
  * <li> <b>endedCbf</b> - callback that is called when the video has finshed playing</li>
  * </ul>
  * 
  * @param {object} args
  * @memberof OULibs#
  */
 libs.prototype.loadVideo = function(args){
      var htmlString = "",
          posterSrc = "",
          controls = "",
          htmlArr;
      
      
      if (typeof args.posterSrc){
          if (this.html5Video === true){
            posterSrc = 'poster="'+args.posterSrc+'"';
          }else{
            posterSrc = 'poster='+args.posterSrc;  
          }
      }
      
      if (typeof args.controls){
          if (args.controls === true && this.html5Video === false){
              controls = 'controls=true';
          }else{
              controls = 'controls="controls"';
          }
      }
      
      
      
      if (this.html5Video === true){
          //HTML5 Video
          htmlString  = '<video id="'+args.videoId+'" '+controls+' '+posterSrc+' width="'+args.width+'" height="'+args.height+'">';
          htmlString += '<source src="'+args.videoSrc+'" type="video/mp4" />';
          htmlString += '</video>';
          document.getElementById(args.divId).innerHTML = htmlString;
          
          this.utils.addEvent(document.getElementById(args.videoId),"canplay",args.loadCbf);
          this.utils.addEvent(document.getElementById(args.videoId),"ended",args.endedCbf);
          this.trace("Is the video loading?");
        
          if (this.isMobileDevice === true){
              args.loadCbf();
          }
      }
      else{
          //Flash Video
       
         //very important that the object tag is done this way otherwise the parameters will be lost
		 htmlArr = [
			'<object type="application/x-shockwave-flash" id="'+args.videoId+'" data="'+args.swfPlayer+'" width="'+args.width+'" height="'+args.height+'">',
			'\t<param name="movie" value="'+args.swfPlayer+'" />',
			'\t<param name="allowFullScreen" value="true" />',
			'\t<param name="wmode" value="transparent" />',
			'\t<param name="flashVars" value="autoplay=true&amp;'+controls+'&amp;'+posterSrc+'&amp;src='+args.videoSrc+'" />'
		];
		
		  htmlString = htmlArr.join('\n')+'\n</object>';

          document.getElementById(args.divId).innerHTML  = htmlString;
        
          args.loadCbf();
      }
   
 };
 
 /**
  * method which handles which key has been pressed and returns the correct keycode.
  * Used to make sure IE plays nicley with the other browsers
  * @param {event} e
  * @returns {keycode}
  * @memberof OULibs#
  */
 libs.prototype.getKeyCode = function (e){
     var keyCode = -1,
         evt = e ? e:window.event;
    
     if(evt.keyCode) // IE8 and earlier
        { keyCode = evt.keyCode; }
     else if(evt.which) // IE9/Firefox/Chrome/Opera/Safari
        { keyCode = evt.which; }
    
     return keyCode;
 };
 
 /**
  * method which handles dom object is currently actioned and return the correct id.
  * Used to make sure IE plays nicley with the other browsers
  * @param {event} e
  * @returns {id}
  * @memberof OULibs#
  */
 libs.prototype.getTargetId = function (e){
   
     var id = "undefined",
         evt = e ? e:window.event;
     
     if(evt.srcElement) // IE8 
         {id = evt.srcElement.id;}
     else
         {id = evt.target.id;}
         
     return id; 
 };
 
 
 /**
  * method which will scale the activity to the avaliable width and height
  * 
  * List of values within the args object
  * <ul>
  * <li> <b>containerDiv</b> - the div which conatins/wraps around the activity. there must be one div that contains all the HTML for this to work.  </li>
  * <li> <b>originalWidth</b> - the original width of the activity. i.e. it's defualt unscaled width </li>
  * <li> <b>originalHeight</b> - the original height of the activity. i.e. it's defualt unscaled height  </li>
  * </ul>
  * @param {object} args
  * @memberof OULibs#
  */
 libs.prototype.setScale = function(args) {

        var fac = 1, cWidth = 0, cHeight = 0, scaleFactorH, scaleFactorW,
                docMargin = 0, leftPos=0, topPos=0;

        //Get correct dimensions of the srceen
        if (window.innerHeight)
        {
            cWidth = window.innerWidth - docMargin;
            cHeight = window.innerHeight - docMargin;
        } else {
            cHeight = document.documentElement.clientHeight - docMargin;
            cWidth = document.documentElement.clientWidth - docMargin;
        }

        //calculate the height and width scale factors
        scaleFactorH = cHeight / (args.originalHeight);
        scaleFactorW = cWidth / (args.originalWidth);

        //Choose which is the smaller of the two factors
        //this is so that the anima will fit to the screen
        if (scaleFactorH <= scaleFactorW)
        {
            fac = scaleFactorH;
        } else {
            fac = scaleFactorW;
        }

        //get the left and top position so that the anim can be centered
        leftPos = Math.floor(((cWidth - (args.originalWidth * fac)) / fac) / 2);
        topPos = Math.floor(((cHeight - (args.originalHeight * fac)) / fac) / 2);


        //Set the scaling factor based upon browser

        if (this.isFirefox === true) {
            document.getElementById(args.containerDiv).setAttribute('style',
                    '-moz-transform: scale(' + fac + ');-moz-transform-origin: 0 0;');
        }
        else if (this.isSafari === true && this.isMobileDevice === false) {

            document.getElementById(args.containerDiv).setAttribute('style',
                    '-webkit-transform: scale(' + fac + ');');
        } else {
            document.getElementById(args.containerDiv).setAttribute('style',
                    'zoom:' + fac + ';');
        }

        //Center the animation 

        document.getElementById(args.containerDiv).style.left = leftPos + "px";
        document.getElementById(args.containerDiv).style.top = topPos + "px";

    
    };
 
    /**
     * method which disables the iframe for scrolling when the user presses
     * the cursor keys
     * 
     * @param {event} event
     * @returns {Boolean}
     * @memberof OULibs#
     */
    libs.prototype.disableWindowScrolling = function(event) {
        event = event || window.event;
       
        if (event.keyCode >= this.KEY_LEFT_ARROW && event.keyCode <= this.KEY_DOWN_ARROW) {
            if (!!event.preventDefault){event.preventDefault();}
            return false;
        }
        return true;
     };
     
     /**
     * resets the parents frame height if it can: Note does not work locally
     * 
     * @param {integer} frameHeight 
     * @memberof OULibs#
     */
    libs.prototype.setFrameHeight = function(frameHeight) {
        
        if (!!window.frameElement){
            window.frameElement.setAttribute("height",frameHeight);
        }
       
     };
 
     
     /**
      * 
      * @param {dom object} elm
      * @returns {integer} height
      */
     libs.prototype.getScrollHeight = function(elm){
    
        
        var height = Math.max( elm.scrollHeight,
                               elm.offsetHeight,
                               elm.clientHeight);
         return height;
     };
 

 return libs;
}());

/**
* @var {OULib}
* @type OULibs */
var OULib = new OULibs({"debugOn":false});


// update the requestAnimationFrame window object to cover all browsers

(function() {
    var requestAnimationFrame = window.requestAnimationFrame || window.mozRequestAnimationFrame ||
                                window.webkitRequestAnimationFrame || window.msRequestAnimationFrame;
 
    if (requestAnimationFrame === undefined){
        window.requestAnimationFrame = (function(func){setTimeout(func,16);});
    }else{
        window.requestAnimationFrame = requestAnimationFrame;
    }
  })();