/**
 *
 *
 */

var OU_k313_pdsa_tool = {
    
    id : "",
    version : "1.01", 
    imageCount : 0,
    loaderLeftPosition : 0,
    current_segment : 0,
    max_segments: 4,
    max_cycles :4,
    current_cycle:0,
    data : {},
    pdsaTextStrings : [],
    pdsa_letters:["p","d","s","a"],
    overlay_pos:0,
    bAutoSave:false,
    tabPDSAIndex: 1,
    tabSegmentButtons: 5,
    tabTextAreaIndex: 10,
    tabSegmentIndex: 15,
    tabSegmentButtonsBottom: 20,
    
    
    scaleDefs:{"containerDiv":"mainDiv","originalWidth":870,"originalHeight":610},

    /**
     * initialisation function
     * @param data
     */
    init: function(data){
      "use strict";
      var self = this;
      
      this.data = data;
      this.id = this.data.id;
      this.max_cycles = this.data.max_cycles || 4;

      OULib.trace("start app");
      OULib.loadData(this.id,true,function(data){self.initActivity(data,true);});
  
      OULib.setScale(this.scaleDefs);
           
    },
            
    initActivity : function(data,loadImages){
        "use strict";
        var crumbsSegment=0;
        var crumbsCycle=0;
        var self = this;
        //do something with the loaded data
        //load it into these arrays
        
        for (var count=0;count<this.max_cycles;count++){
          this.pdsaTextStrings[count]=[];
          for (var subcount=0;subcount<this.max_segments;subcount++){
              
            if (data !==null && count<data.length){
                this.pdsaTextStrings[count][subcount]=data[count][subcount];
            }else{
                this.pdsaTextStrings[count][subcount]="";
            }
            if (this.pdsaTextStrings[count][subcount]!==""){
                crumbsSegment=subcount;
                crumbsCycle=count;
            }
          }
        }
        
        OULib.trace("crumbsCycle"+ crumbsCycle + " crumbsSegment:"+crumbsSegment);
        
        
        
        
        for (var countx=0;countx<=crumbsCycle;countx++){
            var limit=(countx>=crumbsCycle)?crumbsSegment+1:this.max_segments;
            
            if (countx>0){
               document.getElementById("crumbTrailId").getElementsByTagName("img")[(((countx)*5)+1)].src = 
                  this.data.imgDir+"bc_0"+(countx+1)+"_off.png";
           }
          
            OULib.utils.addEvent(document.getElementById("crumbTrailId").getElementsByTagName("img")[(((countx)*5)+1)],
                        "click",function(event){self.jumpToSegement(event);});
            document.getElementById("crumbTrailId").getElementsByTagName("img")[(((countx)*5)+1)].idx = 1;
            document.getElementById("crumbTrailId").getElementsByTagName("img")[(((countx)*5)+1)].cycle = countx+1;  
            document.getElementById("crumbTrailId").getElementsByTagName("img")[(((countx)*5)+1)].className="crumbHover";
            
           OULib.trace(limit);
            
            for (var subcountx=((countx===0)?2:1);subcountx<=limit;subcountx++){
               var letter_idx = (((countx)*5)+1) + (subcountx);
               
               OULib.trace("letter :"+this.pdsa_letters[subcountx-1]+" pos:"+letter_idx);
                              
               this.addCrumbTrailLetter(letter_idx, subcountx,(countx+1));
               
                
            }
         
        } 
         
      
        OULib.utils.addEvent(document.getElementById("listViewId"),"click",function(){ self.storeText(); self.showListView();});
        OULib.utils.addEvent(document.getElementById("backViewId"),"click",function(){ self.showMain();});
        if (this.data.saveButton===true){
            OULib.utils.addEvent(document.getElementById("saveTextId"),"click",function(){ self.bAutoSave = false;self.storeText(); OULib.saveData(self.id,true,self.pdsaTextStrings,self.afterSave);});
        }
        OULib.utils.addEvent(document.getElementById("clearTextId"),"click",function(){ self.resetAll();});
        
        document.getElementById("backViewId").tabIndex = this.tabSegmentButtons;
        if (!!this.data.saveButton){
           document.getElementById("saveTextId").tabIndex = this.tabSegmentButtons;
        }else{
           document.getElementById("saveTextId").tabIndex = -1;
        }
        
        document.getElementById("listViewId").tabIndex= this.tabSegmentButtons;
        document.getElementById("clearTextId").tabIndex = this.tabSegmentButtonsBottom;
        
        //load the images
        if (loadImages === true){
            this.loadImages();
        }
        
    },
    
    
    resetAll:function(){
      "use strict";
        this.bAutoSave = false;
      var self = this ,count;
       for (count=0;count<this.max_cycles;count++){
          
          for (var subcount=0;subcount<this.max_segments;subcount++){
          
                this.pdsaTextStrings[count][subcount]="";
          }
        }
       
       document.getElementById("crumbTrailId").getElementsByTagName("img")[1].src = this.data.imgDir+"bc_01_on.png";
       document.getElementById("crumbTrailId").getElementsByTagName("img")[2].src = this.data.imgDir+"bc_p_on.png";
       
       for (count = 3; count<=(this.max_segments*this.max_cycles)+this.max_cycles; count++){
           document.getElementById("crumbTrailId").getElementsByTagName("img")[count].src = 
                  this.data.imgDir+"transparent.png";
       }

       OULib.saveData(this.id,true,this.pdsaTextStrings, this.afterSave );
       OULib.loadData(this.id,true,function(data){self.initActivity(data,true);});
       
    },
    
    showMain: function(){
        "use strict";
        document.getElementById("listViewDiv").style.visibility = "hidden";
         if (OULib.isMobileDevice===false){
              OULib.setFrameHeight(610); //Set default for intro
          }else{
              OULib.setScale(this.scaleDefs);
          }
        document.getElementById("mainDiv").style.visibility = "visible";

    },
    
    getPDSAText:function(idx){
        "use strict";
        var str="", segment = 0;
        var textTitleArray=["<b>Plan</b>: ","<b>Do</b>: ","<b>Study</b>: ","<b>Act</b>: "];
        while (segment<this.pdsaTextStrings[idx].length /*&& this.pdsaTextStrings[idx][segment]!==""*/){
            str += textTitleArray[segment] + " - <span class='preTxt'>" + this.pdsaTextStrings[idx][segment] + "</span><br/><br/>";
            segment++;
        }
        
        
        return str;

    },
    
    showListView: function (){
        "use strict";
        var domElm, count, listPageHeight, listViewDomStr="", txt;
        
        document.getElementById("mainDiv").style.visibility = "hidden";
        
        //Build up HTML string
        
        
        for (count=0;count<this.max_cycles;count++){
            txt = this.getPDSAText(count);
            if (txt!==""){
                listViewDomStr += "<p><b>Cycle</b> : " + (count+1) + "<hr/>" + txt + "<br/></p>";
            }
        }
        
        
        //Fix for IE 8 && opera as scrollHeight returns incorrect values
        // so what we do is clear the heights on the div containing the div
        // and any containing divs. And set the height to auto for the div 
        // containing the text. Then set the text to be displayed
         domElm = document.getElementById("listViewDiv");
         domElm.style.height ="";
         domElm.style.overflow ="visible";

         domElm = document.getElementById("listViewContentsDivId");
         domElm.style.height ="auto"; //Line is important for opera
         domElm.style.overflow ="visible";

         domElm.innerHTML=listViewDomStr;

         listPageHeight = OULib.getScrollHeight(domElm) + 40;



         domElm.style.height=listPageHeight+"px";

         domElm = document.getElementById("listViewDiv");
         domElm.style.height=listPageHeight+"px";

        


         if (OULib.isMobileDevice===false){
              OULib.setFrameHeight(listPageHeight); //Set default for intro
             
              var lscaleDefs={};
              lscaleDefs.containerDiv = "listViewDiv";
              lscaleDefs.originalHeight = listPageHeight;
              lscaleDefs.originalWidth = 870;

              OULib.setScale(lscaleDefs);
              document.getElementById("listViewDiv").style.top = "0px";
            
          }else{
              
              var lscaleDefs={};
              lscaleDefs.containerDiv = "listViewDiv";
              lscaleDefs.originalHeight = listPageHeight;
              lscaleDefs.originalWidth = 870;

              OULib.setScale(lscaleDefs);
          }

        document.getElementById("listViewDiv").style.visibility = "visible";

    },
    startActivity : function(){
        "use strict";
         var self = this;
         
         document.getElementById("controlArrowsId").src = this.data.imgDir+"k313_pdsa_tool_overlay_"+this.overlay_pos+".png";
         document.getElementById("controlWheelId").style.backgroundImage = "url("+this.data.imgDir+"k313_pdsa_tool_seg_01.png)";
         
         
         
         this.current_segment = 1;
                  
         this.current_cycle = 1;
          
         this.updateTextCycle();
          
         
         for (var count=1; count<= this.max_segments; count++){
            OULib.utils.addEvent(document.getElementById("segment0"+count+"Id"),"click",function(event){self.activateSegement(event);});
            OULib.utils.addEvent(document.getElementById("segment0"+count+"Id"),"keydown",function(event){self.keyActivateSegement(event);});
            OULib.utils.addEvent(document.getElementById("tbc_0"+count).getElementsByTagName("textarea")[0],"keyup",function(event){ self.bAutoSave = true;});
            document.getElementById("tbc_0"+count).getElementsByTagName("textarea")[0].disabled = true;
            document.getElementById("tbc_0"+count).getElementsByTagName("textarea")[0].tabIndex = this.tabTextAreaIndex;
         }
       
        
         document.getElementById("segment0"+(this.current_segment+1)+"Id").className = "imgSegHover";
         document.getElementById("segment0"+(this.current_segment+1)+"Id").tabIndex = this.tabSegmentIndex;
         document.getElementById("tbc_0"+this.current_segment).getElementsByTagName("textarea")[0].style.backgroundColor = "#ffffff";
         document.getElementById("tbc_0"+this.current_segment).getElementsByTagName("textarea")[0].disabled = false;
         document.getElementById("tbc_0"+this.current_segment).style.backgroundColor = "#ffffff";

        this.afterSave();
         
    },

    afterSave: function(){
        "use strict";
        var self = this;

        setTimeout(function (){self.autoSave();},500);
    },

    autoSave: function(){
        "use strict";
        var self = this;
        if (this.bAutoSave === true){
            this.bAutoSave = false;
            this.storeText();
            OULib.saveData(this.id,true,this.pdsaTextStrings,function(){self.afterSave();});
        }else{
            this.afterSave();
        }
    },

    keyActivateSegement: function(event){
        "use strict";
        var key = OULib.getKeyCode(event);
        
        if (key === OULib.KEY_ENTER ){
            
            this.activateSegement(event);
        }
        
    },
    
    keyJumpToSegement:function(event){
        "use strict";
        var key = OULib.getKeyCode(event);
        
        if (key === OULib.KEY_ENTER ){
            
            this.jumpToSegement(event);
        }
        
    },
    
    
    updateTextCycle : function(){
        "use strict";
        for (var count=0;count<this.max_segments;count++){
            
           document.getElementById("tbc_0"+(count+1)).getElementsByTagName("textarea")[0].value =
                   this.pdsaTextStrings[this.current_cycle-1][count];
        }
        
    },
            
    storeText : function(){
        "use strict";
         this.pdsaTextStrings[this.current_cycle-1][this.current_segment-1] = 
              document.getElementById("tbc_0"+this.current_segment).getElementsByTagName("textarea")[0].value;
      
    },
    
    updateOverlayCycle : function(){
        "use strict";
        this.overlay_pos = (this.overlay_pos===0)?1:0;
        document.getElementById("controlArrowsId").src = this.data.imgDir+"k313_pdsa_tool_overlay_"+this.overlay_pos+".png";
    },
    
    activateSegement : function(e){
        "use strict";
        var id  = OULib.getTargetId(e), next_segment, next_segment_id;
            
       
        next_segment = (this.current_segment+1 <= this.max_segments)?this.current_segment+1:1;
        next_segment_id = "segment0"+next_segment+"Id";
                       
        if (id === next_segment_id){
            
            this.gotoNextSegment(next_segment, this.current_cycle, false);
            this.updateOverlayCycle();
            
        }

    },
            
    jumpToSegement : function(e){
        "use strict";
        var target = OULib.getTarget(e);
                
        if (!!target.idx && !!target.cycle){        
            if ((target.idx>0 && target.idx<=this.max_segments) && 
                (target.cycle>0 && target.cycle<=this.max_cycles)){
        
                this.gotoNextSegment(target.idx, target.cycle, true);
                this.updateOverlayCycle();
            }
        }

    },
    
   addCrumbTrailLetter : function (letter_idx, seg , cycle){
       "use strict";
       var self = this;
      
      document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx].src = 
                this.data.imgDir+"bc_"+this.pdsa_letters[(seg-1)]+"_off.png";
         
       
      if (!document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx].idx){
            document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx].className="crumbHover";
            document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx].idx = seg;
            document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx].cycle = cycle;
            OULib.utils.addEvent(document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx],
                            "click",function(event){self.jumpToSegement(event);});
            OULib.utils.addEvent(document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx],
                            "keydown",function(event){self.keyJumpToSegement(event);});
            document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx].tabIndex = this.tabPDSAIndex;
        }
       
   },
   
   gotoNextSegment : function(next_segment,cycle, jump){
       "use strict";
        
        var letter_idx=0, next_segment_id = "";
       this.bAutoSave = false;
        this.storeText();



        OULib.saveData(this.id,true,this.pdsaTextStrings,null);
        
        letter_idx = (((this.current_cycle-1)*5)+1) + this.current_segment;
      
        this.addCrumbTrailLetter(letter_idx, this.current_segment,this.current_cycle);
        

        if (next_segment === 1 && jump===false){

            document.getElementById("crumbTrailId").getElementsByTagName("img")[(((this.current_cycle-1)*5)+1)].src = this.data.imgDir+"bc_0"+this.current_cycle+"_off.png";

            this.current_cycle ++;

            if (this.current_cycle >this.max_cycles){
                this.current_cycle = 1;
            }
            document.getElementById("crumbTrailId").getElementsByTagName("img")[(((this.current_cycle-1)*5)+1)].src = this.data.imgDir+"bc_0"+this.current_cycle+"_on.png";
            this.updateTextCycle();
            
        }else{
            
            if (cycle !== this.current_cycle){
                document.getElementById("crumbTrailId").getElementsByTagName("img")[(((this.current_cycle-1)*5)+1)].src = this.data.imgDir+"bc_0"+this.current_cycle+"_off.png";
                this.current_cycle = cycle;
                document.getElementById("crumbTrailId").getElementsByTagName("img")[(((this.current_cycle-1)*5)+1)].src = this.data.imgDir+"bc_0"+this.current_cycle+"_on.png";
                this.updateTextCycle();
            }
        }


        document.getElementById("tbc_0"+this.current_segment).getElementsByTagName("textarea")[0].style.backgroundColor = "#EBEBE4";
        document.getElementById("tbc_0"+this.current_segment).style.backgroundColor = "#EBEBE4";
        document.getElementById("tbc_0"+this.current_segment).getElementsByTagName("textarea")[0].disabled = true;
        document.getElementById("segment0"+this.current_segment+"Id").className = "imgSeg";

        document.getElementById("controlWheelId").style.backgroundImage = "url("+this.data.imgDir+"k313_pdsa_tool_seg_0"+next_segment+".png)";
        document.getElementById("tbc_0"+next_segment).getElementsByTagName("textarea")[0].style.backgroundColor = "#ffffff";
        document.getElementById("tbc_0"+next_segment).style.backgroundColor = "#ffffff";
        document.getElementById("tbc_0"+next_segment).getElementsByTagName("textarea")[0].disabled = false;
        document.getElementById("tbc_0"+next_segment).getElementsByTagName("textarea")[0].focus();

        
        this.current_segment = next_segment;
       
        letter_idx = (((this.current_cycle-1)*5)+1) + this.current_segment;
        document.getElementById("crumbTrailId").getElementsByTagName("img")[letter_idx].src = this.data.imgDir+"bc_"+this.pdsa_letters[this.current_segment-1]+"_on.png";


        next_segment = (this.current_segment+1 <= this.max_segments)?this.current_segment+1:1;
        next_segment_id = "segment0"+next_segment+"Id";
        document.getElementById(next_segment_id).className = "imgSegHover";
        
    
       document.getElementById("segment0"+(this.current_segment)+"Id").tabIndex = -1;
     
       document.getElementById("segment0"+next_segment+"Id").tabIndex = this.tabSegmentIndex;
          
              
        if (OULib.canPlayAudio()){
            document.getElementById("clickId").play();
        }
       
       
   },
 
   loadImages : function(){
       "use strict";
     var cacheDiv = document.getElementById("cache"), self = this;

     for (var count=0;count<this.data.img.length;count++){
         var elm = document.createElement("img");
         elm.onload = function(){self.loaderUpdate();};
         elm.src = this.data.imgDir+this.data.img[count];
       
         cacheDiv.appendChild(elm);
                  
         this.imageCount++;
         
     }

     this.loaderAnimation();
   },
   loaderUpdate : function(){
       "use strict";
     
       this.imageCount--;
       if (this.imageCount<=0){

            this.startActivity();
            document.getElementById("LoadingDiv").style.visibility="hidden";
            document.getElementById("mainDiv").style.visibility="visible";
            document.getElementById("tbc_0"+this.current_segment).getElementsByTagName("textarea")[0].focus();

       }
    },
   loaderAnimation : function(){
       "use strict";
        var self = this,
             progressBarWidth  =  document.getElementById("progressBarId").offsetWidth;

         this.loaderLeftPosition+=4;

         if (this.loaderLeftPosition>progressBarWidth){

             this.loaderLeftPosition=-document.getElementById("progressBarAnimId").offsetWidth;
         }

         document.getElementById("progressBarAnimId").style.left = this.loaderLeftPosition+"px";
         requestAnimationFrame(function(){self.loaderAnimation();});
    }
    
};



OU_k313_pdsa_tool.init(pdsa_tool_data);