/**
 * @fileOverview force field main JS file
 * <br/> <br/>
 * <b>History</b><br/> <br/>
 * <br/>
 * 
 * 
 * @file forcefield.js
 * @author <a href="mailto:tegai.lansdell@open.ac.uk">Tegai Lansdell</a>
 * 
 * 
 *
 */

"use strict";

 /**
     * ou_forcefield
     * 
     * @class Represents a ou_forcefield
     * @name ou_forcefield
     * 
     */
var ou_forcefield = (function(){

 "use strict";

/**
 * add all the event listenre and init all vars
 * 
 * @constructor 
 * @param theData reference to the data in data.ja
 * @returns {forcefield}
 * @memberof ou_forcefield#
 */
 var forcefield = function(theData){
     var self   = this;
  
     this.STATE_WAIT = 0;
     this.STATE_LOAD = 1;
     this.STATE_FORCE_TO_MIDDLE = 2;
     this.STATE_MOVE_ALL_FORCES = 3;
     
     this.id    = theData.id;
     
     this.SaveIdx = "";
     
     this.data  = theData;
     
     this.leftForce  = 0; 
     this.rightForce = 0;
     this.direction  = 2;
     
     this.currentPosition = 400;
     this.targetPosition  = 0;
     this.currentBarPosition =0;
    
     this.loaderArray=[];
     this.state = this.STATE_WAIT;
     this.loadData = false;
     this.currentLabelObj = null;
     this.loaderLeftPosition =0;
     this.listOfIndexes = [];
     this.listOfTitles  = [];
     this.imageCount =0;
     this.openLabels=0;
     
     
     this.actvityId   = VLE.get_param("activity_id") || VLE.get_param("_a");
     this.documentId  = VLE.get_param("document_id") || VLE.get_param("_i");
     this.courseId    = VLE.get_param("course_id")   || VLE.get_param("_c");
     this.previous_values; // Pass to VLE.set_server_dat as 'undefined' unless
   
     this.scaleDefs={"containerDiv":"mainDiv","originalWidth":800,"originalHeight":650};
          
     
     OULib.utils.addEvent(document,"keydown",function(event){return OULib.disableWindowScrolling(event);});
     OULib.utils.addEvent(document,"keydown",function(event){self.keyHandler(event);});
  
  
     //get and store domObjects
     
     
     this.createLabels("leftSideId");
     this.createLabels("rightSideId");
     
    
       
  
     OULib.utils.addEvent(document.getElementById("addButtonId"),"click",function(){self.addLabel();});
     OULib.utils.addEvent(document.getElementById("updateButtonId"),"click",function(){self.updateLabel();});
     OULib.utils.addEvent(document.getElementById("deleteButtonId"),"click",function(){self.deleteLabel();});
     OULib.utils.addEvent(document.getElementById("cancelButtonId"),"click",function(){self.closePopup(true);});
     
     OULib.utils.addEvent(document.getElementById("masterEditId"),"click",function(){self.editOptions();});
     OULib.utils.addEvent(document.getElementById("doneButtonId"),"click",function(){self.finishEditPopup();});
     OULib.utils.addEvent(document.getElementById("editCancelButtonId"),"click",function(){self.closeEditPopup(true);});
     OULib.utils.addEvent(document.getElementById("clearAllButtonId"),"click",function(){self.editClearAllForces(true);});
     OULib.utils.addEvent(document.getElementById("clearCheckBoxId"),"click",function(){self.editClearCheckBox(true);});
     
     OULib.utils.addEvent(document.getElementById("fileMenuIconId"),"click",function(){self.showFileMenu();});
     OULib.utils.addEvent(document.getElementById("fileCancelButtonId"),"click",function(){self.closeFilePopup(true);});
     OULib.utils.addEvent(document.getElementById("fileNewButtonId"),"click",function(){self.createNewForceField(true);});
     OULib.utils.addEvent(document.getElementById("loadFileId"),"change",function(){self.fileLoadForceField(true);});
     
     
     
       this.forceFieldLoadImages();
     
     
     
 }; 
 
 
 
 /**
 * add all th eimages from the data to the cache div as individual img elements.
 * then attach an onload event which calls loaderUpdate.
 * A count is created to store the number of images to load
 * 
 * 
 * @memberof ou_forcefield#
 */
 
 forcefield.prototype.forceFieldLoadImages = function(){
   
   var cacheDiv = document.getElementById("cache"), self = this;
   
   for (var count=0;count<this.data.img.length;count++){
       var elm = document.createElement("img");
       elm.onload = function(){self.loaderUpdate();};
       elm.src = this.data.imgDir+this.data.img[count];
       cacheDiv.appendChild(elm);
       this.imageCount++;
   }
   this.loaderAnimation();
 };
 
 
 
 /**
  *  each time this function is called (i.e. when an image has loaded
  *  decrement the number of image count. If the count is zero start the 
  *  activity
  * 
  * @memberof ou_forcefield#
  **/
 forcefield.prototype.loaderUpdate = function(){
   var self = this;
    this.imageCount--;
    if (this.imageCount<=0){
        
         if (this.data.fileMenu===true){
            this.loadFileIndex();
         }else{
             this.load();
         }
        
         document.getElementById("LoadingDiv").style.visibility="hidden";
         document.getElementById("mainDiv").style.visibility="visible";
         if (this.data.fileMenu === true){
            document.getElementById("fileMenuIconId").style.visibility = "visible";
        }
         requestAnimationFrame(function(){self.states();});
         
    }
 };
 
  /**
  *  anmimate the loading screeen using css styles
  * 
  * @memberof ou_forcefield#
  **/
forcefield.prototype.loaderAnimation = function(){
    
    var self = this,
         progressBarWidth  =  document.getElementById("progressBarId").offsetWidth;
     
     this.loaderLeftPosition+=4;
     
     if (this.loaderLeftPosition>progressBarWidth){
       
         this.loaderLeftPosition=-document.getElementById("progressBarAnimId").offsetWidth;
     }
       
     document.getElementById("progressBarAnimId").style.left = this.loaderLeftPosition+"px";
     requestAnimationFrame(function(){self.loaderAnimation();});
};
 
 
 
 
  /**
  *  function to load an exisiting force field. The file index is saved so that 
  *  the currently selected force field is remember on reload
  * 
  * @memberof ou_forcefield#
  **/
  forcefield.prototype.fileLoadForceField = function(){
     
     var elm = document.getElementById("loadFileId");
     this.SaveIdx= elm.options[elm.selectedIndex].value;
            
      
      this.saveFileIndex();
      
      this.deleteAllForces();
      
      this.closeFilePopup();
      
      this.load();
      
     
      
      
  };
 
 /**
  *  Create a new force field. Check that the unqiue id doesn't exist.
  *  Save the file index
  *  Delete all the existing forces
  * 
  * @memberof ou_forcefield#
  **/
 forcefield.prototype.createNewForceField = function(){
   
   var id =0, count=0, title="";
   
   title = document.getElementById("titleFileId").value;
   
  
   
   
   if (this.listOfIndexes.length > 0 ){
    for (count=0;count<this.listOfIndexes.length; count++){
        if (this.listOfIndexes[count] === id){
            count=0;
            id++;
        }
    }
   }
   
 
   
   this.listOfIndexes[count]=id;
   this.listOfTitles[count]=title;
   this.SaveIdx = id;
   
   
   
   this.saveFileIndex();
   
   this.deleteAllForces();
   
   document.getElementById("theTitleId").innerHTML= title;
   
   this.save();
   
   this.closeFilePopup();
   
 };
 
 /**
  * Show the file menu popup dialog.
  * 
  * the exisitng force field drop down will only display
  * if more than 1 force exisits
  * 
  * @memberof ou_forcefield#
  */
 forcefield.prototype.showFileMenu =  function(){
   
    var divId = document.getElementById("popupFileWinId"), count=0; 
    

    
    if(this.state === this.STATE_WAIT){
        
  
        
        while(document.getElementById("loadFileId").options.length)
        {
            document.getElementById("loadFileId").remove(0);
        }
        
        
        for (count=0;count<this.listOfIndexes.length; count++){
            var opt = document.createElement('option');
            opt.value = this.listOfIndexes[count];
            opt.innerHTML = this.listOfTitles[count];
            document.getElementById("loadFileId").appendChild(opt);
            
            if(parseInt(this.SaveIdx) === parseInt(this.listOfIndexes[count])){
                document.getElementById("loadFileId").selectedIndex = count;
            }

        }
        if( count<=1){
            document.getElementById("loadingAreaId").style.visibility = "hidden";
            document.getElementById("loadHrId").style.visibility = "hidden";
        }else{
            document.getElementById("loadingAreaId").style.visibility = "visible";
            document.getElementById("loadHrId").style.visibility = "visible";
        }
        divId.style.visibility = "visible";
        document.getElementById("titleFileId").value = "";
        document.getElementById("titleFileId").focus();
        
    }
     
 };
 
 /**
  * Hides the relevant divs
  * 
  * @memberof ou_forcefield
  */
 forcefield.prototype.closeFilePopup =  function(){
   
    var divId = document.getElementById("popupFileWinId"); 
    
    divId.style.visibility = "hidden";
    
    document.getElementById("loadingAreaId").style.visibility = "hidden";
    document.getElementById("loadHrId").style.visibility = "hidden";
     
 };
 
 
 
 /**
  *  Hides or show the clear all forces button depending if the check box is 
  *  checked or not
  *  
  *  @memberof ou_forcefield
  */
 forcefield.prototype.editClearCheckBox = function(){
     if (document.getElementById("clearCheckBoxId").checked===true){
        document.getElementById("clearAllButtonId").disabled = false;
     }else{
        document.getElementById("clearAllButtonId").disabled = true;
     }
 };
 
 
 
 /**
  *  Save and close when the edit popup is closed. 
  *  This function is not called if the cancel button is pressed
  *  
  *  @memberof ou_forcefield
  */ 
forcefield.prototype.finishEditPopup =  function(){
   
    
    document.getElementById("theTitleId").innerHTML = document.getElementById("titleEntryId").value;
    
    this.save();
    
    this.closeEditPopup();
    
     
 };
 
  /**
  *  Hides the relevant divs
  *  
  *  @memberof ou_forcefield
  */
forcefield.prototype.closeEditPopup =  function(){
   
    var divId = document.getElementById("popupEditWinId"); 
    
    divId.style.visibility = "hidden";
    document.getElementById("clearAllButtonId").disabled = true;
    document.getElementById("clearCheckBoxId").checked = false;
     
 };
 
 
  /**
  *  After loading the data from storage, this function loads the 
  *  arrays with the relevant data. And set the relevant state.
  *  @param {object} values - array of values
  *  @memberof ou_forcefield
  */
 forcefield.prototype.populateForceField = function(values) {
   
    var key;
    var id = this.id+this.SaveIdx;
    var weightCheck=0;
    
     for (key in values) {
     if (values.hasOwnProperty(key)){
         OULib.trace("key:"+key+" label:"+values[key].label+
                 " weightIndex:"+values[key].weightIndex+
                 " weightSelectIndex:"+values[key].weightSelectIndex +
                 " probabilityIndex:"+values[key].probabilityIndex+
                 " probabilitySelectIndex:"+values[key].probabilitySelectIndex +
                 "divIdx:"+values[key].divIndex,
                 "open:"+values[key].open);
         if ((id+"title")===key){
             document.getElementById("theTitleId").innerHTML = values[key].title;
         }else{
          
             this.loaderArray.push(values[key]);
             weightCheck +=values[key].weightIndex;
         }
         
            this.state = this.STATE_LOAD;
            this.loadData = true;
         
     }
     
    }

        if (weightCheck===0)
        {
            this.deleteAllForces();
            this.state = this.STATE_MOVE_ALL_FORCES;
            this.loadData = false;
          
         }
 };
 
 
 /**
  *  Clear the relevant data when deleting all the forces. And set the correct
  *   state
  *  
  *  @memberof ou_forcefield
  */
forcefield.prototype.deleteAllForces = function(){  
  
    this.editClearAllForcesSide("leftSideId");
    this.editClearAllForcesSide("rightSideId");

    this.openLabels=0;
    this.leftForce  = 0; 
    this.rightForce = 0;

    this.targetPosition  = 400;

    this.currentLabelObj = null;
    this.state = this.STATE_MOVE_ALL_FORCES;
};


 /**
  * Clear all the forces, save the data and close the edit popup
  *  
  *  @memberof ou_forcefield
  */
forcefield.prototype.editClearAllForces = function(){
     
    this.deleteAllForces();

    this.save();

    this.closeEditPopup();
  
    
};
 

 /**
  *  This function clears the forces from the defined side, either left or right
  *  div. All data is nulled or set to zero. It iterates through all the forces
  *  on the defined side.
  *  @param {string} id - div id of the side
  *  @memberof ou_forcefield
  */
 forcefield.prototype.editClearAllForcesSide = function(id){
     var divId = document.getElementById(id).getElementsByTagName("div");
  
    
     for (var count=0;count<divId.length;count++){
         
         if(count%2 === 0){
             
  
            divId[count].style.width="44px";
            divId[count].weightIndex = 0;
            divId[count].weightSelectIndex = 0;
            divId[count].probabilityIndex = 0;
            divId[count].probabilitySelectIndex = 0;
            divId[count].value = 0;
            divId[count].open = false;  
            
            if (divId[count].parentNode.id === "leftSideId"){
                divId[count].style.backgroundImage = "url('graphics/arrow_left.png')";
            }else{
                divId[count].style.backgroundImage = "url('graphics/arrow_right.png')";
            }
    
            divId[count].getElementsByTagName("div")[0].getElementsByTagName("a")[0].innerHTML="&nbsp;";
            
    
         }
     }
     
 };

  /**
  *  Show the edit options popup only if a forces animation is NOT running.
  *  
  *  @memberof ou_forcefield
  */
 forcefield.prototype.editOptions =  function(){
   
    var divId = document.getElementById("popupEditWinId"); 
    
    if(this.state === this.STATE_WAIT){
        document.getElementById("clearAllButtonId").disabled = true;
        document.getElementById("titleEntryId").value=document.getElementById("theTitleId").innerHTML;
        divId.style.visibility = "visible";
    }
     
 };
 
 
  /**
  *  Populate the local array which contains a list of exisiting force fields.
  *  This function is called after loading the data from the storage device.
  *  
  *  @param {object} values - array of values
  *  @memberof ou_forcefield
  */
 forcefield.prototype.populateFileIndex = function(values) {
   
   
    var id = this.id+"Index";
    
   
    this.SaveIdx="";
    
    for (var count=0;count<values[id].indexs.length;count++){
        this.listOfIndexes[count] = values[id].indexs[count];
       
    }
    for (var count=0;count<values[id].title.length;count++){
        this.listOfTitles[count] = values[id].title[count];
     
    }
    
      
    this.SaveIdx = values[id].defaultFF;
    
         this.load();
    
     
 };
 
 
/**
 * Call VLE storgae or local storage to recover any data. This loads 
 * an index of all exisiting forcefields
 * 
 * 
 * @memberof ou_forcefield
 */
forcefield.prototype.loadFileIndex = function() {

     var user = true, values, parsedObj, vleValues={}, elm=[];
     var id = this.id+"Index";
     var self = this;
      
     elm[0]=id;
     
       
     VLE.get_server_data(user, elm, function(values) {
            var count=0, key;
            
            
            OULib.trace("loaded");  
            if (values){
              
                for (key in values) {
                    if (values.hasOwnProperty(key)){
                         OULib.trace("Index"+count+":"+key+":"+values[key]);
                         if (values[key]!== ""){
                             vleValues[key] = JSON.parse(values[key]);
                             
                         }else{
                             self.showFileMenu();
                             return;
                         }
                         OULib.trace("vleValues Index"+count+":"+key+":"+vleValues[key]);
                    }
                    count++;
                }
               self.populateFileIndex(vleValues);
            }else{
               
               self.showFileMenu();
                
            }
            
            
        }, function(msg) {
            OULib.trace('Use localstorage : ' + msg);
       
            values = localStorage.getItem(id);
            if (values){
                parsedObj = JSON.parse(values);
                self.populateFileIndex(parsedObj);
            }else{
                
                self.showFileMenu();
            }
            
        }, this.actvityId, this.documentId, this.courseId);
    
};
 
 /**
 * Call VLE storgae or local storage to save any data. This saves
 * all indexes of the forcefields
 * 
 * 
 * @memberof ou_forcefield
 */
 forcefield.prototype.saveFileIndex = function() {

       var user = true, values={},  key, vleValues={};
       var id = this.id+"Index";
       
      
       
       values[id]={"indexs":this.listOfIndexes,"title":this.listOfTitles,"defaultFF":this.SaveIdx};
        
        for (key in values) {
            if (values.hasOwnProperty(key)){
                //We need to stringify each element taht contains any objects
                vleValues[key] = JSON.stringify(values[key]);
                OULib.trace(key+":"+vleValues[key]);
            }
           
        }
       
        VLE.set_server_data(user, vleValues, function() {
            OULib.trace('Saved OK');
        }, function(msg) {
           OULib.trace('Use localstorage : ' + msg);
            localStorage.setItem(id, JSON.stringify(values));
        }, this.previous_values, null, this.actvityId, this.documentId, this.courseId);
        
        
       

};
 
/**
 * Call VLE storgae or local storage to recover any data. This loads 
 * the current force fields data
 * 
 * 
 * @memberof ou_forcefield
 */
forcefield.prototype.load = function() {

     var user = true, values, parsedObj, vleValues={}, elm=[], count, subcount;
      var id = this.id+this.SaveIdx;
      var self = this;
      
       var divLeftId = document.getElementById("leftSideId").getElementsByTagName("div");
       var divRightId = document.getElementById("rightSideId").getElementsByTagName("div");
        
        for (count=0; count <divLeftId.length/2; count++){
            
            elm[count]=id+"LS"+(count*2);
          
        }
        subcount = count;
        for (count=0; count<divRightId.length/2; count++){
            
            elm[count+subcount]=id+"RS"+(count*2);
           
        }
        count+=subcount;
        
        elm[count]=id+"title";
           
    
        VLE.get_server_data(user, elm, function(values) {
            var count=0, key;
            
       
            for (key in values) {
                if (values.hasOwnProperty(key)){
                     OULib.trace("Index"+count+":"+key+":"+values[key]);
                     vleValues[key] = JSON.parse(values[key]);
                     OULib.trace("vleValues Index"+count+":"+key+":"+vleValues[key]);
                }
                count++;
            }
            OULib.trace("loaded");  
            if (values){
               self.populateForceField(vleValues);
            }
            
            
        }, function(msg) {
            OULib.trace('Use localstorage : ' + msg);
           
            values = localStorage.getItem(id);
            if (values){
                parsedObj = JSON.parse(values);
                self.populateForceField(parsedObj);
            }
            
        }, this.actvityId, this.documentId, this.courseId);
    
};

/**
 * Call VLE storgae or local storage to save any data. This saves 
 * the current force fields data
 * 
 * 
 * @memberof ou_forcefield
 */
forcefield.prototype.save = function() {

       var user = true, values={}, count=0, key, vleValues={};
       var id = this.id+this.SaveIdx;
       var divLeftId = document.getElementById("leftSideId").getElementsByTagName("div");
       var divRightId = document.getElementById("rightSideId").getElementsByTagName("div");
        
        for (count=0; count <divLeftId.length; count++){
           
           if (count%2===0){
                values[(id+"LS"+count)]={"label":divLeftId[count].getElementsByTagName("a")[0].innerHTML,
                         "weightIndex":divLeftId[count].weightIndex,
                         "weightSelectIndex":divLeftId[count].weightSelectIndex,
                         "probabilityIndex":divLeftId[count].probabilityIndex,
                         "probabilitySelectIndex":divLeftId[count].probabilitySelectIndex,
                         "divIndex":count,
                         "parent":"leftSideId",
                         "open":divLeftId[count].open};
           }
         
        }
        for (count=0; count <divRightId.length; count++){
         
                if (count%2===0){
                    values[(id+"RS"+count)]={"label":divRightId[count].getElementsByTagName("a")[0].innerHTML,
                         "weightIndex":divRightId[count].weightIndex,
                         "weightSelectIndex":divRightId[count].weightSelectIndex,
                         "probabilityIndex":divRightId[count].probabilityIndex,
                         "probabilitySelectIndex":divRightId[count].probabilitySelectIndex,
                         "divIndex":count,
                         "parent":"rightSideId",
                         "open":divRightId[count].open};
                }
        }
        
        values[(id+"title")]={"title":document.getElementById("theTitleId").innerHTML};
        
        for (key in values) {
            if (values.hasOwnProperty(key)){
                //We need to stringify each element taht contains any objects
                vleValues[key] = JSON.stringify(values[key]);
                OULib.trace(key+":"+vleValues[key]);
            }
           
        }
       
        VLE.set_server_data(user, vleValues, function() {
            OULib.trace('Saved OK');
        }, function(msg) {
           OULib.trace('Use localstorage : ' + msg);
            localStorage.setItem(id, JSON.stringify(values));
        }, this.previous_values, null, this.actvityId, this.documentId, this.courseId);
        
        
       

};


/**
 * Called via the state machine and it used to display the current force after
 *  loading the data
 * 
 * 
 * @memberof ou_forcefield
 */
forcefield.prototype.loadAddForce = function() {

    var obj = {}, divs, nValue=0;

OULib.trace("array length"+this.loaderArray.length);
    if (this.loaderArray.length>0){
        obj = this.loaderArray.shift();
        
        if (obj.open === true){
            divs = document.getElementById(obj.parent).getElementsByTagName("div");

            this.currentLabelObj = divs[obj.divIndex];
            this.currentLabelObj.weightIndex = obj.weightIndex;
            this.currentLabelObj.weightSelectIndex = obj.weightSelectIndex;
            this.currentLabelObj.probabilityIndex = obj.probabilityIndex;
            this.currentLabelObj.probabilitySelectIndex = obj.probabilitySelectIndex;
            OULib.trace ("this.currentLabelObj.weightSelectIndex:"+this.currentLabelObj.weightSelectIndex);
            this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].innerHTML = obj.label;
            this.currentLabelObj.open = true;


            nValue = parseInt(this.currentLabelObj.weightIndex) * (this.currentLabelObj.probabilityIndex/100);

            this.setLabel(nValue);
            this.calculateBarPosition(this.STATE_FORCE_TO_MIDDLE);
            
            this.openLabels++;
        }
        
    }else{
       this.loadData = false;
       this.state  = this.STATE_WAIT;
    }
    
   
};
 
 
 /**
 * The state machine which is called every 16fps. Gerally it handles 
 * the animation of the forces when required
 * 
 * 
 * @memberof ou_forcefield
 */
 // All actions should go through here but we really are only concerned with the animation for now
forcefield.prototype.states = function() {
    
    var self = this;
       
    switch (this.state){
        
        case this.STATE_WAIT:{
                //do nothing
                break;
        }
        case this.STATE_LOAD:{
                this.loadAddForce();
                break;
        }
        case this.STATE_FORCE_TO_MIDDLE:{
                
                if (this.loadData===true){
                    this.currentBarPosition+=6;
                }else{
                    this.currentBarPosition+=2;
                }
                
                
                if (this.currentBarPosition>=100){
                    this.currentBarPosition=10;
                    this.currentLabelObj.style.width="100%";               
                    this.state = this.STATE_MOVE_ALL_FORCES;   
                }else{
                    this.currentLabelObj.style.width=this.currentBarPosition+"%";               
                }
                break;
        }
        case this.STATE_MOVE_ALL_FORCES:{
                if (this.loadData===true){
                    this.currentPosition+=(this.direction*6);
                }else{
                    this.currentPosition+=(this.direction*2);
                }
                
                if ((this.direction<0 && (this.currentPosition<=this.targetPosition)) ||
                   (this.direction>0 && (this.currentPosition>=this.targetPosition))){
                    this.currentPosition=this.targetPosition;
                    if (this.loadData===false){
                        this.state = this.STATE_WAIT;
                    }else{
                        this.state = this.STATE_LOAD;
                    }
                    this.currentLabelObj = null;
                }
                
                this.updateOutcome();
                
                document.getElementById("leftSideId").style.width   =this.currentPosition+"px";
                document.getElementById("rightSideId").style.width  =(800-this.currentPosition)+"px";
                document.getElementById("middleId").style.left      =(this.currentPosition-20)+"px";

                break;
        }
        default:
            OULib.trace("state arror;");
    }
  
   
   requestAnimationFrame(function(){self.states();});
   
  };
 
 /**
 * Adds a force to the specified side
 * 
 * @param {string} id - id of the side for which the force is to added, i.e. 
 * left or right
 * @memberof ou_forcefield
 */
 forcefield.prototype.createLabels = function(id) {
   
   var divId = document.getElementById(id).getElementsByTagName("div");
   var funcs = [];
   
     for (var count=0;count<divId.length;count++){
         
         if(count%2 === 0){
             
            funcs[count] = this.createfunc(divId[count]);

            divId[count].style.width="44px";
            
            divId[count].weightIndex = 0;
            divId[count].weightSelectIndex = 0;
            divId[count].probabilityIndex = 0;
            divId[count].probabilitySelectIndex = 0;
            divId[count].value = 0;
            divId[count].open = false;  
            OULib.utils.addEvent(divId[count],"click",funcs[count]); 
            
    
         }
     }
     
 };
 

/**
 * Closure used when adding a force to the field
 * 
 * @param {object} obj force to be added
 * @memberof ou_forcefield
 */
 forcefield.prototype.createfunc = function(obj) {
    var self = this;
    return function() {  self.initForce(obj);};
};
 
/**
 * Initialisation function for a new force, called via the closure createfunc
 * 
 * @param {object} obj force to be added
 * @memberof ou_forcefield
 */
 forcefield.prototype.initForce = function (obj){
     
     if (this.state!==this.STATE_WAIT){return;}
     
     this.currentLabelObj = obj;
     
     if ( this.currentLabelObj.open===true){
        document.getElementById("labelEntryId").value = this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].innerHTML;
        document.getElementById("addButtonId").style.visibility="hidden";
        document.getElementById("addButtonId").style.width = "0px";
        
        document.getElementById("deleteButtonId").style.visibility="visible"; 
        document.getElementById("updateButtonId").style.visibility="visible"; 
        
        document.getElementById("deleteButtonId").style.width = "80px";
        document.getElementById("updateButtonId").style.width = "80px";
        
     }else{
        document.getElementById("labelEntryId").value = "";
        document.getElementById("addButtonId").style.visibility="visible";
        document.getElementById("addButtonId").style.width = "80px";
        
        document.getElementById("deleteButtonId").style.visibility="hidden"; 
        document.getElementById("updateButtonId").style.visibility="hidden"; 
        
        document.getElementById("deleteButtonId").style.width = "0px";
        document.getElementById("updateButtonId").style.width = "0px";
       
     }
     
     document.getElementById('weightEntryId').selectedIndex = this.currentLabelObj.weightSelectIndex;
     document.getElementById('probabilityEntryId').selectedIndex = this.currentLabelObj.probabilitySelectIndex;
     document.getElementById('popupWinId').style.visibility='visible';
     document.getElementById("labelEntryId").focus();
   
 };


/**
 * function which adds a force, also known as a label
 * 
 * @memberof ou_forcefield
 */
forcefield.prototype.addLabel = function (){
   
    this.openLabels++;
    
    this.currentLabelObj.open=true;
    this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].innerHTML=document.getElementById("labelEntryId").value;
    this.updateForces(true,false);
    this.closePopup(false);
    
    
};

/**
 * update the selected force, also known as a label
 * 
 * @memberof ou_forcefield
 */
forcefield.prototype.updateLabel = function (){
    
   
    
    this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].innerHTML=document.getElementById("labelEntryId").value;
    this.updateForces(false,false);
    this.closePopup(false);
};

/**
 * function called to update the scale text and position of the text so taht it
 *  matches the middle bar or down arrow
 * 
 * @memberof ou_forcefield
 */
forcefield.prototype.updateOutcome = function(){
  
    var divId = document.getElementById("outcomeId");
    var val = ((this.currentPosition-100)/600)*100;
   
   
    divId.style.left = (this.currentPosition-110)+"px";
    divId.innerHTML = "Outcome:"+val.toFixed(0)+"%";
    
};



/**
 * Updates all the forces on the screen due to the new force, a deleted force
 * or an updated one.
 * 
 * @param {boolean} bAdd - set to true if a new force has been added
 * @param {boolean} bDelete - set to true if a force has been deleted
 * @memberof ou_forcefield
 */
forcefield.prototype.updateForces = function(bAdd, bDelete){
    
    var weight = document.getElementById('weightEntryId').options[document.getElementById('weightEntryId').selectedIndex].value;
    var probability = document.getElementById('probabilityEntryId').options[document.getElementById('probabilityEntryId').selectedIndex].value;
   
    
   
    var nValue = parseInt(weight) * (parseInt(probability)/100);
    var nextState = this.STATE_WAIT;
    
    if (bAdd === false){
     
        if (this.currentLabelObj.value === nValue){
            nextState = this.STATE_WAIT;         
        }else{
            nextState = this.STATE_MOVE_ALL_FORCES;         
        }
        
        if (this.currentLabelObj.parentNode.id === "leftSideId"){
              
            this.leftForce  -= this.currentLabelObj.value;
        }else{
            
            this.rightForce -= this.currentLabelObj.value;
        }
      
     }else{
         nextState = this.STATE_FORCE_TO_MIDDLE;
     }
    
    
    if (bDelete===false){
        this.currentLabelObj.weightIndex = weight;
        this.currentLabelObj.probabilityIndex = probability;
        this.currentLabelObj.weightSelectIndex = document.getElementById('weightEntryId').selectedIndex;
        this.currentLabelObj.probabilitySelectIndex = document.getElementById('probabilityEntryId').selectedIndex;
        this.setLabel(nValue);
    }
    
    this.calculateBarPosition(nextState);
    
  };   

/**
 * Set the strength of the force, which includes setting the correct image
 * and colour of the text
 * 
 * @param {integer} nValue - value of the force AKA label
 * @memberof ou_forcefield
 */
  forcefield.prototype.setLabel = function (nValue){
        this.currentLabelObj.value = nValue;
        

        if (this.currentLabelObj.parentNode.id === "leftSideId"){
            this.currentLabelObj.style.backgroundImage = "url('graphics/arrow_left_"+Math.ceil(nValue)+".png')";
        }else{
            this.currentLabelObj.style.backgroundImage = "url('graphics/arrow_right_"+Math.ceil(nValue)+".png')";
        }
        
         if (Math.ceil(nValue>2)){
            this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].style.textShadow="0px 1px black";
            this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].style.color="white";
            
        }else{
            this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].style.textShadow="0px 1px white";
            this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].style.color="black";
            
        }


        if (this.currentLabelObj.parentNode.id === "leftSideId"){
            this.leftForce += this.currentLabelObj.value;
        }else{
            this.rightForce+= this.currentLabelObj.value;
        }
    };
   
 /**
 * Calculate the position of the middle bar
 * @param {integer} nextState - the next state to be set
 * @memberof ou_forcefield
 */
 forcefield.prototype.calculateBarPosition = function (nextState){   
    //Now Calculate
    
  
    
    this.targetPosition  = (this.leftForce / ((this.leftForce + this.rightForce) / 600))+100;
    this.direction=(this.currentPosition<this.targetPosition)?1:-1;
    
    this.state = nextState;
     
};

 /**
 * Deletes the selected label and any associated data
 * 
 * @memberof ou_forcefield
 */
forcefield.prototype.deleteLabel = function (){
    
    
    this.updateForces(false,true);
    
    this.state = this.STATE_MOVE_ALL_FORCES;
 
    OULib.trace(this.currentPosition+","+this.targetPosition);
 
    this.currentLabelObj.style.width="44px";
    this.currentLabelObj.open=false;
    
    if (this.currentLabelObj.parentNode.id === "leftSideId"){
        this.currentLabelObj.style.backgroundImage = "url('graphics/arrow_left.png')";
    }else{
        this.currentLabelObj.style.backgroundImage = "url('graphics/arrow_right.png')";
    }
    
    this.currentLabelObj.weightIndex = 0;
    this.currentLabelObj.weightSelectIndex = 0;
    this.currentLabelObj.probabilityIndex = 0;
    this.currentLabelObj.probabilitySelectIndex = 0;
    this.currentLabelObj.value = 0;
    
    this.currentLabelObj.getElementsByTagName("div")[0].getElementsByTagName("a")[0].innerHTML="&nbsp;";
    
    
    this.openLabels--;
    if (this.openLabels<=0){
        this.openLabels=0;
        this.leftForce  = 0; 
        this.rightForce = 0;
        this.targetPosition  = 400;
        this.currentLabelObj = null;
        this.state = this.STATE_MOVE_ALL_FORCES;
    }
    
    this.closePopup(false);
};

 /**
 * Close the edit popup
 * @param {boolean} bCancel - if false save the current data
 * @memberof ou_forcefield
 */
forcefield.prototype.closePopup = function (bCancel){
    
    document.getElementById("addButtonId").style.visibility="hidden";
    document.getElementById("deleteButtonId").style.visibility="hidden"; 
    document.getElementById("updateButtonId").style.visibility="hidden"; 
    document.getElementById('popupWinId').style.visibility='hidden';
    
    if (bCancel===false){this.save();}
        
};


/**
 *  Prevenst the defualt action of the event
  * @param e 
  * @memberof ou_forcefield
  */
 forcefield.prototype.preventDef = function (e){
     e = e || window.event;
     if (OULib.isIE8 === false){
        e.preventDefault();
    }
    return false;
 };
 
 


/**
 * Handle the key events
 * @param {event} evt
 * @memberof hsc_forcefield#
 */
 forcefield.prototype.keyHandler  = function(evt){
          
    var keyCode=OULib.getKeyCode(evt);
                 
    OULib.trace("keyCode:"+keyCode);
          
  
    switch (keyCode)
    {
      
       case OULib.KEY_RIGHT_ARROW:
           break;
       case OULib.KEY_LEFT_ARROW:
           break; 
    }
       
  };
 

 return forcefield;
}());  

/**
 * @var {ou_forcefield} k313_forcefield
 */
var k313_forcefield = new ou_forcefield(data); 


