// Namespace container object for the Tool object and other utils
if (TOOL === undefined) {
	var TOOL = {};
}

/**
 * Constructor for a Tool object
 * @param {Number} position The position of this tool in the tiles array, kept
 *         in the toolkit object
 */
TOOL.Tool = function (position) {
	var links = document.getElementsByTagName("a"),
	    iframes = document.getElementsByTagName("iframe"),
	    i = 0,
	    i_iframes = 0,
	    position = position || 0,
	    max = links.length,
	    max_iframes = iframes.length,
	    iframe = window.frameElement,
	    iframe_height = document.body.getAttribute("height"),
	    favourites_container = document.getElementById('favourites_container'),	
	    that = this;
	
	this.toolkit_data_name = 'tk-k313';
	this.tiles_data = [];
	this.favourites_data = []; // Will store saved data on all tools' favourites status
	this.position = position; // This tools position in favourites_data above
	this.course_id = VLE.get_param('course_id') || VLE.get_param('_c');	
	this.document_id = VLE.get_param('document_id') || VLE.get_param('_i');	
	this.activity_id = VLE.get_param('activity_id') || VLE.get_param('_a');
	
	// Append params to any links of iframes in this html
	for (i = 0; i < max; i += 1) {
		links.item(i).href += window.location.search;
	}
	for (; i_iframes < max_iframes; i_iframes += 1) {
		iframes.item(i_iframes).src += window.location.search;
	}
	
	if (iframe !== null && iframe_height !== null) {		
		iframe.height = iframe_height;	
	}
	
	// Do some stuff for the comments sub-page only
	if (favourites_container !== null) {
		// Attach event listeners
		if (typeof window.addEventListener === 'function') {			
			favourites_container.addEventListener('click', function (e) {
				    return that.setFavouriteStatus(e, that);
				}, false);			
		} else if (typeof document.attachEvent === 'function') {
			favourites_container.attachEvent('onclick', function (e) {
			    return that.setFavouriteStatus(e, that);
			});			
		} else {
			favourites_container.onclick = function (e) {
				return that.setFavouriteStatus(e, that);
			};
		}
		VLE.get_server_data(true, [that.toolkit_data_name],
		    function (values) {
			    var local_data = '';
			    if (values[that.toolkit_data_name] !== '') {
			    	local_data = values[that.toolkit_data_name];
			    	that.tiles_data = local_data.split(';')[0].split(',');
				    that.favourites_data = local_data.split(';')[1].split(',');
			        if (that.isToolFavourite(that)) {
			        	that.toggleFavouriteIndicators();
			        }
			    }			
		    },
		    function (message) {
			    var local_data = '';			
			    if (message === null) {
				    if (window.localStorage) {
					    local_data = window.localStorage.getItem(that.toolkit_data_name);
					    if (local_data !== null) {
					    	that.tiles_data = local_data.split(';')[0].split(',');					    	
					        that.favourites_data = local_data.split(';')[1].split(',');
					        if (that.isToolFavourite(that)) {
					        	that.toggleFavouriteIndicators();
					        }
					    }					
				    }		
			    }		
		    }, that.activity_id, that.document_id, that.course_id);		
	}	
};

/**
 * Determines if this tool is a favourite
 * @param {Object} that This object
 * @return {Boolean} True/false is fav or not
 */
TOOL.Tool.prototype.isToolFavourite = function (that) {
	var is_fav = false;
	if (parseInt(that.favourites_data[that.position], 10)) {	
		is_fav = true;
	}
	return is_fav;
};

/**
 * Toggles the state of the checkbox and image that indicates whether
 * not this is a favourite tool
 */
TOOL.Tool.prototype.toggleFavouriteIndicators = function () {
    var favourites_widgets = document.getElementById('favourites_container'),
        star_image = favourites_widgets.querySelector('img'),
        checkbox = favourites_widgets.querySelector('input');

    if (star_image.src.indexOf('white') === -1) {
    	star_image.src = '../star_rating_white-1.0.png';
    	checkbox.checked = false;
    } else {
    	star_image.src = '../star_rating_yellow-1.0.png';
    	checkbox.checked = true;
    }    
};

/**
 * Set data to indicate whether this tool is a favourite or not also
 * sets defauls for any other tools that aren't yet in the shared data
 * @param {Object} e The event object
 * @param {Object} that This object
 */
TOOL.Tool.prototype.setFavouriteStatus = function (e, that) {
    var e = e || window.event,
        target = e.target || e.srcElement,
        i = 0,
        string_to_save = '',
        data_name = that.toolkit_data_name,
        vle_data = {},
        previous_values;
 
    if (target.nodeName === 'IMG' || target.nodeName === 'INPUT') {
        for (; i <= that.position; i += 1) {      	
            if (typeof that.favourites_data[i] === 'undefined') {         	
                if (i === that.position) {
                	that.favourites_data[i] = '1';
                }  else {
                	that.favourites_data[i] = '0';
                }
            } else {
                if (i === that.position) {               	
                	if (parseInt(that.favourites_data[i], 10)) {
                		that.favourites_data[i] = '0';
                	} else {
                		that.favourites_data[i] = '1';
                	}
                }              	
            }
        }
        // Pack it all back up to pass back to the database
        string_to_save = that.tiles_data.join();
        string_to_save += ';'
        string_to_save += that.favourites_data.join();
        vle_data[data_name] = string_to_save;       
        VLE.set_server_data(true, vle_data,
            function () {
        	    // Do nothing as it worked OK...      	
            },
            function (message) {         	
               if (message === null) {
                   if (window.localStorage) {
                	   window.localStorage.setItem(data_name, string_to_save);
                   }       	   
               } else {
                   alert(message);            	   
               }	
            }, previous_values, null, that.activity_id, that.document_id, that.course_id);
        
        that.toggleFavouriteIndicators();        
    }   
};

document.body.className = "faded";