var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:0,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<div class=\"shadow-r\"></div>Perceived stress perspective",
            content:"<div class=\"box\"><p class=\"n-m-t\">The focus of this approach to burnout is stress. Proponents of this approach (e.g. Gould et al. (1997); Smith’s Cognitive–Affective Model of Athletic Burnout (1986)) argue that stress is said to occur when an individual’s <i><b>perceptions</b></i> of the <i><b>demands of a situation </b></i>(e.g. training requirements, competition preparation, commitments outside of sport) outweigh what his/her <i><b>perceived resources </b></i>can handle (e.g. abilities, coping skills, support network). Burnout occurs when such <i><b>stress is experienced for a prolonged period </b></i>of time. </p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div>Overtraining perspective",
            content:"<div class=\"box\"><p class=\"n-m-t\">For some, burnout is thought of in more physical terms. Here it is the result of doing too much training with inadequate recovery periods. Research using this perspective identifies any exhaustion and subsequent burnout as the product of an accumulating imbalance between stress and adequate recovery. For example, Kellmann (2002) and other proponents would consider physiological and psychological aspects of Barker’s adaptation to training demands with a particular interest in the quality of any recovery strategies used and the extent of overtraining. This is explained in more detail in Sessions 3 and 4.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div>Motivation perspective",
            content:"<div class=\"box\"><p class=\"n-m-t\">At the heart of this perspective is the idea that burnout occurs in individuals who have too high a level of motivation or who are motivated by a very narrow number of factors. This links to the idea that they will push themselves too hard in pursuit of their goals so understanding how people are motivated is central. Therefore, researchers (e.g. Cresswell and Eklund, 2005) would explore the nature of Barker’s motivation and drive. Self-determination theory (Deci and Ryan, 1985) is regularly used to support this perspective. Self-determination (i.e. freely choosing to do an activity rather than feeling you have to do it) is explained in more detail in Session 5.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div>Social perspective",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Coakley (1992) argues that, for many, sport can become all-consuming from a young age. The danger of this is that an individual’s identity (the very way in which they see themselves) becomes overly narrow and focused on their role as an athlete. Athletes can begin to feel trapped in their sport. For example, earlier in Session 1 you saw how travelling seemed to broaden Ellie Simmonds’ identity beyond being an athlete. It is argued that burnout is a social problem stemming from the way sports are organised. In developing insights into Barker’s burnout, researchers would explore how much sport forms part of her main identity and, in turn, if this unidimensional (i.e. narrow, singular) athletic identity relies upon sporting success. </p></div>"
        }
    ]
};

var labels, reveals, resize;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(resizeComplete, 250);
    };
}
function resizeComplete(){
    VLE.resize_iframe();
}

function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    resizeScreen();
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe()}, 250);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
}
function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        resizeScreen();
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
};