var crssword = crssword || {};

crssword.repeats = (function () {
  //tag, parent (obj), props (obj)
  var newEls = function(elType, elParent, elProps){
    if(typeof elType !=="undefined" && typeof elParent === "object"){
      var newEl = document.createElement(elType);
      for(var key in elProps) {
        newEl.setAttribute(key, elProps[key]);
      }
      return elParent.appendChild(newEl);
    }
  };
  // add or remove a class
  var updateClass = function(action, el, className) {
    if (el) {
      var classList = el.className.split(" ");
      switch (action) {
        case "add":
          if (!hasClass(el, className)) {
            classList.push(className);
          }
          break;
        case "remove":
          if (hasClass(el, className)) {
            var removeClassAt;
            for (var i = 0; i < classList.length; i++) {
              if (className === classList[i]) {
                removeClassAt = i
              }
            }
            classList.splice(removeClassAt, 1);
          }
          break;
        default:
          return;
          break;
      }
      el.className = classList.join(" ");
    }
  };
  // getElementByClassName
  var getByClass = function(className,func){
    var itemsWithClass=document.querySelectorAll('.'+className);
    for(var i=0; i<itemsWithClass.length;i++){
      func(itemsWithClass[i]);
    }
  };
  // see if an element has a class already - returns true/false
  var hasClass = function(el,className) {
    var classList=el.className.split(" ");
    var doesHaveClass=false;
    for(var i = 0; i<classList.length; i++){
      if(className===classList[i]){
        doesHaveClass=true;
      }
    }
    return doesHaveClass;
  };
  // END: CLASS FUNCTIONALITY //
  return {
    newEls: newEls,
    updateClass: updateClass,
    getByClass:getByClass,
    hasClass: hasClass
  };
})();