(function() {
    var container = document.getElementById('container') || document.getElementsByTagName('body')[0];
    var index = VLE.get_param('index') || '';
    var url = VLE.get_param('data');
    var data;
    var loader;

    if (index !== '') index = parseInt(index);

    console.log(index);

    var createDemo = function (data, index) {
        var container = OU.utils.createElement('div', 'demo-container');
        var head = document.createElement('h2');
        var code = OU.utils.createElement('div', 'demo-code');
        var textarea = OU.utils.createElement('textarea');
        var pre = document.createElement('pre');
        var json = JSON.stringify(data, null, 4);
        var controls = OU.buttons.construct({
            enabled: ['show', 'copy'],
            data: {
                show: {
                    html: ['Show JSON', 'Hide JSON'],
                    classes: ['osep'],
                    click: function (btn) {
                        if (btn.pressed) pre.style.display = 'block';
                        else pre.style.display = 'none';
                    }
                },
                copy: {
                    html: 'Copy to clipboard',
                    classes: ['osep'],
                    click: function () {
                        textarea.focus();
                        textarea.select();
                        document.execCommand('copy');
                    }
                }
            }
        });

        container.style.visibility = 'hidden';

        head.appendChild(document.createTextNode('Index ' + (typeof index === 'number' ? index : _index)));

        pre.readOnly = true;
        pre.style.display = 'none';
        pre.appendChild(document.createTextNode(json));

        textarea.appendChild(document.createTextNode(json));

        code.appendChild(controls.group);
        code.appendChild(textarea);
        code.appendChild(pre);

        var root = document.getElementById('container');
        if(!root) {
            root = document.body;
        }
        root.appendChild(container);
        container.appendChild(head);
        create(data, container);
        container.appendChild(activity.container);
        container.appendChild(code);
        container.style.visibility = 'visible';
    };
    
    var create = function(data, container) {
        activity = HL.activity.construct(container);
        activity.load(data);
    };

    if (url) {
        data = {};

        if (url.split('.').pop() === 'json') {
            data.file = [url];
        } else {
            data.folder = ['data'];
        }
        create(data);
    }
    else { // local testing
        if (typeof index === 'number') {
            createDemo(OU.data[index], index);
        } else {
            OU.data.forEach(function (data, index) {
                createDemo(data, index);
            });
        }
    }

    // if (VLE.serverversion) {
    //     loader = OU.loader.construct();

    //     loader.load({
    //         load: {
    //             file: [VLE.get_param('data')]
    //         },
    //         callback: function(data) {
    //             create(data.file[0]);
    //             this.spinner.stop();
    //         }
    //     });
    // }
    // else { // local testing purposes
    //     if (typeof index == 'number') {
    //         create(OU.data[index]);
    //     }
    //     else {
    //         OU.data.forEach(function(data) {
    //             create(data);
    //         });
    //     }
    // }
})();