var HL = HL || {};

HL.tool = (function() {
    var container = OU.utils.createElement('div', 'hl-tool-container'),
        tabs = [
            {
                id: 'edit',
                label: 'Edit',
                active: true
            },
            {
                id: 'configure',
                label: 'Configure'
            },
            {
                id: 'preview',
                label: 'Preview',
                content: 'Preview tab...',
                disabled: true
            },
            {
                id: 'upload',
                label: 'Import/Export',
                content: 'Upload tab...'
            }
        ],
        tabset = OU.tab.construct(),
        debug = {
            enabled: false,
            type: 'word',
            upload: {
                enabled: true,
                index: 3
            }
        };

    var initDebugging = function() {
        tabset.on('editor-loaded', function() {
            tabs.configure.activity.cfg.type = debug.type;

            if (debug.upload.enabled) {
                tabs.upload.data.imported = OU.data[debug.upload.index];
                tabset.get('upload').show();
            }
            else {
                tabs.edit.editor.setContent(tabs.edit.sample);
                tabs.configure.activity.cfg.content = tabs.edit.editor.getContent();
                OU.utils.triggerCustomEvent(tabs.configure.container, 'create-activity');
            }

            tabset.get('configure').show();
            //tabset.get('preview').show();
        });
    };

    var init = function() {
        initTabs();

        document.body.appendChild(container);

        //textarea needs to be in dom so init editor after append...
        tabs.edit.initEditor();

        tabset.on('create-activity', function() {
            if (tabset.get('preview').disabled) {
                tabset.get('preview').enable();
            }
        });

        tabset.get('edit').on('show', function() {
            if (tabs.configure.cfg.activity) {
                tabs.edit.editor.setContent(tabs.configure.cfg.activity.content);
            }
        });

        tabset.get('edit').on('hide', function() {
            if (tabs.edit.status.updated) {
                tabs.configure.activity.cfg.content = tabs.edit.editor.getContent();
                tabs.configure.updateActivityContent();
                //tabs.configure.update();
                tabs.edit.status.updated = false;
            }
        });

        tabset.get('configure').on('show', function() {

        });

        tabset.get('configure').on('hide', function() {
            if (tabs.configure.activity.cfg.type) {
                tabs.configure.cfg.activity = tabs.configure.getCfg();
            }
        });

        tabset.get('preview').on('show', function() {
            if (tabs.configure.cfg.activity) {
                tabs.preview.create(tabs.configure.cfg.activity);
            }
        });

        tabset.get('upload').on('show', function() {
            if (tabs.configure.cfg.activity) {
                tabs.upload.data.exported = tabs.configure.cfg.activity;
                tabs.upload.textarea.value = JSON.stringify(tabs.upload.data.exported, null, 4);
            }
        });

        tabset.get('upload').on('hide', function() {
            if (tabs.upload.data.imported) {
                tabs.configure.activity.setCfg(tabs.upload.data.imported);
                tabs.upload.data.imported = null;

                if (tabs.configure.activity.loaded) {
                    tabs.configure.importCfg();
                }
                else {
                    OU.utils.triggerCustomEvent(tabs.configure.container, 'create-activity', {imported: true});
                }
            }
        });

        if (debug.enabled) {
            initDebugging();
        }
    };

    var initTabs = function() {
        var content;

        tabs.forEach(function(data) {
            content = HL[data.id];

            if (content) {
                tabs[data.id] = content;
                data.content = content;
                content.id = data.id;
            }

            tabset.add(data);

            if (content && typeof content.init == 'function') {
                content.init();
            }
        });

        container.appendChild(tabset.container);
    };

    return {
        init: init,
        initTabs: initTabs,
        tabs: tabset.tabs,
        debug: debug
    };
})();

HL.tool.init();