(function(){ /* all enclosing function to help with scope issues */

var mode = null;
var context = null;
var erasing = false;
var currentColor = 0;
var colors = {};

var iframe = $(window.frameElement);
var colorNames = {'#ecf42b': 'yellow', '#00ea4d': 'green', '#ff00b4': 'pink',
				  '#00a0d8': 'blue', '#ffb956': 'orange', '#ff6f79': 'red'};



/* Add margin of 3em to the top of the div if offline, to deal with done bar */


    var protocol = location.protocol;
    var el = document.getElementById('page');
    if (protocol !== "http:" && protocol !== "https:") {
        if (el) {
            el.className = 'first';
        }
    }



$(document).ready(function() {

  	$('body').show();

    var answerDiv = $('#answer');

    if(typeof VLE !== 'undefined'){
     mode = VLE.get_param('mode');
     context = VLE.get_param('context'); // using VLE in offline mode to get context
    }

    if(context == 'preview'){
      $('#content').css('width', '500');
      answerDiv.css('width', '500');
    }

  	switch(mode){

	  case 'feedback_only':
        $('#instructions_div').remove();
		$('#top_bit').remove();
		$('#reset_button').remove();
    	displayFeedbackIfAny();
		var answerText = decodeURIComponent(data.text);
		answerDiv.html(answerText);
		populateAnswer();
		addSkipLink();
		break;

	  default:
		$('#feedback').remove();
		answerDiv.remove();
    	var contentText = decodeURIComponent(data.text);
     	$("#content").html(contentText);
  		makeColors();
		writeButtons();
		set_first_button();
		$('.penciltext').attr('tabindex', 0);
		setDefaultHighlights();
		setEventHandlers();
		break;
		
	} // end of switch(mode)

});  /* end of $(document).ready() */

function addSkipLink() {//Adds a skip link to long description if one is present 
	var longDescLink = iframe.parent().find('.oucontent-longdesclink a');
	if (longDescLink.length > 0) {
		$('<a href="#" class="offscreen">Skip to long description</a>')
			.on('click', function() { longDescLink.focus();	})
			.prependTo('body');
	}
}

function displayFeedbackIfAny(){

  	var feedback = decodeURIComponent(data.feedbackText);
    var feedbackDiv = $('#feedback');

  	if($.trim(feedback) != ''){
	  feedbackDiv.html(feedback);
	  feedbackDiv.show();
	}else{
	  feedbackDiv.hide();
	}
}

function makeColors(){
  	for(var i=0; i<data.colors.length; i++){
	  	colors[data.colorIndices[i]] = data.colors[i];
	}
}

function reset(){
	$('#content span').attr('style', '');
}

function setDefaultHighlights() {

	$("#content span").each(function(){

		var el = $(this);
		var className = el.attr("class");
	  	var colorIndex = '';

	  	if(className.length >= 6){
		  	colorIndex = className.substring(0,6)
		}

		if(el.hasClass('preselected')){
		  el.css('background-color', colors[colorIndex]);
		}
		else if(data.preHighlight && (className.indexOf('color') != -1) && data.DEFAULT_HIGHLIGHT != "") {
			el.css("background-color", data.DEFAULT_HIGHLIGHT);
		} else {
			el.css("background-color", "white");
		}
		el.attr("tabindex", 0);
		
	});
}
	
function set_first_button() {
	var theid = $('.colorbutton').first().attr('id');
	var theindex = theid.substring(6);
	var imageid = $('#' + theid);
		
	imageid.attr('src', 'images/' + theindex + 'b.jpg');
  	imageid.parent().focus();
	currentColor = 0;

}

function populateAnswer() {

  	$("#answer span").each(function(){

		var colorText = $(this).attr("class").substring(0,6);

		if(colorText && colorText != 'color7' && colorText != 'color9') {

				for(var i=0; i<data.colorIndices.length; i++) {
					if(data.colorIndices[i] == colorText) {
					  $(this).css("background-color", data.colors[i]);
					}
				}

		}
	});
}

function getColorKey(span) {

  	var colorIndex = span.attr('class').substring(5,6);
  	if(colorIndex == '7'){
	  	return 7; // to signify unselectable

	}

    var color = span.css('background-color');
    var keyToReturn = 999;
    
    $.each(data.colors, function(key, value) {
      if(colorsAreEqual(value, color)) {
		keyToReturn = key;
      }
    });
    
    return keyToReturn;    
}

function doPencilClick(pencilID){

  if(erasing){
	//doEraserClick();
	$('#eraserbutton').attr('src', 'images/eraser_off.jpg');
	erasing = false;
  }

  var theindex = parseInt(pencilID.substring(6), 10);
  var colorIndex = 'color' + theindex; // e.g. 'color3'
  currentColor = data.colorIndices.indexOf(colorIndex);
  greyout_all_pens();
  $( '#' + pencilID).attr('src', 'images/' + theindex + "b.jpg");
  $('#eraserbutton').attr('src', 'images/eraser_off.jpg');

}

function doEraserClick(){
  if( erasing === false ){
	$('#eraserbutton').attr('src', 'images/eraser_on.jpg');
	erasing = true;
	greyout_all_pens();

  }else{
	set_first_button();
	$('#eraserbutton').attr('src', 'images/eraser_off.jpg');
	erasing = false;
  }
}

function setEventHandlers() {

    var eraserButton =	$('#eraserbutton').parent();;
    var spans = $('#content span');
    var penTexts = $('.penciltext');

    eraserButton.click(function(){
	  doEraserClick();
	});

  	$('#reset_button').click(function(){
	  reset();
	  setDefaultHighlights();
	});

  	penTexts.click(function(){

	  var pencil_id = $(this).children()[0].id;

	  if(pencil_id.indexOf('button') != -1){
		doPencilClick(pencil_id);
	  }


	});

  	eraserButton.keyup(function(e){
		if(e.which == 13){
		  doEraserClick();
		}
  	});

  	penTexts.keyup(function(e){
	  	if(e.which == 13){
		  doPencilClick( $(this).children()[0].id );
		}
	});
	
	spans.keyup(function(e){

	  	if(e.which == 13){     // if the Return key was pressed
		  	$(this).click();
		}

	});
	
	spans.mouseover(function(e) {

	  	if(e.shiftKey && data.allowDragging == true){
		  	doMouseover($(this));
		}
	});

	spans.click(function(){
		/*
			If the span is set to the current color (i.e. the selected
			pen) already, then clicking should return it to the DEFAULT_HIGHLIGHT
			color. If the span is any other color, then it should be set to 
			the selected pen color.
		*/
	  	if($(this).hasClass('preselected')){
		  	return;

		}
		if($(this).hasClass('color7')){
		  return;

		}
	  	if(erasing){
		  $(this).css('background-color', data.DEFAULT_HIGHLIGHT);
		  return;
		}

		var key = getColorKey( $(this) );

		if(key == 999) {
			$(this).css('background-color', data.colors[currentColor]);
		} else if(key == currentColor) {
			$(this).css('background-color', data.DEFAULT_HIGHLIGHT);
		} else {
			$(this).css('background-color', data.colors[currentColor]);
		}
		
	});
	
}

function doMouseover(JQthing){

  if( JQthing.hasClass('preselected')){
	return;
  }
  if( JQthing.hasClass('color7')){
	return;
  }
  if(erasing){
	JQthing.css('background-color', data.DEFAULT_HIGHLIGHT);

  }else{
	JQthing.css('background-color', data.colors[currentColor]);

  }
}

function greyout_all_pens(){
  $(".colorbutton").each(function(){
	var this_particular_index = parseInt($(this).attr('id').substring(6), 10);
	$(this).attr('src', 'images/' + this_particular_index + 'c.jpg');
  });
}

function writeButtons() {

   	var buttonHTML = "<table><tr>";

	for(var i=0; i<data.colors.length; i++) {
	    var labelled = false;
		var colorIndex = parseInt(data.colorIndices[i].substring(5), 10);
		var button_label = $.trim(decodeURIComponent(data['caption' + (i + 1)]));

		if(button_label == 'distractor') {
			continue;
		}

	  	if( button_label != '') {
		   labelled = true;
		}

		if(i == 3) {
			buttonHTML += "</tr><tr>";
		}

		buttonHTML += "<td><div class='penciltext'><img alt='" + colorNames[data.colors[i]] + " highlighter pen' class='colorbutton' src='images/" + colorIndex + "a.jpg' id='button" + colorIndex + "' />";

		if( labelled ) {
			buttonHTML += "<div class='labeldiv'>" + button_label + "</div>";
		}
	  	buttonHTML += "</div></td>";
	}

  	if(data.showEraser === true){
      buttonHTML += "<td><div class='eraserdiv' tabindex='0'><img id='eraserbutton' src='images/eraser_load.jpg' alt='eraser' /></div></td>";
	}

	buttonHTML += "</tr></table>";

	$("#buttons").html(buttonHTML);

}

})(); /* end of all-enclosing function  */










