(function(){ /* all enclosing function to help with scope issues */

    var context = null;
    var colors = {};
    var infoText = {};
    var GAP = 20;
    var ARROW_COLOR = '#ffcc33';
    var canvasSupported = false;

    $(document).ready(function() {

        canvasSupported = !!window.HTMLCanvasElement;

        $('body').show();

        context = VLE.get_param('context'); // using VLE in offline mode to get context
        activity_type = VLE.get_param('type');

        if(context == 'preview'){
            $('#content').css('width', '500');
        }

        $('#reset_button').remove();
        $("#answer").hide();
        $("#feedback").hide();
        $("#content").html(decodeURIComponent(data.text));
        makeInfoText();
        $('#reveal_answer_button').hide();
        setEventHandlers();
        setTabbing();
        setDefaultHighlights();

    });  /* end of $(document).ready() */

    function setDefaultHighlights() {

        $("#content span").each(function(){

            var el = $(this);
            var className = el.attr("class");
            var colorIndex = '';

            if(className.length >= 6){
                colorIndex = className.substring(0,6)
            }

            if(el.hasClass('preselected')){
                el.css('background-color', colors[colorIndex]);
            }
            else if(data.preHighlight && (className.indexOf('color') != -1) && data.DEFAULT_HIGHLIGHT != "") {
                el.css("background-color", data.DEFAULT_HIGHLIGHT);
            } else {
                el.css("background-color", "white");
            }
            el.attr("tabindex", 0);

        });
    }

    function setTabbing(){
        $("#content span").each(function(){
            var el = $(this);
            el.attr("tabindex", 0);
        });
    }

    function makeInfoText(){
        for(var i=0; i<data.colorIndices.length; i++){
            infoText[data.colorIndices[i]] = decodeURIComponent(data['caption' + (i+1)]);
        }
    }

    function setEventHandlers(){  /* for the 'reveal' type activity */

        var contentSpan = $("#content span");

        contentSpan.mouseover(function(e) {
            resetAll();
            $(this).focus();
            $(this).css('background-color', '#FFCC33');
            createInfoBox(e);

        });

        contentSpan.keyup(function(e){

            if(e.which == 13 || e.which == 27){

                if($('#info_box').length == 0 ){
                    $(this).css('background-color', '#FFCC33');
                    createInfoBox(e);
                }else{
                    resetAll();
                }
            }
        });

        contentSpan.click(function(e){

            if($('#info_box').length == 0 ){
                $(this).css('background-color', '#FFCC33');
                createInfoBox(e);
            }else{
                resetAll();
            }
        });
    }


    function resetAll(){

        if( data.preHighlight ){
            $('#content span').css('background-color', data.DEFAULT_HIGHLIGHT);
        }else{
            $('#content span').css('background-color', '');
        }

        if($('#info_box').length != 0){
            $('#info_box').remove();
        }

        if($('#thecanvas').length != 0){
            $('#thecanvas').remove();
        }

    }

    function get_boxtop(el){
        return  el.offsetTop + $(el).height();
    }

    function get_boxleft(el){

        var xvalue = 0;
        var xs = ($('#info_box').width() + el.offsetLeft) - 510;

        if(xs > 0){
            xvalue = el.offsetLeft - xs;
        }else{
            xvalue = el.offsetLeft;
        }

        return xvalue;

    }

    function createInfoBox(e){

        if(canvasSupported){
            createInfoBox_canvas(e);
        }else{
            createInfoBox_no_canvas(e);
        }
    }

    function createInfoBox_no_canvas(e){

        var classText = $(e.target).attr('class');
        var infobox = $('#info_box');


        $('#content').after('<div id="info_box">' + infoText[classText] + '</div>');



        infobox.click(function(e){
            resetAll();
        });

        infobox.css('top', get_boxtop(e.target));
        infobox.css('left', get_boxleft(e.target));
    }


    function createInfoBox_canvas(e){

        var span = $(e.target);
        var classText = span.attr('class');
        var thecanvas = null;
        var ctx = null;
        var infobox = null;
        var topvalue = get_boxtop(e.target);
        var leftvalue = get_boxleft(e.target);
        var canvas_el = null;
        var pointerWidth = null;
        var rightmost_x = 0;

        $('#content').after('<div id="info_box">' + infoText[classText] + '</div><canvas id="thecanvas" style="position: absolute; z-index: 0;"></canvas>');

        infobox = $('#info_box');
        thecanvas = $('#thecanvas');
        canvas_el = thecanvas.get(0);

        infobox.click(function(e){
            resetAll();
        });

        rightmost_x = 500 - (infobox.width() + 28); /* 28 is the padding * 2 plus border-width * 2  */

        if(leftvalue > rightmost_x){
            leftvalue = rightmost_x;
        }

        infobox.css('top', topvalue + GAP);
        infobox.css('left', leftvalue);

        thecanvas.css('top', topvalue);
        thecanvas.css('left', leftvalue);
        canvas_el.height = GAP;
        canvas_el.width = 2 * GAP;

        ctx = canvas_el.getContext('2d');
        ctx.strokeStyle = ARROW_COLOR;
        ctx.fillStyle = ARROW_COLOR;
        ctx.beginPath();
        ctx.moveTo(0,0);

        if(span.width() < GAP * 2){
            pointerWidth = span.width();
        }else{
            pointerWidth = GAP * 2;
        }

        ctx.lineTo(pointerWidth, GAP);
        ctx.lineTo(pointerWidth, 0);
        ctx.lineTo(0,0);
        ctx.fill();
        ctx.stroke();

    }


})() /* end of all-enclosing function  */










