
function getCorrectColorIndex(el){
	
	var numbertext = "";
	
	if( el.attr("class") ) {
		numbertext = el.attr("class");
	} else {
		return 99; // 99 means there is no color set for this span
	}
	
	return (parseInt(numbertext.substr(5)) - 1, 10);
}

function getColorIndex(el){
	
	var color = el.css("background-color");
	
	for(var i=0; i<data.colors.length; i++){
		if(colorsAreEqual(color, data.colors[i])){
			return i;
		}
	}
	
	return -1; /* so we could test for -1 to detect failure */
}


function colorsAreEqual(col1, col2){
               
                var colors1 = getColorTriplet(col1);
                var colors2 = getColorTriplet(col2);
               
                if(colors1.length != colors2.length){
                                console.log("PROBLEM1 IN FUNCTION : colorsAreEqual");
                }
                if(colors1.length != 3){
                                console.log("PROBLEM2 IN FUNCTION : colorsAreEqual");
                }
               
                var equal = true;
               
                for(var i=0; i<colors1.length; i++) {
                                if(colors1[i] != colors2[i]){
                                                equal = false;
                                }
                }
               
                return equal;
               
}
 
function getColorTriplet(col){
 
                var num1, num2, num3;
                num1 = num2 = num3 = "";
                var comma_count = 0;
               
                if(col.toUpperCase().indexOf("RGB") != -1) { // dealing with rgb(12,12,12) type color string
                                               
                                for(var i=0; i<col.length; i++){
                                               
                                                if(col.charCodeAt(i) == 44){ // 44 for comma
                                                                comma_count++;
                                                                continue;
                                                }
                                               
                                                var num = parseInt(col.charAt(i));
                                                               
                                                if( ! isNaN(num) ){ // if it IS a number
                                                                switch(comma_count){
                                                                case 0:
                                                                                num1 += col.charAt(i); // num1 is still a string here
                                                                                break;
                                                                case 1:
                                                                                num2 += col.charAt(i);
                                                                                break;
                                                                case 2:
                                                                                num3 += col.charAt(i);
                                                                                break;
                                                                }
                                                }
                                }
                }
               
                if( col.indexOf("#") != -1) { // dealing with a hex color string like   #deabe1
                               
                                var index = col.indexOf("#");
                                index++;
                               
                                num1 = parseInt(col.substr(index, 2), 16);
                                num2 = parseInt(col.substr(index + 2, 2), 16);
                                num3 = parseInt(col.substr(index + 4, 2), 16);
                               
                }
               
                return [num1, num2, num3];
 
}
 