var userdata = {
    slider1: 4
}


var cols = [
    "#CCC",
    "#1E71B8",
    "#6889AF",
    "#CCBE83",
    "#F7D957",
    "#CFC754",
    "#AAB752",
    "#5D9E50"
]

$("input").change(function() {
    $(this).parent().css('background-color', cols[this.value]);
    userdata[$(this).attr("id")] = this.value
})
$("#savebtn").click(function() { save() })
$("#clearbtn").click(function() {
    userdata = {
        slider1: 4
    }
    setupData()
})

function save() {
    VLE.set_server_data(true, {
        'userdata': JSON.stringify(userdata)
    }, function() {
        console.log("saved")
    }, function() {
        console.log("No VLE")
        localStorage.setItem("testUserData", JSON.stringify(userdata));
    });
}

function load() {
    VLE.get_server_data(true, ['userdata'], function(data) {
            console.log("DATA VLE", data.userdata)
            if (data.userdata !== "") {
                userdata = JSON.parse(data.userdata);
            }
            setupData();
        },
        function() {
            console.log("No VLE")
            if (localStorage.getItem("testUserData")) {
                userdata = JSON.parse(localStorage.getItem("testUserData"));
                setupData();
            }
        });
}


function setupData() {
    $.each(userdata, function(k, i) {
        console.log(k, i)
        $("#" + k).val(i)
        $("#" + k).parent().css('background-color', cols[i]);
    });
    VLE.resize_iframe();
}


$(function() {
    load();
})