/*global requirejs, data, VLE*/
require(
    ['../main'],
    function () {
        "use strict";
        require(
            [
                'utils',
                'loader',
                'inline',
                'buttons',
                'feedback'
            ],
            function (utils, ldr, inline, btn, fbk) {
                var type = 'inline',
                    index = 0,
                    url, data;

                if (VLE.serverversion) {
                    url = VLE.get_param('settings'); // VLE attachment name for JSON file
                    data = {};

                    if (url.split('.').pop() == 'json') {
                        data.file = [url];
                    }
                    else {
                        data.folder = ['settings'];
                    }

                    InlineActivity(data);
                }
                else { //local testing
                    require(['inline-data'], function(data) {
                        if (typeof index == 'number') {
                            InlineActivity(data.examples[index]);
                        }
                        else {
                            data.examples.forEach(function(data) {
                                InlineActivity(data);
                            });
                        }
                    });
                }

                function InlineActivity(data) {
                    console.log(JSON.stringify(data)); //for copy/pasting into data file

                    InlineActivity.index = ++InlineActivity.index || 0;

                    var index = InlineActivity.index,
                        id = type + '-activity' + index,
                        container = document.body.appendChild(utils.createElement('div', 'container', id)),
                        question = inline(),
                        loader = ldr.construct(),
                        buttons, feedback;

                    var load = function() {
                        if (VLE.serverversion) {
                            loader.load({
                                container: container,
                                load: data,
                                callback: function(result) {
                                    data = result.file[0];
                                    init();
                                }
                            });
                        }
                        else {
                            if (data.images && Array.isArray(data.images.files) && data.images.files.length) {
                                loader.load({
                                    container: container,
                                    dir: data.images.dir || 'img/',
                                    load: {
                                        image: data.images.files
                                    },
                                    callback: function (result) {
                                        if (Array.isArray(result.image)) {
                                            data.images.files = result.image;
                                        }

                                        init();
                                    }
                                });
                            }
                            else {
                                init();
                            }
                        }
                    };

                    var init = function () {
                        if (typeof data.css != 'undefined') {
                            addCSS(data.css);
                        }

                        ensureBackwardCompatibility();
                        // initAnswerData();
                        // initButtonData();
                        setOverrides();
                        setCfg();
                        create();
                        setEventHandlers();
                    };

                    //TODO support for old data files - remove in next version
                    var ensureBackwardCompatibility = function () {
                        if (Array.isArray(data.answer)) {
                            data.answer = {
                                data: data.answer
                            };
                        }
                    };

                    //TODO remove in next version/move to activity class
                    var setOverrides = function () {
                        data.buttons.enabled = data.buttons.enabled || [];

                        //enforce retry button - remove in next version
                        if (data.buttons.enabled.indexOf('check') > -1 && data.buttons.enabled.indexOf('retry') < 0) {
                            data.buttons.enabled.push('retry');
                        }
                    };

                    var setCfg = function () {
                        data.buttons.enabled = data.buttons.enabled || [];

                        if (data.buttons.enabled.indexOf('retry') > -1) {
                            data.answer = data.answer || {};

                            if (['text', 'textarea'].indexOf(data.type) > -1 && data.answer.clearIncorrect !== true) {
                                data.answer.clearIncorrect = false;
                            }
                        }
                    };

                    var create = function() {
                        question.init(data, container);

                        if (!container.contains(question.container)) {
                            container.appendChild(question.container);
                        }

                        if (data.buttons) {
                            createButtons();

                            if (buttons.active('check')) {
                                createFeedback();
                            }
                        }

                        utils.triggerCustomEvent(container, 'activity-loaded');
                        //utils.makeResponsive(container);
                        container.style.visibility = 'visible';
                        //utils.resizeIFrame();
                    };

                    var createButtons = function () {
                        if (!question.cfg.answer.overlay) {
                            data.buttons.data = data.buttons.data || {};

                            data.buttons.data.reveal = {
                                html: 'Reveal answer'
                            };
                        }

                        buttons = btn.construct(data.buttons);
                        buttons.init();
                        question.buttons = buttons;
                        container.appendChild(buttons.el);
                    };

                    var createFeedback = function () {
                        data.feedback = data.feedback || {};

                        utils.extendDeep(data.feedback, {
                            alternates: true
                        });

                        feedback = fbk.construct(data.feedback, container);
                        container.appendChild(feedback.el);

                        if (buttons.active('retry')) {
                            feedback.retry.replaceChild(buttons.get('retry').el, feedback.retry.firstChild);
                        }
                    };

                    var addCSS = function(css) {
                        var el, ss;

                        if (typeof css == 'string') {
                            el = document.head.appendChild(document.createElement('link'));
                            el.rel = 'stylesheet';
                            el.href = css;
                        }
                        else {
                            el = document.head.appendChild(document.createElement('style'));
                            //ss = document.head.styleSheets[document.head.styleSheets.length - 1];
                            ss = el.sheet;

                            utils.forIn(css, function (rules, selector) {
                                rules = Array.isArray(rules) ? rules : [rules];

                                rules.forEach(function (rule) {
                                    ss.insertRule('#' + id + ' ' + selector + '{' + rule + '}', ss.cssRules.length);
                                });
                            });
                        }
                    };

                    var setEventHandlers = function () {
                        //container.addEventListener('check', handleEvent);
                        //container.addEventListener('retry', handleEvent);
                        container.addEventListener('feedback-result', handleEvent);
                        container.addEventListener('max-attempts-reached', handleEvent);
                    };

                    var triggerEvent = function (el, type) {
                        utils.triggerCustomEvent(el, type, {
                            triggered: true
                        });
                    };

                    var handleEvent = function (e) {
                        switch (e.type) {
                            case 'max-attempts-reached':
                                buttons.get('check').disable(); //has to exist if feedback

                                if (buttons.active('reveal')) {
                                    buttons.get('reveal').disable();
                                }
                                break;
                            case 'feedback-result':
                                if (e.detail.attempted) {
                                    if (!e.detail.correct) {
                                        feedback.retry.style.display = 'block';

                                        if (!buttons.active('retry')) {
                                            triggerEvent(feedback.retry, 'retry');
                                        }
                                    }
                                }
                                else {
                                    buttons.get('check').enable();
                                    feedback.retry.style.display = 'none';
                                    //TODO this should be a simple call to question.retry (once setup)...
                                    triggerEvent(feedback.retry, 'retry');
                                }

                                utils.resizeIFrame();
                        }
                    };

                    load();
                }
            }
        );
    }
);
define("activities/inline_activity", function(){});

define(
    'inline',[
        'utils',
        'loader',
        'saver',
        'input'
    ],
    function (utils, loader, saver, input) {
        "use strict";

        return function inline() {
            var dom = {
                container: null,
                el: utils.createElement('div', 'inline-container'),
                question: utils.createElement('div', 'question'),
                answer: null,
                inputs: []
            };

            var cfg = {
                type: 'text',
                theme: '',
                width: 512,
                classes: [],
                intro: '',
                html: '',
                lang: '',
                placeholder: { //TODO move placeholder utility module
                    start: '[[',
                    end: ']]',
                    delimeter: '|',
                    index: {
                        enabled: false,
                        zeroBased: true
                    }
                },
                inputs: {
                    data: [], //store data for input objects here
                    text: {
                        width: 'auto',
                        resize: false
                    },
                    select: {
                        options: [], //holds option arrays that can be referenced by placeholder start/end and index
                        shuffle: [] //true for global or index of select to shuffle options
                    }
                },
                footnote: '',
                answer: {
                    data: [],
                    showCorrect: false,
                    showIncorrect: false,
                    clearIncorrect: true,
                    overlay: true
                },
                resetConfirm: false, //TODO move to buttons.js
                images: { //TODO move to activity class?
                    dir: 'img/',
                    lang: '',
                    placeholder: '[[image]]',
                    files: [],
                    alt: []
                }
            };

            var answer = null,
                attempt = null;

            var init = function(data, container) {
                dom.container = container || document.getElementsByTagName('body')[0];

                setCfg(data);
                cfg.html = replaceImagePlaceholders(cfg.html);
                getDataFromHTML();
                initAnswerData();

                if (cfg.type == 'select') {
                    normaliseShuffle();
                }

                setInputData();
                initQuestion();
                initInputs();
                setEventHandlers();

                if (cfg.answer.data.length === 0) {
                    //getAnswer();
                }

                if (!cfg.answer.overlay) {
                    toggle();
                    disableInputs();
                    dom.answer = dom.question.cloneNode(true);
                    dom.answer.className = 'inline-answer';
                    toggle(true);
                    enableInputs();
                }

                retrieveData();
            };

            var setCfg = function(data) {
                console.log(data);

                if (!data.html) {
                    throw new Error('No question data supplied');
                }

                if (data.type == 'text') {
                    cfg.answer.overlay = false;
                }

                utils.extendDeep(cfg, data);
            };

            var replaceImagePlaceholders = function(str) {
                var re = new RegExp(utils.escapeRegExp(cfg.images.placeholder), 'g'),
                    src, alt;

                return str.replace(re, function () {
                    cfg.images.applied = ++cfg.images.applied || 0;

                    src = cfg.images.dir + cfg.images.files[cfg.images.applied].src;
                    alt = cfg.images.alt[cfg.images.applied] || '';

                    return '<img src="' + src + '" alt="' + alt + '" lang="' + cfg.images.lang + '" />';
                });
            };

            var getDataFromHTML = function () {
                var start = utils.escapeRegExp(cfg.placeholder.start),
                    end = utils.escapeRegExp(cfg.placeholder.end),
                    re = new RegExp(start + '(.*?)' + end, 'g');

                cfg.html = cfg.html.replace(re, function(match) {
                    match = match.replace(cfg.placeholder.start, '').replace(cfg.placeholder.end, '');

                    if (match != 'input') {
                        if (cfg.placeholder.index.enabled) {
                            cfg.inputs.data.push(cfg.placeholder.index.zeroBased ? parseInt(match, 10) : parseInt(match, 10) - 1);
                        }
                        else {
                            cfg.inputs.data.push(null);
                            match = match.split(cfg.placeholder.delimeter);

                            switch (cfg.type) {
                                case 'text':
                                    cfg.answer.data.push(match);
                                    break;
                                case 'select':
                                    cfg.inputs.select.options.push(match);
                            }
                        }
                    }

                    //replace with something we can query...
                    return '<span class="inline-input"></span>';
                });
            };

            var initAnswerData = function () {
                switch (cfg.type) {
                    case 'text':
                        cfg.answer.data.forEach(function (data, i, arr) {
                            arr[i] = Array.isArray(data) ? data : [data];

                            arr[i].forEach(function(str, j, arr) {
                                str = str.trim();

                                if (/[\u2018\u2019]/.test(str)) {
                                    arr.push(str.replace(/[\u2018\u2019]/g, '\''));
                                }

                                arr[j] = str;
                            });
                        });
                        break;
                    case 'select':
                        while (cfg.answer.data.length < cfg.inputs.data.length) {
                            cfg.answer.data.push(0);
                        }

                        console.log(cfg.inputs.select.options);
                }

                console.log(cfg.answer.data);
            };

            var normaliseShuffle = function () {
                if (cfg.inputs.select.shuffle === true) {
                    cfg.inputs.select.shuffle = cfg.inputs.data.map(function (el, i) { return i; });
                }
            };

            var initQuestion = function() {
                if (cfg.lang) {
                    dom.question.lang = cfg.lang;
                }

                if (cfg.intro) {
                    dom.question.insertAdjacentHTML('beforeend', '<div class="dnd-intro">' + cfg.intro + '</div>');
                }

                dom.question.insertAdjacentHTML('beforeend', cfg.html);

                if (cfg.footnote) {
                    dom.question.insertAdjacentHTML('beforeend', '<div class="dnd-footnote">' + cfg.footnote + '</div>');
                }

                dom.el.appendChild(dom.question);
            };

            var setInputData = function() {
                console.log(cfg.inputs.data);

                cfg.inputs.data.forEach(function (num, i, arr) {
                    var data = {
                        type: cfg.type,
                        label: {
                            prefix: 'input ' + (i + 1)
                        }
                    };

                    num = (typeof num == 'number') ? num : i;

                    switch (cfg.type) {
                        case 'select':
                            data.options = cfg.inputs.select.options[num].map(function(str) { return { label: str }; });
                            data.shuffle = (cfg.inputs.select.shuffle.indexOf(num) > -1);
                            data.answer = cfg.answer.data[i];
                            break;
                        case 'text':
                            data.answer = cfg.answer.data[i];
                    }

                    arr[i] = data;
                });
            };

            var initInputs = function() {
                var label, data;

                utils.toArray(dom.question.querySelectorAll('.inline-input'))
                    .forEach(function(placeholder, i) {
                        data = cfg.inputs.data[i];
                        label = input.create(data);
                        label.className = 'inline-' + data.type;
                        data.el.setAttribute('data-input-index', i.toString());
                        dom.inputs.push(data.el);
                        utils.addClass(label.firstChild, 'screen-reader');
                        placeholder.parentNode.replaceChild(label, placeholder);
                    });

                switch (cfg.type) {
                    case 'text':
                        resizeTextInputs();
                }
            };

            var resizeTextInputs = function() {
                var span = dom.container.appendChild(document.createElement('span')),
                    max = 0, width;

                cfg.inputs.data.forEach(function(data) {
                    width = 0;

                    data.answer.forEach(function(answer) {
                        span.textContent = answer;

                        if (span.offsetWidth > width) {
                            width = span.offsetWidth;
                        }

                        if (width > max) {
                            max = width;
                        }
                    });

                    if (typeof data.width != 'number' && typeof cfg.inputs.text.width != 'number') {
                        data.width = width;
                    }
                });

                dom.container.removeChild(span);

                if (typeof cfg.inputs.text.width != 'number') {
                    cfg.inputs.text.width = max;
                }

                dom.inputs.forEach(function (input, i) {
                    width = cfg.inputs.text.resize ? cfg.inputs.text.width : (cfg.inputs.data[i].width || cfg.inputs.text.width);
                    input.style.width = width + 10 + 'px';
                });
            };

            var change = function(e) {
                var data, index;

                index = e.target.getAttribute('data-input-index');
                data = cfg.inputs.data[index];

                switch (data.type) {
                    case 'text':
                        data.attempt = e.target.value.trim();

                        if (!data.attempt) {
                            delete data.attempt;
                        }
                        break;
                    case 'select':
                        data.attempt = parseInt(e.target.value, 10);
                }
            };

            var setEventHandlers = function() {
                dom.question.addEventListener('change', change);
                dom.container.addEventListener('check', submit);
                dom.container.addEventListener('reveal', reveal);
                dom.container.addEventListener('reset', reset);
                dom.container.addEventListener('save', save);
                dom.container.addEventListener('retry', retry);
                dom.container.addEventListener('max-attempts-reached', toggle);
            };

            var getAttempt = function() {
                attempt = [];

                cfg.inputs.data.forEach(function(data) {
                    attempt.push((typeof data.attempt !== 'undefined') ? data.attempt : null);
                });
            };

            var submit = function() {
                disableInputs();
                getAttempt();

                utils.triggerCustomEvent(dom.container, 'feedback', {
                    attempt: attempt,
                    answer: cfg.answer.data
                });

                console.log(cfg.answer.data, attempt);
            };

            var enableInputs = function() {
                dom.inputs.forEach(function(input) {
                    input.removeAttribute('disabled');
                });
            };

            var disableInputs = function() {
                dom.inputs.forEach(function(input) {
                    input.disabled = true;
                });
            };

            var retry = function () {
                if (cfg.answer.clearIncorrect) {
                    clearIncorrectAnswers();
                }

                enableInputs();
            };

            var clearIncorrectAnswers = function () {
                dom.inputs.forEach(function (input, i) {
                    if (attempt[i] !== cfg.answer.data[i]) {
                        delete cfg.inputs.data[i].attempt;
                        input.selectedIndex = 0;
                    }
                });
            };

            var reveal = function(e) {
                if (cfg.answer.overlay) {
                    if (e.detail.pressed) {
                        disableInputs();
                        toggle();
                    }
                    else {
                        //enableInputs();
                        toggle(true);
                    }
                }
                else {
                    disableInputs();
                    dom.container.appendChild(dom.answer);
                    utils.resizeIFrame();
                }
            };

            var toggle = function(attempt) {
                var answer = attempt ? 'attempt' : 'answer',
                    index;

                cfg.inputs.data.forEach(function(data, i) {
                    switch (data.type) {
                        case 'text':
                            index = (typeof cfg.answer.data[i] == 'number') ? cfg.answer.data[i] : 0;
                            dom.inputs[i].value = (attempt ? data[answer] : data[answer][index]) || '';
                            break;
                        case 'select':
                            index = 0;

                            //TODO better way??
                            if (typeof data[answer] == 'number') {
                                Array.prototype.some.call(dom.inputs[i].children, function(el, i) {
                                    if (el.value == data[answer]) {
                                        index = i;
                                        return true;
                                    }
                                });
                            }

                            dom.inputs[i].selectedIndex = index;
                    }
                });
            };

            var reset = function() {
                if (cfg.resetConfirm && !window.confirm('Resetting the activity will clear all saved data.')) {
                    return false;
                }

                cfg.inputs.data.forEach(function(data, i) {
                    delete data.attempt;

                    switch (cfg.type) {
                        case 'select':
                            dom.inputs[i].selectedIndex = 0;
                            break;
                        case 'text':
                            dom.inputs[i].value = data.value || '';
                    }
                });

                enableInputs();

                if (cfg.answer.overlay) {
                    toggle(true);
                }
                else {
                    if (dom.container.contains(dom.answer)) {
                        dom.container.removeChild(dom.answer);
                        utils.resizeIFrame();
                    }
                }

                utils.resizeIFrame();
            };

            var retrieveData = function() {
                saver.retrieve({
                    names: getSaveObj(),
                    callback: function(obj) {
                        if (obj.data !== '') {
                            obj = JSON.parse(obj.data);

                            cfg.inputs.data.forEach(function (data, i) {
                                data.attempt = obj[i];
                            });

                            toggle(true);
                        }
                    }
                });
            };

            var save = function() {
                saver.save({
                    values: getSaveObj()
                });
            };

            var getSaveObj = function() {
                var obj = {};

                obj.data = JSON.stringify(cfg.inputs.data.map(function (data) {
                    return data.attempt || null;
                }));

                return obj;
            };

            return {
                container: dom.el,
                dom: dom,
                cfg: cfg,
                init: init
            };
        };
    });
