$(function() {
    var sortable = {
        /**
         * Add event keyboard event handler to the li items
         */
        addKeyboardListener: function() {
            var lists = document.querySelectorAll('.connectedSortable'),
                max = 0,
                i = 0;
            if (lists !== null) {
                max = lists.length;
            }
            for ( ; i < max; i += 1) {

                if (document.addEventListener) {
                    lists[i].addEventListener('keyup', this.moveListElement, false);
                    lists[i].addEventListener('mousedown', this.setFocus, false);
                } else {
                    lists[i].attachEvent('onkeyup', this.moveListElement);
                }
            }
        },

        /**
         * Moves the list elements up and down the order and from one list to another if they are
         * connected lists
         * @param {Object} evt
         */
        moveListElement: function(evt) {
            var e = evt || window.event,
                target = e.target || e.srcElement,
                key_hit = e.key || e.which || e.keyCode;

            switch(key_hit) {
                case 'ArrowUp':
                case 38:
                    sortable.moveListElementUp(target);
                    break;
                case 'ArrowDown':
                case 40:
                    sortable.moveListElementDown(target);
                    break;
                case 'ArrowRight':
                case 39:
                    //sortable.moveListElementRight(target);
                    break;
                case 'ArrowLeft':
                case 37:
                    //sortable.moveListElementLeft(target);
                    break;
                default:
                // Do nothing
            }
        },

        /**
         * Move the li element down the order
         * @param {Object} element_to_move_up
         */
        moveListElementUp: function(element_to_move_up) {
            var inserted_element = {},
                reference_element = element_to_move_up.previousElementSibling || element_to_move_up.previousSibling;

            if (reference_element !== null) {
                inserted_element = element_to_move_up.parentNode.insertBefore(
                    element_to_move_up, reference_element);
                inserted_element.focus();
                sortable.saveState();
            }
        },

        /**
         * Move the li element down the order
         * @param {Object} element_to_move_down
         */
        moveListElementDown: function(element_to_move_down) {
            var inserted_element = {},
                reference_element = element_to_move_down.nextElementSibling || element_to_move_down.nextSibling;

            if (reference_element !== null) {
                inserted_element = element_to_move_down.parentNode.insertBefore(
                    element_to_move_down, reference_element.nextSibling);
                inserted_element.focus();
                sortable.saveState();
            }
        },

        /**
         * Move the li element into the other list
         * @param {Object} element_to_move_right
         */
        moveListElementRight: function(element_to_move_right) {
            var inserted_element = {},
                reference_element = element_to_move_right.parentNode.nextElementSibling
                    || element_to_move_right.parentNode.nextSibling;

            inserted_element =  reference_element.insertBefore(
                element_to_move_right, null);
            inserted_element.focus();
            sortable.saveState();
        },

        /**
         * Move the li element into the other list
         * @param {Object} element_to_move_left
         */
        moveListElementLeft: function(element_to_move_left) {
            var inserted_element = {},
                reference_element = element_to_move_left.parentNode.previousElementSibling ||
                    element_to_move_left.parentNode.previousSibling;

            inserted_element = reference_element.insertBefore(
                element_to_move_left, null);
            inserted_element.focus();
            sortable.saveState();
        },

        /**
         * Sets focus on the element
         * @param {Object} evt
         */
        setFocus: function(evt) {
            var e = evt || window.event,
                target = e.target || e.srcElement;

            if (target.tagName.toUpperCase() === 'STRONG') {
                target.parentNode.focus();
            } else {
                target.focus();
            }
        },

        /**
         * Adds IDs of currently positioned elements to an array for saving if needed
         * @returns {Array|null} IDs of positioned elements in descending order
         */
        notePositionedElements: function() {
            var positioned_elements = document.getElementById('sortable2'),
                max = 0,
                i = 0,
                data = [];

            if (positioned_elements !== null) {
                max = positioned_elements.children.length;
            }

            for ( ; i < max; i += 1) {
                data.push(positioned_elements.children[i].id);
            }

            return data;
        },

        /**
         * Save state of positioned elements
         */
        saveState: function() {
            var data = sortable.notePositionedElements(),
                data_id = document.body.id || 'position_elements',
                vle_data = {};

            if (data !== null) {
                vle_data[data_id] = window.JSON.stringify(data);
                VLE.set_server_data(true, vle_data, function() {
                    // Do nothing, it's set OK
                }, function(message) {
                    if (message === null) {  // Flag we assume to mean offline e.g. ePub
                        if (window.localStorage) {
                            localStorage.setItem(data_id, vle_data[data_id]);
                        }
                    } else {
                        alert('Position not saved.' + ' ' + message);
                    }
                });
            }
        },

        /**
         * Load saved position data.
         */
        loadData: function() {
            var data_id = document.body.id || 'position_elements',
                vle_data = [data_id],
                local_data = null;

            VLE.get_server_data(true, vle_data, function(values) {
                if (values.data_id !== '') {
                    sortable.positionElements(values[data_id]);
                }
            }, function(message) {
                if (message === null) { // Assume offline
                    if (window.localStorage) {
                        local_data = localStorage.getItem(data_id);
                        if (local_data !== null) {
                            sortable.positionElements(local_data);
                        }
                    }
                } else {
                    alert('Data not found.' + ' ' + message);
                }
            })

        },

        /**
         * Position the requested elememts in the required positions
         * @param {String|Array} data
         */
        positionElements: function(data) {
            var parsed_data = [],
                i = 0,
                max = 0;

            if (typeof data === 'string') {
                parsed_data = window.JSON.parse(data);
                if (Object.prototype.toString.call(parsed_data) === '[object Array]') {
                    max = parsed_data.length;
                    for ( ; i < max; i += 1) {
                        sortable.moveElementIntoDropZone(parsed_data[i]);
                    }
                }
            }
        },

        /**
         * Finds requested element and moves it into the drop zone list.
         * @param {String} element_id
         */
        moveElementIntoDropZone: function(element_id) {
            var target_element = document.getElementById(element_id),
                target_list = document.getElementById('sortable2');

            if (target_element !== null && target_list !== null) {
                target_element = target_list.insertBefore(target_element, null);
            }
        }
    };

    $( "#sortable2" ).sortable({
        connectWith: ".connectedSortable",
        start: function( event, ui ) {ui.item.focus();},
        stop: function( event, ui ) {
            ui.item.focus();
            sortable.saveState();
        }
    }).disableSelection();
    sortable.addKeyboardListener();
    sortable.loadData();
});
