require(
    ['../main'],
    function () {
        "use strict";
        require(
            [
                'utils',
                'table',
                'loader',
                'buttons',
                'feedback',
                'table-extend',
                'table-input',
                'table-save'
            ],
            function (utils, table, ldr, buttons, feedback) {
                var dataLoadedFromVLE = VLE.serverversion;
                var container = document.getElementById('container') || document.getElementsByTagName('body')[0];
                var content = utils.createElement('div', 'content');

                container.appendChild(content);

                //if (dataLoadedFromVLE) {
                //    var loader = ldr.construct(),
                //        data_url;
                //
                //    data_url = VLE.get_param('settings');
                //
                //    loader.load({
                //        load: {
                //            files: [data_url]
                //        },
                //        callback: function (data) {
                //            create(data.files[0]);
                //            this.spinner.stop(); // Todo: implement in loader??
                //        }
                //    });
                //} else { //local testing
                    require(['table-data'], function (data) {
                        var index = 0;

                        if (typeof index == 'number') {
                            create(data.tables[index]);
                        }
                        else {
                            data.tables.forEach(function (data) {
                                create(data);
                            });
                        }
                    });
                //}

                function create(data) {
                    //console.log(JSON.stringify(data));
                    var t = table.construct(data),
                        btnGroup, fb;

                    if (data.buttons) {
                        btnGroup = buttons.construct(data.buttons);
                        t.buttons = btnGroup;
                        t.container.appendChild(btnGroup.group);

                        if (btnGroup.active('check')) {
                            fb = feedback.construct(data.feedback, t.container, btnGroup);
                            t.container.appendChild(fb.el);
                        }
                    }
                }

                content.style.visibility = 'visible';
            }
        );
    }
);