var labels = ["Put the money into long-term investments – for example by making full use of your annual £20,000 allowance for investing in Stocks & Shares ISAs?", "Make additional contributions into your pension fund, taking further advantage of the tax relief on contributions?", "Spend money on improvements at home?", "Put the money aside for a dream holiday?", "Buy (or lease) a new car?", "Share money with children or other family members?", "Add to your rainy-day fund to cover such unanticipated events like the recent sudden surge in energy prices?"];

(function () {
    for(var i =0; i<labels.length; i++){
        var lbl = document.createElement("label");
        var checkbox = document.createElement("input");
        checkbox.type="checkbox";
        checkbox.id="checkbox"+i;
        lbl.setAttribute("tabindex","1");
        lbl.innerHTML=lbl.innerHTML+labels[i];
        lbl.addEventListener("keydown", function(e){
            if(e.which ===13 || e.which===32){
                this.click();
            }
        });
        checkbox.addEventListener("change", function(){
            checkAllChecks();
        });
        lbl.appendChild(checkbox);
        document.querySelector(".container").appendChild(lbl);
    }
    vleOpen();
})();

function checkAllChecks(){
    var whichChecked=[];
    var checkboxes=document.querySelectorAll("input[type='checkbox']");
    for(var i=0; i<checkboxes.length; i++){
        var curr={};
        curr[checkboxes[i].id]=checkboxes[i].checked;
        whichChecked.push(curr);
        checkboxes[i].parentNode.removeAttribute("class");
        if(checkboxes[i].checked) {
            checkboxes[i].parentNode.setAttribute("class","highlighted");
        }
    }
    vleSave(whichChecked);
}