var init=true;
var data={
    //display: string | together/seperate
    display:"together",
    //initialshow: int/boolean | number/false
    initialshow:false,
    //plaintexttoggle: boolean | true/false
    plaintexttoggle:true,
    content: [
        {
            label:"<div class=\"shadow-r\"></div><div class=\"title\">Get enough sleep:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Understanding your sleep patterns and making sure you’re getting enough good-quality sleep is a wellbeing essential. Sleep deprivation often has a domino effect. It can cause problems with memory, concentration and decision making. When you’re not functioning well it can affect your overall wellbeing and have a knock-on effect on your immune system. More exercise is a great way of helping improve your sleep. Each of us has different sleep needs and challenges. It can take a little time to understand what triggers improve your quality of sleep, but it’s very much worth doing.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Keep your brain healthy:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">Midlife is a good time to make sure you’re looking after your brain. Health problems and brain changes that cause conditions such as dementia can start years or even decades before symptoms develop. So by having a healthy lifestyle now, you’ll cut down the risk of dementia later on. Being physically active, eating healthily, not smoking and cutting your alcohol intake are particularly important. It’s also worth making sure you stay mentally and socially active. Regular mental challenges seem to build up the brain’s ability to cope with disease. </p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Your work life balance:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">A good work life balance will help you be at your best both at work and at home. But it’s not always easy to achieve. If you find that:</p> <ul><li>work challenges are affecting your home life</li><li>or challenges at home are affecting your performance at work,</li></ul> <p>do reach out to your employer and perhaps also your GP. They should be able to help support you with ways to manage work pressures and stressful situations at work or at home. If you’re worried about raising mental health issues with your employer, remember that they’re very common. One in four people suffer at some point in their lives, so almost everybody’s either been directly affected or knows someone who’s had to deal with them.</p></div>"
        },
        {
            label:"<div class=\"shadow-l\"></div><div class=\"shadow-r\"></div><div class=\"title\">Get regular health checks:</div>",
            content:"<div class=\"box\"><p class=\"n-m-t n-m-b\">The NHS Health Check is a free health check-up for adults in England aged 40 to 74. It’ll help you find out:</p><ul><li>if you’re at risk of a stroke, kidney disease, heart disease, type 2 diabetes or dementia</li><li>how to take action to avoid them.</li></ul><p>The check takes about 20 to 30 minutes. Your GP will ask about your health and wellbeing, and record your height, weight, blood pressure, blood sugar and cholesterol levels. That’ll help them make sure you get the right health care at the right time. It’s also a great opportunity to ask a health care professional about becoming more active, losing weight, cutting down your drinking and stopping smoking.</p></div>"
        },
    ]
};

var labels, reveals, resize;
var prevHeight;
(function () {
    createContentView();
    setupResize();
    if(data.plaintexttoggle) {
        createPlainViewBtn("prepend");
        createPlainViewBtn("append");
    }
    labels=document.querySelectorAll(".label");
    reveals=document.querySelectorAll(".reveal");
    selectLabel(data.initialshow);
    addClickToContainer();
    hasMediaLoaded();
    prevHeight=document.getElementById("container").offsetHeight;
    resizeScreen();
})();
function setupResize() {
    window.onresize = function () {
        clearTimeout(resize);
        resize = setTimeout(function(){
            if(prevHeight!==document.getElementById("container").offsetHeight) {
                prevHeight=document.getElementById("container").offsetHeight;
                VLE.resize_iframe();
                scrollTop()

            } else {
                clearTimeout(resize);
            }
        }, 250);
    };
}

function addClickToContainer(){
    var containers = document.querySelectorAll(".seperate-container");
    for(var i=0; i< containers.length;i++){
        containers[i].onclick=function(){
            this.querySelector(".label-container .label").click();
        }
    }
}

function selectLabel(num){
    for(var i=0; i<data.content.length; i++){
        updateClass("remove",labels[i],"selected");
        updateClass("add",reveals[i],"hidden");
    }
    updateClass("add",labels[num],"selected");
    updateClass("remove",reveals[num],"hidden");
    stopMedia();
    resizeScreen();
}
function stopMedia(){
    /* pauses vids */
    var medias = document.querySelectorAll("video,audio");
    for(var j=0; j<medias.length; j++){
        if(medias[j]) {
            if (medias[j].parentNode) {
                if (medias[j].parentNode.nextElementSibling) {
                    if (medias[j].parentNode.nextElementSibling.querySelector(".omp-stop")) {
                        medias[j].parentNode.nextElementSibling.querySelector(".omp-stop").click();
                    }
                }
            }
        }
    }
}
function resizeScreen(){
    if(!init) {
        setTimeout(function(){VLE.resize_iframe();scrollTop()}, 1000);
    } else {
        if(document.getElementById("container").offsetWidth<512) {
            setTimeout(function () {
                VLE.resize_iframe();
                scrollTop()
            }, 1000);
        }
        init=false;
    }
}
function createContentView(){
    var labelContainer, revealContainer;
    var content = createEl(document.querySelector("#container"),"div", null, null, {"id":"content"});
    if(data.display==="together") {
        labelContainer = createEl(content, "div", null, null, {"class": "label-container"});
        revealContainer = createEl(content, "div", null, null, {"class": "reveal-container"});
    }
    for(var i=0; i<data.content.length; i++){
        if(data.display==="seperate") {
            var seperateContainer = createEl(content,"div", null, ["seperate-container"])
            labelContainer = createEl(seperateContainer, "div", null, null, {"class": "label-container"});
            revealContainer = createEl(seperateContainer, "div", null, null, {"class": "reveal-container","aria-live":"polite"});
        }
        var label = createEl(labelContainer,"div", data.content[i].label, null, {"class":"label", "id":"label-"+i, "tabindex":"0", "role": "button", "aria-label":"test"}, null, data.content[i].label);
        label.setAttribute("aria-label", document.querySelectorAll(".label")[i].innerText)
        label.onkeyup=function(e){
            if(e.keyCode===13 || e.keyCode===32) {
                this.click();
            }
        };
        label.onclick=function() {
            selectLabel(Number(this.getAttribute("id").split("label-")[1]));
        };
        data.content[i].content="<h1 class=\"reveal-heading\">"+data.content[i].label+"</h1>"+data.content[i].content;
        var reveal = createEl(revealContainer,"div", null, null, {"class":"reveal"}, null, data.content[i].content);
        if(data.display==="together") {
            reveal.setAttribute("tabindex","0");
        }
    }
    if(data.backgroundimage) {
        createEl(content,"div", null, null, {"class":"bkg-img"});
    }
    createEl(document.getElementById("container"), "script", null, null, {
        "data-main": "./oump/js/oump",
        "src": "./oump/js/loader.js"
    });
    var mediaContainer = document.querySelectorAll(".media-holder");
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        mediaContainer[mc].addEventListener("click", showHideTranscripts);
    }

    updateClass("add", document.querySelector("#container"), "loaded")
}

function createPlainViewBtn(loc){
    var parent=document.querySelector("#container")
    var btn = createEl(parent,"button", "toggle plain view", ["plainViewBtn"], {"aria-pressed":"false", "tabindex":0}, loc);
    if(loc==="append"){
        updateClass("add", btn,"hidden");
    }
    btn.onclick=function() {
        var content=document.querySelector("#content");
        var plainViewBtns = document.querySelectorAll(".plainViewBtn");
        var seperateContainer= document.querySelectorAll(".seperate-container");
        if(this.getAttribute("aria-pressed")==="true") {
            for(var i=0; i< plainViewBtns.length; i++){
                plainViewBtns[i].setAttribute("aria-pressed",false);
            }
            if(data.display==="seperate") {
                for (var j = 0; j < seperateContainer.length; j++) {
                    seperateContainer[j].removeAttribute("tabindex");
                }
            }
            content.removeAttribute("tabindex");
            updateClass("remove",content,"plain-view");
            updateClass("add", plainViewBtns[plainViewBtns.length-1],"hidden");
            document.querySelector(".plainViewBtn").focus();
        } else {
            for(var k=0; k< plainViewBtns.length; k++){
                plainViewBtns[k].setAttribute("aria-pressed",true);
            }
            if(data.display==="seperate") {
                for (var l = 0; l < seperateContainer.length; l++) {
                    seperateContainer[l].setAttribute("tabindex", "0");
                }
            }
            content.setAttribute("tabindex", "0");
            updateClass("add",content,"plain-view");
            updateClass("remove", plainViewBtns[plainViewBtns.length-1],"hidden");
            content.focus();
        }
        stopMedia();
        VLE.resize_iframe();
        scrollTop()
    };
    if(loc==="prepend"){
        btn.focus();
    }
}


/* repeats */
function createEl(parent, type, txt, classes, attributes, where, html) {
    var el = document.createElement(type);

    if(!where || where && where==="append"){
        parent.appendChild(el);
    } else {
        parent.insertBefore(el, parent.firstChild);
    }
    if (txt) {
        el.innerHTML = txt;
    }
    if (classes) {
        el.className = classes;
    }
    if (attributes) {
        for (var attr in attributes) {
            el.setAttribute(attr, attributes[attr]);
        }
    }
    if(html){
        el.innerHTML=html;
    }
    return el;
}


function hasClass(el, className) {
    var classList = el.className.split(" ");
    var doesHaveClass = false;
    for (var i = 0; i < classList.length; i++) {
        if (className === classList[i]) {
            doesHaveClass = true;
        }
    }
    return doesHaveClass;
};

function updateClass(action, el, className) {
    if (el) {
        var classList = el.className.split(" ");
        switch (action) {
            case "add":
                if (!hasClass(el, className)) {
                    classList.push(className);
                }
                break;
            case "remove":
                if (hasClass(el, className)) {
                    var removeClassAt;
                    for (var i = 0; i < classList.length; i++) {
                        if (className === classList[i]) {
                            removeClassAt = i;
                        }
                    }
                    classList.splice(removeClassAt, 1);
                }
                break;
            default:
                return;
                break;
        }
        el.className = classList.join(" ");
    }
}
function hasMediaLoaded() {
    var mediaContainer = document.querySelectorAll(".media-holder");
    var loaded = true;
    if(!hasClass(document.querySelector("#container"),"loaded")){
        loaded = false;
    }
    for (var mc = 0; mc < mediaContainer.length; mc++) {
        if (!mediaContainer[mc].querySelector(".omp-placeholder-image")) {
            loaded = false;
        }
    }
    if (loaded) {
        setTimeout(function(){VLE.resize_iframe();scrollTop()}, 500);
        document.addEventListener('fullscreenchange', exitHandler);
        document.addEventListener('webkitfullscreenchange', exitHandler);
        document.addEventListener('mozfullscreenchange', exitHandler);
        document.addEventListener('MSFullscreenChange', exitHandler);
    } else {
        setTimeout(function () {
            hasMediaLoaded();
        }, 500);
    }

}
function exitHandler() {
    if (!document.fullscreenElement && !document.webkitIsFullScreen && !document.mozFullScreen && !document.msFullscreenElement) {
        setTimeout(function () {
            VLE.resize_iframe();
            scrollTop()
        }, 500);
    }
}
function showHideTranscripts(e) {
    var el = e.target;
    if (hasClass(el.parentNode, "omp-transcript-toggle-checkbox")) {
        setTimeout(function () {
            VLE.resize_iframe();
            scrollTop()
        }, 500);
    }
};
function scrollTop(){
    document.body.scrollTop = 0;
    document.documentElement.scrollTop = 0;
}