/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.common;

import com.elluminate.registrarui.RegistrarUI;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.TimeZone;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTextArea;
import javax.swing.UIManager;

public class Utility {
    private static final String ILLEGAL_CHARACTERS = "/\\:*?\"<>|+";
    private static final String ILLEGAL_REPLACEMENT = "_-------__";
    private static final Component sComponent = new Component(){};
    private static final MediaTracker sTracker = new MediaTracker(sComponent);
    private static int sID = 0;
    private static SimpleDateFormat formatter = null;
    private static boolean SkipSaveImage = false;
    private static File TempFolder = null;
    private static boolean Verbose = false;
    private static boolean VerboseUnknown = true;

    private Utility() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String decodeTime(long time) {
        String timeString = "";
        long milliseconds = time % 1000L;
        Date date = new Date(time);
        if (formatter == null) {
            formatter = new SimpleDateFormat("yyyy MMM dd HH:mm:ss", Locale.US);
        }
        SimpleDateFormat simpleDateFormat = formatter;
        synchronized (simpleDateFormat) {
            formatter.setTimeZone(TimeZone.getDefault());
            timeString = formatter.format(date);
        }
        return timeString + "." + milliseconds;
    }

    public static String escapeRTF(String text) {
        if (text == null || text.length() == 0) {
            return text;
        }
        StringBuffer msg = new StringBuffer(text.length() + text.length() / 5);
        block6: for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '\r': {
                    continue block6;
                }
                case '\n': {
                    msg.append(" \\par ");
                    continue block6;
                }
                case '\t': {
                    msg.append(" \\tab ");
                    continue block6;
                }
                case '\\': {
                    msg.append('\\');
                    continue block6;
                }
                default: {
                    if (c > '\u008f') {
                        msg.append("\\u" + c);
                        msg.append(" ");
                        continue block6;
                    }
                    msg.append(c);
                }
            }
        }
        return msg.toString();
    }

    public static String editCaptionText(String textString) {
        StringBuffer text = new StringBuffer(textString);
        int i = text.indexOf("\b");
        while (i < text.length() && i >= 0) {
            if (i > 0) {
                text.delete(i - 1, i + 1);
            } else if (i == 0) {
                text.deleteCharAt(0);
            }
            i = text.indexOf("\b");
        }
        return text.toString();
    }

    public static Frame findFrame(JComponent component) {
        if (component == null) {
            throw new RuntimeException("FindFrame: supplied component has no parent.");
        }
        if (component.getParent() instanceof Frame) {
            return (Frame)component.getParent();
        }
        if (component.getParent() instanceof JComponent) {
            return Utility.findFrame((JComponent)component.getParent());
        }
        return null;
    }

    public static JFrame findJFrame(JComponent component) {
        if (component == null) {
            throw new RuntimeException("FindFrame: supplied component has no parent.");
        }
        if (component.getParent() instanceof JFrame) {
            return (JFrame)component.getParent();
        }
        if (component.getParent() instanceof JComponent) {
            return Utility.findJFrame((JComponent)component.getParent());
        }
        return null;
    }

    public static JDialog findJDialog(JComponent component) {
        if (component == null) {
            throw new RuntimeException("FindFrame: supplied component has no parent.");
        }
        if (component.getParent() instanceof JDialog) {
            return (JDialog)component.getParent();
        }
        if (component.getParent() instanceof JComponent) {
            return Utility.findJDialog((JComponent)component.getParent());
        }
        return null;
    }

    public static void healEnvironmentBugs() {
    }

    public static boolean isVerbose() {
        if (VerboseUnknown) {
            VerboseUnknown = false;
            String verb = System.getProperty("verbose", null);
            Verbose = verb != null;
        }
        return Verbose;
    }

    public static void normalizeWidths(JComponent[] components) {
        int i;
        int width = 0;
        for (i = 0; i < components.length; ++i) {
            if (components[i].getPreferredSize().width <= width) continue;
            components[i].setPreferredSize(null);
            width = components[i].getPreferredSize().width;
        }
        for (i = 0; i < components.length; ++i) {
            components[i].setPreferredSize(new Dimension(width, components[i].getPreferredSize().height));
            components[i].setSize(components[i].getPreferredSize());
        }
    }

    public static void printSystemProperties() {
        Utility.printSystemProperties("");
    }

    public static void printSystemProperties(String title) {
        System.out.println(title);
        String where = "getting properties";
        try {
            Properties sys = System.getProperties();
            where = "printing properties";
            Utility.printProperties("System", sys);
        }
        catch (Throwable t) {
            System.out.println("Exception while: " + where);
            t.printStackTrace();
        }
    }

    public static void printProperties(String title, Properties properties) {
        System.out.println("Properties - " + title);
        Enumeration<Object> namesEnumeration = properties.keys();
        TreeMap<String, String> propertyMap = new TreeMap<String, String>();
        while (namesEnumeration.hasMoreElements()) {
            String key = (String)namesEnumeration.nextElement();
            String value = properties.getProperty(key);
            propertyMap.put(key, value);
        }
        for (String key : propertyMap.keySet()) {
            System.out.println(" " + key + "=\"" + propertyMap.get(key) + "\"");
        }
        System.out.println();
    }

    public static boolean revalidate(JFrame frame, String productKey, String appName, String appVersion) {
        if (!RegistrarUI.checkLicense((Frame)frame, (String)productKey, (String)appName, (String)appVersion, (boolean)true)) {
            return false;
        }
        RegistrarUI.checkRegistration((Frame)frame, (String)productKey, (String)appName, (String)appVersion, (boolean)false);
        return true;
    }

    public static void saveImage(int width, int height, int[] pixels, String tag) {
        if (SkipSaveImage) {
            return;
        }
        try {
            if (TempFolder == null) {
                TempFolder = File.createTempFile("PV2ImageTemp", ".folder");
                TempFolder.delete();
                TempFolder.mkdir();
            }
            BufferedImage image = new BufferedImage(width, height, 1);
            image.setRGB(0, 0, width, height, pixels, 0, width);
            File file = new File(TempFolder, tag + ".png");
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException ex) {
            ex.printStackTrace();
            SkipSaveImage = true;
        }
    }

    public static String canoncializePathName(String nameTry) {
        StringBuffer pathName = new StringBuffer();
        for (int i = 0; i < nameTry.length(); ++i) {
            char c = nameTry.charAt(i);
            int indexReplace = ILLEGAL_CHARACTERS.indexOf(c);
            if (indexReplace >= 0) {
                c = ILLEGAL_REPLACEMENT.charAt(indexReplace);
            }
            pathName.append(c);
        }
        return pathName.toString();
    }

    public static boolean is8Bit(String nameTry) {
        if (nameTry == null) {
            return false;
        }
        for (int i = 0; i < nameTry.length(); ++i) {
            if (nameTry.charAt(i) <= '\u00ff') continue;
            return false;
        }
        return true;
    }

    public static boolean checkLicense(Frame parent, String productKey, String applicationName, String applicationVersion, boolean expiringSoon) {
        return RegistrarUI.checkLicense((Frame)parent, (String)productKey, (String)applicationName, (String)applicationVersion, (boolean)expiringSoon);
    }

    public static boolean checkRegistration(Frame parent, String productKey, String applicationName, String applicationVersion, boolean mandatory, JButton proxyButton) {
        Component[] comps = null;
        if (proxyButton != null) {
            comps = new Component[]{proxyButton};
        }
        return RegistrarUI.checkRegistration((Frame)parent, (String)productKey, (String)applicationName, (String)applicationVersion, (boolean)mandatory, (Component[])comps);
    }

    public static boolean showLicenseDialog(JFrame frame, String productKey, String appName, String appVersion) {
        return RegistrarUI.editLicense((Frame)frame, (String)productKey, (String)appName, (String)appVersion);
    }

    public static boolean showRegisterDialog(JFrame frame, String productKey, String appName, String appVersion) {
        return RegistrarUI.editRegistration((Frame)frame, (String)productKey, (String)appName, (String)appVersion);
    }

    public static boolean isTrialLicense(String productKey) {
        return RegistrarUI.isTrialLicense((String)productKey);
    }

    public static String stringToXML(StringBuffer inString) {
        return Utility.stringToXML(inString.toString());
    }

    public static String stringToXML(String inString) {
        StringBuffer outString = new StringBuffer((int)((double)inString.length() * 1.1));
        block7: for (int i = 0; i < inString.length(); ++i) {
            char c = inString.charAt(i);
            switch (c) {
                case '<': {
                    outString.append("&lt;");
                    continue block7;
                }
                case '>': {
                    outString.append("&gt;");
                    continue block7;
                }
                case '&': {
                    outString.append("&amp;");
                    continue block7;
                }
                case '\'': {
                    outString.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    outString.append("&quot;");
                    continue block7;
                }
                default: {
                    if (c < '\u0080') {
                        outString.append(c);
                        continue block7;
                    }
                    char x = c;
                    outString.append("&#");
                    outString.append(Integer.toString(x) + ";");
                }
            }
        }
        return outString.substring(0);
    }

    public static String timeFormat(long milliseconds) {
        return Utility.timeFormat((int)milliseconds);
    }

    public static String timeFormat(int milliseconds) {
        String seconds;
        String milli = "" + (long)milliseconds % 1000L;
        String hours = "" + milliseconds / 3600000;
        String minutes = "" + milliseconds / 60000 % 60;
        if (minutes.length() == 1) {
            minutes = "0" + minutes;
        }
        if ((seconds = "" + milliseconds / 1000 % 60).length() == 1) {
            seconds = "0" + seconds;
        }
        if (hours.equals("0")) {
            return minutes + ":" + seconds;
        }
        return hours + ":" + minutes + ":" + seconds;
    }

    public static Component wrapMessage(String message) {
        JTextArea ta = new JTextArea(){

            public void setText(String text) {
                super.setText(text);
                this.setLineWrap(false);
                this.setWrapStyleWord(false);
                this.setSize(this.getPreferredSize().width, Integer.MAX_VALUE);
                this.setLineWrap(true);
                this.setWrapStyleWord(true);
            }
        };
        ta.setEditable(false);
        ta.setOpaque(false);
        ta.setBackground(UIManager.getColor("Label.background"));
        ta.setFont(UIManager.getFont("Label.font"));
        ta.setText(message);
        if (System.getProperty("os.name").equals("Mac OS X") || message.length() >= 60) {
            ta.setSize(375, Integer.MAX_VALUE);
        }
        return ta;
    }

    public static boolean revealInFileManager(File file) {
        File fo = file;
        if (!file.isDirectory()) {
            fo = file.getParentFile();
        }
        String[] cmd = null;
        String osname = System.getProperty("os.name");
        if (osname.startsWith("Windows")) {
            cmd = new String[]{"cmd.exe", "/c", "start", "\"\"", fo.getAbsolutePath()};
        } else if (osname.equals("Mac OS X")) {
            cmd = new String[]{"open", fo.getAbsolutePath()};
        } else if (System.getenv("GNOME_DESKTOP_SESSION_ID") != null) {
            cmd = new String[]{"gnome-open", fo.getAbsolutePath()};
        } else if ("true".equalsIgnoreCase(System.getenv("KDE_FULL_SESSION"))) {
            cmd = new String[]{"kfmclient", "exec", fo.getAbsolutePath()};
        } else {
            return false;
        }
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            return true;
        }
        catch (IOException ex) {
            return false;
        }
    }

    public static Character[] getIllegalFileNameCharacters(String fileName) {
        ArrayList<Character> list = new ArrayList<Character>();
        for (int i = 0; i < fileName.length(); ++i) {
            char ch = fileName.charAt(i);
            if (ILLEGAL_CHARACTERS.indexOf(ch) == -1) continue;
            list.add(Character.valueOf(ch));
        }
        if (list.size() != 0) {
            return list.toArray(new Character[0]);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean waitForImage(Image image) {
        int id;
        Component component = sComponent;
        synchronized (component) {
            id = sID++;
        }
        sTracker.addImage(image, id);
        try {
            sTracker.waitForID(id, 2000L);
        }
        catch (InterruptedException ie) {
            return false;
        }
        return !sTracker.isErrorID(id);
    }
}

