/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFGroup
extends MRFPacket
implements TimedPacket {
    public static final byte CREATE = 1;
    public static final byte DELETE = 2;
    public static final byte RENAME = 3;
    private short groupId;
    private String groupName;
    private short prevGroupId;
    private String prevGroupName;
    private long time;
    private byte type;

    public MRFGroup(String groupName, short groupId, String prevGroupName, short prevGroupId, byte type, long time) {
        super((byte)11);
        this.groupName = groupName;
        this.groupId = groupId;
        this.prevGroupName = prevGroupName;
        this.prevGroupId = prevGroupId;
        this.type = type;
        this.time = time;
    }

    public MRFGroup(byte[] packetData) throws IOException {
        super((byte)11);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.type = istr.readByte();
        this.groupName = istr.readUTF();
        this.groupId = istr.readShort();
        this.time = istr.readLong();
        if (this.type == 3) {
            this.prevGroupName = istr.readUTF();
            this.prevGroupId = istr.readShort();
        } else {
            this.prevGroupName = null;
            this.prevGroupId = 0;
        }
    }

    public short getGroupId() {
        return this.groupId;
    }

    public String getGroupName() {
        return this.groupName;
    }

    public short getPrevGroupId() {
        return this.prevGroupId;
    }

    public String getPrevGroupName() {
        return this.prevGroupName;
    }

    public long getTime() {
        return this.time;
    }

    public byte getType() {
        return this.type;
    }

    public void setGroupId(short groupId) {
        this.groupId = groupId;
    }

    public void setGroupName(String groupName) {
        this.groupName = groupName;
    }

    public void setPrevGroupId(short prevGroupId) {
        this.prevGroupId = prevGroupId;
    }

    public void setPrevGroupName(String prevGroupName) {
        this.prevGroupName = prevGroupName;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeByte(this.type);
        if (this.groupName == null) {
            ostr.writeUTF("");
        } else {
            ostr.writeUTF(this.groupName);
        }
        ostr.writeShort(this.groupId);
        ostr.writeLong(this.time);
        if (this.type == 3) {
            if (this.prevGroupName == null) {
                ostr.writeUTF("");
            } else {
                ostr.writeUTF(this.prevGroupName);
            }
            ostr.writeShort(this.prevGroupId);
        }
        return bostr.toByteArray();
    }

    public String toString() {
        return "MRFGroup: " + this.groupName + ", id: " + this.groupId + ", prevName: " + this.prevGroupName + ", prevId: " + this.prevGroupId + ", type: " + this.type + ", time: " + MRFGroup.decodeTime(this.time);
    }
}

