/*
 * Decompiled with CFR 0.152.
 */
package com.elluminate.mediastream;

import com.elluminate.mediastream.FeedPacket;
import com.elluminate.mediastream.MRFPacket;
import com.elluminate.mediastream.TimedPacket;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class MRFTextData
extends MRFPacket
implements FeedPacket,
TimedPacket {
    public static final short NO_ADDRESS = -1;
    public static final short JOIN_ADDRESS = -2;
    private short author;
    private short feedIdx;
    private String text;
    private long time;

    public MRFTextData(short feedIdx, short author, long time, String text) {
        super((byte)7);
        this.feedIdx = feedIdx;
        this.author = author;
        this.time = time;
        this.text = text;
    }

    public MRFTextData(byte[] packetData) throws IOException {
        super((byte)7);
        ByteArrayInputStream bistr = new ByteArrayInputStream(packetData);
        DataInputStream istr = new DataInputStream(bistr);
        this.feedIdx = istr.readShort();
        this.time = istr.readLong();
        this.text = istr.readUTF();
        try {
            this.author = istr.readShort();
        }
        catch (Exception e) {
            this.author = (short)-1;
        }
    }

    public short getAuthor() {
        return this.author;
    }

    public short getFeedIdx() {
        return this.feedIdx;
    }

    public String getText() {
        return this.text;
    }

    public long getTime() {
        return this.time;
    }

    public void setAuthor(short author) {
        this.author = author;
    }

    public void setFeedIdx(short feedIdx) {
        this.feedIdx = feedIdx;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public byte[] toByteArray() throws IOException {
        ByteArrayOutputStream bostr = new ByteArrayOutputStream();
        DataOutputStream ostr = new DataOutputStream(bostr);
        ostr.writeShort(this.feedIdx);
        ostr.writeLong(this.time);
        if (this.text == null) {
            ostr.writeUTF("");
        } else {
            ostr.writeUTF(this.text);
        }
        if (this.author != -1) {
            ostr.writeShort(this.author);
        }
        return bostr.toByteArray();
    }

    public String toString() {
        return "MRFTextData: " + this.feedIdx + ", author: " + this.author + ", time: " + MRFTextData.decodeTime(this.time) + ", text: " + this.text;
    }
}

